/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.distributed.dht.preloader;

import java.nio.ByteBuffer;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.GridDirectTransient;
import org.apache.ignite.internal.IgniteCodeGeneratingFail;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.cache.GridCacheGroupIdMessage;
import org.apache.ignite.internal.processors.cache.GridCacheMessage;
import org.apache.ignite.internal.processors.cache.GridCachePartitionExchangeManager;
import org.apache.ignite.internal.processors.cache.GridCacheSharedContext;
import org.apache.ignite.internal.processors.cache.distributed.dht.preloader.GridDhtPartitionDemandLegacyMessage;
import org.apache.ignite.internal.processors.cache.distributed.dht.preloader.IgniteDhtDemandedPartitionsMap;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteProductVersion;
import org.apache.ignite.plugin.extensions.communication.MessageReader;
import org.apache.ignite.plugin.extensions.communication.MessageWriter;
import org.jetbrains.annotations.NotNull;

@IgniteCodeGeneratingFail
public class GridDhtPartitionDemandMessage
extends GridCacheGroupIdMessage {
    private static final long serialVersionUID = 0L;
    public static final IgniteProductVersion VERSION_SINCE = IgniteProductVersion.fromString("2.4.4");
    private static final Object REBALANCE_TOPIC = GridCachePartitionExchangeManager.rebalanceTopic(0);
    private long rebalanceId;
    @GridDirectTransient
    private IgniteDhtDemandedPartitionsMap parts;
    private byte[] partsBytes;
    @GridDirectTransient
    private Object topic = REBALANCE_TOPIC;
    private byte[] topicBytes;
    private long timeout;
    private int workerId = -1;
    private AffinityTopologyVersion topVer;

    GridDhtPartitionDemandMessage(long rebalanceId, @NotNull AffinityTopologyVersion topVer, int grpId) {
        this(rebalanceId, topVer, grpId, new IgniteDhtDemandedPartitionsMap());
    }

    GridDhtPartitionDemandMessage(long rebalanceId, @NotNull AffinityTopologyVersion topVer, int grpId, IgniteDhtDemandedPartitionsMap parts) {
        this.grpId = grpId;
        this.rebalanceId = rebalanceId;
        this.topVer = topVer;
        this.parts = parts;
    }

    public GridDhtPartitionDemandMessage(GridDhtPartitionDemandLegacyMessage cp) {
        this.grpId = cp.groupId();
        this.rebalanceId = cp.updateSequence();
        this.topic = cp.topic();
        this.timeout = cp.timeout();
        this.workerId = cp.workerId();
        this.topVer = cp.topologyVersion();
        IgniteDhtDemandedPartitionsMap partMap = new IgniteDhtDemandedPartitionsMap();
        if (cp.partitions() != null) {
            for (Integer p : cp.partitions()) {
                if (cp.isHistorical(p)) {
                    partMap.addHistorical(p, 0L, cp.partitionCounter(p), cp.partitions().size());
                    continue;
                }
                partMap.addFull(p);
            }
        }
        partMap.historicalMap().trim();
        this.parts = partMap;
    }

    public GridDhtPartitionDemandMessage() {
    }

    public GridDhtPartitionDemandMessage withNewPartitionsMap(@NotNull IgniteDhtDemandedPartitionsMap parts) {
        GridDhtPartitionDemandMessage cp = new GridDhtPartitionDemandMessage();
        cp.grpId = this.grpId;
        cp.rebalanceId = this.rebalanceId;
        cp.topic = this.topic;
        cp.timeout = this.timeout;
        cp.workerId = this.workerId;
        cp.topVer = this.topVer;
        cp.parts = parts;
        return cp;
    }

    public IgniteDhtDemandedPartitionsMap partitions() {
        return this.parts;
    }

    void rebalanceId(long updateSeq) {
        this.rebalanceId = updateSeq;
    }

    long rebalanceId() {
        return this.rebalanceId;
    }

    long timeout() {
        return this.timeout;
    }

    void timeout(long timeout) {
        this.timeout = timeout;
    }

    Object topic() {
        return this.topic;
    }

    int workerId() {
        return this.workerId;
    }

    void workerId(int workerId) {
        this.workerId = workerId;
    }

    @Override
    public AffinityTopologyVersion topologyVersion() {
        return this.topVer;
    }

    public GridCacheMessage convertIfNeeded(IgniteProductVersion target) {
        if (target.compareTo(VERSION_SINCE) <= 0) {
            return new GridDhtPartitionDemandLegacyMessage(this);
        }
        return this;
    }

    @Override
    public void prepareMarshal(GridCacheSharedContext ctx) throws IgniteCheckedException {
        super.prepareMarshal(ctx);
        if (this.topic != null && this.topicBytes == null) {
            this.topicBytes = U.marshal(ctx, this.topic);
        }
        if (this.parts != null && this.partsBytes == null) {
            this.partsBytes = U.marshal(ctx, (Object)this.parts);
        }
    }

    @Override
    public void finishUnmarshal(GridCacheSharedContext ctx, ClassLoader ldr) throws IgniteCheckedException {
        super.finishUnmarshal(ctx, ldr);
        if (this.topicBytes != null && this.topic == null) {
            this.topic = U.unmarshal(ctx, this.topicBytes, U.resolveClassLoader(ldr, ctx.gridConfig()));
        }
        if (this.partsBytes != null && this.parts == null) {
            this.parts = (IgniteDhtDemandedPartitionsMap)U.unmarshal(ctx, this.partsBytes, U.resolveClassLoader(ldr, ctx.gridConfig()));
        }
    }

    @Override
    public boolean addDeploymentInfo() {
        return false;
    }

    @Override
    public boolean writeTo(ByteBuffer buf, MessageWriter writer) {
        writer.setBuffer(buf);
        if (!super.writeTo(buf, writer)) {
            return false;
        }
        if (!writer.isHeaderWritten()) {
            if (!writer.writeHeader(this.directType(), this.fieldsCount())) {
                return false;
            }
            writer.onHeaderWritten();
        }
        switch (writer.state()) {
            case 4: {
                if (!writer.writeByteArray("partsBytes", this.partsBytes)) {
                    return false;
                }
                writer.incrementState();
            }
            case 5: {
                if (!writer.writeLong("timeout", this.timeout)) {
                    return false;
                }
                writer.incrementState();
            }
            case 6: {
                if (!writer.writeAffinityTopologyVersion("topVer", this.topVer)) {
                    return false;
                }
                writer.incrementState();
            }
            case 7: {
                if (!writer.writeByteArray("topicBytes", this.topicBytes)) {
                    return false;
                }
                writer.incrementState();
            }
            case 8: {
                if (!writer.writeLong("rebalanceId", this.rebalanceId)) {
                    return false;
                }
                writer.incrementState();
            }
            case 9: {
                if (!writer.writeInt("workerId", this.workerId)) {
                    return false;
                }
                writer.incrementState();
            }
        }
        return true;
    }

    @Override
    public boolean readFrom(ByteBuffer buf, MessageReader reader) {
        reader.setBuffer(buf);
        if (!reader.beforeMessageRead()) {
            return false;
        }
        if (!super.readFrom(buf, reader)) {
            return false;
        }
        switch (reader.state()) {
            case 4: {
                this.partsBytes = reader.readByteArray("partsBytes");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 5: {
                this.timeout = reader.readLong("timeout");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 6: {
                this.topVer = reader.readAffinityTopologyVersion("topVer");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 7: {
                this.topicBytes = reader.readByteArray("topicBytes");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 8: {
                this.rebalanceId = reader.readLong("rebalanceId");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 9: {
                this.workerId = reader.readInt("workerId");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(GridDhtPartitionDemandMessage.class);
    }

    @Override
    public short directType() {
        return 45;
    }

    @Override
    public byte fieldsCount() {
        return 10;
    }

    @Override
    public byte policy() {
        return 13;
    }

    @Override
    public String toString() {
        return S.toString(GridDhtPartitionDemandMessage.class, this, "partCnt", this.parts != null ? this.parts.size() : 0, "super", super.toString());
    }
}

