/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.distributed.dht.topology;

import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.IgniteSystemProperties;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.failure.FailureContext;
import org.apache.ignite.failure.FailureType;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.NodeStoppingException;
import org.apache.ignite.internal.pagemem.wal.record.delta.PartitionMetaStateRecord;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.cache.CacheGroupContext;
import org.apache.ignite.internal.processors.cache.GridCacheAdapter;
import org.apache.ignite.internal.processors.cache.GridCacheConcurrentMap;
import org.apache.ignite.internal.processors.cache.GridCacheConcurrentMapImpl;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.GridCacheEntryEx;
import org.apache.ignite.internal.processors.cache.GridCacheMapEntry;
import org.apache.ignite.internal.processors.cache.GridCacheMapEntryFactory;
import org.apache.ignite.internal.processors.cache.GridCacheSharedContext;
import org.apache.ignite.internal.processors.cache.IgniteCacheOffheapManager;
import org.apache.ignite.internal.processors.cache.KeyCacheObject;
import org.apache.ignite.internal.processors.cache.distributed.dht.GridDhtCacheEntry;
import org.apache.ignite.internal.processors.cache.distributed.dht.GridReservable;
import org.apache.ignite.internal.processors.cache.distributed.dht.preloader.GridDhtPreloader;
import org.apache.ignite.internal.processors.cache.distributed.dht.topology.EvictionContext;
import org.apache.ignite.internal.processors.cache.distributed.dht.topology.GridDhtInvalidPartitionException;
import org.apache.ignite.internal.processors.cache.distributed.dht.topology.GridDhtPartitionState;
import org.apache.ignite.internal.processors.cache.distributed.dht.topology.GridDhtPartitionsReservation;
import org.apache.ignite.internal.processors.cache.extras.GridCacheObsoleteEntryExtras;
import org.apache.ignite.internal.processors.cache.persistence.CacheDataRow;
import org.apache.ignite.internal.processors.cache.persistence.CheckpointState;
import org.apache.ignite.internal.processors.cache.transactions.IgniteInternalTx;
import org.apache.ignite.internal.processors.cache.transactions.TxCounters;
import org.apache.ignite.internal.processors.cache.version.GridCacheVersion;
import org.apache.ignite.internal.processors.query.GridQueryRowCacheCleaner;
import org.apache.ignite.internal.util.GridLongList;
import org.apache.ignite.internal.util.collection.IntMap;
import org.apache.ignite.internal.util.collection.IntRWHashMap;
import org.apache.ignite.internal.util.future.GridFinishedFuture;
import org.apache.ignite.internal.util.future.GridFutureAdapter;
import org.apache.ignite.internal.util.lang.GridIterator;
import org.apache.ignite.internal.util.tostring.GridToStringExclude;
import org.apache.ignite.internal.util.typedef.internal.LT;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteInClosure;
import org.apache.ignite.util.deque.FastSizeDeque;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GridDhtLocalPartition
extends GridCacheConcurrentMapImpl
implements Comparable<GridDhtLocalPartition>,
GridReservable {
    private static final GridCacheMapEntryFactory ENTRY_FACTORY = GridDhtCacheEntry::new;
    public static final int MAX_DELETE_QUEUE_SIZE = Integer.getInteger("IGNITE_ATOMIC_CACHE_DELETE_HISTORY_SIZE", 200000);
    private static boolean forceTestCheckpointOnEviction = IgniteSystemProperties.getBoolean("TEST_CHECKPOINT_ON_EVICTION", false);
    static volatile Integer partWhereTestCheckpointEnforced;
    private final int rmvQueueMaxSize;
    private final long rmvdEntryTtl;
    private static final AtomicReference<IgniteLogger> logRef;
    private static volatile IgniteLogger log;
    private final int id;
    @GridToStringExclude
    private final AtomicLong state = new AtomicLong((long)GridDhtPartitionState.MOVING.ordinal() << 32);
    @GridToStringExclude
    private final GridFutureAdapter<?> rent;
    @GridToStringExclude
    private final GridCacheSharedContext ctx;
    @GridToStringExclude
    private final CacheGroupContext grp;
    @GridToStringExclude
    private final long createTime = U.currentTimeMillis();
    @GridToStringExclude
    private final IntMap<GridCacheConcurrentMap.CacheMapHolder> cacheMaps;
    @GridToStringExclude
    private final GridCacheConcurrentMap.CacheMapHolder singleCacheEntryMap;
    @GridToStringExclude
    private final FastSizeDeque<RemovedEntryHolder> rmvQueue = new FastSizeDeque(new ConcurrentLinkedDeque());
    @GridToStringExclude
    private final CopyOnWriteArrayList<GridDhtPartitionsReservation> reservations = new CopyOnWriteArrayList();
    @GridToStringExclude
    private volatile IgniteCacheOffheapManager.CacheDataStore store;
    private volatile long delayedRentingTopVer;
    private final AtomicReference<GridFutureAdapter<?>> finishFutRef = new AtomicReference();
    private volatile long clearVer;

    public GridDhtLocalPartition(GridCacheSharedContext ctx, CacheGroupContext grp, int id, boolean recovery) {
        super(ENTRY_FACTORY);
        this.id = id;
        this.ctx = ctx;
        this.grp = grp;
        log = U.logger(ctx.kernalContext(), logRef, this);
        if (grp.sharedGroup()) {
            this.singleCacheEntryMap = null;
            this.cacheMaps = new IntRWHashMap<GridCacheConcurrentMap.CacheMapHolder>();
        } else {
            this.singleCacheEntryMap = ctx.kernalContext().resource().resolve(new GridCacheConcurrentMap.CacheMapHolder(grp.singleCacheContext(), this.createEntriesMap()));
            this.cacheMaps = null;
        }
        this.rent = new GridFutureAdapter<Object>(){

            @Override
            public String toString() {
                return "PartitionRentFuture [part=" + GridDhtLocalPartition.this + ']';
            }
        };
        int delQueueSize = grp.systemCache() ? 100 : Math.max(MAX_DELETE_QUEUE_SIZE / grp.affinity().partitions(), 20);
        this.rmvQueueMaxSize = U.ceilPow2(delQueueSize);
        this.rmvdEntryTtl = Long.getLong("IGNITE_CACHE_REMOVED_ENTRIES_TTL", 10000L);
        try {
            this.store = grp.offheap().createCacheDataStore(id);
            if (grp.walEnabled() && !recovery) {
                ctx.wal().log(new PartitionMetaStateRecord(grp.groupId(), id, this.state(), 0L));
            }
            if (ctx.kernalContext().query().moduleEnabled()) {
                GridQueryRowCacheCleaner cleaner = ctx.kernalContext().query().getIndexing().rowCacheCleaner(grp.groupId());
                if (this.store != null && cleaner != null) {
                    this.store.setRowCacheCleaner(cleaner);
                }
            }
        }
        catch (IgniteCheckedException e) {
            throw new IgniteException(e);
        }
        if (log.isDebugEnabled()) {
            log.debug("Partition has been created [grp=" + grp.cacheOrGroupName() + ", p=" + id + ", state=" + (Object)((Object)this.state()) + "]");
        }
        this.clearVer = ctx.versions().localOrder();
    }

    private ConcurrentMap<KeyCacheObject, GridCacheMapEntry> createEntriesMap() {
        return new ConcurrentHashMap<KeyCacheObject, GridCacheMapEntry>(Math.max(10, GridCacheAdapter.DFLT_START_CACHE_SIZE / this.grp.affinity().partitions()), 0.75f, Runtime.getRuntime().availableProcessors() * 2);
    }

    @Override
    public int internalSize() {
        if (this.grp.sharedGroup()) {
            AtomicInteger size = new AtomicInteger(0);
            this.cacheMaps.forEach((key, hld) -> size.addAndGet(hld.map.size()));
            return size.get();
        }
        return this.singleCacheEntryMap.map.size();
    }

    @Override
    protected GridCacheConcurrentMap.CacheMapHolder entriesMap(GridCacheContext cctx) {
        if (this.grp.sharedGroup()) {
            return this.cacheMapHolder(cctx);
        }
        return this.singleCacheEntryMap;
    }

    @Override
    @Nullable
    protected GridCacheConcurrentMap.CacheMapHolder entriesMapIfExists(Integer cacheId) {
        return this.grp.sharedGroup() ? this.cacheMaps.get(cacheId) : this.singleCacheEntryMap;
    }

    private GridCacheConcurrentMap.CacheMapHolder cacheMapHolder(GridCacheContext cctx) {
        assert (this.grp.sharedGroup());
        GridCacheConcurrentMap.CacheMapHolder hld = this.cacheMaps.get(cctx.cacheIdBoxed());
        if (hld != null) {
            return hld;
        }
        hld = this.ctx.kernalContext().resource().resolve(new GridCacheConcurrentMap.CacheMapHolder(cctx, this.createEntriesMap()));
        GridCacheConcurrentMap.CacheMapHolder old = this.cacheMaps.putIfAbsent(cctx.cacheIdBoxed(), hld);
        if (old != null) {
            hld = old;
        }
        return hld;
    }

    public IgniteCacheOffheapManager.CacheDataStore dataStore() {
        return this.store;
    }

    public boolean addReservation(GridDhtPartitionsReservation r) {
        assert (GridDhtLocalPartition.getPartState(this.state.get()) != GridDhtPartitionState.EVICTED) : "we can reserve only active partitions";
        assert (GridDhtLocalPartition.getReservations(this.state.get()) != 0) : "partition must be already reserved before adding group reservation";
        return this.reservations.addIfAbsent(r);
    }

    public void removeReservation(GridDhtPartitionsReservation r) {
        if (!this.reservations.remove(r)) {
            throw new IllegalStateException("Reservation was already removed.");
        }
    }

    public int id() {
        return this.id;
    }

    public long createTime() {
        return this.createTime;
    }

    public GridDhtPartitionState state() {
        return GridDhtLocalPartition.getPartState(this.state.get());
    }

    public int reservations() {
        return GridDhtLocalPartition.getReservations(this.state.get());
    }

    public boolean isEmpty() {
        return this.store.isEmpty() && this.internalSize() == 0;
    }

    public boolean valid() {
        GridDhtPartitionState state = this.state();
        return state == GridDhtPartitionState.MOVING || state == GridDhtPartitionState.OWNING || state == GridDhtPartitionState.RENTING;
    }

    public void onRemoved(GridDhtCacheEntry entry) {
        assert (entry.obsolete()) : entry;
        this.removeEntry(entry);
    }

    private void removeVersionedEntry(int cacheId, KeyCacheObject key, GridCacheVersion ver) {
        GridCacheMapEntry entry;
        GridCacheConcurrentMap.CacheMapHolder hld = this.grp.sharedGroup() ? this.cacheMaps.get(cacheId) : this.singleCacheEntryMap;
        GridCacheMapEntry gridCacheMapEntry = entry = hld != null ? (GridCacheMapEntry)hld.map.get(key) : null;
        if (entry != null && entry.markObsoleteVersion(ver)) {
            this.removeEntry(entry);
        }
    }

    void cleanupRemoveQueue() {
        RemovedEntryHolder item;
        if (this.state() == GridDhtPartitionState.MOVING) {
            if (this.rmvQueue.sizex() >= this.rmvQueueMaxSize) {
                LT.warn(log, "Deletion queue cleanup for moving partition was delayed until rebalance is finished. [grpId=" + this.grp.groupId() + ", partId=" + this.id() + ", grpParts=" + this.grp.affinity().partitions() + ", maxRmvQueueSize=" + this.rmvQueueMaxSize + ']');
            }
            return;
        }
        while (this.rmvQueue.sizex() >= this.rmvQueueMaxSize) {
            item = this.rmvQueue.pollFirst();
            if (item == null) continue;
            this.removeVersionedEntry(item.cacheId(), item.key(), item.version());
        }
        if (!this.grp.isDrEnabled()) {
            item = this.rmvQueue.peekFirst();
            while (item != null && item.expireTime() < U.currentTimeMillis() && (item = this.rmvQueue.pollFirst()) != null) {
                this.removeVersionedEntry(item.cacheId(), item.key(), item.version());
                item = this.rmvQueue.peekFirst();
            }
        }
    }

    public void onDeferredDelete(int cacheId, KeyCacheObject key, GridCacheVersion ver) {
        this.cleanupRemoveQueue();
        this.rmvQueue.add(new RemovedEntryHolder(cacheId, key, ver, this.rmvdEntryTtl));
    }

    @Override
    public boolean reserve() {
        long newState;
        long state;
        do {
            int ordinal;
            if ((ordinal = GridDhtLocalPartition.ordinal(state = this.state.get())) != GridDhtPartitionState.RENTING.ordinal() && ordinal != GridDhtPartitionState.EVICTED.ordinal()) continue;
            return false;
        } while (!this.state.compareAndSet(state, newState = GridDhtLocalPartition.setReservations(state, GridDhtLocalPartition.getReservations(state) + 1)));
        return true;
    }

    @Override
    public void release() {
        this.release0(0);
    }

    @Override
    protected void release(int sizeChange, GridCacheConcurrentMap.CacheMapHolder hld, GridCacheEntryEx e) {
        if (this.grp.sharedGroup() && sizeChange != 0) {
            hld.size.addAndGet(sizeChange);
        }
        this.release0(sizeChange);
    }

    private void release0(int sizeChange) {
        int reservations;
        long newState;
        long state;
        do {
            if ((reservations = GridDhtLocalPartition.getReservations(state = this.state.get())) == 0) {
                return;
            }
            assert (GridDhtLocalPartition.getPartState(state) != GridDhtPartitionState.EVICTED) : this;
            newState = GridDhtLocalPartition.setReservations(state, --reservations);
            newState = GridDhtLocalPartition.setSize(newState, GridDhtLocalPartition.getSize(newState) + sizeChange);
            assert (GridDhtLocalPartition.getSize(newState) == GridDhtLocalPartition.getSize(state) + sizeChange);
        } while (!this.state.compareAndSet(state, newState));
        if (reservations == 0) {
            this.tryContinueClearing();
        }
    }

    public void restoreState(GridDhtPartitionState stateToRestore) {
        this.state.set(GridDhtLocalPartition.setPartState(this.state.get(), stateToRestore));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setState(GridDhtPartitionState toState) {
        if (this.grp.persistenceEnabled() && this.grp.walEnabled()) {
            GridDhtLocalPartition gridDhtLocalPartition = this;
            synchronized (gridDhtLocalPartition) {
                long state0 = this.state.get();
                this.state.compareAndSet(state0, GridDhtLocalPartition.setPartState(state0, toState));
                try {
                    this.ctx.wal().log(new PartitionMetaStateRecord(this.grp.groupId(), this.id, toState, 0L));
                }
                catch (IgniteCheckedException e) {
                    U.error(log, "Error while writing to log", e);
                }
            }
        }
        this.restoreState(toState);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean casState(long state, GridDhtPartitionState toState) {
        if (this.grp.persistenceEnabled() && this.grp.walEnabled()) {
            GridDhtLocalPartition gridDhtLocalPartition = this;
            synchronized (gridDhtLocalPartition) {
                GridDhtPartitionState prevState = this.state();
                boolean updated = this.state.compareAndSet(state, GridDhtLocalPartition.setPartState(state, toState));
                if (updated) {
                    assert (toState != GridDhtPartitionState.EVICTED || this.reservations() == 0) : this;
                    try {
                        if (prevState == GridDhtPartitionState.OWNING && toState == GridDhtPartitionState.LOST) {
                            return true;
                        }
                        this.ctx.wal().log(new PartitionMetaStateRecord(this.grp.groupId(), this.id, toState == GridDhtPartitionState.LOST ? GridDhtPartitionState.OWNING : toState, 0L));
                    }
                    catch (IgniteCheckedException e) {
                        U.error(log, "Failed to log partition state change to WAL.", e);
                        this.ctx.kernalContext().failure().process(new FailureContext(FailureType.CRITICAL_ERROR, e));
                    }
                    if (log.isDebugEnabled()) {
                        log.debug("Partition changed state [grp=" + this.grp.cacheOrGroupName() + ", p=" + this.id + ", prev=" + (Object)((Object)prevState) + ", to=" + (Object)((Object)toState) + "]");
                    }
                }
                return updated;
            }
        }
        GridDhtPartitionState prevState = this.state();
        boolean updated = this.state.compareAndSet(state, GridDhtLocalPartition.setPartState(state, toState));
        if (updated) {
            assert (toState != GridDhtPartitionState.EVICTED || this.reservations() == 0) : this;
            if (log.isDebugEnabled()) {
                log.debug("Partition changed state [grp=" + this.grp.cacheOrGroupName() + ", p=" + this.id + ", prev=" + (Object)((Object)prevState) + ", to=" + (Object)((Object)toState) + "]");
            }
        }
        return updated;
    }

    public boolean own() {
        long state;
        do {
            GridDhtPartitionState partState;
            if ((partState = GridDhtLocalPartition.getPartState(state = this.state.get())) == GridDhtPartitionState.RENTING || partState == GridDhtPartitionState.EVICTED) {
                return false;
            }
            if (partState == GridDhtPartitionState.OWNING) {
                return true;
            }
            assert (partState == GridDhtPartitionState.MOVING || partState == GridDhtPartitionState.LOST);
        } while (!this.casState(state, GridDhtPartitionState.OWNING));
        return true;
    }

    public boolean moving() {
        long state;
        do {
            GridDhtPartitionState partState;
            if ((partState = GridDhtLocalPartition.getPartState(state = this.state.get())) == GridDhtPartitionState.EVICTED) {
                return false;
            }
            assert (partState == GridDhtPartitionState.OWNING || partState == GridDhtPartitionState.RENTING) : "Only partitions in state OWNING or RENTING can be moved to MOVING state " + (Object)((Object)partState) + " " + this.id;
        } while (!this.casState(state, GridDhtPartitionState.MOVING));
        this.clearVer = this.ctx.versions().localOrder();
        return true;
    }

    public boolean markLost() {
        long state;
        do {
            GridDhtPartitionState partState;
            if ((partState = GridDhtLocalPartition.getPartState(state = this.state.get())) != GridDhtPartitionState.LOST) continue;
            return false;
        } while (!this.casState(state, GridDhtPartitionState.LOST));
        return true;
    }

    public IgniteInternalFuture<?> rent() {
        long state0 = this.state.get();
        GridDhtPartitionState partState = GridDhtLocalPartition.getPartState(state0);
        if (partState == GridDhtPartitionState.EVICTED) {
            return this.rent;
        }
        if (partState == GridDhtPartitionState.RENTING) {
            if (this.finishFutRef.get() == null) {
                this.clearAsync();
            }
            return this.rent;
        }
        this.delayedRentingTopVer = this.ctx.exchange().readyAffinityVersion().topologyVersion();
        if (this.tryInvalidateGroupReservations() && GridDhtLocalPartition.getReservations(state0) == 0 && this.casState(state0, GridDhtPartitionState.RENTING)) {
            this.delayedRentingTopVer = 0L;
            this.clearAsync();
        }
        return this.rent;
    }

    public void tryContinueClearing() {
        if (this.delayedRentingTopVer != 0L && this.delayedRentingTopVer == this.ctx.exchange().readyAffinityVersion().topologyVersion()) {
            this.rent();
        }
    }

    public IgniteInternalFuture<?> clearAsync() {
        boolean clearingRequested;
        long state = this.state.get();
        GridDhtPartitionState partState = GridDhtLocalPartition.getPartState(state);
        boolean evictionRequested = partState == GridDhtPartitionState.RENTING;
        boolean bl = clearingRequested = partState == GridDhtPartitionState.MOVING;
        if (!evictionRequested && !clearingRequested) {
            return new GridFinishedFuture();
        }
        GridFutureAdapter finishFut = new GridFutureAdapter();
        do {
            GridFutureAdapter<?> curFut;
            if ((curFut = this.finishFutRef.get()) == null) continue;
            return curFut;
        } while (!this.finishFutRef.compareAndSet(null, finishFut));
        finishFut.listen(new IgniteInClosure<IgniteInternalFuture<?>>(){

            @Override
            public void apply(IgniteInternalFuture<?> fut) {
                if (GridDhtLocalPartition.this.state() == GridDhtPartitionState.EVICTED) {
                    GridDhtLocalPartition.this.rent.onDone(fut.error());
                } else {
                    GridDhtLocalPartition.this.finishFutRef.set(null);
                }
            }
        });
        this.ctx.evict().evictPartitionAsync(this.grp, this, finishFut);
        return finishFut;
    }

    private boolean tryInvalidateGroupReservations() {
        for (GridDhtPartitionsReservation reservation : this.reservations) {
            if (reservation.invalidate()) continue;
            return false;
        }
        return true;
    }

    private boolean freeAndEmpty(long state) {
        return this.isEmpty() && GridDhtLocalPartition.getSize(state) == 0 && GridDhtLocalPartition.getReservations(state) == 0;
    }

    public void finishEviction() {
        long state0 = this.state.get();
        GridDhtPartitionState state = GridDhtLocalPartition.getPartState(state0);
        if (this.store.isEmpty() && GridDhtLocalPartition.getReservations(state0) == 0 && state == GridDhtPartitionState.RENTING) {
            this.casState(state0, GridDhtPartitionState.EVICTED);
        }
    }

    public boolean isClearing() {
        return this.finishFutRef.get() != null;
    }

    public void onUnlock() {
    }

    public boolean primary(AffinityTopologyVersion topVer) {
        List<ClusterNode> nodes = this.grp.affinity().cachedAffinity(topVer).get(this.id);
        return !nodes.isEmpty() && this.ctx.localNode().equals(nodes.get(0));
    }

    public boolean backup(AffinityTopologyVersion topVer) {
        List<ClusterNode> nodes = this.grp.affinity().cachedAffinity(topVer).get(this.id);
        return nodes.indexOf(this.ctx.localNode()) > 0;
    }

    public long nextUpdateCounter(int cacheId, AffinityTopologyVersion topVer, boolean primary, boolean init, @Nullable Long primaryCntr) {
        long nextCntr;
        if (primaryCntr == null) {
            nextCntr = this.store.nextUpdateCounter();
        } else {
            assert (!init) : "Initial update must generate a counter for partition " + this;
            assert (primaryCntr != 0L);
            nextCntr = primaryCntr;
            this.store.updateCounter(nextCntr);
        }
        if (this.grp.sharedGroup()) {
            this.grp.onPartitionCounterUpdate(cacheId, this.id, nextCntr, topVer, primary);
        }
        return nextCntr;
    }

    public long nextUpdateCounter(int cacheId, IgniteInternalTx tx, @Nullable Long primaryCntr) {
        Long nextCntr;
        if (primaryCntr != null) {
            nextCntr = primaryCntr;
        } else {
            TxCounters txCounters = tx.txCounters(false);
            assert (txCounters != null) : "Must have counters for tx [nearXidVer=" + tx.nearXidVersion() + ']';
            nextCntr = txCounters.generateNextCounter(cacheId, this.id());
            assert (nextCntr != null) : this;
        }
        if (this.grp.sharedGroup()) {
            this.grp.onPartitionCounterUpdate(cacheId, this.id, nextCntr, tx.topologyVersion(), tx.local());
        }
        return nextCntr;
    }

    public long updateCounter() {
        return this.store.updateCounter();
    }

    public long reservedCounter() {
        return this.store.reservedCounter();
    }

    public void updateCounter(long val) {
        this.store.updateCounter(val);
    }

    public long initialUpdateCounter() {
        return this.store.initialUpdateCounter();
    }

    public long getAndIncrementUpdateCounter(long delta) {
        return this.store.getAndIncrementUpdateCounter(delta);
    }

    public boolean updateCounter(long start, long delta) {
        return this.store.updateCounter(start, delta);
    }

    public void resetUpdateCounter() {
        this.store.resetUpdateCounter();
    }

    public void resetInitialUpdateCounter() {
        this.store.resetInitialUpdateCounter();
    }

    public long fullSize() {
        return this.store.fullSize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected long clearAll(EvictionContext evictionCtx) throws NodeStoppingException {
        long order = this.clearVer;
        GridCacheVersion clearVer = this.ctx.versions().startVersion();
        GridCacheObsoleteEntryExtras extras = new GridCacheObsoleteEntryExtras(clearVer);
        boolean rec = this.grp.eventRecordable(85);
        long cleared = 0L;
        int stopCntr = 0;
        GridCacheConcurrentMap.CacheMapHolder hld = this.grp.sharedGroup() ? null : this.singleCacheEntryMap;
        try {
            GridIterator<CacheDataRow> it0 = this.grp.offheap().partitionIterator(this.id);
            while (it0.hasNext()) {
                if ((stopCntr = stopCntr + 1 & 0x3FF) == 0 && evictionCtx.shouldStop()) {
                    return cleared;
                }
                this.ctx.database().checkpointReadLock();
                try {
                    CacheDataRow row = (CacheDataRow)it0.next();
                    long order0 = row.version().order();
                    if (this.state() == GridDhtPartitionState.MOVING && (order0 == 0L || order0 > order)) continue;
                    if (this.grp.sharedGroup() && (hld == null || hld.cctx.cacheId() != row.cacheId())) {
                        hld = this.cacheMapHolder(this.ctx.cacheContext(row.cacheId()));
                    }
                    assert (hld != null);
                    GridCacheMapEntry cached = this.putEntryIfObsoleteOrAbsent(hld, hld.cctx, this.grp.affinity().lastVersion(), row.key(), true, true);
                    assert (cached != null) : "Expecting the reservation " + this;
                    if (cached.deleted() || !(cached instanceof GridDhtCacheEntry) || !((GridDhtCacheEntry)cached).clearInternal(clearVer, extras)) continue;
                    this.removeEntry(cached);
                    if (rec && !hld.cctx.config().isEventsDisabled().booleanValue()) {
                        hld.cctx.events().addEvent(cached.partition(), cached.key(), this.ctx.localNodeId(), null, null, null, 85, null, false, cached.rawGet(), cached.hasValue(), null, null, null, false);
                    }
                    ++cleared;
                }
                catch (GridDhtInvalidPartitionException e) {
                    assert (this.isEmpty() && this.state() == GridDhtPartitionState.EVICTED) : "Invalid error [e=" + e + ", part=" + this + ']';
                    break;
                }
                finally {
                    this.ctx.database().checkpointReadUnlock();
                }
            }
            if (forceTestCheckpointOnEviction && partWhereTestCheckpointEnforced == null && cleared >= this.fullSize()) {
                this.ctx.database().forceCheckpoint("test").futureFor(CheckpointState.FINISHED).get();
                log.warning("Forced checkpoint by test reasons for partition: " + this);
                partWhereTestCheckpointEnforced = this.id;
            }
            ((GridDhtPreloader)this.grp.preloader()).tryFinishEviction(this);
        }
        catch (NodeStoppingException e) {
            if (log.isDebugEnabled()) {
                log.debug("Failed to get iterator for evicted partition: " + this.id);
            }
            throw e;
        }
        catch (IgniteCheckedException e) {
            U.error(log, "Failed to get iterator for evicted partition: " + this.id, e);
        }
        return cleared;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clear(ConcurrentMap<KeyCacheObject, GridCacheMapEntry> map, GridCacheObsoleteEntryExtras extras, boolean evt) throws NodeStoppingException {
        Iterator it = map.values().iterator();
        while (it.hasNext()) {
            GridCacheMapEntry cached = null;
            this.ctx.database().checkpointReadLock();
            try {
                cached = (GridCacheMapEntry)it.next();
                if (!(cached instanceof GridDhtCacheEntry) || !((GridDhtCacheEntry)cached).clearInternal(extras.obsoleteVersion(), extras)) continue;
                this.removeEntry(cached);
                if (cached.isInternal() || !evt) continue;
                this.grp.addCacheEvent(cached.partition(), cached.key(), this.ctx.localNodeId(), 85, null, false, cached.rawGet(), cached.hasValue(), false);
            }
            catch (GridDhtInvalidPartitionException e) {
                assert (this.isEmpty() && this.state() == GridDhtPartitionState.EVICTED) : "Invalid error [e=" + e + ", part=" + this + ']';
                break;
            }
            catch (NodeStoppingException e) {
                if (log.isDebugEnabled()) {
                    log.debug("Failed to clear cache entry for evicted partition: " + cached.partition());
                }
                throw e;
            }
            catch (IgniteCheckedException e) {
                U.error(log, "Failed to clear cache entry for evicted partition: " + cached, e);
            }
            finally {
                this.ctx.database().checkpointReadUnlock();
            }
        }
    }

    public void clearDeferredDeletes() {
        for (RemovedEntryHolder e : this.rmvQueue) {
            this.removeVersionedEntry(e.cacheId(), e.key(), e.version());
        }
    }

    public int hashCode() {
        return 31 * this.id + this.grp.groupId();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GridDhtLocalPartition part = (GridDhtLocalPartition)o;
        return this.id == part.id && this.grp.groupId() == part.group().groupId();
    }

    @Override
    public int compareTo(@NotNull GridDhtLocalPartition part) {
        if (part == null) {
            return 1;
        }
        return Integer.compare(this.id, part.id());
    }

    public String toString() {
        return S.toString(GridDhtLocalPartition.class, this, "grp", this.grp.cacheOrGroupName(), "state", (Object)this.state(), "reservations", this.reservations(), "empty", (Object)this.isEmpty(), "createTime", (Object)U.format(this.createTime), "fullSize", this.fullSize(), "cntr", this.dataStore().partUpdateCounter());
    }

    @Override
    public int publicSize(int cacheId) {
        if (this.grp.sharedGroup()) {
            GridCacheConcurrentMap.CacheMapHolder hld = this.cacheMaps.get(cacheId);
            return hld != null ? hld.size.get() : 0;
        }
        return GridDhtLocalPartition.getSize(this.state.get());
    }

    @Override
    public void incrementPublicSize(@Nullable GridCacheConcurrentMap.CacheMapHolder hld, GridCacheEntryEx e) {
        long state;
        if (this.grp.sharedGroup()) {
            if (hld == null) {
                hld = this.cacheMapHolder(e.context());
            }
            hld.size.incrementAndGet();
        }
        while (!this.state.compareAndSet(state = this.state.get(), GridDhtLocalPartition.setSize(state, GridDhtLocalPartition.getSize(state) + 1))) {
        }
    }

    @Override
    public void decrementPublicSize(@Nullable GridCacheConcurrentMap.CacheMapHolder hld, GridCacheEntryEx e) {
        long state;
        if (this.grp.sharedGroup()) {
            if (hld == null) {
                hld = this.cacheMapHolder(e.context());
            }
            hld.size.decrementAndGet();
        }
        do {
            state = this.state.get();
            assert (GridDhtLocalPartition.getPartState(state) != GridDhtPartitionState.EVICTED);
        } while (!this.state.compareAndSet(state, GridDhtLocalPartition.setSize(state, GridDhtLocalPartition.getSize(state) - 1)));
    }

    public CacheGroupContext group() {
        return this.grp;
    }

    public void onCacheStopped(int cacheId) {
        assert (this.grp.sharedGroup()) : this.grp.cacheOrGroupName();
        Iterator<RemovedEntryHolder> it = this.rmvQueue.iterator();
        while (it.hasNext()) {
            RemovedEntryHolder e = it.next();
            if (e.cacheId() != cacheId) continue;
            it.remove();
        }
        this.cacheMaps.remove(cacheId);
    }

    private static GridDhtPartitionState getPartState(long state) {
        return GridDhtPartitionState.fromOrdinal((int)(state & 7L));
    }

    private static int ordinal(long state) {
        return (int)(state & 7L);
    }

    private static long setPartState(long state, GridDhtPartitionState partState) {
        return state & 0xFFFFFFFFFFFFFFF8L | (long)partState.ordinal();
    }

    private static int getReservations(long state) {
        return (int)((state & 0xFFFF0000L) >> 16);
    }

    private static long setReservations(long state, int reservations) {
        return state & 0xFFFFFFFF0000FFFFL | (long)(reservations << 16);
    }

    private static int getSize(long state) {
        return (int)((state & 0xFFFFFFFF00000000L) >> 32);
    }

    private static long setSize(long state, int size) {
        return state & 0xFFFFFFFFL | (long)size << 32;
    }

    public GridLongList finalizeUpdateCounters() {
        return this.store.finalizeUpdateCounters();
    }

    public void beforeApplyBatch(boolean last) {
    }

    static {
        logRef = new AtomicReference();
    }

    private static class RemovedEntryHolder {
        private final int cacheId;
        private final KeyCacheObject key;
        private final GridCacheVersion ver;
        private final long expireTime;

        private RemovedEntryHolder(int cacheId, KeyCacheObject key, GridCacheVersion ver, long ttl) {
            this.cacheId = cacheId;
            this.key = key;
            this.ver = ver;
            this.expireTime = U.currentTimeMillis() + ttl;
        }

        int cacheId() {
            return this.cacheId;
        }

        KeyCacheObject key() {
            return this.key;
        }

        GridCacheVersion version() {
            return this.ver;
        }

        long expireTime() {
            return this.expireTime;
        }

        public String toString() {
            return S.toString(RemovedEntryHolder.class, this);
        }
    }
}

