/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.distributed.near;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.ignite.IgniteCacheRestartingException;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.cache.CacheWriteSynchronizationMode;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.cluster.ClusterTopologyCheckedException;
import org.apache.ignite.internal.cluster.ClusterTopologyServerNotFoundException;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.cache.CacheEntryPredicate;
import org.apache.ignite.internal.processors.cache.CacheInvalidStateException;
import org.apache.ignite.internal.processors.cache.CacheObject;
import org.apache.ignite.internal.processors.cache.CacheStoppedException;
import org.apache.ignite.internal.processors.cache.GridCacheCompoundIdentityFuture;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.GridCacheEntryEx;
import org.apache.ignite.internal.processors.cache.GridCacheEntryRemovedException;
import org.apache.ignite.internal.processors.cache.GridCacheLockTimeoutException;
import org.apache.ignite.internal.processors.cache.GridCacheMapEntry;
import org.apache.ignite.internal.processors.cache.GridCacheMessage;
import org.apache.ignite.internal.processors.cache.GridCacheMvccCandidate;
import org.apache.ignite.internal.processors.cache.GridCacheVersionedFuture;
import org.apache.ignite.internal.processors.cache.KeyCacheObject;
import org.apache.ignite.internal.processors.cache.distributed.GridDistributedCacheEntry;
import org.apache.ignite.internal.processors.cache.distributed.dht.GridDhtCacheEntry;
import org.apache.ignite.internal.processors.cache.distributed.dht.GridDhtTopologyFuture;
import org.apache.ignite.internal.processors.cache.distributed.dht.GridDhtTransactionalCacheAdapter;
import org.apache.ignite.internal.processors.cache.distributed.near.GridNearCacheEntry;
import org.apache.ignite.internal.processors.cache.distributed.near.GridNearLockMapping;
import org.apache.ignite.internal.processors.cache.distributed.near.GridNearLockRequest;
import org.apache.ignite.internal.processors.cache.distributed.near.GridNearLockResponse;
import org.apache.ignite.internal.processors.cache.distributed.near.GridNearTxLocal;
import org.apache.ignite.internal.processors.cache.transactions.IgniteTxEntry;
import org.apache.ignite.internal.processors.cache.transactions.IgniteTxKey;
import org.apache.ignite.internal.processors.cache.transactions.TxDeadlock;
import org.apache.ignite.internal.processors.cache.version.GridCacheVersion;
import org.apache.ignite.internal.processors.timeout.GridTimeoutObjectAdapter;
import org.apache.ignite.internal.transactions.IgniteTxRollbackCheckedException;
import org.apache.ignite.internal.transactions.IgniteTxTimeoutCheckedException;
import org.apache.ignite.internal.util.future.GridEmbeddedFuture;
import org.apache.ignite.internal.util.future.GridFutureAdapter;
import org.apache.ignite.internal.util.tostring.GridToStringExclude;
import org.apache.ignite.internal.util.tostring.GridToStringInclude;
import org.apache.ignite.internal.util.typedef.C1;
import org.apache.ignite.internal.util.typedef.C2;
import org.apache.ignite.internal.util.typedef.CI1;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.CU;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteBiTuple;
import org.apache.ignite.lang.IgniteInClosure;
import org.apache.ignite.lang.IgnitePredicate;
import org.apache.ignite.lang.IgniteUuid;
import org.apache.ignite.transactions.TransactionDeadlockException;
import org.apache.ignite.transactions.TransactionIsolation;
import org.jetbrains.annotations.Nullable;

public final class GridNearLockFuture
extends GridCacheCompoundIdentityFuture<Boolean>
implements GridCacheVersionedFuture<Boolean> {
    private static final long serialVersionUID = 0L;
    private static final AtomicReference<IgniteLogger> logRef = new AtomicReference();
    private static final AtomicIntegerFieldUpdater<GridNearLockFuture> DONE_UPD = AtomicIntegerFieldUpdater.newUpdater(GridNearLockFuture.class, "done");
    private static IgniteLogger log;
    @GridToStringExclude
    private final GridCacheContext<?, ?> cctx;
    @GridToStringInclude
    private long threadId;
    @GridToStringInclude
    private final Collection<KeyCacheObject> keys;
    private final IgniteUuid futId;
    private final GridCacheVersion lockVer;
    private boolean read;
    private final boolean retval;
    private volatile Throwable err;
    private volatile boolean timedOut;
    @GridToStringExclude
    private volatile LockTimeoutObject timeoutObj;
    private final long timeout;
    private final CacheEntryPredicate[] filter;
    @GridToStringExclude
    private final GridNearTxLocal tx;
    private volatile AffinityTopologyVersion topVer;
    private final Map<KeyCacheObject, IgniteBiTuple<GridCacheVersion, CacheObject>> valMap;
    private volatile int done;
    @GridToStringExclude
    private List<GridDistributedCacheEntry> entries;
    private long createTtl;
    private long accessTtl;
    private final boolean skipStore;
    @GridToStringExclude
    private Queue<GridNearLockMapping> mappings;
    private final boolean keepBinary;
    private final boolean recovery;
    private int miniId;

    public GridNearLockFuture(GridCacheContext<?, ?> cctx, Collection<KeyCacheObject> keys, @Nullable GridNearTxLocal tx, boolean read, boolean retval, long timeout, long createTtl, long accessTtl, CacheEntryPredicate[] filter, boolean skipStore, boolean keepBinary, boolean recovery) {
        super(CU.boolReducer());
        assert (keys != null);
        assert (tx != null && timeout >= 0L || tx == null);
        this.cctx = cctx;
        this.keys = keys;
        this.tx = tx;
        this.read = read;
        this.retval = retval;
        this.timeout = timeout;
        this.createTtl = createTtl;
        this.accessTtl = accessTtl;
        this.filter = filter;
        this.skipStore = skipStore;
        this.keepBinary = keepBinary;
        this.recovery = recovery;
        this.ignoreInterrupts();
        this.threadId = tx == null ? Thread.currentThread().getId() : tx.threadId();
        this.lockVer = tx != null ? tx.xidVersion() : cctx.cache().nextVersion();
        this.futId = IgniteUuid.randomUuid();
        this.entries = new ArrayList<GridDistributedCacheEntry>(keys.size());
        if (log == null) {
            log = U.logger(cctx.kernalContext(), logRef, GridNearLockFuture.class);
        }
        this.valMap = new ConcurrentHashMap<KeyCacheObject, IgniteBiTuple<GridCacheVersion, CacheObject>>();
        if (tx != null && !tx.updateLockFuture(null, this)) {
            this.err = tx.timedOut() ? tx.timeoutException() : tx.rollbackException();
            this.onComplete(false, false);
        }
    }

    @Override
    public GridCacheVersion version() {
        return this.lockVer;
    }

    public synchronized List<GridDistributedCacheEntry> entriesCopy() {
        return new ArrayList<GridDistributedCacheEntry>(this.entries);
    }

    @Override
    public IgniteUuid futureId() {
        return this.futId;
    }

    @Override
    public boolean trackable() {
        return true;
    }

    @Override
    public void markNotTrackable() {
    }

    private boolean inTx() {
        return this.tx != null;
    }

    private boolean implicitSingleTx() {
        return this.tx != null && this.tx.implicitSingle();
    }

    private boolean isInvalidate() {
        return this.tx != null && this.tx.isInvalidate();
    }

    @Nullable
    private TransactionIsolation isolation() {
        return this.tx == null ? null : this.tx.isolation();
    }

    private boolean implicitTx() {
        return this.tx != null && this.tx.implicit();
    }

    private boolean locked(GridCacheEntryEx cached) throws GridCacheEntryRemovedException {
        return cached.lockedLocallyByIdOrThread(this.lockVer, this.threadId) && this.filter(cached);
    }

    @Nullable
    private GridCacheMvccCandidate addEntry(AffinityTopologyVersion topVer, GridNearCacheEntry entry, UUID dhtNodeId) throws GridCacheEntryRemovedException {
        assert (Thread.holdsLock(this));
        if (this.timedOut) {
            return null;
        }
        GridCacheMvccCandidate c = entry.addNearLocal(dhtNodeId, this.threadId, this.lockVer, topVer, this.timeout, !this.inTx(), this.inTx(), this.implicitSingleTx(), false);
        if (this.inTx()) {
            IgniteTxEntry txEntry = this.tx.entry(entry.txKey());
            txEntry.cached(entry);
        }
        this.entries.add(entry);
        if (c == null && this.timeout < 0L) {
            if (log.isDebugEnabled()) {
                log.debug("Failed to acquire lock with negative timeout: " + entry);
            }
            this.onFailed(false);
            return null;
        }
        if (this.timedOut) {
            entry.removeLock(this.lockVer);
            return null;
        }
        return c;
    }

    private void undoLocks(boolean dist, boolean rollback) {
        if (dist && this.tx == null) {
            this.cctx.nearTx().removeLocks(this.lockVer, this.keys);
        } else {
            if (rollback && this.tx != null) {
                if (this.tx.setRollbackOnly()) {
                    if (log.isDebugEnabled()) {
                        log.debug("Marked transaction as rollback only because locks could not be acquired: " + this.tx);
                    }
                } else if (log.isDebugEnabled()) {
                    log.debug("Transaction was not marked rollback-only while locks were not acquired: " + this.tx);
                }
            }
            block4: for (GridCacheEntryEx gridCacheEntryEx : this.entriesCopy()) {
                try {
                    gridCacheEntryEx.removeLock(this.lockVer);
                }
                catch (GridCacheEntryRemovedException ignored) {
                    while (true) {
                        try {
                            GridCacheEntryEx gridCacheEntryEx2 = this.cctx.cache().peekEx(gridCacheEntryEx.key());
                            if (gridCacheEntryEx2 == null) continue block4;
                            gridCacheEntryEx2.removeLock(this.lockVer);
                            continue block4;
                        }
                        catch (GridCacheEntryRemovedException ignore) {
                            if (!log.isDebugEnabled()) continue;
                            log.debug("Attempted to remove lock on removed entry (will retry) [ver=" + this.lockVer + ", entry=" + gridCacheEntryEx + ']');
                            continue;
                        }
                        break;
                    }
                }
            }
        }
        this.cctx.mvcc().recheckPendingLocks();
    }

    private void onFailed(boolean dist) {
        this.undoLocks(dist, true);
        this.complete(false);
    }

    public void complete(boolean success) {
        this.onComplete(success, true);
    }

    @Override
    public boolean onNodeLeft(UUID nodeId) {
        boolean found = false;
        for (IgniteInternalFuture fut : this.futures()) {
            MiniFuture f;
            if (!this.isMini(fut) || !(f = (MiniFuture)fut).node().id().equals(nodeId)) continue;
            if (log.isDebugEnabled()) {
                log.debug("Found mini-future for left node [nodeId=" + nodeId + ", mini=" + f + ", fut=" + this + ']');
            }
            f.onResult(this.newTopologyException(null, nodeId));
            found = true;
        }
        if (!found && log.isDebugEnabled()) {
            log.debug("Near lock future does not have mapping for left node (ignoring) [nodeId=" + nodeId + ", fut=" + this + ']');
        }
        return found;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onResult(UUID nodeId, GridNearLockResponse res) {
        boolean done = this.isDone();
        if (!done) {
            if (this.timeoutObj == null) {
                this.onResult0(nodeId, res);
                return;
            }
            LockTimeoutObject lockTimeoutObject = this.timeoutObj;
            synchronized (lockTimeoutObject) {
                if (!this.isDone()) {
                    if (this.onResult0(nodeId, res)) {
                        return;
                    }
                } else {
                    done = true;
                }
            }
        }
        if (done && log.isDebugEnabled()) {
            log.debug("Ignoring lock response from node (future is done) [nodeId=" + nodeId + ", res=" + res + ", fut=" + this + ']');
        }
    }

    private boolean onResult0(UUID nodeId, GridNearLockResponse res) {
        MiniFuture mini;
        if (log.isDebugEnabled()) {
            log.debug("Received lock response from node [nodeId=" + nodeId + ", res=" + res + ", fut=" + this + ']');
        }
        if ((mini = this.miniFuture(res.miniId())) != null) {
            assert (mini.node().id().equals(nodeId));
            if (log.isDebugEnabled()) {
                log.debug("Found mini future for response [mini=" + mini + ", res=" + res + ']');
            }
            mini.onResult(res);
            if (log.isDebugEnabled()) {
                log.debug("Future after processed lock response [fut=" + this + ", mini=" + mini + ", res=" + res + ']');
            }
            return true;
        }
        U.warn(log, "Failed to find mini future for response (perhaps due to stale message) [res=" + res + ", fut=" + this + ']');
        return false;
    }

    public synchronized Set<IgniteTxKey> requestedKeys() {
        if (this.timeoutObj != null && this.timeoutObj.requestedKeys != null) {
            return this.timeoutObj.requestedKeys;
        }
        return this.requestedKeys0();
    }

    private Set<IgniteTxKey> requestedKeys0() {
        for (IgniteInternalFuture miniFut : this.futures()) {
            if (!this.isMini(miniFut) || miniFut.isDone()) continue;
            MiniFuture mini = (MiniFuture)miniFut;
            HashSet<IgniteTxKey> requestedKeys = U.newHashSet(mini.keys.size());
            for (KeyCacheObject key : mini.keys) {
                requestedKeys.add(new IgniteTxKey(key, this.cctx.cacheId()));
            }
            return requestedKeys;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MiniFuture miniFuture(int miniId) {
        GridNearLockFuture gridNearLockFuture = this;
        synchronized (gridNearLockFuture) {
            int size = this.futuresCountNoLock();
            for (int i = 0; i < size; ++i) {
                MiniFuture mini;
                IgniteInternalFuture fut = this.future(i);
                if (!this.isMini(fut) || (mini = (MiniFuture)fut).futureId() != miniId) continue;
                if (!mini.isDone()) {
                    return mini;
                }
                return null;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onError(Throwable t) {
        GridNearLockFuture gridNearLockFuture = this;
        synchronized (gridNearLockFuture) {
            if (this.err == null) {
                this.err = t;
            }
        }
    }

    private boolean filter(GridCacheEntryEx cached) {
        try {
            if (!this.cctx.isAll(cached, this.filter)) {
                if (log.isDebugEnabled()) {
                    log.debug("Filter didn't pass for entry (will fail lock): " + cached);
                }
                this.onFailed(true);
                return false;
            }
            return true;
        }
        catch (IgniteCheckedException e) {
            this.onError(e);
            return false;
        }
    }

    @Override
    public boolean onOwnerChanged(GridCacheEntryEx entry, GridCacheMvccCandidate owner) {
        if (owner != null && owner.nearLocal() && owner.version().equals(this.lockVer)) {
            this.onDone(true);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkLocks() {
        if (!this.isDone() && this.initialized() && !this.hasPending()) {
            GridNearLockFuture gridNearLockFuture = this;
            synchronized (gridNearLockFuture) {
                block5: for (int i = 0; i < this.entries.size(); ++i) {
                    while (true) {
                        GridCacheEntryEx cached = this.entries.get(i);
                        try {
                            if (this.locked(cached)) continue block5;
                            if (log.isDebugEnabled()) {
                                log.debug("Lock is still not acquired for entry (will keep waiting) [entry=" + cached + ", fut=" + this + ']');
                            }
                            return false;
                        }
                        catch (GridCacheEntryRemovedException ignore) {
                            if (log.isDebugEnabled()) {
                                log.debug("Got removed entry in onOwnerChanged method (will retry): " + cached);
                            }
                            this.entries.set(i, (GridDistributedCacheEntry)this.cctx.cache().entryEx(cached.key()));
                            continue;
                        }
                        break;
                    }
                }
                if (log.isDebugEnabled()) {
                    log.debug("Local lock acquired for entries [fut=" + this + ", entries=" + this.entries + "]");
                }
            }
            this.onComplete(true, true);
            return true;
        }
        return false;
    }

    @Override
    public boolean cancel() {
        if (this.inTx()) {
            this.onError(this.tx.commitError() != null ? new IgniteTxRollbackCheckedException(this.tx.commitError()) : this.tx.rollbackException());
        }
        return this.onComplete(false, true);
    }

    @Override
    public boolean onDone(Boolean success, Throwable err) {
        if (log.isDebugEnabled()) {
            log.debug("Received onDone(..) callback [success=" + success + ", err=" + err + ", fut=" + this + ']');
        }
        if (this.inTx() && this.cctx.tm().deadlockDetectionEnabled() && (this.err instanceof IgniteTxTimeoutCheckedException || this.timedOut)) {
            return false;
        }
        if (this.isDone() || err == null && success.booleanValue() && !this.checkLocks()) {
            return false;
        }
        if (err != null && !(err instanceof GridCacheLockTimeoutException)) {
            this.onError(err);
        }
        if (err != null) {
            success = false;
        }
        return this.onComplete(success, true);
    }

    private boolean onComplete(boolean success, boolean distribute) {
        if (log.isDebugEnabled()) {
            log.debug("Received onComplete(..) callback [success=" + success + ", distribute=" + distribute + ", fut=" + this + ']');
        }
        if (!DONE_UPD.compareAndSet(this, 0, 1)) {
            return false;
        }
        if (!success) {
            this.undoLocks(distribute, true);
        }
        if (this.tx != null) {
            this.cctx.tm().txContext(this.tx);
            if (success) {
                this.tx.clearLockFuture(this);
            }
        }
        if (super.onDone(success, this.err)) {
            if (log.isDebugEnabled()) {
                log.debug("Completing future: " + this);
            }
            this.cctx.mvcc().removeVersionedFuture(this);
            if (this.timeoutObj != null) {
                this.cctx.time().removeTimeoutObject(this.timeoutObj);
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        return this.futId.hashCode();
    }

    @Override
    public String toString() {
        Collection futs = F.viewReadOnly(this.futures(), new C1<IgniteInternalFuture<?>, String>(){

            @Override
            public String apply(IgniteInternalFuture<?> f) {
                if (GridNearLockFuture.this.isMini(f)) {
                    MiniFuture m = (MiniFuture)f;
                    return "[node=" + m.node().id() + ", loc=" + m.node().isLocal() + ", done=" + f.isDone() + "]";
                }
                return "[loc=true, done=" + f.isDone() + "]";
            }
        }, new IgnitePredicate[0]);
        return S.toString(GridNearLockFuture.class, this, "innerFuts", futs, "inTx", this.inTx(), "super", super.toString());
    }

    private boolean isMini(IgniteInternalFuture<?> f) {
        return f.getClass().equals(MiniFuture.class);
    }

    void map() {
        if (this.isDone()) {
            return;
        }
        if (this.timeout > 0L) {
            this.timeoutObj = new LockTimeoutObject();
            this.cctx.time().addTimeoutObject(this.timeoutObj);
        }
        boolean added = this.cctx.mvcc().addFuture(this);
        assert (added) : this;
        long threadId = Thread.currentThread().getId();
        AffinityTopologyVersion topVer = this.cctx.mvcc().lastExplicitLockTopologyVersion(threadId);
        if (topVer == null && this.tx != null && this.tx.system()) {
            topVer = this.cctx.tm().lockedTopologyVersion(threadId, this.tx);
        }
        if (topVer != null && this.tx != null) {
            this.tx.topologyVersion(topVer);
        }
        if (topVer == null && this.tx != null) {
            topVer = this.tx.topologyVersionSnapshot();
        }
        if (topVer != null) {
            for (GridDhtTopologyFuture gridDhtTopologyFuture : this.cctx.shared().exchange().exchangeFutures()) {
                if (!gridDhtTopologyFuture.exchangeDone() || !gridDhtTopologyFuture.topologyVersion().equals(topVer)) continue;
                Throwable err = null;
                try {
                    gridDhtTopologyFuture.get();
                }
                catch (IgniteCheckedException e) {
                    err = gridDhtTopologyFuture.error();
                }
                Throwable throwable = err = err == null ? gridDhtTopologyFuture.validateCache(this.cctx, this.recovery, this.read, null, this.keys) : err;
                if (err == null) break;
                this.onDone(err);
                return;
            }
            if (this.topVer == null) {
                this.topVer = topVer;
            }
            this.map(this.keys, false, true);
            this.markInitialized();
            return;
        }
        this.mapOnTopology(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void mapOnTopology(final boolean remap) {
        this.cctx.topology().readLock();
        try {
            if (this.cctx.topology().stopping()) {
                this.onDone(this.cctx.shared().cache().isCacheRestarting(this.cctx.name()) ? new IgniteCacheRestartingException(this.cctx.name()) : new CacheStoppedException(this.cctx.name()));
                return;
            }
            GridDhtTopologyFuture fut = this.cctx.topologyVersionFuture();
            if (fut.isDone()) {
                CacheInvalidStateException err = fut.validateCache(this.cctx, this.recovery, this.read, null, this.keys);
                if (err != null) {
                    this.onDone(err);
                    return;
                }
                AffinityTopologyVersion topVer = fut.topologyVersion();
                if (remap) {
                    if (this.tx != null) {
                        this.tx.onRemap(topVer, true);
                    }
                    this.topVer = topVer;
                } else {
                    if (this.tx != null) {
                        this.tx.topologyVersion(topVer);
                    }
                    if (this.topVer == null) {
                        this.topVer = topVer;
                    }
                }
                this.map(this.keys, remap, false);
                this.markInitialized();
            } else {
                fut.listen(new CI1<IgniteInternalFuture<AffinityTopologyVersion>>(){

                    @Override
                    public void apply(IgniteInternalFuture<AffinityTopologyVersion> fut) {
                        try {
                            fut.get();
                            GridNearLockFuture.this.mapOnTopology(remap);
                        }
                        catch (IgniteCheckedException e) {
                            GridNearLockFuture.this.onDone(e);
                        }
                        finally {
                            GridNearLockFuture.this.cctx.shared().txContextReset();
                        }
                    }
                });
            }
        }
        finally {
            this.cctx.topology().readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void map(Iterable<KeyCacheObject> keys, boolean remap, boolean topLocked) {
        try {
            AffinityTopologyVersion topVer = this.topVer;
            assert (topVer != null);
            assert (topVer.topologyVersion() > 0L) : topVer;
            if (CU.affinityNodes(this.cctx, topVer).isEmpty()) {
                this.onDone(new ClusterTopologyServerNotFoundException("Failed to map keys for near-only cache (all partition nodes left the grid)."));
                return;
            }
            boolean clientNode = this.cctx.kernalContext().clientNode();
            assert (!remap || clientNode && (this.tx == null || !this.tx.hasRemoteLocks()));
            GridNearLockFuture gridNearLockFuture = this;
            synchronized (gridNearLockFuture) {
                this.mappings = new ArrayDeque<GridNearLockMapping>();
                GridNearLockMapping map = null;
                for (KeyCacheObject key : keys) {
                    GridNearLockMapping updated = this.map(key, map, topVer);
                    if (updated != map) {
                        this.mappings.add(updated);
                        if (this.tx != null && updated.node().isLocal()) {
                            this.tx.nearLocallyMapped(true);
                        }
                    }
                    map = updated;
                }
                if (this.isDone()) {
                    if (log.isDebugEnabled()) {
                        log.debug("Abandoning (re)map because future is done: " + this);
                    }
                    return;
                }
                if (log.isDebugEnabled()) {
                    log.debug("Starting (re)map for mappings [mappings=" + this.mappings + ", fut=" + this + ']');
                }
                boolean first = true;
                Iterator iter = this.mappings.iterator();
                while (iter.hasNext()) {
                    GridNearLockMapping mapping = (GridNearLockMapping)iter.next();
                    ClusterNode node = mapping.node();
                    Collection<KeyCacheObject> mappedKeys = mapping.mappedKeys();
                    assert (!mappedKeys.isEmpty());
                    GridNearLockRequest req = null;
                    ArrayList<KeyCacheObject> distributedKeys = new ArrayList<KeyCacheObject>(mappedKeys.size());
                    boolean explicit = false;
                    for (KeyCacheObject key : mappedKeys) {
                        boolean marked;
                        IgniteTxKey txKey = this.cctx.txKey(key);
                        while (true) {
                            GridCacheMapEntry entry = null;
                            try {
                                entry = this.cctx.near().entryExx(key, topVer);
                                if (!this.cctx.isAll(entry, this.filter)) {
                                    if (log.isDebugEnabled()) {
                                        log.debug("Entry being locked did not pass filter (will not lock): " + entry);
                                    }
                                    this.onComplete(false, false);
                                    return;
                                }
                                GridCacheMvccCandidate cand = this.addEntry(topVer, (GridNearCacheEntry)entry, node.id());
                                if (this.isDone()) {
                                    if (log.isDebugEnabled()) {
                                        log.debug("Abandoning (re)map because future is done after addEntry attempt [fut=" + this + ", entry=" + entry + ']');
                                    }
                                    return;
                                }
                                if (cand != null) {
                                    IgniteBiTuple<GridCacheVersion, CacheObject> val;
                                    block45: {
                                        if (this.tx == null && !cand.reentry()) {
                                            this.cctx.mvcc().addExplicitLock(this.threadId, cand, topVer);
                                        }
                                        if ((val = ((GridNearCacheEntry)entry).versionedValue()) == null) {
                                            GridDhtCacheEntry dhtEntry = this.dht().peekExx(key);
                                            try {
                                                if (dhtEntry != null) {
                                                    val = dhtEntry.versionedValue(topVer);
                                                }
                                            }
                                            catch (GridCacheEntryRemovedException ignored) {
                                                assert (dhtEntry.obsolete()) : dhtEntry;
                                                if (!log.isDebugEnabled()) break block45;
                                                log.debug("Got removed exception for DHT entry in map (will ignore): " + dhtEntry);
                                            }
                                        }
                                    }
                                    GridCacheVersion dhtVer = null;
                                    if (val != null) {
                                        dhtVer = val.get1();
                                        this.valMap.put(key, val);
                                    }
                                    if (!cand.reentry()) {
                                        if (req == null) {
                                            boolean clientFirst = false;
                                            if (first) {
                                                clientFirst = clientNode && !topLocked && (this.tx == null || !this.tx.hasRemoteLocks());
                                                first = false;
                                            }
                                            assert (!this.implicitTx() && !this.implicitSingleTx()) : this.tx;
                                            req = new GridNearLockRequest(this.cctx.cacheId(), topVer, this.cctx.nodeId(), this.threadId, this.futId, this.lockVer, this.inTx(), this.read, this.retval, this.isolation(), this.isInvalidate(), this.timeout, mappedKeys.size(), this.inTx() ? this.tx.size() : mappedKeys.size(), this.inTx() && this.tx.syncMode() == CacheWriteSynchronizationMode.FULL_SYNC, this.inTx() ? this.tx.subjectId() : null, this.inTx() ? this.tx.taskNameHash() : 0, this.read ? this.createTtl : -1L, this.read ? this.accessTtl : -1L, this.skipStore, this.keepBinary, clientFirst, true, this.cctx.deploymentEnabled(), this.inTx() ? this.tx.label() : null);
                                            mapping.request(req);
                                        }
                                        distributedKeys.add(key);
                                        if (this.tx != null) {
                                            this.tx.addKeyMapping(txKey, mapping.node());
                                        }
                                        req.addKeyBytes(key, this.retval && dhtVer == null, dhtVer, this.cctx);
                                    }
                                    if (cand.reentry()) {
                                        explicit = this.tx != null && !entry.hasLockCandidate(this.tx.xidVersion());
                                    }
                                } else {
                                    if (this.timedOut) {
                                        return;
                                    }
                                    boolean bl = explicit = this.tx != null && !entry.hasLockCandidate(this.tx.xidVersion());
                                }
                                if (!explicit) break;
                                this.tx.addKeyMapping(txKey, mapping.node());
                            }
                            catch (GridCacheEntryRemovedException ignored) {
                                assert (entry.obsolete()) : "Got removed exception on non-obsolete entry: " + entry;
                                if (!log.isDebugEnabled()) continue;
                                log.debug("Got removed entry in lockAsync(..) method (will retry): " + entry);
                                continue;
                            }
                            break;
                        }
                        if (!explicit) continue;
                        boolean bl = marked = this.tx != null && this.tx.markExplicit(node.id());
                        assert (this.tx == null || marked);
                    }
                    if (!distributedKeys.isEmpty()) {
                        mapping.distributedKeys(distributedKeys);
                        continue;
                    }
                    assert (mapping.request() == null);
                    iter.remove();
                }
            }
            this.cctx.mvcc().recheckPendingLocks();
            this.proceedMapping();
        }
        catch (IgniteCheckedException ex) {
            this.onError(ex);
        }
    }

    private void proceedMapping() throws IgniteCheckedException {
        boolean set = this.tx != null && this.cctx.shared().tm().setTxTopologyHint(this.tx.topologyVersionSnapshot());
        try {
            this.proceedMapping0();
        }
        finally {
            if (set) {
                this.cctx.tm().setTxTopologyHint(null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void proceedMapping0() throws IgniteCheckedException {
        GridNearLockMapping map;
        GridNearLockFuture gridNearLockFuture = this;
        synchronized (gridNearLockFuture) {
            map = this.mappings.poll();
        }
        if (map == null) {
            return;
        }
        final GridNearLockRequest req = map.request();
        final Collection<KeyCacheObject> mappedKeys = map.distributedKeys();
        final ClusterNode node = map.node();
        if (this.filter != null && this.filter.length != 0) {
            req.filter(this.filter, this.cctx);
        }
        if (node.isLocal()) {
            req.miniId(-1);
            if (log.isDebugEnabled()) {
                log.debug("Before locally locking near request: " + req);
            }
            IgniteInternalFuture<GridNearLockResponse> fut = this.dht().lockAllAsync(this.cctx, this.cctx.localNode(), req, this.filter);
            this.add(new GridEmbeddedFuture<Boolean, GridNearLockResponse>(new C2<GridNearLockResponse, Exception, Boolean>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public Boolean apply(GridNearLockResponse res, Exception e) {
                    if (CU.isLockTimeoutOrCancelled(e) || res != null && CU.isLockTimeoutOrCancelled(res.error())) {
                        return false;
                    }
                    if (e != null) {
                        GridNearLockFuture.this.onError(e);
                        return false;
                    }
                    if (res == null) {
                        GridNearLockFuture.this.onError(new IgniteCheckedException("Lock response is null for future: " + this));
                        return false;
                    }
                    if (res.error() != null) {
                        GridNearLockFuture.this.onError(res.error());
                        return false;
                    }
                    if (log.isDebugEnabled()) {
                        log.debug("Acquired lock for local DHT mapping [locId=" + GridNearLockFuture.this.cctx.nodeId() + ", mappedKeys=" + mappedKeys + ", fut=" + GridNearLockFuture.this + ']');
                    }
                    try {
                        int i = 0;
                        for (KeyCacheObject k : mappedKeys) {
                            while (true) {
                                GridNearCacheEntry entry = GridNearLockFuture.this.cctx.near().entryExx(k, req.topologyVersion());
                                try {
                                    boolean record;
                                    IgniteBiTuple oldValTup = (IgniteBiTuple)GridNearLockFuture.this.valMap.get(entry.key());
                                    boolean hasBytes = entry.hasValue();
                                    CacheObject oldVal = entry.rawGet();
                                    CacheObject newVal = res.value(i);
                                    GridCacheVersion dhtVer = res.dhtVersion(i);
                                    GridCacheVersion mappedVer = res.mappedVersion(i);
                                    boolean bl = record = GridNearLockFuture.this.retval && oldValTup != null && ((GridCacheVersion)oldValTup.get1()).equals(dhtVer);
                                    if (newVal == null && oldValTup != null) {
                                        if (((GridCacheVersion)oldValTup.get1()).equals(dhtVer)) {
                                            newVal = (CacheObject)oldValTup.get2();
                                        }
                                        oldVal = (CacheObject)oldValTup.get2();
                                    }
                                    entry.resetFromPrimary(newVal, GridNearLockFuture.this.lockVer, dhtVer, node.id(), GridNearLockFuture.this.topVer);
                                    entry.readyNearLock(GridNearLockFuture.this.lockVer, mappedVer, res.committedVersions(), res.rolledbackVersions(), res.pending());
                                    if (GridNearLockFuture.this.inTx() && GridNearLockFuture.this.implicitTx() && GridNearLockFuture.this.tx.onePhaseCommit()) {
                                        boolean pass = res.filterResult(i);
                                        GridNearLockFuture.this.tx.entry(GridNearLockFuture.this.cctx.txKey(k)).filters(pass ? CU.empty0() : CU.alwaysFalse0Arr());
                                    }
                                    if (record) {
                                        if (GridNearLockFuture.this.cctx.events().isRecordable(64)) {
                                            GridNearLockFuture.this.cctx.events().addEvent(entry.partition(), entry.key(), GridNearLockFuture.this.tx, null, 64, newVal, newVal != null, oldVal, hasBytes, CU.subjectId(GridNearLockFuture.this.tx, GridNearLockFuture.this.cctx.shared()), null, GridNearLockFuture.this.inTx() ? GridNearLockFuture.this.tx.resolveTaskName() : null, GridNearLockFuture.this.keepBinary);
                                        }
                                        if (GridNearLockFuture.this.cctx.statisticsEnabled()) {
                                            GridNearLockFuture.this.cctx.cache().metrics0().onRead(oldVal != null);
                                        }
                                    }
                                    if (!log.isDebugEnabled()) break;
                                    log.debug("Processed response for entry [res=" + res + ", entry=" + entry + ']');
                                    break;
                                }
                                catch (GridCacheEntryRemovedException ignored) {
                                    if (log.isDebugEnabled()) {
                                        log.debug("Failed to add candidates because entry was removed (will renew).");
                                    }
                                    GridNearLockFuture gridNearLockFuture = GridNearLockFuture.this;
                                    synchronized (gridNearLockFuture) {
                                        GridNearLockFuture.this.entries.set(i, (GridDistributedCacheEntry)GridNearLockFuture.this.cctx.cache().entryEx(entry.key()));
                                    }
                                }
                            }
                            ++i;
                        }
                        GridNearLockFuture.this.proceedMapping();
                    }
                    catch (IgniteCheckedException ex) {
                        GridNearLockFuture.this.onError(ex);
                        return false;
                    }
                    return true;
                }
            }, fut));
        } else {
            MiniFuture fut = new MiniFuture(node, mappedKeys, ++this.miniId);
            req.miniId(fut.futureId());
            this.add(fut);
            try {
                if (log.isDebugEnabled()) {
                    log.debug("Sending near lock request [node=" + node.id() + ", req=" + req + ']');
                }
                this.cctx.io().send(node, (GridCacheMessage)req, this.cctx.ioPolicy());
            }
            catch (ClusterTopologyCheckedException ex) {
                fut.onResult(ex);
            }
        }
    }

    private GridNearLockMapping map(KeyCacheObject key, @Nullable GridNearLockMapping mapping, AffinityTopologyVersion topVer) throws IgniteCheckedException {
        assert (mapping == null || mapping.node() != null);
        ClusterNode primary = this.cctx.affinity().primaryByKey(key, topVer);
        if (primary == null) {
            throw new ClusterTopologyServerNotFoundException("Failed to lock keys (all partition nodes left the grid).");
        }
        if (this.cctx.discovery().node(primary.id()) == null) {
            throw this.newTopologyException(null, primary.id());
        }
        if (mapping == null || !primary.id().equals(mapping.node().id())) {
            mapping = new GridNearLockMapping(primary, key);
        } else {
            mapping.addKey(key);
        }
        return mapping;
    }

    private GridDhtTransactionalCacheAdapter<?, ?> dht() {
        return this.cctx.nearTx().dht();
    }

    private ClusterTopologyCheckedException newTopologyException(@Nullable Throwable nested, UUID nodeId) {
        ClusterTopologyCheckedException topEx = new ClusterTopologyCheckedException("Failed to acquire lock for keys (primary node left grid, retry transaction if possible) [keys=" + this.keys + ", node=" + nodeId + ']', nested);
        topEx.retryReadyFuture(this.cctx.shared().nextAffinityReadyFuture(this.topVer));
        return topEx;
    }

    private class MiniFuture
    extends GridFutureAdapter<Boolean> {
        private final int futId;
        @GridToStringExclude
        private ClusterNode node;
        @GridToStringInclude(sensitive=true)
        private Collection<KeyCacheObject> keys;
        private boolean rcvRes;

        MiniFuture(ClusterNode node, Collection<KeyCacheObject> keys, int futId) {
            this.node = node;
            this.keys = keys;
            this.futId = futId;
        }

        int futureId() {
            return this.futId;
        }

        public ClusterNode node() {
            return this.node;
        }

        public Collection<KeyCacheObject> keys() {
            return this.keys;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void onResult(ClusterTopologyCheckedException e) {
            if (this.isDone()) {
                return;
            }
            MiniFuture miniFuture = this;
            synchronized (miniFuture) {
                if (this.rcvRes) {
                    return;
                }
                this.rcvRes = true;
            }
            if (log.isDebugEnabled()) {
                log.debug("Remote node left grid while sending or waiting for reply (will fail): " + this);
            }
            if (GridNearLockFuture.this.tx != null) {
                GridNearLockFuture.this.tx.removeMapping(this.node.id());
            }
            GridNearLockFuture.this.onDone(false, (Throwable)GridNearLockFuture.this.newTopologyException(e, this.node.id()));
            this.onDone(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void onResult(GridNearLockResponse res) {
            GridFutureAdapter gridFutureAdapter = this;
            synchronized (gridFutureAdapter) {
                if (this.rcvRes) {
                    return;
                }
                this.rcvRes = true;
            }
            if (res.error() != null) {
                if (GridNearLockFuture.this.inTx() && GridNearLockFuture.this.cctx.tm().deadlockDetectionEnabled() && (res.error() instanceof IgniteTxTimeoutCheckedException || GridNearLockFuture.this.tx.remainingTime() == -1L)) {
                    return;
                }
                if (log.isDebugEnabled()) {
                    log.debug("Finishing mini future with an error due to error in response [miniFut=" + this + ", res=" + res + ']');
                }
                if (res.error() instanceof GridCacheLockTimeoutException) {
                    this.onDone(false);
                } else {
                    this.onDone(res.error());
                }
                return;
            }
            if (res.clientRemapVersion() != null) {
                assert (GridNearLockFuture.this.cctx.kernalContext().clientNode());
                if (res.compatibleRemapVersion()) {
                    if (GridNearLockFuture.this.tx != null) {
                        GridNearLockFuture.this.tx.onRemap(res.clientRemapVersion(), false);
                        gridFutureAdapter = GridNearLockFuture.this;
                        synchronized (gridFutureAdapter) {
                            for (Object mapping : GridNearLockFuture.this.mappings) {
                                GridNearLockRequest req = ((GridNearLockMapping)mapping).request();
                                assert (req != null) : mapping;
                                req.topologyVersion(res.clientRemapVersion());
                            }
                        }
                    }
                } else {
                    IgniteInternalFuture<AffinityTopologyVersion> affFut = GridNearLockFuture.this.cctx.shared().exchange().affinityReadyFuture(res.clientRemapVersion());
                    if (!affFut.isDone()) {
                        affFut.listen(new CI1<IgniteInternalFuture<?>>(){

                            @Override
                            public void apply(IgniteInternalFuture<?> fut) {
                                try {
                                    fut.get();
                                    MiniFuture.this.remap();
                                }
                                catch (IgniteCheckedException e) {
                                    MiniFuture.this.onDone(e);
                                }
                                finally {
                                    GridNearLockFuture.this.cctx.shared().txContextReset();
                                }
                            }
                        });
                    } else {
                        this.remap();
                    }
                    return;
                }
            }
            int i = 0;
            AffinityTopologyVersion topVer = GridNearLockFuture.this.topVer;
            for (KeyCacheObject k : this.keys) {
                while (true) {
                    GridNearCacheEntry entry = GridNearLockFuture.this.cctx.near().entryExx(k, topVer);
                    try {
                        if (res.dhtVersion(i) == null) {
                            this.onDone(new IgniteCheckedException("Failed to receive DHT version from remote node (will fail the lock): " + res));
                            return;
                        }
                        IgniteBiTuple oldValTup = (IgniteBiTuple)GridNearLockFuture.this.valMap.get(entry.key());
                        CacheObject oldVal = entry.rawGet();
                        boolean hasOldVal = false;
                        CacheObject newVal = res.value(i);
                        boolean readRecordable = false;
                        if (GridNearLockFuture.this.retval && (readRecordable = GridNearLockFuture.this.cctx.events().isRecordable(64))) {
                            hasOldVal = entry.hasValue();
                        }
                        GridCacheVersion dhtVer = res.dhtVersion(i);
                        GridCacheVersion mappedVer = res.mappedVersion(i);
                        if (newVal == null && oldValTup != null) {
                            if (((GridCacheVersion)oldValTup.get1()).equals(dhtVer)) {
                                newVal = (CacheObject)oldValTup.get2();
                            }
                            oldVal = (CacheObject)oldValTup.get2();
                        }
                        entry.resetFromPrimary(newVal, GridNearLockFuture.this.lockVer, dhtVer, this.node.id(), topVer);
                        if (GridNearLockFuture.this.inTx()) {
                            GridNearLockFuture.this.tx.hasRemoteLocks(true);
                            if (GridNearLockFuture.this.implicitTx() && GridNearLockFuture.this.tx.onePhaseCommit()) {
                                boolean pass = res.filterResult(i);
                                GridNearLockFuture.this.tx.entry(GridNearLockFuture.this.cctx.txKey(k)).filters(pass ? CU.empty0() : CU.alwaysFalse0Arr());
                            }
                        }
                        entry.readyNearLock(GridNearLockFuture.this.lockVer, mappedVer, res.committedVersions(), res.rolledbackVersions(), res.pending());
                        if (GridNearLockFuture.this.retval) {
                            if (readRecordable) {
                                GridNearLockFuture.this.cctx.events().addEvent(entry.partition(), entry.key(), GridNearLockFuture.this.tx, null, 64, newVal, newVal != null, oldVal, hasOldVal, CU.subjectId(GridNearLockFuture.this.tx, GridNearLockFuture.this.cctx.shared()), null, GridNearLockFuture.this.inTx() ? GridNearLockFuture.this.tx.resolveTaskName() : null, GridNearLockFuture.this.keepBinary);
                            }
                            if (GridNearLockFuture.this.cctx.statisticsEnabled()) {
                                GridNearLockFuture.this.cctx.cache().metrics0().onRead(false);
                            }
                        }
                        if (!log.isDebugEnabled()) break;
                        log.debug("Processed response for entry [res=" + res + ", entry=" + entry + ']');
                        break;
                    }
                    catch (GridCacheEntryRemovedException ignored) {
                        if (log.isDebugEnabled()) {
                            log.debug("Failed to add candidates because entry was removed (will renew).");
                        }
                        GridNearLockFuture gridNearLockFuture = GridNearLockFuture.this;
                        synchronized (gridNearLockFuture) {
                            GridNearLockFuture.this.entries.set(i, (GridDistributedCacheEntry)GridNearLockFuture.this.cctx.cache().entryEx(entry.key()));
                        }
                    }
                }
                ++i;
            }
            try {
                GridNearLockFuture.this.proceedMapping();
            }
            catch (IgniteCheckedException e) {
                this.onDone(e);
            }
            this.onDone(true);
        }

        private void remap() {
            GridNearLockFuture.this.undoLocks(false, false);
            GridNearLockFuture.this.mapOnTopology(true);
            this.onDone(true);
        }

        @Override
        public String toString() {
            return S.toString(MiniFuture.class, this, "node", this.node.id(), "super", super.toString());
        }
    }

    private class LockTimeoutObject
    extends GridTimeoutObjectAdapter {
        private Set<IgniteTxKey> requestedKeys;

        LockTimeoutObject() {
            super(GridNearLockFuture.this.timeout);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onTimeout() {
            if (log.isDebugEnabled()) {
                log.debug("Timed out waiting for lock response: " + this);
            }
            GridNearLockFuture.this.timedOut = true;
            if (GridNearLockFuture.this.inTx()) {
                if (GridNearLockFuture.this.cctx.tm().deadlockDetectionEnabled()) {
                    GridNearLockFuture gridNearLockFuture = GridNearLockFuture.this;
                    synchronized (gridNearLockFuture) {
                        this.requestedKeys = GridNearLockFuture.this.requestedKeys0();
                        GridNearLockFuture.this.clear();
                    }
                    HashSet<IgniteTxKey> keys = new HashSet<IgniteTxKey>();
                    for (IgniteTxEntry txEntry : GridNearLockFuture.this.tx.allEntries()) {
                        if (txEntry.locked()) continue;
                        keys.add(txEntry.txKey());
                    }
                    IgniteInternalFuture<TxDeadlock> fut = GridNearLockFuture.this.cctx.tm().detectDeadlock(GridNearLockFuture.this.tx, keys);
                    fut.listen(new IgniteInClosure<IgniteInternalFuture<TxDeadlock>>(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void apply(IgniteInternalFuture<TxDeadlock> fut) {
                            try {
                                TxDeadlock deadlock = fut.get();
                                GridNearLockFuture.this.err = new IgniteTxTimeoutCheckedException("Failed to acquire lock within provided timeout for transaction [timeout=" + GridNearLockFuture.this.tx.timeout() + ", tx=" + CU.txString(GridNearLockFuture.this.tx) + ']', deadlock != null ? new TransactionDeadlockException(deadlock.toString(GridNearLockFuture.this.cctx.shared())) : null);
                            }
                            catch (IgniteCheckedException e) {
                                GridNearLockFuture.this.err = e;
                                U.warn(log, "Failed to detect deadlock.", e);
                            }
                            LockTimeoutObject lockTimeoutObject = LockTimeoutObject.this;
                            synchronized (lockTimeoutObject) {
                                GridNearLockFuture.this.onComplete(false, true);
                            }
                        }
                    });
                } else {
                    GridNearLockFuture.this.err = GridNearLockFuture.this.tx.timeoutException();
                }
            } else {
                LockTimeoutObject lockTimeoutObject = this;
                synchronized (lockTimeoutObject) {
                    GridNearLockFuture.this.onComplete(false, true);
                }
            }
        }

        public String toString() {
            return S.toString(LockTimeoutObject.class, this);
        }
    }
}

