/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.distributed.near;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.cluster.ClusterTopologyCheckedException;
import org.apache.ignite.internal.cluster.ClusterTopologyServerNotFoundException;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.GridCacheEntryEx;
import org.apache.ignite.internal.processors.cache.GridCacheMessage;
import org.apache.ignite.internal.processors.cache.GridCacheMvccCandidate;
import org.apache.ignite.internal.processors.cache.GridCacheOperation;
import org.apache.ignite.internal.processors.cache.GridCacheSharedContext;
import org.apache.ignite.internal.processors.cache.distributed.GridDistributedTxMapping;
import org.apache.ignite.internal.processors.cache.distributed.dht.GridDhtTxMapping;
import org.apache.ignite.internal.processors.cache.distributed.dht.topology.GridDhtPartitionTopology;
import org.apache.ignite.internal.processors.cache.distributed.near.GridNearTxLocal;
import org.apache.ignite.internal.processors.cache.distributed.near.GridNearTxPrepareFutureAdapter;
import org.apache.ignite.internal.processors.cache.distributed.near.GridNearTxPrepareRequest;
import org.apache.ignite.internal.processors.cache.distributed.near.GridNearTxPrepareResponse;
import org.apache.ignite.internal.processors.cache.transactions.IgniteInternalTx;
import org.apache.ignite.internal.processors.cache.transactions.IgniteTxEntry;
import org.apache.ignite.internal.processors.tracing.MTC;
import org.apache.ignite.internal.processors.tracing.SpanType;
import org.apache.ignite.internal.transactions.IgniteTxTimeoutCheckedException;
import org.apache.ignite.internal.util.future.GridFutureAdapter;
import org.apache.ignite.internal.util.typedef.C1;
import org.apache.ignite.internal.util.typedef.CI1;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteInClosure;
import org.apache.ignite.lang.IgnitePredicate;
import org.apache.ignite.transactions.TransactionState;
import org.jetbrains.annotations.Nullable;

public class GridNearPessimisticTxPrepareFuture
extends GridNearTxPrepareFutureAdapter {
    private static final long serialVersionUID = 4014479758215810181L;

    public GridNearPessimisticTxPrepareFuture(GridCacheSharedContext cctx, GridNearTxLocal tx) {
        super(cctx, tx);
        assert (tx.pessimistic()) : tx;
    }

    @Override
    public void onNearTxLocalTimeout() {
    }

    @Override
    protected boolean ignoreFailure(Throwable err) {
        return IgniteCheckedException.class.isAssignableFrom(err.getClass());
    }

    @Override
    public boolean onNodeLeft(UUID nodeId) {
        boolean found = false;
        for (IgniteInternalFuture fut : this.futures()) {
            MiniFuture f;
            if (!(fut instanceof MiniFuture) || !(f = (MiniFuture)fut).primary().id().equals(nodeId)) continue;
            ClusterTopologyCheckedException e = new ClusterTopologyCheckedException("Remote node left grid: " + nodeId);
            e.retryReadyFuture(this.cctx.nextAffinityReadyFuture(this.tx.topologyVersion()));
            f.onNodeLeft(e);
            found = true;
        }
        return found;
    }

    @Override
    public void onResult(UUID nodeId, GridNearTxPrepareResponse res) {
        if (!this.isDone()) {
            assert (res.clientRemapVersion() == null) : res;
            MiniFuture f = this.miniFuture(res.miniId());
            if (f != null) {
                assert (f.primary().id().equals(nodeId));
                f.onResult(res, true);
            } else if (msgLog.isDebugEnabled()) {
                msgLog.debug("Near pessimistic prepare, failed to find mini future [txId=" + this.tx.nearXidVersion() + ", node=" + nodeId + ", res=" + res + ", fut=" + this + ']');
            }
        } else if (msgLog.isDebugEnabled()) {
            msgLog.debug("Near pessimistic prepare, response for finished future [txId=" + this.tx.nearXidVersion() + ", node=" + nodeId + ", res=" + res + ", fut=" + this + ']');
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MiniFuture miniFuture(int miniId) {
        GridNearPessimisticTxPrepareFuture gridNearPessimisticTxPrepareFuture = this;
        synchronized (gridNearPessimisticTxPrepareFuture) {
            int size = this.futuresCountNoLock();
            for (int i = 0; i < size; ++i) {
                MiniFuture mini;
                IgniteInternalFuture fut = this.future(i);
                if (!(fut instanceof MiniFuture) || (mini = (MiniFuture)fut).futureId() != miniId) continue;
                if (!mini.isDone()) {
                    return mini;
                }
                return null;
            }
        }
        return null;
    }

    @Override
    public void prepare() {
        this.span = this.cctx.kernalContext().tracing().create(SpanType.TX_NEAR_PREPARE, MTC.span());
        try (MTC.TraceSurroundings ignored = MTC.supportContinual(this.span);){
            if (!this.tx.state(TransactionState.PREPARING)) {
                if (this.tx.isRollbackOnly() || this.tx.setRollbackOnly()) {
                    if (this.tx.remainingTime() == -1L) {
                        this.onDone(this.tx.timeoutException());
                    } else {
                        this.onDone(this.tx.rollbackException());
                    }
                } else {
                    this.onDone(new IgniteCheckedException("Invalid transaction state for prepare [state=" + (Object)((Object)this.tx.state()) + ", tx=" + this + ']'));
                }
                return;
            }
            try {
                this.tx.userPrepare(Collections.emptyList());
                this.cctx.mvcc().addFuture(this);
                this.preparePessimistic();
            }
            catch (IgniteCheckedException e) {
                this.onDone(e);
            }
        }
    }

    private GridNearTxPrepareRequest createRequest(Map<UUID, Collection<UUID>> txNodes, GridDistributedTxMapping m, long timeout, Collection<IgniteTxEntry> reads, Collection<IgniteTxEntry> writes) {
        GridNearTxPrepareRequest req = new GridNearTxPrepareRequest(this.futId, this.tx.topologyVersion(), this.tx, timeout, reads, writes, m.hasNearCacheEntries(), txNodes, true, this.tx.onePhaseCommit(), this.tx.needReturnValue() && this.tx.implicit(), this.tx.implicitSingle(), m.explicitLock(), this.tx.subjectId(), this.tx.taskNameHash(), false, true, this.tx.activeCachesDeploymentEnabled(), this.tx.txState().recovery());
        req.queryUpdate(m.queryUpdate());
        for (IgniteTxEntry txEntry : writes) {
            if (txEntry.op() != GridCacheOperation.TRANSFORM) continue;
            req.addDhtVersion(txEntry.txKey(), null);
        }
        return req;
    }

    private void prepareLocal(GridNearTxPrepareRequest req, GridDistributedTxMapping m, int miniId, final boolean nearEntries) {
        final MiniFuture fut = new MiniFuture(m, miniId);
        req.miniId(fut.futureId());
        this.add(fut);
        IgniteInternalFuture<GridNearTxPrepareResponse> prepFut = nearEntries ? this.cctx.tm().txHandler().prepareNearTxLocal(this.tx, req) : this.cctx.tm().txHandler().prepareColocatedTx(this.tx, req);
        prepFut.listen((IgniteInClosure<IgniteInternalFuture<GridNearTxPrepareResponse>>)new CI1<IgniteInternalFuture<GridNearTxPrepareResponse>>(){

            @Override
            public void apply(IgniteInternalFuture<GridNearTxPrepareResponse> prepFut) {
                try {
                    fut.onResult(prepFut.get(), nearEntries);
                }
                catch (IgniteCheckedException e) {
                    fut.onError(e);
                }
            }
        });
    }

    private void preparePessimistic() {
        long timeout;
        ClusterNode primary;
        HashMap<UUID, Collection<UUID>> txNodes;
        assert (!this.tx.implicitSingle() || this.tx.txState().mvccEnabled());
        HashMap<UUID, GridDistributedTxMapping> mappings = new HashMap<UUID, GridDistributedTxMapping>();
        AffinityTopologyVersion topVer = this.tx.topologyVersion();
        boolean hasNearCache = false;
        if (this.tx.txState().mvccEnabled()) {
            Collection<GridDistributedTxMapping> mvccMappings = this.tx.implicitSingle() ? Collections.singleton(this.tx.mappings().singleMapping()) : this.tx.mappings().mappings();
            txNodes = new HashMap(mvccMappings.size());
            for (GridDistributedTxMapping m : mvccMappings) {
                mappings.put(m.primary().id(), m);
                txNodes.put(m.primary().id(), m.backups());
            }
        } else {
            GridDhtTxMapping txMapping = new GridDhtTxMapping();
            for (IgniteTxEntry txEntry : this.tx.allEntries()) {
                List<ClusterNode> nodes;
                txEntry.clearEntryReadVersion();
                GridCacheContext<?, ?> cacheCtx = txEntry.context();
                if (cacheCtx.isNear()) {
                    hasNearCache = true;
                }
                if (!cacheCtx.isLocal()) {
                    GridDhtPartitionTopology top = cacheCtx.topology();
                    nodes = top.nodes(cacheCtx.affinity().partition(txEntry.key()), topVer);
                } else {
                    nodes = cacheCtx.affinity().nodesByKey(txEntry.key(), topVer);
                }
                if (F.isEmpty(nodes)) {
                    this.onDone(new ClusterTopologyServerNotFoundException("Failed to map keys to nodes (partition is not mapped to any node) [key=" + txEntry.key() + ", partition=" + cacheCtx.affinity().partition(txEntry.key()) + ", topVer=" + topVer + ']'));
                    return;
                }
                primary = nodes.get(0);
                GridDistributedTxMapping nodeMapping = (GridDistributedTxMapping)mappings.get(primary.id());
                if (nodeMapping == null) {
                    nodeMapping = new GridDistributedTxMapping(primary);
                    mappings.put(primary.id(), nodeMapping);
                }
                txEntry.nodeId(primary.id());
                nodeMapping.add(txEntry);
                txMapping.addMapping(nodes);
            }
            txNodes = txMapping.transactionNodes();
        }
        this.tx.transactionNodes(txNodes);
        if (!hasNearCache) {
            this.checkOnePhase(txNodes);
        }
        if ((timeout = this.tx.remainingTime()) == -1L) {
            this.onDone(new IgniteTxTimeoutCheckedException("Transaction timed out and was rolled back: " + this.tx));
            return;
        }
        int miniId = 0;
        for (GridDistributedTxMapping m : mappings.values()) {
            GridNearTxPrepareRequest req;
            primary = m.primary();
            if (primary.isLocal()) {
                if (m.hasNearCacheEntries() && m.hasColocatedCacheEntries()) {
                    GridNearTxPrepareRequest nearReq = this.createRequest(txNodes, m, timeout, m.nearEntriesReads(), m.nearEntriesWrites());
                    this.prepareLocal(nearReq, m, ++miniId, true);
                    GridNearTxPrepareRequest colocatedReq = this.createRequest(txNodes, m, timeout, m.colocatedEntriesReads(), m.colocatedEntriesWrites());
                    this.prepareLocal(colocatedReq, m, ++miniId, false);
                    continue;
                }
                req = this.createRequest(txNodes, m, timeout, m.reads(), m.writes());
                this.prepareLocal(req, m, ++miniId, m.hasNearCacheEntries());
                continue;
            }
            req = this.createRequest(txNodes, m, timeout, m.reads(), m.writes());
            MiniFuture fut = new MiniFuture(m, ++miniId);
            req.miniId(fut.futureId());
            this.add(fut);
            try {
                this.cctx.io().send(primary, (GridCacheMessage)req, this.tx.ioPolicy());
                if (!msgLog.isDebugEnabled()) continue;
                msgLog.debug("Near pessimistic prepare, sent request [txId=" + this.tx.nearXidVersion() + ", node=" + primary.id() + ']');
            }
            catch (ClusterTopologyCheckedException e) {
                e.retryReadyFuture(this.cctx.nextAffinityReadyFuture(topVer));
                fut.onNodeLeft(e);
            }
            catch (IgniteCheckedException e) {
                if (msgLog.isDebugEnabled()) {
                    msgLog.debug("Near pessimistic prepare, failed send request [txId=" + this.tx.nearXidVersion() + ", node=" + primary.id() + ", err=" + e + ']');
                }
                fut.onError(e);
                break;
            }
        }
        this.markInitialized();
    }

    @Override
    public boolean onOwnerChanged(GridCacheEntryEx entry, GridCacheMvccCandidate owner) {
        return false;
    }

    @Override
    public boolean onDone(@Nullable IgniteInternalTx res, @Nullable Throwable err) {
        try (MTC.TraceSurroundings ignored = MTC.support(this.span);){
            if (err != null) {
                ERR_UPD.compareAndSet(this, null, err);
            }
            err = this.err;
            if (!(this.tx.onePhaseCommit() && this.tx.mappings().get(this.cctx.localNodeId()) != null || err != null && !this.tx.needCheckBackup())) {
                this.tx.state(TransactionState.PREPARED);
            }
            if (super.onDone(this.tx, err)) {
                this.cctx.mvcc().removeVersionedFuture(this);
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
    }

    @Override
    public String toString() {
        Collection futs = F.viewReadOnly(this.futures(), new C1<IgniteInternalFuture<?>, String>(){

            @Override
            public String apply(IgniteInternalFuture<?> f) {
                if (f instanceof MiniFuture) {
                    return "[node=" + ((MiniFuture)f).primary().id() + ", loc=" + ((MiniFuture)f).primary().isLocal() + ", done=" + f.isDone() + "]";
                }
                return f.toString();
            }
        }, new IgnitePredicate[0]);
        return S.toString(GridNearPessimisticTxPrepareFuture.class, this, "innerFuts", futs, "txId", this.tx.nearXidVersion(), "super", super.toString());
    }

    private class MiniFuture
    extends GridFutureAdapter<GridNearTxPrepareResponse> {
        private final int futId;
        private GridDistributedTxMapping m;

        MiniFuture(GridDistributedTxMapping m, int futId) {
            this.m = m;
            this.futId = futId;
        }

        int futureId() {
            return this.futId;
        }

        public ClusterNode primary() {
            return this.m.primary();
        }

        void onResult(GridNearTxPrepareResponse res, boolean updateMapping) {
            if (res.error() != null) {
                this.onError(res.error());
            } else {
                GridNearPessimisticTxPrepareFuture.this.onPrepareResponse(this.m, res, updateMapping);
                this.onDone(res);
            }
        }

        void onNodeLeft(ClusterTopologyCheckedException e) {
            if (GridNearTxPrepareFutureAdapter.msgLog.isDebugEnabled()) {
                GridNearTxPrepareFutureAdapter.msgLog.debug("Near pessimistic prepare, mini future node left [txId=" + GridNearPessimisticTxPrepareFuture.this.tx.nearXidVersion() + ", nodeId=" + this.m.primary().id() + ']');
            }
            if (GridNearPessimisticTxPrepareFuture.this.tx.onePhaseCommit()) {
                GridNearPessimisticTxPrepareFuture.this.tx.markForBackupCheck();
                this.onDone((GridNearTxPrepareResponse)null);
            }
            this.onError(e);
        }

        void onError(Throwable e) {
            if (this.isDone()) {
                U.warn(GridNearTxPrepareFutureAdapter.log, "Received error when future is done [fut=" + this + ", err=" + e + ", tx=" + GridNearPessimisticTxPrepareFuture.this.tx + ']');
                return;
            }
            if (GridNearTxPrepareFutureAdapter.log.isDebugEnabled()) {
                GridNearTxPrepareFutureAdapter.log.debug("Error on tx prepare [fut=" + this + ", err=" + e + ", tx=" + GridNearPessimisticTxPrepareFuture.this.tx + ']');
            }
            if (GridNearTxPrepareFutureAdapter.ERR_UPD.compareAndSet(GridNearPessimisticTxPrepareFuture.this, null, e)) {
                GridNearPessimisticTxPrepareFuture.this.tx.setRollbackOnly();
            }
            this.onDone(e);
        }

        @Override
        public String toString() {
            return S.toString(MiniFuture.class, this, "done", (Object)this.isDone(), "cancelled", this.isCancelled(), "err", this.error());
        }
    }
}

