/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.persistence;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.OverlappingFileLockException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.LockSupport;
import java.util.concurrent.locks.ReentrantLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.ToLongFunction;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.ignite.DataRegionMetricsProvider;
import org.apache.ignite.DataStorageMetrics;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteInterruptedException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.IgniteSystemProperties;
import org.apache.ignite.cache.CacheAtomicityMode;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.configuration.DataPageEvictionMode;
import org.apache.ignite.configuration.DataRegionConfiguration;
import org.apache.ignite.configuration.DataStorageConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.failure.FailureContext;
import org.apache.ignite.failure.FailureType;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.IgniteFutureTimeoutCheckedException;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.NodeStoppingException;
import org.apache.ignite.internal.managers.discovery.GridDiscoveryManager;
import org.apache.ignite.internal.mem.DirectMemoryProvider;
import org.apache.ignite.internal.mem.DirectMemoryRegion;
import org.apache.ignite.internal.metric.IoStatisticsHolderNoOp;
import org.apache.ignite.internal.pagemem.FullPageId;
import org.apache.ignite.internal.pagemem.PageIdUtils;
import org.apache.ignite.internal.pagemem.PageMemory;
import org.apache.ignite.internal.pagemem.PageUtils;
import org.apache.ignite.internal.pagemem.store.IgnitePageStoreManager;
import org.apache.ignite.internal.pagemem.store.PageStore;
import org.apache.ignite.internal.pagemem.wal.WALIterator;
import org.apache.ignite.internal.pagemem.wal.WALPointer;
import org.apache.ignite.internal.pagemem.wal.record.CacheState;
import org.apache.ignite.internal.pagemem.wal.record.CheckpointRecord;
import org.apache.ignite.internal.pagemem.wal.record.DataEntry;
import org.apache.ignite.internal.pagemem.wal.record.DataRecord;
import org.apache.ignite.internal.pagemem.wal.record.MemoryRecoveryRecord;
import org.apache.ignite.internal.pagemem.wal.record.MetastoreDataRecord;
import org.apache.ignite.internal.pagemem.wal.record.MvccTxRecord;
import org.apache.ignite.internal.pagemem.wal.record.PageSnapshot;
import org.apache.ignite.internal.pagemem.wal.record.RollbackRecord;
import org.apache.ignite.internal.pagemem.wal.record.WALRecord;
import org.apache.ignite.internal.pagemem.wal.record.WalRecordCacheGroupAware;
import org.apache.ignite.internal.pagemem.wal.record.delta.PageDeltaRecord;
import org.apache.ignite.internal.pagemem.wal.record.delta.PartitionDestroyRecord;
import org.apache.ignite.internal.pagemem.wal.record.delta.PartitionMetaStateRecord;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.cache.CacheGroupContext;
import org.apache.ignite.internal.processors.cache.CacheGroupDescriptor;
import org.apache.ignite.internal.processors.cache.DynamicCacheDescriptor;
import org.apache.ignite.internal.processors.cache.ExchangeActions;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.GridCacheSharedContext;
import org.apache.ignite.internal.processors.cache.distributed.dht.preloader.GridDhtPartitionsExchangeFuture;
import org.apache.ignite.internal.processors.cache.distributed.dht.preloader.PartitionsExchangeAware;
import org.apache.ignite.internal.processors.cache.distributed.dht.topology.GridDhtLocalPartition;
import org.apache.ignite.internal.processors.cache.distributed.dht.topology.GridDhtPartitionState;
import org.apache.ignite.internal.processors.cache.mvcc.txlog.TxLog;
import org.apache.ignite.internal.processors.cache.persistence.CheckpointState;
import org.apache.ignite.internal.processors.cache.persistence.DataRegion;
import org.apache.ignite.internal.processors.cache.persistence.DataRegionMetricsImpl;
import org.apache.ignite.internal.processors.cache.persistence.DataStorageMetricsImpl;
import org.apache.ignite.internal.processors.cache.persistence.DataStorageMetricsSnapshot;
import org.apache.ignite.internal.processors.cache.persistence.DatabaseLifecycleListener;
import org.apache.ignite.internal.processors.cache.persistence.DbCheckpointListener;
import org.apache.ignite.internal.processors.cache.persistence.GridCacheOffheapManager;
import org.apache.ignite.internal.processors.cache.persistence.IgniteCacheDatabaseSharedManager;
import org.apache.ignite.internal.processors.cache.persistence.StorageException;
import org.apache.ignite.internal.processors.cache.persistence.checkpoint.CheckpointEntry;
import org.apache.ignite.internal.processors.cache.persistence.checkpoint.CheckpointEntryType;
import org.apache.ignite.internal.processors.cache.persistence.checkpoint.CheckpointHistory;
import org.apache.ignite.internal.processors.cache.persistence.checkpoint.CheckpointHistoryResult;
import org.apache.ignite.internal.processors.cache.persistence.checkpoint.CheckpointPagesInfoHolder;
import org.apache.ignite.internal.processors.cache.persistence.checkpoint.CheckpointProgress;
import org.apache.ignite.internal.processors.cache.persistence.checkpoint.Checkpointer;
import org.apache.ignite.internal.processors.cache.persistence.checkpoint.ReservationReason;
import org.apache.ignite.internal.processors.cache.persistence.file.FileIO;
import org.apache.ignite.internal.processors.cache.persistence.file.FileIOFactory;
import org.apache.ignite.internal.processors.cache.persistence.file.FilePageStoreManager;
import org.apache.ignite.internal.processors.cache.persistence.metastorage.MetaStorage;
import org.apache.ignite.internal.processors.cache.persistence.metastorage.MetastorageLifecycleListener;
import org.apache.ignite.internal.processors.cache.persistence.pagemem.PageMemoryEx;
import org.apache.ignite.internal.processors.cache.persistence.pagemem.PageMemoryImpl;
import org.apache.ignite.internal.processors.cache.persistence.partstate.GroupPartitionId;
import org.apache.ignite.internal.processors.cache.persistence.snapshot.IgniteCacheSnapshotManager;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.PageIO;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.PagePartitionMetaIO;
import org.apache.ignite.internal.processors.cache.persistence.wal.FileWALPointer;
import org.apache.ignite.internal.processors.cache.persistence.wal.crc.IgniteDataIntegrityViolationException;
import org.apache.ignite.internal.processors.port.GridPortProcessor;
import org.apache.ignite.internal.processors.port.GridPortRecord;
import org.apache.ignite.internal.processors.query.GridQueryProcessor;
import org.apache.ignite.internal.util.GridMultiCollectionWrapper;
import org.apache.ignite.internal.util.IgniteUtils;
import org.apache.ignite.internal.util.StripedExecutor;
import org.apache.ignite.internal.util.TimeBag;
import org.apache.ignite.internal.util.future.GridCompoundFuture;
import org.apache.ignite.internal.util.future.GridFutureAdapter;
import org.apache.ignite.internal.util.lang.GridInClosure3X;
import org.apache.ignite.internal.util.tostring.GridToStringInclude;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.T2;
import org.apache.ignite.internal.util.typedef.X;
import org.apache.ignite.internal.util.typedef.internal.CU;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.SB;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteBiPredicate;
import org.apache.ignite.lang.IgniteBiTuple;
import org.apache.ignite.lang.IgniteInClosure;
import org.apache.ignite.lang.IgniteOutClosure;
import org.apache.ignite.lang.IgnitePredicate;
import org.apache.ignite.mxbean.DataStorageMetricsMXBean;
import org.apache.ignite.thread.IgniteThread;
import org.apache.ignite.thread.IgniteThreadPoolExecutor;
import org.apache.ignite.transactions.TransactionState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GridCacheDatabaseSharedManager
extends IgniteCacheDatabaseSharedManager {
    public static final String IGNITE_PDS_CHECKPOINT_TEST_SKIP_SYNC = "IGNITE_PDS_CHECKPOINT_TEST_SKIP_SYNC";
    public static final String IGNITE_PDS_SKIP_CHECKPOINT_ON_NODE_STOP = "IGNITE_PDS_SKIP_CHECKPOINT_ON_NODE_STOP";
    public static final String IGNITE_PDS_LOG_CP_READ_LOCK_HOLDERS = "IGNITE_PDS_LOG_CP_READ_LOCK_HOLDERS";
    public static final String METASTORE_DATA_REGION_NAME = "metastoreMemPlc";
    private static final double PAGE_LIST_CACHE_LIMIT_THRESHOLD = 0.1;
    private final int walRebalanceThreshold = IgniteSystemProperties.getInteger("IGNITE_PDS_WAL_REBALANCE_THRESHOLD", 500);
    private final boolean preferWalRebalance = IgniteSystemProperties.getBoolean("IGNITE_PREFER_WAL_REBALANCE");
    private final String throttlingPlcOverride = IgniteSystemProperties.getString("IGNITE_OVERRIDE_WRITE_THROTTLING_ENABLED");
    private final boolean logReadLockHolders = IgniteSystemProperties.getBoolean("IGNITE_PDS_LOG_CP_READ_LOCK_HOLDERS");
    private static final boolean ASSERTION_ENABLED = GridCacheDatabaseSharedManager.class.desiredAssertionStatus();
    public static final Pattern CP_FILE_NAME_PATTERN = Pattern.compile("(\\d+)-(.*)-(START|END)\\.bin");
    private static final String MBEAN_NAME = "DataStorageMetrics";
    private static final String MBEAN_GROUP = "Persistent Store";
    private static final String WAL_KEY_PREFIX = "grp-wal-";
    private static final String WAL_GLOBAL_KEY_PREFIX = "grp-wal-disabled-";
    private static final String WAL_LOCAL_KEY_PREFIX = "grp-wal-local-disabled-";
    private static final String CHECKPOINT_INAPPLICABLE_FOR_REBALANCE = "cp-wal-rebalance-inapplicable-";
    private static final String CHECKPOINT_RUNNER_THREAD_PREFIX = "checkpoint-runner";
    private static final long THROTTLE_LOGGING_THRESHOLD = TimeUnit.SECONDS.toNanos(5L);
    private static final int THROTTLE_QUEUE_SIZE_THRESHOLD = 10000;
    private volatile Checkpointer checkpointer;
    private volatile IgniteThread checkpointerThread;
    ReentrantReadWriteLock checkpointLock = new ReentrantReadWriteLock();
    private CheckpointHistory cpHist;
    private FilePageStoreManager storeMgr;
    private File cpDir;
    private final DataStorageConfiguration persistenceCfg;
    private boolean stopping;
    private volatile WALPointer walTail;
    @Nullable
    private IgniteThreadPoolExecutor asyncRunner;
    private ThreadLocal<ByteBuffer> threadBuf;
    private final ConcurrentMap<Integer, GridFutureAdapter<Void>> idxRebuildFuts = new ConcurrentHashMap<Integer, GridFutureAdapter<Void>>();
    @Nullable
    private FileLockHolder fileLockHolder;
    private final long lockWaitTime;
    private WALPointer reservedForExchange;
    private volatile WALPointer reservedForPreloading;
    private IgniteCacheSnapshotManager snapshotMgr;
    private DataStorageMetricsImpl persStoreMetrics;
    private MetaStorage metaStorage;
    private MetaStorage.TmpStorage tmpMetaStorage;
    private List<MetastorageLifecycleListener> metastorageLifecycleLsnrs;
    private Collection<Integer> initiallyGlobalWalDisabledGrps = new HashSet<Integer>();
    private Collection<Integer> initiallyLocWalDisabledGrps = new HashSet<Integer>();
    private final FileIOFactory ioFactory;
    private volatile long checkpointReadLockTimeout;
    private final boolean recoveryVerboseLogging = IgniteSystemProperties.getBoolean("IGNITE_RECOVERY_VERBOSE_LOGGING", false);
    private volatile WALPointer memoryRecoveryRecordPtr;
    private ReentrantLock releaseHistForPreloadingLock = new ReentrantLock();
    private final Map<String, AtomicLong> pageListCacheLimits = new ConcurrentHashMap<String, AtomicLong>();

    public GridCacheDatabaseSharedManager(GridKernalContext ctx) {
        Long cfgCheckpointReadLockTimeout;
        IgniteConfiguration cfg = ctx.config();
        this.persistenceCfg = cfg.getDataStorageConfiguration();
        assert (this.persistenceCfg != null);
        this.lockWaitTime = this.persistenceCfg.getLockWaitTime();
        this.persStoreMetrics = new DataStorageMetricsImpl(ctx.metric(), this.persistenceCfg.isMetricsEnabled(), this.persistenceCfg.getMetricsRateTimeInterval(), this.persistenceCfg.getMetricsSubIntervalCount());
        this.ioFactory = this.persistenceCfg.getFileIOFactory();
        Long l = cfgCheckpointReadLockTimeout = ctx.config().getDataStorageConfiguration() != null ? ctx.config().getDataStorageConfiguration().getCheckpointReadLockTimeout() : null;
        this.checkpointReadLockTimeout = IgniteSystemProperties.getLong("IGNITE_CHECKPOINT_READ_LOCK_TIMEOUT", cfgCheckpointReadLockTimeout != null ? cfgCheckpointReadLockTimeout : (ctx.workersRegistry() != null ? ctx.workersRegistry().getSystemWorkerBlockedTimeout() : ctx.config().getFailureDetectionTimeout().longValue()));
    }

    public FilePageStoreManager getFileStoreManager() {
        return this.storeMgr;
    }

    private void notifyMetastorageReadyForRead() throws IgniteCheckedException {
        for (MetastorageLifecycleListener lsnr : this.metastorageLifecycleLsnrs) {
            lsnr.onReadyForRead(this.metaStorage);
        }
    }

    private void notifyMetastorageReadyForReadWrite() throws IgniteCheckedException {
        for (MetastorageLifecycleListener lsnr : this.metastorageLifecycleLsnrs) {
            lsnr.onReadyForReadWrite(this.metaStorage);
        }
    }

    public Checkpointer getCheckpointer() {
        return this.checkpointer;
    }

    public IgniteThread checkpointerThread() {
        return this.checkpointerThread;
    }

    public boolean preferWalRebalance() {
        return this.preferWalRebalance;
    }

    public IgniteInternalFuture<Void> enableCheckpoints(boolean enable) {
        IgniteInternalFuture<Void> fut = this.checkpointer.enableCheckpoints(enable);
        this.wakeupForCheckpoint("enableCheckpoints()");
        return fut;
    }

    @Override
    protected void initDataRegions0(DataStorageConfiguration memCfg) throws IgniteCheckedException {
        super.initDataRegions0(memCfg);
        this.addDataRegion(memCfg, this.createMetastoreDataRegionConfig(memCfg), false);
        this.persStoreMetrics.regionMetrics(this.memMetricsMap.values());
    }

    private CheckpointPagesInfoHolder beginAllCheckpoints(IgniteInternalFuture<?> allowToReplace) {
        ArrayList<Map.Entry<PageMemoryEx, GridMultiCollectionWrapper<FullPageId>>> res = new ArrayList<Map.Entry<PageMemoryEx, GridMultiCollectionWrapper<FullPageId>>>(this.dataRegions().size());
        int pagesNum = 0;
        for (DataRegion reg : this.dataRegions()) {
            if (!reg.config().isPersistenceEnabled()) continue;
            GridMultiCollectionWrapper<FullPageId> nextCpPagesCol = ((PageMemoryEx)reg.pageMemory()).beginCheckpoint(allowToReplace);
            pagesNum += nextCpPagesCol.size();
            res.add(new T2<PageMemoryEx, GridMultiCollectionWrapper<FullPageId>>((PageMemoryEx)reg.pageMemory(), nextCpPagesCol));
        }
        CheckpointProgress progress = this.getCheckpointer().currentProgress();
        if (progress != null) {
            progress.currentCheckpointPagesCount(pagesNum);
        }
        return new CheckpointPagesInfoHolder(res, pagesNum);
    }

    private DataRegionConfiguration createMetastoreDataRegionConfig(DataStorageConfiguration storageCfg) {
        DataRegionConfiguration cfg = new DataRegionConfiguration();
        cfg.setName(METASTORE_DATA_REGION_NAME);
        cfg.setInitialSize(storageCfg.getSystemRegionInitialSize());
        cfg.setMaxSize(storageCfg.getSystemRegionMaxSize());
        cfg.setPersistenceEnabled(true);
        cfg.setLazyMemoryAllocation(false);
        return cfg;
    }

    @Override
    protected void start0() throws IgniteCheckedException {
        super.start0();
        this.snapshotMgr = this.cctx.snapshot();
        GridKernalContext kernalCtx = this.cctx.kernalContext();
        if (this.logReadLockHolders) {
            this.checkpointLock = new IgniteUtils.ReentrantReadWriteLockTracer(this.checkpointLock, kernalCtx, 5000L);
        }
        if (!kernalCtx.clientNode()) {
            kernalCtx.internalSubscriptionProcessor().registerDatabaseListener(new MetastorageRecoveryLifecycle());
            this.cpHist = new CheckpointHistory(kernalCtx);
            IgnitePageStoreManager store = this.cctx.pageStore();
            assert (store instanceof FilePageStoreManager) : "Invalid page store manager was created: " + store;
            this.storeMgr = (FilePageStoreManager)store;
            this.cpDir = Paths.get(this.storeMgr.workDir().getAbsolutePath(), "cp").toFile();
            if (!U.mkdirs(this.cpDir)) {
                throw new IgniteCheckedException("Could not create directory for checkpoint metadata: " + this.cpDir);
            }
            this.checkpointer = new Checkpointer(this.cctx.igniteInstanceName(), "db-checkpoint-thread", kernalCtx.workersRegistry(), this.log, this.pageSize(), this.cctx.kernalContext().longJvmPauseDetector(), kernalCtx.failure(), this.persistenceCfg, this.initializeCheckpointPool(), this.snapshotMgr, this.checkpointLock, this.cctx.wal(), this.cpHist, this.persistentStoreMetricsImpl(), this::dataRegions, this.ioFactory, this.cpDir, this.cctx.cache(), this.storeMgr, this.resolveThrottlingPolicy(), this::getPageMemoryForCacheGroup, new ThreadLocal<ByteBuffer>(){

                @Override
                protected ByteBuffer initialValue() {
                    ByteBuffer tmpWriteBuf = ByteBuffer.allocateDirect(GridCacheDatabaseSharedManager.this.pageSize());
                    tmpWriteBuf.order(ByteOrder.nativeOrder());
                    return tmpWriteBuf;
                }
            });
            FileLockHolder preLocked = kernalCtx.pdsFolderResolver().resolveFolders().getLockedFileLockHolder();
            this.acquireFileLock(preLocked);
            this.cleanupTempCheckpointDirectory();
            this.persStoreMetrics.wal(this.cctx.wal());
        }
    }

    @Override
    public void cleanupTempCheckpointDirectory() throws IgniteCheckedException {
        try (DirectoryStream<Path> files = Files.newDirectoryStream(this.cpDir.toPath(), FilePageStoreManager.TMP_FILE_MATCHER::matches);){
            for (Path path : files) {
                Files.delete(path);
            }
        }
        catch (IOException e) {
            throw new IgniteCheckedException("Failed to cleanup checkpoint directory from temporary files: " + this.cpDir, e);
        }
    }

    @Override
    public void cleanupRestoredCaches() {
        PageMemory memory;
        if (this.dataRegionMap.isEmpty()) {
            return;
        }
        boolean hasMvccCache = false;
        for (CacheGroupDescriptor grpDesc : this.cctx.cache().cacheGroupDescriptors().values()) {
            hasMvccCache |= grpDesc.config().getAtomicityMode() == CacheAtomicityMode.TRANSACTIONAL_SNAPSHOT;
            String regionName = grpDesc.config().getDataRegionName();
            DataRegion region = regionName != null ? (DataRegion)this.dataRegionMap.get(regionName) : this.dfltDataRegion;
            if (region == null) continue;
            if (this.log.isInfoEnabled()) {
                this.log.info("Page memory " + region.config().getName() + " for " + grpDesc + " has invalidated.");
            }
            int partitions = grpDesc.config().getAffinity().partitions();
            if (!(region.pageMemory() instanceof PageMemoryEx)) continue;
            PageMemoryEx memEx = (PageMemoryEx)region.pageMemory();
            for (int partId = 0; partId < partitions; ++partId) {
                memEx.invalidate(grpDesc.groupId(), partId);
            }
            memEx.invalidate(grpDesc.groupId(), 65535);
        }
        if (!hasMvccCache && this.dataRegionMap.containsKey("TxLog") && (memory = ((DataRegion)this.dataRegionMap.get("TxLog")).pageMemory()) instanceof PageMemoryEx) {
            ((PageMemoryEx)memory).invalidate(TxLog.TX_LOG_CACHE_ID, 65535);
        }
        final boolean hasMvccCache0 = hasMvccCache;
        this.storeMgr.cleanupPageStoreIfMatch(new Predicate<Integer>(){

            @Override
            public boolean test(Integer grpId) {
                return MetaStorage.METASTORAGE_CACHE_ID != grpId && (TxLog.TX_LOG_CACHE_ID != grpId || !hasMvccCache0);
            }
        }, true);
    }

    @Override
    public void cleanupCheckpointDirectory() throws IgniteCheckedException {
        if (this.cpHist != null) {
            this.cpHist = new CheckpointHistory(this.cctx.kernalContext());
        }
        try (DirectoryStream<Path> files = Files.newDirectoryStream(this.cpDir.toPath());){
            for (Path path : files) {
                Files.delete(path);
            }
        }
        catch (IOException e) {
            throw new IgniteCheckedException("Failed to cleanup checkpoint directory: " + this.cpDir, e);
        }
    }

    private void acquireFileLock(FileLockHolder preLocked) throws IgniteCheckedException {
        if (this.cctx.kernalContext().clientNode()) {
            return;
        }
        FileLockHolder fileLockHolder = this.fileLockHolder = preLocked == null ? new FileLockHolder(this.storeMgr.workDir().getPath(), this.cctx.kernalContext(), this.log) : preLocked;
        if (!this.fileLockHolder.isLocked()) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Try to capture file lock [nodeId=" + this.cctx.localNodeId() + " path=" + this.fileLockHolder.lockPath() + "]");
            }
            this.fileLockHolder.tryLock(this.lockWaitTime);
        }
    }

    private void releaseFileLock() {
        if (this.cctx.kernalContext().clientNode() || this.fileLockHolder == null) {
            return;
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("Release file lock [nodeId=" + this.cctx.localNodeId() + " path=" + this.fileLockHolder.lockPath() + "]");
        }
        this.fileLockHolder.close();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private List<CheckpointEntry> retreiveHistory() throws IgniteCheckedException {
        if (!this.cpDir.exists()) {
            return Collections.emptyList();
        }
        try (DirectoryStream<Path> cpFiles = Files.newDirectoryStream(this.cpDir.toPath(), path -> CP_FILE_NAME_PATTERN.matcher(path.toFile().getName()).matches());){
            ArrayList<CheckpointEntry> checkpoints = new ArrayList<CheckpointEntry>();
            ByteBuffer buf = ByteBuffer.allocate(16);
            buf.order(ByteOrder.nativeOrder());
            for (Path cpFile : cpFiles) {
                CheckpointEntry cp = this.parseFromFile(buf, cpFile.toFile());
                if (cp == null) continue;
                checkpoints.add(cp);
            }
            ArrayList<CheckpointEntry> arrayList = checkpoints;
            return arrayList;
        }
        catch (IOException e) {
            throw new IgniteCheckedException("Failed to load checkpoint history.", e);
        }
    }

    @Nullable
    private CheckpointEntry parseFromFile(ByteBuffer buf, File file) throws IgniteCheckedException {
        Matcher matcher = CP_FILE_NAME_PATTERN.matcher(file.getName());
        if (!matcher.matches()) {
            return null;
        }
        CheckpointEntryType type = CheckpointEntryType.valueOf(matcher.group(3));
        if (type != CheckpointEntryType.START) {
            return null;
        }
        long cpTs = Long.parseLong(matcher.group(1));
        UUID cpId = UUID.fromString(matcher.group(2));
        WALPointer ptr = this.readPointer(file, buf);
        return this.checkpointer.createCheckPointEntry(cpTs, ptr, cpId, null, CheckpointEntryType.START);
    }

    private void removeCheckpointFiles(CheckpointEntry cpEntry) throws IgniteCheckedException {
        Path startFile = new File(this.cpDir.getAbsolutePath(), Checkpointer.checkpointFileName(cpEntry, CheckpointEntryType.START)).toPath();
        Path endFile = new File(this.cpDir.getAbsolutePath(), Checkpointer.checkpointFileName(cpEntry, CheckpointEntryType.END)).toPath();
        try {
            if (Files.exists(startFile, new LinkOption[0])) {
                Files.delete(startFile);
            }
            if (Files.exists(endFile, new LinkOption[0])) {
                Files.delete(endFile);
            }
        }
        catch (IOException e) {
            throw new StorageException("Failed to delete stale checkpoint files: " + cpEntry, e);
        }
    }

    private void readMetastore() throws IgniteCheckedException {
        try {
            CheckpointStatus status = this.readCheckpointStatus();
            this.checkpointReadLock();
            try {
                this.dataRegion(METASTORE_DATA_REGION_NAME).pageMemory().start();
                this.performBinaryMemoryRestore(status, this.onlyMetastorageGroup(), this.physicalRecords(), false);
                this.metaStorage = this.createMetastorage(true);
                this.applyLogicalUpdates(status, this.onlyMetastorageGroup(), this.onlyMetastorageRecords(), false);
                this.fillWalDisabledGroups();
                this.cpHist.initialize(this.retreiveHistory());
                this.notifyMetastorageReadyForRead();
                this.metaStorage = null;
            }
            catch (Throwable throwable) {
                this.metaStorage = null;
                this.dataRegion(METASTORE_DATA_REGION_NAME).pageMemory().stop(false);
                this.cctx.pageStore().cleanupPageStoreIfMatch(new Predicate<Integer>(){

                    @Override
                    public boolean test(Integer grpId) {
                        return MetaStorage.METASTORAGE_CACHE_ID == grpId;
                    }
                }, false);
                this.checkpointReadUnlock();
                throw throwable;
            }
            this.dataRegion(METASTORE_DATA_REGION_NAME).pageMemory().stop(false);
            this.cctx.pageStore().cleanupPageStoreIfMatch(new /* invalid duplicate definition of identical inner class */, false);
            this.checkpointReadUnlock();
        }
        catch (StorageException e) {
            this.cctx.kernalContext().failure().process(new FailureContext(FailureType.CRITICAL_ERROR, e));
            throw new IgniteCheckedException(e);
        }
    }

    @Override
    public void onActivate(GridKernalContext ctx) throws IgniteCheckedException {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Activate database manager [id=" + this.cctx.localNodeId() + " topVer=" + this.cctx.discovery().topologyVersionEx() + " ]");
        }
        this.snapshotMgr = this.cctx.snapshot();
        if (!this.cctx.kernalContext().clientNode() && this.checkpointer == null) {
            this.checkpointer = new Checkpointer(this.cctx.igniteInstanceName(), "db-checkpoint-thread", this.cctx.kernalContext().workersRegistry(), this.log, this.pageSize(), this.cctx.kernalContext().longJvmPauseDetector(), this.cctx.kernalContext().failure(), this.persistenceCfg, this.initializeCheckpointPool(), this.snapshotMgr, this.checkpointLock, this.cctx.wal(), this.cpHist, this.persistentStoreMetricsImpl(), this::dataRegions, this.ioFactory, this.cpDir, this.cctx.cache(), this.storeMgr, this.resolveThrottlingPolicy(), this::getPageMemoryForCacheGroup, new ThreadLocal<ByteBuffer>(){

                @Override
                protected ByteBuffer initialValue() {
                    ByteBuffer tmpWriteBuf = ByteBuffer.allocateDirect(GridCacheDatabaseSharedManager.this.pageSize());
                    tmpWriteBuf.order(ByteOrder.nativeOrder());
                    return tmpWriteBuf;
                }
            });
        }
        super.onActivate(ctx);
        if (!this.cctx.kernalContext().clientNode()) {
            this.finishRecovery();
        }
    }

    @Override
    public void onDeActivate(GridKernalContext kctx) {
        if (this.log.isDebugEnabled()) {
            this.log.debug("DeActivate database manager [id=" + this.cctx.localNodeId() + " topVer=" + this.cctx.discovery().topologyVersionEx() + " ]");
        }
        this.onKernalStop0(false);
        super.onDeActivate(kctx);
        this.stopping = false;
    }

    private IgniteThreadPoolExecutor initializeCheckpointPool() {
        if (this.persistenceCfg.getCheckpointThreads() > 1) {
            return new IgniteThreadPoolExecutor(CHECKPOINT_RUNNER_THREAD_PREFIX, this.cctx.igniteInstanceName(), this.persistenceCfg.getCheckpointThreads(), this.persistenceCfg.getCheckpointThreads(), 30000L, new LinkedBlockingQueue<Runnable>());
        }
        return null;
    }

    @Override
    protected void registerMetricsMBeans(IgniteConfiguration cfg) {
        super.registerMetricsMBeans(cfg);
        this.registerMetricsMBean(this.cctx.kernalContext().config(), MBEAN_GROUP, MBEAN_NAME, this.persStoreMetrics, DataStorageMetricsMXBean.class);
    }

    @Override
    @Deprecated
    protected IgniteOutClosure<Long> freeSpaceProvider(DataRegionConfiguration dataRegCfg) {
        if (!dataRegCfg.isPersistenceEnabled()) {
            return super.freeSpaceProvider(dataRegCfg);
        }
        final String dataRegName = dataRegCfg.getName();
        return new IgniteOutClosure<Long>(){

            @Override
            public Long apply() {
                long freeSpace = 0L;
                for (CacheGroupContext grpCtx : GridCacheDatabaseSharedManager.this.cctx.cache().cacheGroups()) {
                    if (!grpCtx.dataRegion().config().getName().equals(dataRegName)) continue;
                    assert (grpCtx.offheap() instanceof GridCacheOffheapManager);
                    freeSpace += ((GridCacheOffheapManager)grpCtx.offheap()).freeSpace();
                }
                return freeSpace;
            }
        };
    }

    @Override
    protected DataRegionMetricsProvider dataRegionMetricsProvider(DataRegionConfiguration dataRegCfg) {
        if (!dataRegCfg.isPersistenceEnabled()) {
            return super.dataRegionMetricsProvider(dataRegCfg);
        }
        final String dataRegName = dataRegCfg.getName();
        return new DataRegionMetricsProvider(){

            @Override
            public long partiallyFilledPagesFreeSpace() {
                long freeSpace = 0L;
                for (CacheGroupContext grpCtx : GridCacheDatabaseSharedManager.this.cctx.cache().cacheGroups()) {
                    if (!grpCtx.dataRegion().config().getName().equals(dataRegName)) continue;
                    assert (grpCtx.offheap() instanceof GridCacheOffheapManager);
                    freeSpace += ((GridCacheOffheapManager)grpCtx.offheap()).freeSpace();
                }
                return freeSpace;
            }

            @Override
            public long emptyDataPages() {
                long emptyDataPages = 0L;
                for (CacheGroupContext grpCtx : GridCacheDatabaseSharedManager.this.cctx.cache().cacheGroups()) {
                    if (!grpCtx.dataRegion().config().getName().equals(dataRegName)) continue;
                    assert (grpCtx.offheap() instanceof GridCacheOffheapManager);
                    emptyDataPages += ((GridCacheOffheapManager)grpCtx.offheap()).emptyDataPages();
                }
                return emptyDataPages;
            }
        };
    }

    private void finishRecovery() throws IgniteCheckedException {
        assert (!this.cctx.kernalContext().clientNode());
        long time = System.currentTimeMillis();
        Checkpointer.CHECKPOINT_LOCK_HOLD_COUNT.set(Checkpointer.CHECKPOINT_LOCK_HOLD_COUNT.get() + 1);
        try {
            for (DatabaseLifecycleListener lsnr : this.getDatabaseListeners(this.cctx.kernalContext())) {
                lsnr.beforeResumeWalLogging(this);
            }
            if (this.walTail == null) {
                CheckpointStatus status = this.readCheckpointStatus();
                this.walTail = CheckpointStatus.NULL_PTR.equals(status.endPtr) ? null : status.endPtr;
            }
            this.cctx.wal().resumeLogging(this.walTail);
            this.walTail = null;
            if (this.metaStorage == null) {
                this.metaStorage = this.createMetastorage(false);
            }
            this.notifyMetastorageReadyForReadWrite();
            U.log(this.log, "Finish recovery performed in " + (System.currentTimeMillis() - time) + " ms.");
        }
        catch (IgniteCheckedException e) {
            if (X.hasCause((Throwable)e, StorageException.class, IOException.class)) {
                this.cctx.kernalContext().failure().process(new FailureContext(FailureType.CRITICAL_ERROR, e));
            }
            throw e;
        }
        finally {
            Checkpointer.CHECKPOINT_LOCK_HOLD_COUNT.set(Checkpointer.CHECKPOINT_LOCK_HOLD_COUNT.get() - 1);
        }
    }

    private MetaStorage createMetastorage(boolean readOnly) throws IgniteCheckedException {
        this.cctx.pageStore().initializeForMetastorage();
        MetaStorage storage = new MetaStorage(this.cctx, this.dataRegion(METASTORE_DATA_REGION_NAME), (DataRegionMetricsImpl)this.memMetricsMap.get(METASTORE_DATA_REGION_NAME), readOnly);
        storage.init(this);
        return storage;
    }

    private RestoreBinaryState restoreBinaryMemory(IgnitePredicate<Integer> cacheGroupsPredicate, IgniteBiPredicate<WALRecord.RecordType, WALPointer> recordTypePredicate) throws IgniteCheckedException {
        long time = System.currentTimeMillis();
        try {
            if (this.log.isInfoEnabled()) {
                this.log.info("Starting binary memory restore for: " + this.cctx.cache().cacheGroupDescriptors().keySet());
            }
            for (DatabaseLifecycleListener lsnr : this.getDatabaseListeners(this.cctx.kernalContext())) {
                lsnr.beforeBinaryMemoryRestore(this);
            }
            CheckpointStatus status = this.readCheckpointStatus();
            RestoreBinaryState binaryState = this.performBinaryMemoryRestore(status, cacheGroupsPredicate, recordTypePredicate, true);
            WALPointer restored = binaryState.lastReadRecordPointer();
            restored = ((Object)restored).equals(CheckpointStatus.NULL_PTR) ? null : restored.next();
            if (restored == null && !status.endPtr.equals(CheckpointStatus.NULL_PTR)) {
                throw new StorageException("The memory cannot be restored. The critical part of WAL archive is missing [tailWalPtr=" + restored + ", endPtr=" + status.endPtr + ']');
            }
            if (restored != null) {
                U.log(this.log, "Binary memory state restored at node startup [restoredPtr=" + restored + ']');
            }
            this.cctx.wal().resumeLogging(restored);
            this.checkpointer.memoryRecoveryRecordPtr(this.cctx.wal().log(new MemoryRecoveryRecord(U.currentTimeMillis())));
            for (DatabaseLifecycleListener lsnr : this.getDatabaseListeners(this.cctx.kernalContext())) {
                lsnr.afterBinaryMemoryRestore(this, binaryState);
            }
            if (this.log.isInfoEnabled()) {
                this.log.info("Binary recovery performed in " + (System.currentTimeMillis() - time) + " ms.");
            }
            return binaryState;
        }
        catch (IgniteCheckedException e) {
            if (X.hasCause((Throwable)e, StorageException.class, IOException.class)) {
                this.cctx.kernalContext().failure().process(new FailureContext(FailureType.CRITICAL_ERROR, e));
            }
            throw e;
        }
    }

    @Override
    protected void onKernalStop0(boolean cancel) {
        this.checkpointLock.writeLock().lock();
        try {
            this.stopping = true;
        }
        finally {
            this.checkpointLock.writeLock().unlock();
        }
        Checkpointer cp = this.checkpointer;
        if (cp != null) {
            cp.shutdownCheckpointer(cancel);
        }
        this.checkpointer = null;
        super.onKernalStop0(cancel);
        this.unregisterMetricsMBean(this.cctx.gridConfig(), MBEAN_GROUP, MBEAN_NAME);
        this.metaStorage = null;
    }

    @Override
    protected void stop0(boolean cancel) {
        super.stop0(cancel);
        this.releaseFileLock();
    }

    private long[] calculateFragmentSizes(int concLvl, long cacheSize, long chpBufSize) {
        long fragmentSize;
        if (concLvl < 2) {
            concLvl = Runtime.getRuntime().availableProcessors();
        }
        if ((fragmentSize = cacheSize / (long)concLvl) < 0x100000L) {
            fragmentSize = 0x100000L;
        }
        long[] sizes = new long[concLvl + 1];
        for (int i = 0; i < concLvl; ++i) {
            sizes[i] = fragmentSize;
        }
        sizes[concLvl] = chpBufSize;
        return sizes;
    }

    @Override
    protected PageMemory createPageMemory(DirectMemoryProvider memProvider, DataStorageConfiguration memCfg, DataRegionConfiguration plcCfg, DataRegionMetricsImpl memMetrics, boolean trackable) {
        if (!plcCfg.isPersistenceEnabled()) {
            return super.createPageMemory(memProvider, memCfg, plcCfg, memMetrics, trackable);
        }
        memMetrics.persistenceEnabled(true);
        long cacheSize = plcCfg.getMaxSize();
        long chpBufSize = IgniteUtils.checkpointBufferSize(plcCfg);
        if (chpBufSize > cacheSize) {
            U.quietAndInfo(this.log, "Configured checkpoint page buffer size is too big, setting to the max region size [size=" + U.readableSize(cacheSize, false) + ",  memPlc=" + plcCfg.getName() + ']');
            chpBufSize = cacheSize;
        }
        GridInClosure3X<Long, FullPageId, PageMemoryEx> changeTracker = trackable ? new GridInClosure3X<Long, FullPageId, PageMemoryEx>(){

            @Override
            public void applyx(Long page, FullPageId fullId, PageMemoryEx pageMem) throws IgniteCheckedException {
                GridCacheDatabaseSharedManager.this.snapshotMgr.onChangeTrackerPage(page, fullId, pageMem);
            }
        } : null;
        PageMemoryImpl pageMem = new PageMemoryImpl(this.wrapMetricsMemoryProvider(memProvider, memMetrics), this.calculateFragmentSizes(memCfg.getConcurrencyLevel(), cacheSize, chpBufSize), this.cctx, memCfg.getPageSize(), (fullId, pageBuf, tag) -> {
            memMetrics.onPageWritten();
            this.snapshotMgr.beforePageWrite(fullId);
            this.storeMgr.write(fullId.groupId(), fullId.pageId(), pageBuf, tag);
            this.getCheckpointer().currentProgress().updateEvictedPages(1);
        }, changeTracker, this, memMetrics, this.resolveThrottlingPolicy(), new IgniteOutClosure<CheckpointProgress>(){

            @Override
            public CheckpointProgress apply() {
                return GridCacheDatabaseSharedManager.this.getCheckpointer().currentProgress();
            }
        });
        memMetrics.pageMemory(pageMem);
        return pageMem;
    }

    @Override
    protected DirectMemoryProvider wrapMetricsMemoryProvider(final DirectMemoryProvider memoryProvider0, final DataRegionMetricsImpl memMetrics) {
        return new DirectMemoryProvider(){
            private AtomicInteger checkPointBufferIdxCnt = new AtomicInteger();
            private final DirectMemoryProvider memProvider = memoryProvider0;

            @Override
            public void initialize(long[] chunkSizes) {
                this.memProvider.initialize(chunkSizes);
                this.checkPointBufferIdxCnt.set(chunkSizes.length);
            }

            @Override
            public void shutdown(boolean deallocate) {
                this.memProvider.shutdown(deallocate);
            }

            @Override
            public DirectMemoryRegion nextRegion() {
                DirectMemoryRegion nextMemoryRegion = this.memProvider.nextRegion();
                if (nextMemoryRegion == null) {
                    return null;
                }
                int idx = this.checkPointBufferIdxCnt.decrementAndGet();
                long chunkSize = nextMemoryRegion.size();
                if (idx != 0) {
                    memMetrics.updateOffHeapSize(chunkSize);
                } else {
                    memMetrics.updateCheckpointBufferSize(chunkSize);
                }
                return nextMemoryRegion;
            }
        };
    }

    @NotNull
    private PageMemoryImpl.ThrottlingPolicy resolveThrottlingPolicy() {
        PageMemoryImpl.ThrottlingPolicy plc;
        PageMemoryImpl.ThrottlingPolicy throttlingPolicy = plc = this.persistenceCfg.isWriteThrottlingEnabled() ? PageMemoryImpl.ThrottlingPolicy.SPEED_BASED : PageMemoryImpl.ThrottlingPolicy.CHECKPOINT_BUFFER_ONLY;
        if (this.throttlingPlcOverride != null) {
            try {
                plc = PageMemoryImpl.ThrottlingPolicy.valueOf(this.throttlingPlcOverride.toUpperCase());
            }
            catch (IllegalArgumentException e) {
                this.log.error("Incorrect value of IGNITE_OVERRIDE_WRITE_THROTTLING_ENABLED property. The default throttling policy will be used [plc=" + this.throttlingPlcOverride + ", defaultPlc=" + (Object)((Object)plc) + ']');
            }
        }
        return plc;
    }

    @Override
    protected void checkRegionEvictionProperties(DataRegionConfiguration regCfg, DataStorageConfiguration dbCfg) throws IgniteCheckedException {
        if (!regCfg.isPersistenceEnabled()) {
            super.checkRegionEvictionProperties(regCfg, dbCfg);
        } else if (regCfg.getPageEvictionMode() != DataPageEvictionMode.DISABLED) {
            U.warn(this.log, "Page eviction mode will have no effect because the oldest pages are evicted automatically if Ignite persistence is enabled: " + regCfg.getName());
        }
    }

    @Override
    protected void checkPageSize(DataStorageConfiguration memCfg) {
        if (memCfg.getPageSize() == 0) {
            try {
                assert (this.cctx.pageStore() instanceof FilePageStoreManager) : "Invalid page store manager was created: " + this.cctx.pageStore();
                Path anyIdxPartFile = IgniteUtils.searchFileRecursively(((FilePageStoreManager)this.cctx.pageStore()).workDir().toPath(), "index.bin");
                if (anyIdxPartFile != null) {
                    memCfg.setPageSize(this.resolvePageSizeFromPartitionFile(anyIdxPartFile));
                    return;
                }
            }
            catch (IOException | IllegalArgumentException | IgniteCheckedException e) {
                U.quietAndWarn(this.log, "Attempt to resolve pageSize from store files failed: " + e.getMessage());
                U.quietAndWarn(this.log, "Default page size will be used: 4096 bytes");
            }
            memCfg.setPageSize(4096);
        }
    }

    private int resolvePageSizeFromPartitionFile(Path partFile) throws IOException, IgniteCheckedException {
        try (FileIO fileIO = this.ioFactory.create(partFile.toFile());){
            int minimalHdr = 17;
            if (fileIO.size() < (long)minimalHdr) {
                throw new IgniteCheckedException("Partition file is too small: " + partFile);
            }
            ByteBuffer hdr = ByteBuffer.allocate(minimalHdr).order(ByteOrder.nativeOrder());
            fileIO.readFully(hdr);
            hdr.rewind();
            hdr.getLong();
            hdr.getInt();
            hdr.get();
            int pageSize = hdr.getInt();
            if (pageSize == 2048) {
                U.quietAndWarn(this.log, "You are currently using persistent store with 2K pages (DataStorageConfiguration#pageSize). If you use SSD disk, consider migrating to 4K pages for better IO performance.");
            }
            int n = pageSize;
            return n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void beforeExchange(GridDhtPartitionsExchangeFuture fut) throws IgniteCheckedException {
        block8: {
            ExchangeActions acts;
            block9: {
                if (fut.localJoinExchange() || fut.activateCluster() || fut.exchangeActions() != null && !F.isEmpty(fut.exchangeActions().cacheGroupsToStart())) {
                    U.doInParallel(this.cctx.kernalContext().getSystemExecutorService(), this.cctx.cache().cacheGroups(), cacheGroup -> {
                        if (cacheGroup.isLocal()) {
                            return null;
                        }
                        this.cctx.database().checkpointReadLock();
                        try {
                            cacheGroup.offheap().restorePartitionStates(Collections.emptyMap());
                            if (cacheGroup.localStartVersion().equals(fut.initialVersion())) {
                                cacheGroup.topology().afterStateRestored(fut.initialVersion());
                            }
                            fut.timeBag().finishLocalStage("Restore partition states [grp=" + cacheGroup.cacheOrGroupName() + "]");
                        }
                        finally {
                            this.cctx.database().checkpointReadUnlock();
                        }
                        return null;
                    });
                    fut.timeBag().finishGlobalStage("Restore partition states");
                    this.cctx.exchange().exchangerBlockingSectionBegin();
                    try {
                        List<PartitionsExchangeAware> exchangeAwareComponents = this.cctx.exchange().exchangeAwareComponents();
                        for (PartitionsExchangeAware partitionsExchangeAware : exchangeAwareComponents) {
                            partitionsExchangeAware.onPartitionStatesRestored(fut);
                        }
                    }
                    finally {
                        this.cctx.exchange().exchangerBlockingSectionEnd();
                    }
                }
                if (!this.cctx.kernalContext().query().moduleEnabled() || (acts = fut.exchangeActions()) == null) break block8;
                if (F.isEmpty(acts.cacheStartRequests())) break block9;
                for (ExchangeActions.CacheActionData cacheActionData : acts.cacheStartRequests()) {
                    this.prepareIndexRebuildFuture(CU.cacheId(cacheActionData.request().cacheName()));
                }
                break block8;
            }
            if (acts.localJoinContext() == null || F.isEmpty(acts.localJoinContext().caches())) break block8;
            for (T2 t2 : acts.localJoinContext().caches()) {
                this.prepareIndexRebuildFuture(((DynamicCacheDescriptor)t2.get1()).cacheId());
            }
        }
    }

    private void prepareIndexRebuildFuture(int cacheId) {
        GridFutureAdapter old = this.idxRebuildFuts.put(cacheId, new GridFutureAdapter());
        if (old != null) {
            old.onDone();
        }
    }

    @Override
    public void rebuildIndexesIfNeeded(GridDhtPartitionsExchangeFuture exchangeFut) {
        this.rebuildIndexes(this.cctx.cacheContexts(), cacheCtx -> cacheCtx.startTopologyVersion().equals(exchangeFut.initialVersion()));
    }

    @Override
    public void forceRebuildIndexes(Collection<GridCacheContext> contexts) {
        contexts.forEach(ctx -> this.prepareIndexRebuildFuture(ctx.cacheId()));
        this.rebuildIndexes(contexts, cacheCtx -> true);
    }

    private void rebuildIndexes(Collection<GridCacheContext> contexts, Predicate<GridCacheContext> rebuildCond) {
        GridQueryProcessor qryProc = this.cctx.kernalContext().query();
        if (!qryProc.moduleEnabled()) {
            return;
        }
        GridCompoundFuture allCacheIdxsCompoundFut = null;
        for (GridCacheContext cacheCtx : contexts) {
            if (!rebuildCond.test(cacheCtx)) continue;
            int cacheId = cacheCtx.cacheId();
            GridFutureAdapter usrFut = (GridFutureAdapter)this.idxRebuildFuts.get(cacheId);
            IgniteInternalFuture<?> rebuildFut = qryProc.rebuildIndexesFromHash(cacheCtx);
            if (Objects.nonNull(rebuildFut)) {
                if (this.log.isInfoEnabled()) {
                    this.log.info("Started indexes rebuilding for cache [" + this.cacheInfo(cacheCtx) + ']');
                }
                if (Objects.isNull(allCacheIdxsCompoundFut)) {
                    allCacheIdxsCompoundFut = new GridCompoundFuture();
                }
                allCacheIdxsCompoundFut.add(rebuildFut);
                rebuildFut.listen(fut -> {
                    this.idxRebuildFuts.remove(cacheId, usrFut);
                    Throwable err = fut.error();
                    usrFut.onDone(err);
                    if (Objects.isNull(err)) {
                        if (this.log.isInfoEnabled()) {
                            this.log.info("Finished indexes rebuilding for cache [" + this.cacheInfo(cacheCtx) + ']');
                        }
                    } else if (!(err instanceof NodeStoppingException)) {
                        this.log.error("Failed to rebuild indexes for cache [" + this.cacheInfo(cacheCtx) + ']', err);
                    }
                });
                continue;
            }
            if (!Objects.nonNull(usrFut)) continue;
            this.idxRebuildFuts.remove(cacheId, usrFut);
            usrFut.onDone();
        }
        if (Objects.nonNull(allCacheIdxsCompoundFut)) {
            allCacheIdxsCompoundFut.listen(fut -> {
                if (this.log.isInfoEnabled()) {
                    this.log.info("Indexes rebuilding completed for all caches.");
                }
            });
            allCacheIdxsCompoundFut.markInitialized();
        }
    }

    private String cacheInfo(GridCacheContext cacheCtx) {
        assert (Objects.nonNull(cacheCtx));
        return "name=" + cacheCtx.name() + ", grpName=" + cacheCtx.group().name();
    }

    @Override
    @Nullable
    public IgniteInternalFuture indexRebuildFuture(int cacheId) {
        return (IgniteInternalFuture)this.idxRebuildFuts.get(cacheId);
    }

    @Override
    public void onCacheGroupsStopped(Collection<IgniteBiTuple<CacheGroupContext, Boolean>> stoppedGrps) {
        HashMap<PageMemoryEx, Collection> destroyed = new HashMap<PageMemoryEx, Collection>();
        for (IgniteBiTuple<CacheGroupContext, Boolean> tup : stoppedGrps) {
            CacheGroupContext cacheGroupContext = tup.get1();
            if (!cacheGroupContext.persistenceEnabled()) continue;
            this.snapshotMgr.onCacheGroupStop(cacheGroupContext, tup.get2());
            PageMemoryEx pageMem = (PageMemoryEx)cacheGroupContext.dataRegion().pageMemory();
            Collection grpIds = destroyed.computeIfAbsent(pageMem, k -> new HashSet());
            grpIds.add(tup.get1().groupId());
            pageMem.onCacheGroupDestroyed(tup.get1().groupId());
            if (!tup.get2().booleanValue()) continue;
            this.cctx.kernalContext().encryption().onCacheGroupDestroyed(cacheGroupContext.groupId());
        }
        ArrayList<IgniteInternalFuture<Void>> clearFuts = new ArrayList<IgniteInternalFuture<Void>>(destroyed.size());
        for (Map.Entry entry : destroyed.entrySet()) {
            Collection grpIds = (Collection)entry.getValue();
            clearFuts.add(((PageMemoryEx)entry.getKey()).clearAsync((grpId, pageIdg) -> grpIds.contains(grpId), false));
        }
        for (IgniteInternalFuture igniteInternalFuture : clearFuts) {
            try {
                igniteInternalFuture.get();
            }
            catch (IgniteCheckedException e) {
                this.log.error("Failed to clear page memory", e);
            }
        }
        if (this.cctx.pageStore() != null) {
            for (IgniteBiTuple igniteBiTuple : stoppedGrps) {
                CacheGroupContext grp = (CacheGroupContext)igniteBiTuple.get1();
                try {
                    this.cctx.pageStore().shutdownForCacheGroup(grp, (Boolean)igniteBiTuple.get2());
                }
                catch (IgniteCheckedException e) {
                    U.error(this.log, "Failed to gracefully clean page store resources for destroyed cache [cache=" + grp.cacheOrGroupName() + "]", e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void checkpointReadLock() {
        block23: {
            if (this.checkpointLock.writeLock().isHeldByCurrentThread()) {
                return;
            }
            long timeout = this.checkpointReadLockTimeout;
            long start = U.currentTimeMillis();
            boolean interruped = false;
            block10: while (true) {
                while (true) {
                    try {
                        while (true) {
                            if (timeout > 0L && U.currentTimeMillis() - start >= timeout) {
                                this.failCheckpointReadLock();
                            }
                            try {
                                if (timeout > 0L) {
                                    if (!this.checkpointLock.readLock().tryLock(timeout - (U.currentTimeMillis() - start), TimeUnit.MILLISECONDS)) {
                                        this.failCheckpointReadLock();
                                    }
                                } else {
                                    this.checkpointLock.readLock().lock();
                                }
                            }
                            catch (InterruptedException e) {
                                interruped = true;
                                continue;
                            }
                            if (this.stopping) {
                                this.checkpointLock.readLock().unlock();
                                throw new IgniteException(new NodeStoppingException("Failed to perform cache update: node is stopping."));
                            }
                            if (this.checkpointLock.getReadHoldCount() > 1 || this.safeToUpdatePageMemories()) break block23;
                            if (this.checkpointerThread == null) {
                                break block23;
                            }
                            this.checkpointLock.readLock().unlock();
                            if (timeout > 0L && U.currentTimeMillis() - start >= timeout) {
                                this.failCheckpointReadLock();
                            }
                            try {
                                this.checkpointer.wakeupForCheckpoint(0L, "too many dirty pages").futureFor(CheckpointState.LOCK_RELEASED).getUninterruptibly();
                                continue block10;
                            }
                            catch (IgniteFutureTimeoutCheckedException e) {
                                this.failCheckpointReadLock();
                                continue;
                            }
                            catch (IgniteCheckedException e) {
                                throw new IgniteException("Failed to wait for checkpoint begin.", e);
                            }
                            break;
                        }
                    }
                    catch (CheckpointReadLockTimeoutException e) {
                        this.log.error(e.getMessage(), e);
                        timeout = 0L;
                        continue;
                    }
                    break;
                }
            }
            finally {
                if (interruped) {
                    Thread.currentThread().interrupt();
                }
            }
        }
        if (ASSERTION_ENABLED) {
            Checkpointer.CHECKPOINT_LOCK_HOLD_COUNT.set(Checkpointer.CHECKPOINT_LOCK_HOLD_COUNT.get() + 1);
        }
    }

    private void failCheckpointReadLock() throws CheckpointReadLockTimeoutException, IgniteException {
        String msg = "Checkpoint read lock acquisition has been timed out.";
        IgniteException e = new IgniteException(msg);
        if (this.cctx.kernalContext().failure().process(new FailureContext(FailureType.SYSTEM_CRITICAL_OPERATION_TIMEOUT, e))) {
            throw e;
        }
        throw new CheckpointReadLockTimeoutException(msg);
    }

    @Override
    public boolean checkpointLockIsHeldByThread() {
        return !ASSERTION_ENABLED || this.checkpointLock.isWriteLockedByCurrentThread() || Checkpointer.CHECKPOINT_LOCK_HOLD_COUNT.get() > 0 || Thread.currentThread().getName().startsWith(CHECKPOINT_RUNNER_THREAD_PREFIX);
    }

    private boolean safeToUpdatePageMemories() {
        Collection<DataRegion> memPlcs = this.context().database().dataRegions();
        if (memPlcs == null) {
            return true;
        }
        for (DataRegion memPlc : memPlcs) {
            PageMemoryEx pageMemEx;
            if (!memPlc.config().isPersistenceEnabled() || (pageMemEx = (PageMemoryEx)memPlc.pageMemory()).safeToUpdate()) continue;
            return false;
        }
        return true;
    }

    @Override
    public void checkpointReadUnlock() {
        if (this.checkpointLock.writeLock().isHeldByCurrentThread()) {
            return;
        }
        this.checkpointLock.readLock().unlock();
        if (ASSERTION_ENABLED) {
            Checkpointer.CHECKPOINT_LOCK_HOLD_COUNT.set(Checkpointer.CHECKPOINT_LOCK_HOLD_COUNT.get() - 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized Map<Integer, Map<Integer, Long>> reserveHistoryForExchange() {
        Map<Integer, T2<ReservationReason, Map<Integer, CheckpointEntry>>> earliestValidCheckpoints;
        assert (this.reservedForExchange == null) : this.reservedForExchange;
        Map<Integer, Set<Integer>> applicableGroupsAndPartitions = this.partitionsApplicableForWalRebalance();
        this.checkpointReadLock();
        try {
            CheckpointHistoryResult checkpointHistoryResult = this.cpHist.searchAndReserveCheckpoints(applicableGroupsAndPartitions);
            earliestValidCheckpoints = checkpointHistoryResult.earliestValidCheckpoints();
            if (checkpointHistoryResult.reservedCheckoint() != null) {
                this.reservedForExchange = checkpointHistoryResult.reservedCheckoint().checkpointMark();
            }
        }
        finally {
            this.checkpointReadUnlock();
        }
        HashMap<Integer, Map<Integer, Long>> grpPartsWithCnts = new HashMap<Integer, Map<Integer, Long>>();
        for (Map.Entry<Integer, T2<ReservationReason, Map<Integer, CheckpointEntry>>> e : earliestValidCheckpoints.entrySet()) {
            int grpId = e.getKey();
            if (e.getValue().get2() == null) continue;
            for (Map.Entry e0 : ((Map)e.getValue().get2()).entrySet()) {
                CheckpointEntry cpEntry = (CheckpointEntry)e0.getValue();
                int partId = (Integer)e0.getKey();
                assert (this.cctx.wal().reserved(cpEntry.checkpointMark())) : "WAL segment for checkpoint " + cpEntry + " has not reserved";
                Long updCntr = cpEntry.partitionCounter(this.cctx, grpId, partId);
                if (updCntr == null) continue;
                grpPartsWithCnts.computeIfAbsent(grpId, k -> new HashMap()).put(partId, updCntr);
            }
        }
        if (this.log.isInfoEnabled() && !F.isEmpty(earliestValidCheckpoints)) {
            this.printReservationToLog(earliestValidCheckpoints);
        }
        return grpPartsWithCnts;
    }

    private void printReservationToLog(Map<Integer, T2<ReservationReason, Map<Integer, CheckpointEntry>>> earliestValidCheckpoints) {
        try {
            HashMap<ReservationReason, List> notReservedCachesToPrint = new HashMap<ReservationReason, List>();
            HashMap<ReservationReason, List> reservedCachesToPrint = new HashMap<ReservationReason, List>();
            for (Map.Entry<Integer, T2<ReservationReason, Map<Integer, CheckpointEntry>>> entry2 : earliestValidCheckpoints.entrySet()) {
                if (entry2.getValue().get2() == null) {
                    notReservedCachesToPrint.computeIfAbsent((ReservationReason)((Object)entry2.getValue().get1()), reason -> new ArrayList()).add(entry2.getKey());
                    continue;
                }
                reservedCachesToPrint.computeIfAbsent((ReservationReason)((Object)entry2.getValue().get1()), reason -> new ArrayList()).add(new T2<Integer, CheckpointEntry>(entry2.getKey(), ((Map)entry2.getValue().get2()).values().stream().min(Comparator.comparingLong(CheckpointEntry::timestamp)).get()));
            }
            if (!F.isEmpty(notReservedCachesToPrint)) {
                this.log.info("Cache groups were not reserved [" + notReservedCachesToPrint.entrySet().stream().map(entry -> '[' + ((List)entry.getValue()).stream().map(grpId -> "[grpId=" + grpId + ", grpName=" + this.cctx.cache().cacheGroup((int)grpId).cacheOrGroupName() + ']').collect(Collectors.joining(", ")) + ", reason=" + entry.getKey() + ']').collect(Collectors.joining(", ")) + ']');
            }
            if (!F.isEmpty(reservedCachesToPrint)) {
                this.log.info("Cache groups with earliest reserved checkpoint and a reason why a previous checkpoint was inapplicable: [" + reservedCachesToPrint.entrySet().stream().map(entry -> '[' + ((List)entry.getValue()).stream().map(grpCp -> "[grpId=" + grpCp.get1() + ", grpName=" + this.cctx.cache().cacheGroup((Integer)grpCp.get1()).cacheOrGroupName() + ", cp=(" + ((CheckpointEntry)grpCp.get2()).checkpointId() + ", " + U.format(((CheckpointEntry)grpCp.get2()).timestamp()) + ")]").collect(Collectors.joining(", ")) + ", reason=" + entry.getKey() + ']').collect(Collectors.joining(", ")) + ']');
            }
        }
        catch (Exception e) {
            this.log.error("An error happened during printing partitions that were reserved for potential historical rebalance.", e);
        }
    }

    private Map<Integer, Set<Integer>> partitionsApplicableForWalRebalance() {
        HashMap<Integer, Set<Integer>> res = new HashMap<Integer, Set<Integer>>();
        for (CacheGroupContext grp : this.cctx.cache().cacheGroups()) {
            if (grp.isLocal()) continue;
            for (GridDhtLocalPartition locPart : grp.topology().currentLocalPartitions()) {
                if (locPart.state() != GridDhtPartitionState.OWNING || !this.preferWalRebalance() && locPart.fullSize() <= (long)this.walRebalanceThreshold) continue;
                res.computeIfAbsent(grp.groupId(), k -> new HashSet()).add(locPart.id());
            }
        }
        return res;
    }

    @Override
    public synchronized void releaseHistoryForExchange() {
        if (this.reservedForExchange == null) {
            return;
        }
        assert (this.cctx.wal().reserved(this.reservedForExchange)) : "Earliest checkpoint WAL pointer is not reserved for exchange: " + this.reservedForExchange;
        try {
            this.cctx.wal().release(this.reservedForExchange);
        }
        catch (IgniteCheckedException e) {
            this.log.error("Failed to release earliest checkpoint WAL pointer: " + this.reservedForExchange, e);
        }
        this.reservedForExchange = null;
    }

    @Override
    public boolean reserveHistoryForPreloading(Map<T2<Integer, Integer>, Long> reservationMap) {
        Map<GroupPartitionId, CheckpointEntry> entries = this.cpHist.searchCheckpointEntry(reservationMap);
        if (F.isEmpty(entries)) {
            return false;
        }
        WALPointer oldestWALPointerToReserve = null;
        for (GroupPartitionId key : entries.keySet()) {
            WALPointer ptr = entries.get(key).checkpointMark();
            if (ptr == null) {
                return false;
            }
            if (oldestWALPointerToReserve != null && ((FileWALPointer)ptr).index() >= ((FileWALPointer)oldestWALPointerToReserve).index()) continue;
            oldestWALPointerToReserve = ptr;
        }
        if (this.cctx.wal().reserve(oldestWALPointerToReserve)) {
            this.reservedForPreloading = oldestWALPointerToReserve;
            return true;
        }
        return false;
    }

    @Override
    public void releaseHistoryForPreloading() {
        this.releaseHistForPreloadingLock.lock();
        try {
            if (this.reservedForPreloading != null) {
                this.cctx.wal().release(this.reservedForPreloading);
                this.reservedForPreloading = null;
            }
        }
        catch (IgniteCheckedException ex) {
            U.error(this.log, "Could not release WAL reservation", ex);
            throw new IgniteException(ex);
        }
        finally {
            this.releaseHistForPreloadingLock.unlock();
        }
    }

    @Override
    @Nullable
    public IgniteInternalFuture wakeupForCheckpoint(String reason) {
        Checkpointer cp = this.checkpointer;
        if (cp != null) {
            return cp.wakeupForCheckpoint(0L, reason).futureFor(CheckpointState.LOCK_RELEASED);
        }
        return null;
    }

    @Override
    public <R> void waitForCheckpoint(String reason, IgniteInClosure<? super IgniteInternalFuture<R>> lsnr) throws IgniteCheckedException {
        Checkpointer cp = this.checkpointer;
        if (cp == null) {
            return;
        }
        cp.wakeupForCheckpoint(0L, reason, lsnr).futureFor(CheckpointState.FINISHED).get();
    }

    @Override
    public CheckpointProgress forceCheckpoint(String reason) {
        Checkpointer cp = this.checkpointer;
        if (cp == null) {
            return null;
        }
        return cp.wakeupForCheckpoint(0L, reason);
    }

    @Override
    public WALPointer lastCheckpointMarkWalPointer() {
        CheckpointEntry lastCheckpointEntry = this.cpHist == null ? null : this.cpHist.lastCheckpoint();
        return lastCheckpointEntry == null ? null : lastCheckpointEntry.checkpointMark();
    }

    public File checkpointDirectory() {
        return this.cpDir;
    }

    public void addCheckpointListener(DbCheckpointListener lsnr) {
        Checkpointer cp = this.checkpointer;
        if (cp != null) {
            cp.addCheckpointListener(lsnr);
        }
    }

    public void removeCheckpointListener(DbCheckpointListener lsnr) {
        Checkpointer cp = this.checkpointer;
        if (cp != null) {
            cp.removeCheckpointListener(lsnr);
        }
    }

    private CheckpointStatus readCheckpointStatus() throws IgniteCheckedException {
        File[] files;
        long lastStartTs = 0L;
        long lastEndTs = 0L;
        UUID startId = CheckpointStatus.NULL_UUID;
        UUID endId = CheckpointStatus.NULL_UUID;
        File startFile = null;
        File endFile = null;
        WALPointer startPtr = CheckpointStatus.NULL_PTR;
        WALPointer endPtr = CheckpointStatus.NULL_PTR;
        File dir = this.cpDir;
        if (!dir.exists()) {
            this.log.warning("Read checkpoint status: checkpoint directory is not found.");
            return new CheckpointStatus(0L, startId, startPtr, endId, endPtr);
        }
        for (File file : files = dir.listFiles()) {
            Matcher matcher = CP_FILE_NAME_PATTERN.matcher(file.getName());
            if (!matcher.matches()) continue;
            long ts = Long.parseLong(matcher.group(1));
            UUID id = UUID.fromString(matcher.group(2));
            CheckpointEntryType type = CheckpointEntryType.valueOf(matcher.group(3));
            if (type == CheckpointEntryType.START && ts > lastStartTs) {
                lastStartTs = ts;
                startId = id;
                startFile = file;
                continue;
            }
            if (type != CheckpointEntryType.END || ts <= lastEndTs) continue;
            lastEndTs = ts;
            endId = id;
            endFile = file;
        }
        ByteBuffer buf = ByteBuffer.allocate(16);
        buf.order(ByteOrder.nativeOrder());
        if (startFile != null) {
            startPtr = this.readPointer(startFile, buf);
        }
        if (endFile != null) {
            endPtr = this.readPointer(endFile, buf);
        }
        if (this.log.isInfoEnabled()) {
            this.log.info("Read checkpoint status [startMarker=" + startFile + ", endMarker=" + endFile + ']');
        }
        return new CheckpointStatus(lastStartTs, startId, startPtr, endId, endPtr);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private WALPointer readPointer(File cpMarkerFile, ByteBuffer buf) throws IgniteCheckedException {
        buf.position(0);
        try (FileIO io = this.ioFactory.create(cpMarkerFile, StandardOpenOption.READ);){
            io.readFully(buf);
            buf.flip();
            FileWALPointer fileWALPointer = new FileWALPointer(buf.getLong(), buf.getInt(), buf.getInt());
            return fileWALPointer;
        }
        catch (IOException e) {
            throw new IgniteCheckedException("Failed to read checkpoint pointer from marker file: " + cpMarkerFile.getAbsolutePath(), e);
        }
    }

    @Override
    public void startMemoryRestore(GridKernalContext kctx, TimeBag startTimer) throws IgniteCheckedException {
        if (kctx.clientNode()) {
            return;
        }
        this.checkpointReadLock();
        try {
            this.initAndStartRegions(kctx.config().getDataStorageConfiguration());
            startTimer.finishGlobalStage("Init and start regions");
            this.restoreBinaryMemory(this.groupsWithEnabledWal(), this.physicalRecords());
            if (this.recoveryVerboseLogging && this.log.isInfoEnabled()) {
                this.log.info("Partition states information after BINARY RECOVERY phase:");
                GridCacheDatabaseSharedManager.dumpPartitionsInfo(this.cctx, this.log);
            }
            startTimer.finishGlobalStage("Restore binary memory");
            CheckpointStatus status = this.readCheckpointStatus();
            RestoreLogicalState logicalState = this.applyLogicalUpdates(status, this.groupsWithEnabledWal(), this.logicalRecords(), true);
            if (this.recoveryVerboseLogging && this.log.isInfoEnabled()) {
                this.log.info("Partition states information after LOGICAL RECOVERY phase:");
                GridCacheDatabaseSharedManager.dumpPartitionsInfo(this.cctx, this.log);
            }
            startTimer.finishGlobalStage("Restore logical state");
            this.walTail = this.tailPointer(logicalState);
            this.cctx.wal().onDeActivate(kctx);
        }
        catch (IgniteCheckedException e) {
            this.releaseFileLock();
            throw e;
        }
        finally {
            this.checkpointReadUnlock();
        }
    }

    public PageStore getPageStore(int grpId, int partId) throws IgniteCheckedException {
        return this.storeMgr.getStore(grpId, partId);
    }

    public long forGroupPageStores(CacheGroupContext gctx, ToLongFunction<PageStore> f) {
        int groupId = gctx.groupId();
        long res = 0L;
        try {
            Collection<PageStore> stores = this.storeMgr.getStores(groupId);
            if (stores != null) {
                for (PageStore store : stores) {
                    res += f.applyAsLong(store);
                }
            }
        }
        catch (IgniteCheckedException e) {
            throw new IgniteException(e);
        }
        return res;
    }

    private WALPointer tailPointer(RestoreLogicalState logicalState) throws IgniteCheckedException {
        WALPointer lastFlushPtr = this.cctx.wal().flush(null, true);
        FileWALPointer lastReadPtr = logicalState.lastReadRecordPointer();
        if (lastFlushPtr != null && lastReadPtr == null) {
            return lastFlushPtr;
        }
        if (lastFlushPtr == null && lastReadPtr != null) {
            return lastReadPtr;
        }
        if (lastFlushPtr != null && lastReadPtr != null) {
            FileWALPointer lastReadPtr0 = lastReadPtr;
            FileWALPointer lastFlushPtr0 = (FileWALPointer)lastFlushPtr;
            return lastReadPtr0.compareTo(lastFlushPtr0) >= 0 ? lastReadPtr : lastFlushPtr0;
        }
        return null;
    }

    @Override
    public void onStateRestored(AffinityTopologyVersion topVer) throws IgniteCheckedException {
        IgniteThread cpThread = new IgniteThread(this.cctx.igniteInstanceName(), "db-checkpoint-thread", this.checkpointer);
        cpThread.start();
        this.checkpointerThread = cpThread;
        CheckpointProgress chp = this.checkpointer.wakeupForCheckpoint(0L, "node started");
        if (chp != null) {
            chp.futureFor(CheckpointState.LOCK_RELEASED).get();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private RestoreBinaryState performBinaryMemoryRestore(CheckpointStatus status, IgnitePredicate<Integer> cacheGroupsPredicate, IgniteBiPredicate<WALRecord.RecordType, WALPointer> recordTypePredicate, boolean finalizeState) throws IgniteCheckedException {
        WALPointer recPtr;
        block21: {
            if (this.log.isInfoEnabled()) {
                this.log.info("Checking memory state [lastValidPos=" + status.endPtr + ", lastMarked=" + status.startPtr + ", lastCheckpointId=" + status.cpStartId + ']');
            }
            recPtr = status.endPtr;
            boolean apply = status.needRestoreMemory();
            try {
                WALRecord startRec;
                WALRecord wALRecord = startRec = !CheckpointStatus.NULL_PTR.equals(status.startPtr) || apply ? this.cctx.wal().read(status.startPtr) : null;
                if (apply) {
                    if (finalizeState) {
                        U.quietAndWarn(this.log, "Ignite node stopped in the middle of checkpoint. Will restore memory state and finish checkpoint on node start.");
                    }
                    this.cctx.cache().cacheGroupDescriptors().forEach((grpId, desc) -> {
                        if (!cacheGroupsPredicate.apply((Integer)grpId)) {
                            return;
                        }
                        try {
                            DataRegion region = this.cctx.database().dataRegion(desc.config().getDataRegionName());
                            if (region == null || !this.cctx.isLazyMemoryAllocation(region)) {
                                return;
                            }
                            region.pageMemory().start();
                        }
                        catch (IgniteCheckedException e) {
                            throw new IgniteException(e);
                        }
                    });
                    this.cctx.pageStore().beginRecover();
                    if (!(startRec instanceof CheckpointRecord)) {
                        throw new StorageException("Checkpoint marker doesn't point to checkpoint record [ptr=" + status.startPtr + ", rec=" + startRec + "]");
                    }
                    WALPointer cpMark = ((CheckpointRecord)startRec).checkpointMark();
                    if (cpMark != null) {
                        if (this.log.isInfoEnabled()) {
                            this.log.info("Restoring checkpoint after logical recovery, will start physical recovery from back pointer: " + cpMark);
                        }
                        recPtr = cpMark;
                    }
                    break block21;
                }
                this.cctx.wal().notchLastCheckpointPtr(status.startPtr);
            }
            catch (NoSuchElementException e) {
                throw new StorageException("Failed to read checkpoint record from WAL, persistence consistency cannot be guaranteed. Make sure configuration points to correct WAL folders and WAL folder is properly mounted [ptr=" + status.startPtr + ", walPath=" + this.persistenceCfg.getWalPath() + ", walArchive=" + this.persistenceCfg.getWalArchivePath() + "]");
            }
        }
        AtomicReference<Throwable> applyError = new AtomicReference<Throwable>();
        StripedExecutor exec = this.cctx.kernalContext().getStripedExecutorService();
        Semaphore semaphore = new Semaphore(this.semaphorePertmits(exec));
        long start = U.currentTimeMillis();
        long lastArchivedSegment = this.cctx.wal().lastArchivedSegment();
        WALIterator it = this.cctx.wal().replay(recPtr, recordTypePredicate);
        RestoreBinaryState restoreBinaryState = new RestoreBinaryState(status, it, lastArchivedSegment, cacheGroupsPredicate);
        AtomicLong applied = new AtomicLong();
        try {
            WALRecord rec;
            block10: while (it.hasNextX() && applyError.get() == null && (rec = restoreBinaryState.next()) != null) {
                switch (rec.type()) {
                    case PAGE_RECORD: {
                        int partId;
                        if (!restoreBinaryState.needApplyBinaryUpdate()) continue block10;
                        PageSnapshot pageSnapshot = (PageSnapshot)rec;
                        int groupId = pageSnapshot.fullPageId().groupId();
                        if (this.skipRemovedIndexUpdates(groupId, partId = PageIdUtils.partId(pageSnapshot.fullPageId().pageId()))) break;
                        this.stripedApplyPage(pageMem -> {
                            try {
                                this.applyPageSnapshot((PageMemoryEx)pageMem, pageSnapshot);
                                applied.incrementAndGet();
                            }
                            catch (Throwable t) {
                                U.error(this.log, "Failed to apply page snapshot. rec=[" + pageSnapshot + ']');
                                applyError.compareAndSet(null, t instanceof IgniteCheckedException ? (IgniteCheckedException)t : new IgniteCheckedException("Failed to apply page snapshot", t));
                            }
                        }, groupId, partId, exec, semaphore);
                        break;
                    }
                    case PART_META_UPDATE_STATE: {
                        PartitionMetaStateRecord metaStateRecord = (PartitionMetaStateRecord)rec;
                        int groupId = metaStateRecord.groupId();
                        int partId = metaStateRecord.partitionId();
                        this.stripedApplyPage(pageMem -> {
                            GridDhtPartitionState state = GridDhtPartitionState.fromOrdinal(metaStateRecord.state());
                            if (state == null || state == GridDhtPartitionState.EVICTED) {
                                this.schedulePartitionDestroy(groupId, partId);
                            } else {
                                try {
                                    this.cancelOrWaitPartitionDestroy(groupId, partId);
                                }
                                catch (Throwable t) {
                                    U.error(this.log, "Failed to cancel or wait partition destroy. rec=[" + metaStateRecord + ']');
                                    applyError.compareAndSet(null, t instanceof IgniteCheckedException ? (IgniteCheckedException)t : new IgniteCheckedException("Failed to cancel or wait partition destroy", t));
                                }
                            }
                        }, groupId, partId, exec, semaphore);
                        break;
                    }
                    case PARTITION_DESTROY: {
                        PartitionDestroyRecord destroyRecord = (PartitionDestroyRecord)rec;
                        int groupId = destroyRecord.groupId();
                        int partId = destroyRecord.partitionId();
                        this.stripedApplyPage(pageMem -> {
                            pageMem.invalidate(groupId, partId);
                            this.schedulePartitionDestroy(groupId, partId);
                        }, groupId, partId, exec, semaphore);
                        break;
                    }
                    default: {
                        int partId;
                        if (!restoreBinaryState.needApplyBinaryUpdate() || !(rec instanceof PageDeltaRecord)) continue block10;
                        PageDeltaRecord pageDelta = (PageDeltaRecord)rec;
                        int groupId = pageDelta.groupId();
                        if (this.skipRemovedIndexUpdates(groupId, partId = PageIdUtils.partId(pageDelta.pageId()))) break;
                        this.stripedApplyPage(pageMem -> {
                            try {
                                this.applyPageDelta((PageMemoryEx)pageMem, pageDelta, true);
                                applied.incrementAndGet();
                            }
                            catch (Throwable t) {
                                U.error(this.log, "Failed to apply page delta. rec=[" + pageDelta + ']');
                                applyError.compareAndSet(null, t instanceof IgniteCheckedException ? (IgniteCheckedException)t : new IgniteCheckedException("Failed to apply page delta", t));
                            }
                        }, groupId, partId, exec, semaphore);
                    }
                }
            }
        }
        finally {
            it.close();
            this.awaitApplyComplete(exec, applyError);
        }
        if (!finalizeState) {
            return null;
        }
        FileWALPointer lastReadPtr = restoreBinaryState.lastReadRecordPointer();
        if (status.needRestoreMemory()) {
            if (restoreBinaryState.needApplyBinaryUpdate()) {
                throw new StorageException("Failed to restore memory state (checkpoint marker is present on disk, but checkpoint record is missed in WAL) [cpStatus=" + status + ", lastRead=" + lastReadPtr + "]");
            }
            if (this.log.isInfoEnabled()) {
                this.log.info("Finished applying memory changes [changesApplied=" + applied + ", time=" + (U.currentTimeMillis() - start) + " ms]");
            }
            this.finalizeCheckpointOnRecovery(status.cpStartTs, status.cpStartId, status.startPtr, exec);
        }
        return restoreBinaryState;
    }

    private int semaphorePertmits(StripedExecutor exec) {
        int permits = exec.stripes() * 4;
        long maxMemory = Runtime.getRuntime().maxMemory();
        int permits0 = (int)((double)maxMemory * 0.2 / 8192.0);
        if (permits0 < permits) {
            permits = permits0;
        }
        return IgniteSystemProperties.getInteger("IGNITE_RECOVERY_SEMAPHORE_PERMITS", permits);
    }

    private void awaitApplyComplete(StripedExecutor exec, AtomicReference<Throwable> applyError) throws IgniteCheckedException {
        try {
            exec.awaitComplete(new int[0]);
        }
        catch (InterruptedException e) {
            throw new IgniteInterruptedException(e);
        }
        Throwable error = applyError.get();
        if (error != null) {
            throw error instanceof IgniteCheckedException ? (IgniteCheckedException)error : new IgniteCheckedException(error);
        }
    }

    public void stripedApplyPage(Consumer<PageMemoryEx> consumer, int grpId, int partId, StripedExecutor exec, Semaphore semaphore) throws IgniteCheckedException {
        assert (consumer != null);
        assert (exec != null);
        assert (semaphore != null);
        PageMemoryEx pageMem = this.getPageMemoryForCacheGroup(grpId);
        if (pageMem == null) {
            return;
        }
        this.stripedApply(() -> consumer.accept(pageMem), grpId, partId, exec, semaphore);
    }

    public void stripedApply(Runnable run, int grpId, int partId, StripedExecutor exec, Semaphore semaphore) {
        assert (run != null);
        assert (exec != null);
        assert (semaphore != null);
        int stripes = exec.stripes();
        int stripe = U.stripeIdx(stripes, grpId, partId);
        assert (stripe >= 0 && stripe <= stripes) : "idx=" + stripe + ", stripes=" + stripes;
        try {
            semaphore.acquire();
        }
        catch (InterruptedException e) {
            throw new IgniteInterruptedException(e);
        }
        exec.execute(stripe, () -> {
            Checkpointer.CHECKPOINT_LOCK_HOLD_COUNT.set(1);
            try {
                run.run();
            }
            finally {
                Checkpointer.CHECKPOINT_LOCK_HOLD_COUNT.set(0);
                semaphore.release();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void applyPageSnapshot(PageMemoryEx pageMem, PageSnapshot pageSnapshotRecord) throws IgniteCheckedException {
        int grpId = pageSnapshotRecord.fullPageId().groupId();
        long pageId = pageSnapshotRecord.fullPageId().pageId();
        long page = pageMem.acquirePage(grpId, pageId, IoStatisticsHolderNoOp.INSTANCE, true);
        try {
            long pageAddr = pageMem.writeLock(grpId, pageId, page, true);
            try {
                PageUtils.putBytes(pageAddr, 0, pageSnapshotRecord.pageData());
                if (PageIO.getCompressionType(pageAddr) != 0) {
                    int realPageSize = pageMem.realPageSize(pageSnapshotRecord.groupId());
                    assert (pageSnapshotRecord.pageDataSize() <= realPageSize) : pageSnapshotRecord.pageDataSize();
                    this.cctx.kernalContext().compress().decompressPage(pageMem.pageBuffer(pageAddr), realPageSize);
                }
            }
            finally {
                pageMem.writeUnlock(grpId, pageId, page, null, true, true);
            }
        }
        finally {
            pageMem.releasePage(grpId, pageId, page);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void applyPageDelta(PageMemoryEx pageMem, PageDeltaRecord pageDeltaRecord, boolean restore) throws IgniteCheckedException {
        int grpId = pageDeltaRecord.groupId();
        long pageId = pageDeltaRecord.pageId();
        long page = pageMem.acquirePage(grpId, pageId, IoStatisticsHolderNoOp.INSTANCE, restore);
        try {
            long pageAddr = pageMem.writeLock(grpId, pageId, page, restore);
            try {
                pageDeltaRecord.applyDelta(pageMem, pageAddr);
            }
            finally {
                pageMem.writeUnlock(grpId, pageId, page, null, true, restore);
            }
        }
        finally {
            pageMem.releasePage(grpId, pageId, page);
        }
    }

    private boolean skipRemovedIndexUpdates(int grpId, int partId) {
        return partId == 65535 && !this.storeMgr.hasIndexStore(grpId);
    }

    private PageMemoryEx getPageMemoryForCacheGroup(int grpId) throws IgniteCheckedException {
        if (grpId == MetaStorage.METASTORAGE_CACHE_ID) {
            return (PageMemoryEx)this.dataRegion(METASTORE_DATA_REGION_NAME).pageMemory();
        }
        if (grpId == TxLog.TX_LOG_CACHE_ID) {
            return (PageMemoryEx)this.dataRegion("TxLog").pageMemory();
        }
        GridCacheSharedContext sharedCtx = this.context();
        CacheGroupDescriptor desc = sharedCtx.cache().cacheGroupDescriptors().get(grpId);
        if (desc == null) {
            return null;
        }
        String memPlcName = desc.config().getDataRegionName();
        return (PageMemoryEx)sharedCtx.database().dataRegion(memPlcName).pageMemory();
    }

    public void applyUpdatesOnRecovery(@Nullable WALIterator it, IgniteBiPredicate<WALPointer, WALRecord> stopPred, IgniteBiPredicate<WALRecord, DataEntry> entryPred) throws IgniteCheckedException {
        if (it == null) {
            return;
        }
        this.cctx.walState().runWithOutWAL(() -> {
            if (it != null) {
                this.applyUpdates(it, stopPred, entryPred, false, null, false);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void applyUpdates(WALIterator it, @Nullable IgniteBiPredicate<WALPointer, WALRecord> stopPred, IgniteBiPredicate<WALRecord, DataEntry> entryPred, boolean lockEntries, IgniteInClosure<WALPointer> onWalPointerApplied, boolean asyncApply) {
        StripedExecutor exec = this.cctx.kernalContext().getStripedExecutorService();
        AtomicReference<IgniteCheckedException> applyError = new AtomicReference<IgniteCheckedException>();
        int[] stripesThrottleAccumulator = new int[exec.stripes()];
        while (it.hasNext()) {
            IgniteBiTuple next = (IgniteBiTuple)it.next();
            WALRecord rec = (WALRecord)next.get2();
            if (stopPred != null && stopPred.apply((WALPointer)next.get1(), rec)) break;
            switch (rec.type()) {
                case MVCC_DATA_RECORD: 
                case DATA_RECORD: {
                    if (!entryPred.apply(rec, null)) break;
                    this.checkpointReadLock();
                    try {
                        DataRecord dataRec = (DataRecord)rec;
                        for (DataEntry dataEntry : dataRec.writeEntries()) {
                            if (!entryPred.apply(rec, dataEntry)) continue;
                            int cacheId = dataEntry.cacheId();
                            GridCacheContext cacheCtx = this.cctx.cacheContext(cacheId);
                            if (cacheCtx != null) {
                                if (asyncApply) {
                                    this.applyUpdateAsync(cacheCtx, dataEntry, lockEntries, exec, applyError, stripesThrottleAccumulator);
                                    continue;
                                }
                                this.applyUpdate(cacheCtx, dataEntry, lockEntries);
                                continue;
                            }
                            if (this.log == null) continue;
                            this.log.warning("Cache is not started. Updates cannot be applied [cacheId=" + cacheId + ']');
                        }
                        break;
                    }
                    catch (IgniteCheckedException e) {
                        throw new IgniteException(e);
                    }
                    finally {
                        this.checkpointReadUnlock();
                    }
                }
                case MVCC_TX_RECORD: {
                    if (!entryPred.apply(rec, null)) break;
                    this.checkpointReadLock();
                    try {
                        MvccTxRecord txRecord = (MvccTxRecord)rec;
                        byte txState = this.convertToTxState(txRecord.state());
                        this.cctx.coordinators().updateState(txRecord.mvccVersion(), txState, true);
                        break;
                    }
                    finally {
                        this.checkpointReadUnlock();
                    }
                }
                case ROLLBACK_TX_RECORD: {
                    RollbackRecord rbRec = (RollbackRecord)rec;
                    this.checkpointReadLock();
                    try {
                        CacheGroupContext ctx = this.cctx.cache().cacheGroup(rbRec.groupId());
                        if (ctx == null || ctx.isLocal()) break;
                        try {
                            ctx.topology().forceCreatePartition(rbRec.partitionId());
                            ctx.offheap().onPartitionInitialCounterUpdated(rbRec.partitionId(), rbRec.start(), rbRec.range());
                            break;
                        }
                        catch (IgniteCheckedException e) {
                            throw new IgniteException(e);
                        }
                    }
                    finally {
                        this.checkpointReadUnlock();
                    }
                }
            }
            if (onWalPointerApplied == null) continue;
            onWalPointerApplied.apply(rec.position());
        }
        if (applyError.get() != null) {
            throw new IgniteException((Throwable)applyError.get());
        }
        CountDownLatch stripesClearLatch = new CountDownLatch(exec.stripes());
        for (int i = 0; i < exec.stripes(); ++i) {
            exec.execute(i, stripesClearLatch::countDown);
        }
        try {
            stripesClearLatch.await();
        }
        catch (InterruptedException e) {
            throw new IgniteInterruptedException(e);
        }
        if (applyError.get() != null) {
            throw new IgniteException((Throwable)applyError.get());
        }
    }

    private void applyUpdateAsync(GridCacheContext cacheCtx, DataEntry dataEntry, boolean lockEntries, StripedExecutor exec, AtomicReference<IgniteCheckedException> applyError, int[] stripesThrottleAccumulator) throws IgniteCheckedException {
        if (applyError.get() != null) {
            throw applyError.get();
        }
        int stripeIdx = dataEntry.partitionId() % exec.stripes();
        assert (stripeIdx >= 0) : "Stripe index should be non-negative: " + stripeIdx;
        if (exec.queueSize(stripeIdx) > 10000) {
            int n = stripeIdx;
            stripesThrottleAccumulator[n] = stripesThrottleAccumulator[n] + 1;
            int throttlePower = stripesThrottleAccumulator[n];
            long throttleParkTimeNs = (long)(1000.0 * Math.pow(1.05, throttlePower));
            if (throttleParkTimeNs > THROTTLE_LOGGING_THRESHOLD) {
                U.warn(this.log, "Parking thread=" + Thread.currentThread().getName() + " for timeout(ms)=" + throttleParkTimeNs / 1000000L);
            }
            LockSupport.parkNanos(throttleParkTimeNs);
        } else {
            stripesThrottleAccumulator[stripeIdx] = 0;
        }
        exec.execute(stripeIdx, () -> {
            try {
                if (applyError.get() != null) {
                    return;
                }
                this.checkpointReadLock();
                try {
                    this.applyUpdate(cacheCtx, dataEntry, lockEntries);
                }
                finally {
                    this.checkpointReadUnlock();
                }
            }
            catch (IgniteCheckedException e) {
                applyError.compareAndSet(null, e);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private RestoreLogicalState applyLogicalUpdates(CheckpointStatus status, IgnitePredicate<Integer> cacheGroupsPredicate, IgniteBiPredicate<WALRecord.RecordType, WALPointer> recordTypePredicate, boolean skipFieldLookup) throws IgniteCheckedException {
        if (this.log.isInfoEnabled()) {
            this.log.info("Applying lost cache updates since last checkpoint record [lastMarked=" + status.startPtr + ", lastCheckpointId=" + status.cpStartId + ']');
        }
        if (skipFieldLookup) {
            this.cctx.kernalContext().query().skipFieldLookup(true);
        }
        long start = U.currentTimeMillis();
        AtomicReference<Throwable> applyError = new AtomicReference<Throwable>();
        AtomicLong applied = new AtomicLong();
        long lastArchivedSegment = this.cctx.wal().lastArchivedSegment();
        StripedExecutor exec = this.cctx.kernalContext().getStripedExecutorService();
        Semaphore semaphore = new Semaphore(this.semaphorePertmits(exec));
        HashMap<GroupPartitionId, Integer> partitionRecoveryStates = new HashMap<GroupPartitionId, Integer>();
        WALIterator it = this.cctx.wal().replay(status.startPtr, recordTypePredicate);
        RestoreLogicalState restoreLogicalState = new RestoreLogicalState(status, it, lastArchivedSegment, cacheGroupsPredicate, partitionRecoveryStates);
        try {
            WALRecord rec;
            block12: while (it.hasNextX() && (rec = restoreLogicalState.next()) != null) {
                switch (rec.type()) {
                    case CHECKPOINT_RECORD: {
                        CheckpointRecord cpRec = (CheckpointRecord)rec;
                        for (Map.Entry<Integer, CacheState> entry : cpRec.cacheGroupStates().entrySet()) {
                            CacheState cacheState = entry.getValue();
                            for (int i = 0; i < cacheState.size(); ++i) {
                                int partId = cacheState.partitionByIndex(i);
                                byte state = cacheState.stateByIndex(i);
                                if (state == -1) continue;
                                partitionRecoveryStates.put(new GroupPartitionId(entry.getKey(), partId), Integer.valueOf(state));
                            }
                        }
                        continue block12;
                    }
                    case ROLLBACK_TX_RECORD: {
                        RollbackRecord rbRec = (RollbackRecord)rec;
                        CacheGroupContext ctx = this.cctx.cache().cacheGroup(rbRec.groupId());
                        if (ctx == null || ctx.isLocal()) break;
                        ctx.topology().forceCreatePartition(rbRec.partitionId());
                        ctx.offheap().onPartitionInitialCounterUpdated(rbRec.partitionId(), rbRec.start(), rbRec.range());
                        break;
                    }
                    case MVCC_DATA_RECORD: 
                    case DATA_RECORD: 
                    case ENCRYPTED_DATA_RECORD: {
                        DataRecord dataRec = (DataRecord)rec;
                        for (DataEntry dataEntry : dataRec.writeEntries()) {
                            int cacheId = dataEntry.cacheId();
                            DynamicCacheDescriptor cacheDesc = this.cctx.cache().cacheDescriptor(cacheId);
                            if (cacheDesc == null) continue;
                            this.stripedApply(() -> {
                                GridCacheContext cacheCtx = this.cctx.cacheContext(cacheId);
                                if (this.skipRemovedIndexUpdates(cacheCtx.groupId(), 65535)) {
                                    this.cctx.kernalContext().query().markAsRebuildNeeded(cacheCtx);
                                }
                                try {
                                    this.applyUpdate(cacheCtx, dataEntry, false);
                                }
                                catch (IgniteCheckedException e) {
                                    U.error(this.log, "Failed to apply data entry, dataEntry=" + dataEntry + ", ptr=" + dataRec.position());
                                    applyError.compareAndSet(null, e);
                                }
                                applied.incrementAndGet();
                            }, cacheDesc.groupId(), dataEntry.partitionId(), exec, semaphore);
                        }
                        continue block12;
                    }
                    case MVCC_TX_RECORD: {
                        MvccTxRecord txRecord = (MvccTxRecord)rec;
                        byte txState = this.convertToTxState(txRecord.state());
                        this.cctx.coordinators().updateState(txRecord.mvccVersion(), txState, true);
                        break;
                    }
                    case PART_META_UPDATE_STATE: {
                        PartitionMetaStateRecord metaStateRecord = (PartitionMetaStateRecord)rec;
                        GroupPartitionId groupPartitionId = new GroupPartitionId(metaStateRecord.groupId(), metaStateRecord.partitionId());
                        restoreLogicalState.partitionRecoveryStates.put(groupPartitionId, Integer.valueOf(metaStateRecord.state()));
                        break;
                    }
                    case METASTORE_DATA_RECORD: {
                        MetastoreDataRecord metastoreDataRecord = (MetastoreDataRecord)rec;
                        this.metaStorage.applyUpdate(metastoreDataRecord.key(), metastoreDataRecord.value());
                        break;
                    }
                    case META_PAGE_UPDATE_NEXT_SNAPSHOT_ID: 
                    case META_PAGE_UPDATE_LAST_SUCCESSFUL_SNAPSHOT_ID: 
                    case META_PAGE_UPDATE_LAST_SUCCESSFUL_FULL_SNAPSHOT_ID: 
                    case META_PAGE_UPDATE_LAST_ALLOCATED_INDEX: {
                        PageDeltaRecord pageDelta = (PageDeltaRecord)rec;
                        this.stripedApplyPage(pageMem -> {
                            try {
                                this.applyPageDelta((PageMemoryEx)pageMem, pageDelta, false);
                            }
                            catch (IgniteCheckedException e) {
                                U.error(this.log, "Failed to apply page delta, " + pageDelta);
                                applyError.compareAndSet(null, e);
                            }
                        }, pageDelta.groupId(), PageIdUtils.partId(pageDelta.pageId()), exec, semaphore);
                        break;
                    }
                }
            }
        }
        finally {
            it.close();
            if (skipFieldLookup) {
                this.cctx.kernalContext().query().skipFieldLookup(false);
            }
        }
        this.awaitApplyComplete(exec, applyError);
        if (this.log.isInfoEnabled()) {
            this.log.info("Finished applying WAL changes [updatesApplied=" + applied + ", time=" + (U.currentTimeMillis() - start) + " ms]");
        }
        Iterator<DatabaseLifecycleListener> iterator = this.getDatabaseListeners(this.cctx.kernalContext()).iterator();
        while (iterator.hasNext()) {
            DatabaseLifecycleListener lsnr = iterator.next();
            lsnr.afterLogicalUpdatesApplied(this, restoreLogicalState);
        }
        return restoreLogicalState;
    }

    private byte convertToTxState(TransactionState state) {
        switch (state) {
            case PREPARED: {
                return 1;
            }
            case COMMITTED: {
                return 3;
            }
            case ROLLED_BACK: {
                return 2;
            }
        }
        throw new IllegalStateException("Unsupported TxState.");
    }

    public void onWalTruncated(WALPointer highBound) throws IgniteCheckedException {
        List<CheckpointEntry> rmvFromHist = this.cpHist.onWalTruncated(highBound);
        for (CheckpointEntry cp : rmvFromHist) {
            this.removeCheckpointFiles(cp);
        }
    }

    private void finalizeCheckpointOnRecovery(long cpTs, UUID cpId, WALPointer walPtr, StripedExecutor exec) throws IgniteCheckedException {
        assert (this.checkpointer != null) : "Checkpointer is null";
        this.checkpointer.finalizeCheckpointOnRecovery(cpTs, cpId, walPtr, exec);
        this.cctx.pageStore().finishRecover();
    }

    public void setThreadBuf(ThreadLocal<ByteBuffer> threadBuf) {
        assert (this.checkpointer != null) : "Checkpointer is null";
        this.checkpointer.threadBuf(threadBuf);
    }

    @Nullable
    public CheckpointHistory checkpointHistory() {
        return this.cpHist;
    }

    public void schedulePartitionDestroy(int grpId, int partId) {
        Checkpointer cp = this.checkpointer;
        if (cp != null) {
            cp.schedulePartitionDestroy(this.cctx.cache().cacheGroup(grpId), grpId, partId);
        }
    }

    public void cancelOrWaitPartitionDestroy(int grpId, int partId) throws IgniteCheckedException {
        Checkpointer cp = this.checkpointer;
        if (cp != null) {
            cp.cancelOrWaitPartitionDestroy(grpId, partId);
        }
    }

    @Override
    public long checkpointReadLockTimeout() {
        return this.checkpointReadLockTimeout;
    }

    @Override
    public void checkpointReadLockTimeout(long val) {
        this.checkpointReadLockTimeout = val;
    }

    public AtomicLong pageListCacheLimitHolder(DataRegion dataRegion) {
        if (dataRegion.config().isPersistenceEnabled()) {
            return this.pageListCacheLimits.computeIfAbsent(dataRegion.config().getName(), name -> new AtomicLong((long)((double)((PageMemoryEx)dataRegion.pageMemory()).totalPages() * 0.1)));
        }
        return null;
    }

    @Override
    public DataStorageMetrics persistentStoreMetrics() {
        return new DataStorageMetricsSnapshot(this.persStoreMetrics);
    }

    public DataStorageMetricsImpl persistentStoreMetricsImpl() {
        return this.persStoreMetrics;
    }

    @Override
    public MetaStorage metaStorage() {
        return this.metaStorage;
    }

    public MetaStorage.TmpStorage temporaryMetaStorage() {
        return this.tmpMetaStorage;
    }

    public void temporaryMetaStorage(MetaStorage.TmpStorage tmpMetaStorage) {
        this.tmpMetaStorage = tmpMetaStorage;
    }

    @Override
    public void notifyMetaStorageSubscribersOnReadyForRead() throws IgniteCheckedException {
        this.metastorageLifecycleLsnrs = this.cctx.kernalContext().internalSubscriptionProcessor().getMetastorageSubscribers();
        this.readMetastore();
    }

    @Override
    public boolean walEnabled(int grpId, boolean local) {
        if (local) {
            return !this.initiallyLocWalDisabledGrps.contains(grpId);
        }
        return !this.initiallyGlobalWalDisabledGrps.contains(grpId);
    }

    @Override
    public void walEnabled(int grpId, boolean enabled, boolean local) {
        String key = GridCacheDatabaseSharedManager.walGroupIdToKey(grpId, local);
        this.checkpointReadLock();
        try {
            if (enabled) {
                this.metaStorage.remove(key);
            } else {
                this.metaStorage.write(key, Boolean.valueOf(true));
                this.lastCheckpointInapplicableForWalRebalance(grpId);
            }
        }
        catch (IgniteCheckedException e) {
            throw new IgniteException("Failed to write cache group WAL state [grpId=" + grpId + ", enabled=" + enabled + ']', e);
        }
        finally {
            this.checkpointReadUnlock();
        }
    }

    public boolean isCheckpointInapplicableForWalRebalance(Long cpTs, int grpId) throws IgniteCheckedException {
        return this.metaStorage.read(GridCacheDatabaseSharedManager.checkpointInapplicableCpAndGroupIdToKey(cpTs, grpId)) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void lastCheckpointInapplicableForWalRebalance(int grpId) {
        this.checkpointReadLock();
        try {
            long lastCpTs;
            CheckpointEntry lastCp = this.cpHist.lastCheckpointMarkingAsInapplicable(grpId);
            long l = lastCpTs = lastCp != null ? lastCp.timestamp() : 0L;
            if (lastCpTs != 0L) {
                this.metaStorage.write(GridCacheDatabaseSharedManager.checkpointInapplicableCpAndGroupIdToKey(lastCpTs, grpId), Boolean.valueOf(true));
            }
        }
        catch (IgniteCheckedException e) {
            this.log.error("Failed to mark last checkpoint as inapplicable for WAL rebalance for group: " + grpId, e);
        }
        finally {
            this.checkpointReadUnlock();
        }
    }

    private void fillWalDisabledGroups() {
        assert (this.metaStorage != null);
        try {
            this.metaStorage.iterate(WAL_KEY_PREFIX, (key, val) -> {
                T2<Integer, Boolean> t2 = GridCacheDatabaseSharedManager.walKeyToGroupIdAndLocalFlag(key);
                if (t2 != null) {
                    if (((Boolean)t2.get2()).booleanValue()) {
                        this.initiallyLocWalDisabledGrps.add((Integer)t2.get1());
                    } else {
                        this.initiallyGlobalWalDisabledGrps.add((Integer)t2.get1());
                    }
                }
            }, false);
        }
        catch (IgniteCheckedException e) {
            throw new IgniteException("Failed to read cache groups WAL state.", e);
        }
    }

    private static String walGroupIdToKey(int grpId, boolean local) {
        if (local) {
            return WAL_LOCAL_KEY_PREFIX + grpId;
        }
        return WAL_GLOBAL_KEY_PREFIX + grpId;
    }

    private static String checkpointInapplicableCpAndGroupIdToKey(long cpTs, int grpId) {
        return CHECKPOINT_INAPPLICABLE_FOR_REBALANCE + cpTs + "-" + grpId;
    }

    private static T2<Integer, Boolean> walKeyToGroupIdAndLocalFlag(String key) {
        if (key.startsWith(WAL_LOCAL_KEY_PREFIX)) {
            return new T2<Integer, Boolean>(Integer.parseInt(key.substring(WAL_LOCAL_KEY_PREFIX.length())), true);
        }
        if (key.startsWith(WAL_GLOBAL_KEY_PREFIX)) {
            return new T2<Integer, Boolean>(Integer.parseInt(key.substring(WAL_GLOBAL_KEY_PREFIX.length())), false);
        }
        return null;
    }

    private static void dumpPartitionsInfo(GridCacheSharedContext cctx, IgniteLogger log) throws IgniteCheckedException {
        for (CacheGroupContext grp : cctx.cache().cacheGroups()) {
            if (grp.isLocal() || !grp.persistenceEnabled()) continue;
            GridCacheDatabaseSharedManager.dumpPartitionsInfo(grp, log);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void dumpPartitionsInfo(CacheGroupContext grp, IgniteLogger log) throws IgniteCheckedException {
        PageMemoryEx pageMem = (PageMemoryEx)grp.dataRegion().pageMemory();
        IgnitePageStoreManager pageStore = grp.shared().pageStore();
        assert (pageStore != null) : "Persistent cache should have initialize page store manager.";
        for (int p = 0; p < grp.affinity().partitions(); ++p) {
            GridDhtLocalPartition part = grp.topology().localPartition(p);
            if (part != null) {
                if (!log.isInfoEnabled()) continue;
                log.info("Partition [grp=" + grp.cacheOrGroupName() + ", id=" + p + ", state=" + (Object)((Object)part.state()) + ", counter=" + part.dataStore().partUpdateCounter() + ", size=" + part.fullSize() + "]");
                continue;
            }
            if (!pageStore.exists(grp.groupId(), p)) continue;
            pageStore.ensure(grp.groupId(), p);
            if (pageStore.pages(grp.groupId(), p) <= 1) {
                if (!log.isInfoEnabled()) continue;
                log.info("Partition [grp=" + grp.cacheOrGroupName() + ", id=" + p + ", state=N/A (only file header) ]");
                continue;
            }
            long partMetaId = pageMem.partitionMetaPageId(grp.groupId(), p);
            long partMetaPage = pageMem.acquirePage(grp.groupId(), partMetaId);
            try {
                long pageAddr = pageMem.readLock(grp.groupId(), partMetaId, partMetaPage);
                try {
                    PagePartitionMetaIO io = PagePartitionMetaIO.VERSIONS.forPage(pageAddr);
                    GridDhtPartitionState partState = GridDhtPartitionState.fromOrdinal(io.getPartitionState(pageAddr));
                    String state = partState != null ? partState.toString() : "N/A";
                    long updateCntr = io.getUpdateCounter(pageAddr);
                    long size = io.getSize(pageAddr);
                    if (!log.isInfoEnabled()) continue;
                    log.info("Partition [grp=" + grp.cacheOrGroupName() + ", id=" + p + ", state=" + state + ", counter=" + updateCntr + ", size=" + size + "]");
                    continue;
                }
                finally {
                    pageMem.readUnlock(grp.groupId(), partMetaId, partMetaPage);
                }
            }
            finally {
                pageMem.releasePage(grp.groupId(), partMetaId, partMetaPage);
            }
        }
    }

    private IgnitePredicate<Integer> onlyMetastorageGroup() {
        return groupId -> MetaStorage.METASTORAGE_CACHE_ID == groupId;
    }

    private IgnitePredicate<Integer> groupsWithEnabledWal() {
        return groupId -> !this.initiallyGlobalWalDisabledGrps.contains(groupId) && !this.initiallyLocWalDisabledGrps.contains(groupId);
    }

    private IgniteBiPredicate<WALRecord.RecordType, WALPointer> onlyMetastorageRecords() {
        return (type, ptr) -> type == WALRecord.RecordType.METASTORE_DATA_RECORD;
    }

    private IgniteBiPredicate<WALRecord.RecordType, WALPointer> physicalRecords() {
        return (type, ptr) -> type.purpose() == WALRecord.RecordPurpose.PHYSICAL || type.purpose() == WALRecord.RecordPurpose.MIXED;
    }

    private IgniteBiPredicate<WALRecord.RecordType, WALPointer> logicalRecords() {
        return (type, ptr) -> type.purpose() == WALRecord.RecordPurpose.LOGICAL || type.purpose() == WALRecord.RecordPurpose.MIXED || type == WALRecord.RecordType.CHECKPOINT_RECORD;
    }

    private static class CheckpointReadLockTimeoutException
    extends IgniteCheckedException {
        private static final long serialVersionUID = 0L;

        private CheckpointReadLockTimeoutException(String msg) {
            super(msg);
        }
    }

    public class RestoreLogicalState
    extends RestoreStateContext {
        private final Map<GroupPartitionId, Integer> partitionRecoveryStates;

        public RestoreLogicalState(CheckpointStatus status, WALIterator iterator, long lastArchivedSegment, IgnitePredicate<Integer> cacheGroupsPredicate, Map<GroupPartitionId, Integer> partitionRecoveryStates) {
            super(status, iterator, lastArchivedSegment, cacheGroupsPredicate);
            this.partitionRecoveryStates = partitionRecoveryStates;
        }

        public Map<GroupPartitionId, Integer> partitionRecoveryStates() {
            return Collections.unmodifiableMap(this.partitionRecoveryStates);
        }
    }

    public class RestoreBinaryState
    extends RestoreStateContext {
        private boolean needApplyBinaryUpdates;

        public RestoreBinaryState(CheckpointStatus status, WALIterator iterator, long lastArchivedSegment, IgnitePredicate<Integer> cacheGroupsPredicate) {
            super(status, iterator, lastArchivedSegment, cacheGroupsPredicate);
            this.needApplyBinaryUpdates = status.needRestoreMemory();
        }

        @Override
        public WALRecord next() throws IgniteCheckedException {
            WALRecord rec = super.next();
            if (rec == null) {
                return null;
            }
            if (rec.type() == WALRecord.RecordType.CHECKPOINT_RECORD) {
                CheckpointRecord cpRec = (CheckpointRecord)rec;
                if (F.eq(cpRec.checkpointId(), this.status.cpStartId)) {
                    if (GridCacheDatabaseSharedManager.this.log.isInfoEnabled()) {
                        GridCacheDatabaseSharedManager.this.log.info("Found last checkpoint marker [cpId=" + cpRec.checkpointId() + ", pos=" + rec.position() + ']');
                    }
                    this.needApplyBinaryUpdates = false;
                } else if (!F.eq(cpRec.checkpointId(), this.status.cpEndId)) {
                    U.warn(GridCacheDatabaseSharedManager.this.log, "Found unexpected checkpoint marker, skipping [cpId=" + cpRec.checkpointId() + ", expCpId=" + this.status.cpStartId + ", pos=" + rec.position() + ']');
                }
            }
            return rec;
        }

        public boolean needApplyBinaryUpdate() {
            return this.needApplyBinaryUpdates;
        }

        @Override
        public boolean throwsCRCError() {
            GridCacheDatabaseSharedManager.this.log.info("Throws CRC error check [needApplyBinaryUpdates=" + this.needApplyBinaryUpdates + ", lastArchivedSegment=" + this.lastArchivedSegment + ", lastRead=" + this.lastReadRecordPointer() + ']');
            if (this.needApplyBinaryUpdates) {
                return true;
            }
            return super.throwsCRCError();
        }
    }

    private abstract class RestoreStateContext {
        protected final long lastArchivedSegment;
        protected final CheckpointStatus status;
        private final WALIterator iterator;
        private final IgnitePredicate<Integer> cacheGroupPredicate;

        protected RestoreStateContext(CheckpointStatus status, WALIterator iterator, long lastArchivedSegment, IgnitePredicate<Integer> cacheGroupPredicate) {
            this.status = status;
            this.iterator = iterator;
            this.lastArchivedSegment = lastArchivedSegment;
            this.cacheGroupPredicate = cacheGroupPredicate;
        }

        public WALRecord next() throws IgniteCheckedException {
            try {
                WalRecordCacheGroupAware grpAwareRecord;
                WALRecord rec;
                do {
                    if (!this.iterator.hasNextX()) {
                        return null;
                    }
                    IgniteBiTuple tup = (IgniteBiTuple)this.iterator.nextX();
                    if (tup == null) {
                        return null;
                    }
                    rec = (WALRecord)tup.get2();
                    WALPointer ptr = (WALPointer)tup.get1();
                    rec.position(ptr);
                } while (rec instanceof WalRecordCacheGroupAware && !this.cacheGroupPredicate.apply((grpAwareRecord = (WalRecordCacheGroupAware)((Object)rec)).groupId()));
                if (rec instanceof DataRecord) {
                    rec = this.filterEntriesByGroupId((DataRecord)rec);
                }
                return rec;
            }
            catch (IgniteCheckedException e) {
                boolean throwsCRCError = this.throwsCRCError();
                if (X.hasCause((Throwable)e, IgniteDataIntegrityViolationException.class)) {
                    if (throwsCRCError) {
                        throw e;
                    }
                    return null;
                }
                GridCacheDatabaseSharedManager.this.log.error("There is an error during restore state [throwsCRCError=" + throwsCRCError + ']', e);
                throw e;
            }
        }

        private DataRecord filterEntriesByGroupId(DataRecord record) {
            List<DataEntry> filteredEntries = record.writeEntries().stream().filter(entry -> {
                int cacheId = entry.cacheId();
                return GridCacheDatabaseSharedManager.this.cctx.cacheContext(cacheId) != null && this.cacheGroupPredicate.apply(GridCacheDatabaseSharedManager.this.cctx.cacheContext(cacheId).groupId());
            }).collect(Collectors.toList());
            return record.setWriteEntries(filteredEntries);
        }

        public FileWALPointer lastReadRecordPointer() {
            assert (this.status.startPtr != null && this.status.startPtr instanceof FileWALPointer);
            return this.iterator.lastRead().map(ptr -> (FileWALPointer)ptr).orElseGet(() -> (FileWALPointer)this.status.startPtr);
        }

        public boolean throwsCRCError() {
            return this.lastReadRecordPointer().index() <= this.lastArchivedSegment;
        }
    }

    private class MetastorageRecoveryLifecycle
    implements DatabaseLifecycleListener {
        private MetastorageRecoveryLifecycle() {
        }

        @Override
        public void beforeBinaryMemoryRestore(IgniteCacheDatabaseSharedManager mgr) throws IgniteCheckedException {
            GridCacheDatabaseSharedManager.this.cctx.pageStore().initializeForMetastorage();
        }

        @Override
        public void afterBinaryMemoryRestore(IgniteCacheDatabaseSharedManager mgr, RestoreBinaryState restoreState) throws IgniteCheckedException {
            assert (GridCacheDatabaseSharedManager.this.metaStorage == null);
            GridCacheDatabaseSharedManager.this.metaStorage = GridCacheDatabaseSharedManager.this.createMetastorage(false);
        }
    }

    public static class FileLockHolder
    implements AutoCloseable {
        private static final String lockFileName = "lock";
        private File file;
        private RandomAccessFile lockFile;
        private volatile FileLock lock;
        @NotNull
        private GridKernalContext ctx;
        private IgniteLogger log;

        public FileLockHolder(String path, @NotNull GridKernalContext ctx, IgniteLogger log) {
            try {
                this.file = Paths.get(path, lockFileName).toFile();
                this.lockFile = new RandomAccessFile(this.file, "rw");
                this.ctx = ctx;
                this.log = log;
            }
            catch (IOException e) {
                throw new IgniteException(e);
            }
        }

        public void tryLock(long lockWaitTimeMillis) throws IgniteCheckedException {
            String failMsg;
            GridPortProcessor ports;
            ClusterNode node;
            assert (this.lockFile != null);
            FileChannel ch = this.lockFile.getChannel();
            SB sb = new SB();
            sb.a("[").a(this.ctx.localNodeId().toString()).a("]");
            GridDiscoveryManager discovery = this.ctx.discovery();
            if (discovery != null && (node = discovery.localNode()) != null) {
                sb.a(node.addresses());
            }
            if ((ports = this.ctx.ports()) != null) {
                sb.a("[");
                Iterator<GridPortRecord> it = ports.records().iterator();
                while (it.hasNext()) {
                    GridPortRecord rec = it.next();
                    sb.a((Object)rec.protocol()).a(":").a(rec.port());
                    if (!it.hasNext()) continue;
                    sb.a(", ");
                }
                sb.a("]");
            }
            try {
                String content = null;
                int i = 0;
                while ((long)i < lockWaitTimeMillis) {
                    try {
                        this.lock = ch.tryLock(0L, 1L, false);
                        if (this.lock != null && this.lock.isValid()) {
                            this.writeContent(sb.toString());
                            return;
                        }
                    }
                    catch (OverlappingFileLockException ignore) {
                        if (content == null) {
                            content = this.readContent();
                        }
                        this.log.warning("Failed to acquire file lock. Will try again in 1s [nodeId=" + this.ctx.localNodeId() + ", holder=" + content + ", path=" + this.file.getAbsolutePath() + ']');
                    }
                    U.sleep(1000L);
                    i += 1000;
                }
                if (content == null) {
                    content = this.readContent();
                }
                failMsg = "Failed to acquire file lock [holder=" + content + ", time=" + lockWaitTimeMillis / 1000L + " sec, path=" + this.file.getAbsolutePath() + ']';
            }
            catch (Exception e) {
                throw new IgniteCheckedException(e);
            }
            if (failMsg != null) {
                throw new IgniteCheckedException(failMsg);
            }
        }

        private void writeContent(String content) throws IOException {
            FileChannel ch = this.lockFile.getChannel();
            byte[] bytes = content.getBytes();
            ByteBuffer buf = ByteBuffer.allocate(bytes.length);
            buf.put(bytes);
            buf.flip();
            ch.write(buf, 1L);
            ch.force(false);
        }

        private String readContent() throws IOException {
            FileChannel ch = this.lockFile.getChannel();
            ByteBuffer buf = ByteBuffer.allocate((int)(ch.size() - 1L));
            ch.read(buf, 1L);
            String content = new String(buf.array());
            buf.clear();
            return content;
        }

        public boolean isLocked() {
            return this.lock != null && this.lock.isValid();
        }

        public void release() {
            U.releaseQuiet(this.lock);
        }

        @Override
        public void close() {
            this.release();
            U.closeQuiet(this.lockFile);
        }

        private String lockPath() {
            return this.file.getAbsolutePath();
        }
    }

    public static class CheckpointStatus {
        private static final UUID NULL_UUID = new UUID(0L, 0L);
        public static final WALPointer NULL_PTR = new FileWALPointer(0L, 0, 0);
        private long cpStartTs;
        private UUID cpStartId;
        @GridToStringInclude
        private WALPointer startPtr;
        private UUID cpEndId;
        @GridToStringInclude
        private WALPointer endPtr;

        private CheckpointStatus(long cpStartTs, UUID cpStartId, WALPointer startPtr, UUID cpEndId, WALPointer endPtr) {
            this.cpStartTs = cpStartTs;
            this.cpStartId = cpStartId;
            this.startPtr = startPtr;
            this.cpEndId = cpEndId;
            this.endPtr = endPtr;
        }

        public boolean needRestoreMemory() {
            return !F.eq(this.cpStartId, this.cpEndId) && !F.eq(NULL_UUID, this.cpStartId);
        }

        public String toString() {
            return S.toString(CheckpointStatus.class, this);
        }
    }
}

