/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.persistence.checkpoint;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Set;
import java.util.concurrent.ConcurrentSkipListMap;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.IgniteSystemProperties;
import org.apache.ignite.configuration.DataStorageConfiguration;
import org.apache.ignite.configuration.WALMode;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.pagemem.wal.WALPointer;
import org.apache.ignite.internal.pagemem.wal.record.CacheState;
import org.apache.ignite.internal.processors.cache.GridCacheSharedContext;
import org.apache.ignite.internal.processors.cache.persistence.GridCacheDatabaseSharedManager;
import org.apache.ignite.internal.processors.cache.persistence.checkpoint.Checkpoint;
import org.apache.ignite.internal.processors.cache.persistence.checkpoint.CheckpointEntry;
import org.apache.ignite.internal.processors.cache.persistence.checkpoint.CheckpointHistoryResult;
import org.apache.ignite.internal.processors.cache.persistence.checkpoint.ReservationReason;
import org.apache.ignite.internal.processors.cache.persistence.partstate.GroupPartitionId;
import org.apache.ignite.internal.processors.cache.persistence.wal.FileWALPointer;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.T2;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteBiTuple;
import org.jetbrains.annotations.Nullable;

public class CheckpointHistory {
    private final IgniteLogger log;
    private final GridCacheSharedContext<?, ?> cctx;
    private final NavigableMap<Long, CheckpointEntry> histMap = new ConcurrentSkipListMap<Long, CheckpointEntry>();
    private final int maxCpHistMemSize;
    private final boolean isWalTruncationEnabled;
    private final long maxWalArchiveSize;
    private final Map<GroupPartitionId, CheckpointEntry> earliestCp = new HashMap<GroupPartitionId, CheckpointEntry>();

    public CheckpointHistory(GridKernalContext ctx) {
        this.cctx = ctx.cache().context();
        this.log = ctx.log(this.getClass());
        DataStorageConfiguration dsCfg = ctx.config().getDataStorageConfiguration();
        this.maxWalArchiveSize = dsCfg.getMaxWalArchiveSize();
        this.isWalTruncationEnabled = this.maxWalArchiveSize != -1L;
        this.maxCpHistMemSize = IgniteSystemProperties.getInteger("IGNITE_PDS_MAX_CHECKPOINT_MEMORY_HISTORY_SIZE", 100);
    }

    public void initialize(List<CheckpointEntry> checkpoints) {
        for (CheckpointEntry e : checkpoints) {
            this.histMap.put(e.timestamp(), e);
        }
        for (Long timestamp : this.checkpoints(false)) {
            try {
                this.updateEarliestCpMap(this.entry(timestamp));
            }
            catch (IgniteCheckedException e) {
                U.warn(this.log, "Failed to process checkpoint, happened at " + U.format(timestamp) + '.', e);
            }
        }
    }

    private CheckpointEntry entry(Long cpTs) throws IgniteCheckedException {
        CheckpointEntry entry = (CheckpointEntry)this.histMap.get(cpTs);
        if (entry == null) {
            throw new IgniteCheckedException("Checkpoint entry was removed: " + cpTs);
        }
        return entry;
    }

    public CheckpointEntry firstCheckpoint() {
        Map.Entry<Long, CheckpointEntry> entry = this.histMap.firstEntry();
        return entry != null ? entry.getValue() : null;
    }

    public CheckpointEntry lastCheckpoint() {
        Map.Entry<Long, CheckpointEntry> entry = this.histMap.lastEntry();
        return entry != null ? entry.getValue() : null;
    }

    public WALPointer firstCheckpointPointer() {
        CheckpointEntry entry = this.firstCheckpoint();
        return entry != null ? entry.checkpointMark() : null;
    }

    public Collection<Long> checkpoints(boolean descending) {
        if (descending) {
            return this.histMap.descendingKeySet();
        }
        return this.histMap.keySet();
    }

    public Collection<Long> checkpoints() {
        return this.checkpoints(false);
    }

    public void addCheckpoint(CheckpointEntry entry, Map<Integer, CacheState> cacheStates) {
        this.addCpCacheStatesToEarliestCpMap(entry, cacheStates);
        this.histMap.put(entry.timestamp(), entry);
    }

    private void updateEarliestCpMap(CheckpointEntry entry) {
        try {
            Map<Integer, CheckpointEntry.GroupState> states = entry.groupState(this.cctx);
            Iterator<Map.Entry<GroupPartitionId, CheckpointEntry>> iter = this.earliestCp.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry<GroupPartitionId, CheckpointEntry> grpPartCp = iter.next();
                int grpId = grpPartCp.getKey().getGroupId();
                if (!this.isCheckpointApplicableForGroup(grpId, entry)) {
                    iter.remove();
                    continue;
                }
                int part = grpPartCp.getKey().getPartitionId();
                int pIdx = states.get(grpId).indexByPartition(part);
                if (pIdx >= 0) continue;
                iter.remove();
            }
            this.addCpGroupStatesToEarliestCpMap(entry, states);
        }
        catch (IgniteCheckedException ex) {
            U.warn(this.log, "Failed to process checkpoint: " + (entry != null ? entry : "none"), ex);
            this.earliestCp.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CheckpointEntry lastCheckpointMarkingAsInapplicable(Integer grpId) {
        Map<GroupPartitionId, CheckpointEntry> map = this.earliestCp;
        synchronized (map) {
            CheckpointEntry lastCp = this.lastCheckpoint();
            this.earliestCp.keySet().removeIf(grpPart -> grpId.equals(grpPart.getGroupId()));
            return lastCp;
        }
    }

    private void addCpCacheStatesToEarliestCpMap(CheckpointEntry entry, Map<Integer, CacheState> cacheStates) {
        for (Integer grpId : cacheStates.keySet()) {
            CacheState cacheState = cacheStates.get(grpId);
            for (int pIdx = 0; pIdx < cacheState.size(); ++pIdx) {
                int part = cacheState.partitionByIndex(pIdx);
                GroupPartitionId grpPartKey = new GroupPartitionId(grpId, part);
                this.addPartitionToEarliestCheckpoints(grpPartKey, entry);
            }
        }
    }

    private void addCpGroupStatesToEarliestCpMap(CheckpointEntry entry, Map<Integer, CheckpointEntry.GroupState> cacheGrpStates) {
        for (Integer grpId : cacheGrpStates.keySet()) {
            CheckpointEntry.GroupState grpState = cacheGrpStates.get(grpId);
            for (int pIdx = 0; pIdx < grpState.size(); ++pIdx) {
                int part = grpState.getPartitionByIndex(pIdx);
                GroupPartitionId grpPartKey = new GroupPartitionId(grpId, part);
                this.addPartitionToEarliestCheckpoints(grpPartKey, entry);
            }
        }
    }

    private void addPartitionToEarliestCheckpoints(GroupPartitionId grpPartKey, CheckpointEntry entry) {
        if (!this.earliestCp.containsKey(grpPartKey)) {
            this.earliestCp.put(grpPartKey, entry);
        }
    }

    public List<CheckpointEntry> onWalTruncated(WALPointer ptr) {
        CheckpointEntry cpEntry;
        FileWALPointer cpPnt;
        ArrayList<CheckpointEntry> removed = new ArrayList<CheckpointEntry>();
        FileWALPointer highBound = (FileWALPointer)ptr;
        Iterator iterator = this.histMap.values().iterator();
        while (iterator.hasNext() && highBound.compareTo(cpPnt = (FileWALPointer)(cpEntry = (CheckpointEntry)iterator.next()).checkpointMark()) > 0 && this.removeCheckpoint(cpEntry)) {
            removed.add(cpEntry);
        }
        return removed;
    }

    public List<CheckpointEntry> removeCheckpoints(int countToRemove) {
        Map.Entry entry;
        CheckpointEntry checkpoint;
        if (countToRemove == 0) {
            return Collections.emptyList();
        }
        ArrayList<CheckpointEntry> removed = new ArrayList<CheckpointEntry>();
        Iterator iterator = this.histMap.entrySet().iterator();
        while (iterator.hasNext() && removed.size() < countToRemove && this.removeCheckpoint(checkpoint = (CheckpointEntry)(entry = iterator.next()).getValue())) {
            removed.add(checkpoint);
        }
        return removed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean removeCheckpoint(CheckpointEntry checkpoint) {
        if (this.cctx.wal().reserved(checkpoint.checkpointMark())) {
            U.warn(this.log, "Could not clear historyMap due to WAL reservation on cp: " + checkpoint + ", history map size is " + this.histMap.size());
            return false;
        }
        Map<GroupPartitionId, CheckpointEntry> map = this.earliestCp;
        synchronized (map) {
            CheckpointEntry deletedCpEntry = (CheckpointEntry)this.histMap.remove(checkpoint.timestamp());
            CheckpointEntry oldestCpInHistory = this.firstCheckpoint();
            for (Map.Entry<GroupPartitionId, CheckpointEntry> grpPartPerCp : this.earliestCp.entrySet()) {
                if (grpPartPerCp.getValue() != deletedCpEntry) continue;
                grpPartPerCp.setValue(oldestCpInHistory);
            }
        }
        return true;
    }

    public List<CheckpointEntry> onCheckpointFinished(Checkpoint chp) {
        int removeCount;
        chp.walSegsCoveredRange(this.calculateWalSegmentsCovered());
        int n = removeCount = this.isWalTruncationEnabled ? this.checkpointCountUntilDeleteByArchiveSize() : this.histMap.size() - this.maxCpHistMemSize;
        if (removeCount <= 0) {
            return Collections.emptyList();
        }
        List<CheckpointEntry> deletedCheckpoints = this.removeCheckpoints(removeCount);
        if (this.isWalTruncationEnabled) {
            int deleted = this.cctx.wal().truncate(null, this.firstCheckpointPointer());
            chp.walFilesDeleted(deleted);
        }
        return deletedCheckpoints;
    }

    private int checkpointCountUntilDeleteByArchiveSize() {
        long absFileIdxToDel = this.cctx.wal().maxArchivedSegmentToDelete();
        if (absFileIdxToDel < 0L) {
            return 0;
        }
        long fileUntilDel = absFileIdxToDel + 1L;
        long checkpointFileIdx = this.absFileIdx(this.lastCheckpoint());
        int countToRemove = 0;
        for (CheckpointEntry cpEntry : this.histMap.values()) {
            long currFileIdx = this.absFileIdx(cpEntry);
            if (checkpointFileIdx <= currFileIdx || fileUntilDel <= currFileIdx) {
                return countToRemove;
            }
            ++countToRemove;
        }
        return this.histMap.size() - 1;
    }

    private long absFileIdx(CheckpointEntry pointer) {
        return ((FileWALPointer)pointer.checkpointMark()).index();
    }

    private IgniteBiTuple<Long, Long> calculateWalSegmentsCovered() {
        IgniteBiTuple<Long, Long> tup = new IgniteBiTuple<Long, Long>(-1L, -1L);
        Map.Entry<Long, CheckpointEntry> lastEntry = this.histMap.lastEntry();
        if (lastEntry == null) {
            return tup;
        }
        Map.Entry<Long, CheckpointEntry> previousEntry = this.histMap.lowerEntry(lastEntry.getKey());
        WALPointer lastWALPointer = lastEntry.getValue().checkpointMark();
        long lastIdx = 0L;
        long prevIdx = 0L;
        if (lastWALPointer instanceof FileWALPointer) {
            lastIdx = ((FileWALPointer)lastWALPointer).index();
            if (previousEntry != null) {
                prevIdx = ((FileWALPointer)previousEntry.getValue().checkpointMark()).index();
            }
        }
        tup.set1(prevIdx);
        tup.set2(lastIdx - 1L);
        return tup;
    }

    @Nullable
    public WALPointer searchEarliestWalPointer(int grpId, Map<Integer, Long> partsCounter, long margin) throws IgniteCheckedException {
        if (F.isEmpty(partsCounter)) {
            return null;
        }
        HashMap<Integer, Long> modifiedPartsCounter = new HashMap<Integer, Long>(partsCounter);
        FileWALPointer minPtr = null;
        LinkedList<WalPointerCandidate> historyPointerCandidate = new LinkedList<WalPointerCandidate>();
        for (Long cpTs : this.checkpoints(true)) {
            CheckpointEntry cpEntry = this.entry(cpTs);
            while (!F.isEmpty(historyPointerCandidate)) {
                FileWALPointer ptr = ((WalPointerCandidate)historyPointerCandidate.poll()).choose(cpEntry, margin, partsCounter);
                if (minPtr != null && ptr.compareTo(minPtr) >= 0) continue;
                minPtr = ptr;
            }
            Iterator iter = modifiedPartsCounter.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry entry = iter.next();
                Long foundCntr = cpEntry.partitionCounter(this.cctx, grpId, (Integer)entry.getKey());
                if (foundCntr == null || foundCntr > (Long)entry.getValue()) continue;
                iter.remove();
                FileWALPointer ptr = (FileWALPointer)cpEntry.checkpointMark();
                if (ptr == null) {
                    throw new IgniteCheckedException("Could not find start pointer for partition [part=" + entry.getKey() + ", partCntrSince=" + entry.getValue() + "]");
                }
                if (foundCntr + margin > (Long)entry.getValue()) {
                    historyPointerCandidate.add(new WalPointerCandidate(grpId, (Integer)entry.getKey(), (Long)entry.getValue(), ptr, foundCntr));
                    continue;
                }
                partsCounter.put((Integer)entry.getKey(), (Long)entry.getValue() - margin);
                if (minPtr != null && ptr.compareTo(minPtr) >= 0) continue;
                minPtr = ptr;
            }
            if (!F.isEmpty(modifiedPartsCounter) || !F.isEmpty(historyPointerCandidate)) continue;
            return minPtr;
        }
        if (!F.isEmpty(modifiedPartsCounter)) {
            Map.Entry entry = modifiedPartsCounter.entrySet().iterator().next();
            throw new IgniteCheckedException("Could not find start pointer for partition [part=" + entry.getKey() + ", partCntrSince=" + entry.getValue() + "]");
        }
        while (!F.isEmpty(historyPointerCandidate)) {
            FileWALPointer ptr = ((WalPointerCandidate)historyPointerCandidate.poll()).choose(null, margin, partsCounter);
            if (minPtr != null && ptr.compareTo(minPtr) >= 0) continue;
            minPtr = ptr;
        }
        return minPtr;
    }

    @Nullable
    public Map<GroupPartitionId, CheckpointEntry> searchCheckpointEntry(Map<T2<Integer, Integer>, Long> searchCntrMap) {
        if (F.isEmpty(searchCntrMap)) {
            return Collections.emptyMap();
        }
        HashMap<T2<Integer, Integer>, Long> modifiedSearchMap = new HashMap<T2<Integer, Integer>, Long>(searchCntrMap);
        HashMap<GroupPartitionId, CheckpointEntry> res = new HashMap<GroupPartitionId, CheckpointEntry>();
        for (Long cpTs : this.checkpoints(true)) {
            try {
                CheckpointEntry cpEntry = this.entry(cpTs);
                Iterator iter = modifiedSearchMap.entrySet().iterator();
                while (iter.hasNext()) {
                    Map.Entry entry = iter.next();
                    Long foundCntr = cpEntry.partitionCounter(this.cctx, (Integer)((T2)entry.getKey()).get1(), (Integer)((T2)entry.getKey()).get2());
                    if (foundCntr == null || foundCntr > (Long)entry.getValue()) continue;
                    iter.remove();
                    res.put(new GroupPartitionId((Integer)((T2)entry.getKey()).get1(), (Integer)((T2)entry.getKey()).get2()), cpEntry);
                }
                if (!F.isEmpty(modifiedSearchMap)) continue;
                return res;
            }
            catch (IgniteCheckedException ignore) {
                break;
            }
        }
        if (!F.isEmpty(modifiedSearchMap)) {
            return Collections.emptyMap();
        }
        return res;
    }

    @Nullable
    public CheckpointEntry searchCheckpointEntry(int grpId, int part, long partCntrSince) {
        for (Long cpTs : this.checkpoints(true)) {
            try {
                CheckpointEntry entry = this.entry(cpTs);
                Long foundCntr = entry.partitionCounter(this.cctx, grpId, part);
                if (foundCntr == null || foundCntr > partCntrSince) continue;
                return entry;
            }
            catch (IgniteCheckedException ignore) {
                break;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CheckpointHistoryResult searchAndReserveCheckpoints(Map<Integer, Set<Integer>> groupsAndPartitions) {
        if (F.isEmpty(groupsAndPartitions) || this.cctx.kernalContext().config().getDataStorageConfiguration().getWalMode() == WALMode.NONE) {
            return new CheckpointHistoryResult(Collections.emptyMap(), null);
        }
        HashMap<Integer, T2<ReservationReason, Map<Integer, CheckpointEntry>>> res = new HashMap<Integer, T2<ReservationReason, Map<Integer, CheckpointEntry>>>();
        CheckpointEntry oldestCpForReservation = null;
        Map<GroupPartitionId, CheckpointEntry> map = this.earliestCp;
        synchronized (map) {
            CheckpointEntry checkpointEntry = this.firstCheckpoint();
            for (Integer grpId : groupsAndPartitions.keySet()) {
                CheckpointEntry oldestGrpCpEntry = null;
                for (Integer part : groupsAndPartitions.get(grpId)) {
                    CheckpointEntry cpEntry = this.earliestCp.get(new GroupPartitionId(grpId, part));
                    if (cpEntry == null) continue;
                    if (oldestCpForReservation == null || oldestCpForReservation.timestamp() > cpEntry.timestamp()) {
                        oldestCpForReservation = cpEntry;
                    }
                    if (oldestGrpCpEntry == null || oldestGrpCpEntry.timestamp() > cpEntry.timestamp()) {
                        oldestGrpCpEntry = cpEntry;
                    }
                    ((Map)res.computeIfAbsent(grpId, partCpMap -> new T2(ReservationReason.NO_MORE_HISTORY, new HashMap())).get2()).put(part, cpEntry);
                }
                if (oldestGrpCpEntry != null && oldestGrpCpEntry == checkpointEntry) continue;
                res.computeIfAbsent(grpId, partCpMap -> new T2<ReservationReason, Object>(ReservationReason.CHECKPOINT_NOT_APPLICABLE, null)).set1(ReservationReason.CHECKPOINT_NOT_APPLICABLE);
            }
        }
        if (oldestCpForReservation != null && !this.cctx.wal().reserve(oldestCpForReservation.checkpointMark())) {
            this.log.warning("Could not reserve cp " + oldestCpForReservation.checkpointMark());
            for (Map.Entry entry : res.entrySet()) {
                entry.setValue(new T2<ReservationReason, Object>(ReservationReason.WAL_RESERVATION_ERROR, null));
            }
            oldestCpForReservation = null;
        }
        return new CheckpointHistoryResult(res, oldestCpForReservation);
    }

    public boolean isCheckpointApplicableForGroup(int grpId, CheckpointEntry cp) throws IgniteCheckedException {
        GridCacheDatabaseSharedManager dbMgr = (GridCacheDatabaseSharedManager)this.cctx.database();
        if (dbMgr.isCheckpointInapplicableForWalRebalance(cp.timestamp(), grpId)) {
            return false;
        }
        return cp.groupState(this.cctx).containsKey(grpId);
    }

    private class WalPointerCandidate {
        private int grpId;
        private int part;
        private long partContr;
        private FileWALPointer walPntr;
        private long walPntrCntr;

        public WalPointerCandidate(int grpId, int part, long partContr, FileWALPointer walPntr, long walPntrCntr) {
            this.grpId = grpId;
            this.part = part;
            this.partContr = partContr;
            this.walPntr = walPntr;
            this.walPntrCntr = walPntrCntr;
        }

        public FileWALPointer choose(CheckpointEntry cpEntry, long margin, Map<Integer, Long> partCntsForUpdate) {
            Long foundCntr;
            Long l = foundCntr = cpEntry == null ? null : cpEntry.partitionCounter(CheckpointHistory.this.cctx, this.grpId, this.part);
            if (foundCntr == null || foundCntr == this.walPntrCntr) {
                partCntsForUpdate.put(this.part, this.walPntrCntr);
                return this.walPntr;
            }
            partCntsForUpdate.put(this.part, Math.max(foundCntr, this.partContr - margin));
            return (FileWALPointer)cpEntry.checkpointMark();
        }
    }
}

