/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.persistence.checkpoint;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinWorkerThread;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.atomic.LongAdder;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Supplier;
import java.util.function.ToLongFunction;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteInterruptedException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.IgniteSystemProperties;
import org.apache.ignite.configuration.CheckpointWriteOrder;
import org.apache.ignite.configuration.DataStorageConfiguration;
import org.apache.ignite.failure.FailureContext;
import org.apache.ignite.failure.FailureType;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.IgniteInterruptedCheckedException;
import org.apache.ignite.internal.LongJVMPauseDetector;
import org.apache.ignite.internal.NodeStoppingException;
import org.apache.ignite.internal.pagemem.FullPageId;
import org.apache.ignite.internal.pagemem.store.PageStore;
import org.apache.ignite.internal.pagemem.wal.IgniteWriteAheadLogManager;
import org.apache.ignite.internal.pagemem.wal.WALPointer;
import org.apache.ignite.internal.pagemem.wal.record.CacheState;
import org.apache.ignite.internal.pagemem.wal.record.CheckpointRecord;
import org.apache.ignite.internal.processors.cache.CacheGroupContext;
import org.apache.ignite.internal.processors.cache.GridCacheProcessor;
import org.apache.ignite.internal.processors.cache.distributed.dht.topology.GridDhtLocalPartition;
import org.apache.ignite.internal.processors.cache.distributed.dht.topology.GridDhtPartitionState;
import org.apache.ignite.internal.processors.cache.persistence.CheckpointState;
import org.apache.ignite.internal.processors.cache.persistence.DataRegion;
import org.apache.ignite.internal.processors.cache.persistence.DataStorageMetricsImpl;
import org.apache.ignite.internal.processors.cache.persistence.DbCheckpointListener;
import org.apache.ignite.internal.processors.cache.persistence.GridCacheDatabaseSharedManager;
import org.apache.ignite.internal.processors.cache.persistence.GridCacheOffheapManager;
import org.apache.ignite.internal.processors.cache.persistence.PageStoreWriter;
import org.apache.ignite.internal.processors.cache.persistence.StorageException;
import org.apache.ignite.internal.processors.cache.persistence.checkpoint.Checkpoint;
import org.apache.ignite.internal.processors.cache.persistence.checkpoint.CheckpointEntry;
import org.apache.ignite.internal.processors.cache.persistence.checkpoint.CheckpointEntryType;
import org.apache.ignite.internal.processors.cache.persistence.checkpoint.CheckpointHistory;
import org.apache.ignite.internal.processors.cache.persistence.checkpoint.CheckpointPagesInfoHolder;
import org.apache.ignite.internal.processors.cache.persistence.checkpoint.CheckpointProgress;
import org.apache.ignite.internal.processors.cache.persistence.checkpoint.CheckpointProgressImpl;
import org.apache.ignite.internal.processors.cache.persistence.checkpoint.DbCheckpointContextImpl;
import org.apache.ignite.internal.processors.cache.persistence.checkpoint.PartitionDestroyQueue;
import org.apache.ignite.internal.processors.cache.persistence.checkpoint.PartitionDestroyRequest;
import org.apache.ignite.internal.processors.cache.persistence.checkpoint.WriteCheckpointPages;
import org.apache.ignite.internal.processors.cache.persistence.file.FileIO;
import org.apache.ignite.internal.processors.cache.persistence.file.FileIOFactory;
import org.apache.ignite.internal.processors.cache.persistence.file.FilePageStoreManager;
import org.apache.ignite.internal.processors.cache.persistence.pagemem.CheckpointMetricsTracker;
import org.apache.ignite.internal.processors.cache.persistence.pagemem.PageMemoryEx;
import org.apache.ignite.internal.processors.cache.persistence.pagemem.PageMemoryImpl;
import org.apache.ignite.internal.processors.cache.persistence.partstate.PartitionAllocationMap;
import org.apache.ignite.internal.processors.cache.persistence.snapshot.IgniteCacheSnapshotManager;
import org.apache.ignite.internal.processors.cache.persistence.snapshot.SnapshotOperation;
import org.apache.ignite.internal.processors.cache.persistence.wal.FileWALPointer;
import org.apache.ignite.internal.processors.failure.FailureProcessor;
import org.apache.ignite.internal.util.GridConcurrentHashSet;
import org.apache.ignite.internal.util.GridConcurrentMultiPairQueue;
import org.apache.ignite.internal.util.GridMultiCollectionWrapper;
import org.apache.ignite.internal.util.StripedExecutor;
import org.apache.ignite.internal.util.future.CountDownFuture;
import org.apache.ignite.internal.util.future.GridCompoundFuture;
import org.apache.ignite.internal.util.future.GridFinishedFuture;
import org.apache.ignite.internal.util.future.GridFutureAdapter;
import org.apache.ignite.internal.util.lang.IgniteThrowableFunction;
import org.apache.ignite.internal.util.typedef.T2;
import org.apache.ignite.internal.util.typedef.internal.LT;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.internal.util.worker.GridWorker;
import org.apache.ignite.internal.worker.WorkersRegistry;
import org.apache.ignite.lang.IgniteBiTuple;
import org.apache.ignite.lang.IgniteFuture;
import org.apache.ignite.lang.IgniteInClosure;
import org.apache.ignite.thread.IgniteThreadPoolExecutor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jsr166.ConcurrentLinkedHashMap;

public class Checkpointer
extends GridWorker {
    private static final String CHECKPOINT_STARTED_LOG_FORMAT = "Checkpoint started [checkpointId=%s, startPtr=%s, checkpointBeforeLockTime=%dms, checkpointLockWait=%dms, checkpointListenersExecuteTime=%dms, checkpointLockHoldTime=%dms, walCpRecordFsyncDuration=%dms, writeCheckpointEntryDuration=%dms, splitAndSortCpPagesDuration=%dms, %s pages=%d, reason='%s']";
    private static final long PARTITION_DESTROY_CHECKPOINT_TIMEOUT = 30000L;
    private static final int PARALLEL_SORT_THREADS = Math.min(Runtime.getRuntime().availableProcessors(), 8);
    private final int parallelSortThreshold = IgniteSystemProperties.getInteger("CHECKPOINT_PARALLEL_SORT_THRESHOLD", 524288);
    private static final boolean ASSERTION_ENABLED = GridCacheDatabaseSharedManager.class.desiredAssertionStatus();
    public static final ThreadLocal<Integer> CHECKPOINT_LOCK_HOLD_COUNT = ThreadLocal.withInitial(() -> 0);
    private final boolean skipSync = IgniteSystemProperties.getBoolean("IGNITE_PDS_CHECKPOINT_TEST_SKIP_SYNC");
    private final boolean skipCheckpointOnNodeStop = IgniteSystemProperties.getBoolean("IGNITE_PDS_SKIP_CHECKPOINT_ON_NODE_STOP", false);
    private final int longJvmPauseThreshold = IgniteSystemProperties.getInteger("IGNITE_JVM_PAUSE_DETECTOR_THRESHOLD", 500);
    private final boolean printCheckpointStats = true;
    private final ByteBuffer tmpWriteBuf;
    private final LongJVMPauseDetector pauseDetector;
    private final long checkpointFreq;
    private final FailureProcessor failureProcessor;
    private final DataStorageConfiguration persistenceCfg;
    @Nullable
    private final IgniteThreadPoolExecutor asyncRunner;
    private final IgniteCacheSnapshotManager snapshotMgr;
    private final Collection<DbCheckpointListener> lsnrs = new CopyOnWriteArrayList<DbCheckpointListener>();
    private final ReentrantReadWriteLock checkpointLock;
    private final IgniteWriteAheadLogManager wal;
    private final CheckpointHistory cpHistory;
    private final DataStorageMetricsImpl persStoreMetrics;
    private final Supplier<Collection<DataRegion>> dataRegions;
    private final FileIOFactory ioFactory;
    private final File cpDir;
    private final int pageSize;
    private final GridCacheProcessor cacheProcessor;
    private final FilePageStoreManager storeMgr;
    private final PageMemoryImpl.ThrottlingPolicy throttlingPolicy;
    private final IgniteThrowableFunction<Integer, PageMemoryEx> pageMemoryGroupResolver;
    private volatile ThreadLocal<ByteBuffer> threadBuf;
    private volatile CheckpointProgressImpl scheduledCp;
    private volatile CheckpointProgressImpl curCpProgress;
    private volatile boolean shutdownNow;
    private long lastCpTs;
    private volatile WALPointer memoryRecoveryRecordPtr;
    private GridFutureAdapter<Void> enableChangeApplied;
    private volatile boolean checkpointsEnabled = true;

    public Checkpointer(@Nullable String gridName, String name, WorkersRegistry workersRegistry, IgniteLogger log, int pageSize, LongJVMPauseDetector detector, FailureProcessor failureProcessor, DataStorageConfiguration dsCfg, @Nullable IgniteThreadPoolExecutor checkpointPoolExecutor, IgniteCacheSnapshotManager snapshotManager, ReentrantReadWriteLock checkpointLock, IgniteWriteAheadLogManager wal, CheckpointHistory cpHistory, DataStorageMetricsImpl dsMetrics, Supplier<Collection<DataRegion>> regionsSupplier, FileIOFactory factory, File dir, GridCacheProcessor cacheProcessor, FilePageStoreManager storeMgr, PageMemoryImpl.ThrottlingPolicy throttlingPolicy, IgniteThrowableFunction<Integer, PageMemoryEx> pageMemoryGroupResolver, ThreadLocal<ByteBuffer> buf) {
        super(gridName, name, log, workersRegistry);
        this.pauseDetector = detector;
        this.checkpointFreq = dsCfg.getCheckpointFrequency();
        this.failureProcessor = failureProcessor;
        this.persistenceCfg = dsCfg;
        this.asyncRunner = checkpointPoolExecutor;
        this.snapshotMgr = snapshotManager;
        this.checkpointLock = checkpointLock;
        this.wal = wal;
        this.cpHistory = cpHistory;
        this.persStoreMetrics = dsMetrics;
        this.dataRegions = regionsSupplier;
        this.ioFactory = factory;
        this.cpDir = dir;
        this.cacheProcessor = cacheProcessor;
        this.storeMgr = storeMgr;
        this.throttlingPolicy = throttlingPolicy;
        this.pageMemoryGroupResolver = pageMemoryGroupResolver;
        this.threadBuf = buf;
        this.pageSize = pageSize;
        this.scheduledCp = new CheckpointProgressImpl(this.checkpointFreq);
        this.tmpWriteBuf = ByteBuffer.allocateDirect(pageSize);
        this.tmpWriteBuf.order(ByteOrder.nativeOrder());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void body() {
        Throwable err = null;
        try {
            while (!this.isCancelled()) {
                this.waitCheckpointEvent();
                if (this.skipCheckpointOnNodeStop && (this.isCancelled() || this.shutdownNow)) {
                    if (this.log.isInfoEnabled()) {
                        this.log.warning("Skipping last checkpoint because node is stopping.");
                    }
                    return;
                }
                GridFutureAdapter<Void> enableChangeApplied = this.enableChangeApplied;
                if (enableChangeApplied != null) {
                    enableChangeApplied.onDone();
                    this.enableChangeApplied = null;
                }
                if (this.checkpointsEnabled) {
                    this.doCheckpoint();
                    continue;
                }
                Checkpointer checkpointer = this;
                synchronized (checkpointer) {
                    this.scheduledCp.nextCpNanos(System.nanoTime() + U.millisToNanos(this.checkpointFreq));
                }
            }
            if (this.checkpointsEnabled && !this.shutdownNow) {
                this.doCheckpoint();
            }
        }
        catch (Throwable t) {
            err = t;
            this.scheduledCp.fail(t);
            throw t;
        }
        finally {
            if (err == null && !this.isCancelled) {
                err = new IllegalStateException("Thread is terminated unexpectedly: " + this.name());
            }
            if (err instanceof OutOfMemoryError) {
                this.failureProcessor.process(new FailureContext(FailureType.CRITICAL_ERROR, err));
            } else if (err != null) {
                this.failureProcessor.process(new FailureContext(FailureType.SYSTEM_WORKER_TERMINATION, err));
            }
            this.scheduledCp.fail(new NodeStoppingException("Node is stopping."));
        }
    }

    public CheckpointProgress wakeupForCheckpoint(long delayFromNow, String reason) {
        return this.wakeupForCheckpoint(delayFromNow, reason, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <R> CheckpointProgress wakeupForCheckpoint(long delayFromNow, String reason, IgniteInClosure<? super IgniteInternalFuture<R>> lsnr) {
        if (lsnr != null) {
            Checkpointer checkpointer = this;
            synchronized (checkpointer) {
                CheckpointProgressImpl sched = this.scheduledCp;
                sched.futureFor(CheckpointState.FINISHED).listen(lsnr);
            }
        }
        CheckpointProgressImpl sched = this.scheduledCp;
        long nextNanos = System.nanoTime() + U.millisToNanos(delayFromNow);
        if (sched.nextCpNanos() <= nextNanos) {
            return sched;
        }
        Checkpointer checkpointer = this;
        synchronized (checkpointer) {
            sched = this.scheduledCp;
            if (sched.nextCpNanos() > nextNanos) {
                sched.reason(reason);
                sched.nextCpNanos(nextNanos);
            }
            this.notifyAll();
        }
        return sched;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IgniteInternalFuture wakeupForSnapshotCreation(SnapshotOperation snapshotOperation) {
        GridFutureAdapter ret;
        Checkpointer checkpointer = this;
        synchronized (checkpointer) {
            this.scheduledCp.nextCpNanos(System.nanoTime());
            this.scheduledCp.reason("snapshot");
            this.scheduledCp.nextSnapshot(true);
            this.scheduledCp.snapshotOperation(snapshotOperation);
            ret = this.scheduledCp.futureFor(CheckpointState.LOCK_RELEASED);
            this.notifyAll();
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doCheckpoint() {
        Checkpoint chp = null;
        try {
            int destroyedPartitionsCnt;
            CheckpointMetricsTracker tracker = new CheckpointMetricsTracker();
            try {
                chp = this.markCheckpointBegin(tracker);
            }
            catch (Exception e) {
                if (this.curCpProgress != null) {
                    this.curCpProgress.fail(e);
                }
                this.failureProcessor.process(new FailureContext(FailureType.CRITICAL_ERROR, e));
                throw new IgniteException(e);
            }
            this.updateHeartbeat();
            this.currentProgress().initCounters(chp.pagesSize);
            boolean success = false;
            try {
                if (chp.hasDelta()) {
                    ConcurrentLinkedHashMap<PageStore, LongAdder> updStores = new ConcurrentLinkedHashMap<PageStore, LongAdder>();
                    CountDownFuture doneWriteFut = new CountDownFuture(this.asyncRunner == null ? 1 : this.persistenceCfg.getCheckpointThreads());
                    tracker.onPagesWriteStart();
                    int totalPagesToWriteCnt = chp.pagesSize;
                    if (this.asyncRunner != null) {
                        for (int i = 0; i < this.persistenceCfg.getCheckpointThreads(); ++i) {
                            WriteCheckpointPages write = new WriteCheckpointPages(tracker, chp.cpPages, updStores, doneWriteFut, totalPagesToWriteCnt, this::updateHeartbeat, this.snapshotMgr, this.log, this.persStoreMetrics, this.threadBuf, this.throttlingPolicy, this.pageMemoryGroupResolver, this.curCpProgress, this.storeMgr, this::isShutdownNow);
                            try {
                                this.asyncRunner.execute(write);
                                continue;
                            }
                            catch (RejectedExecutionException e) {
                                this.handleRejectiedExecutionException(e);
                            }
                        }
                    } else {
                        this.updateHeartbeat();
                        WriteCheckpointPages write = new WriteCheckpointPages(tracker, chp.cpPages, updStores, doneWriteFut, totalPagesToWriteCnt, this::updateHeartbeat, this.snapshotMgr, this.log, this.persStoreMetrics, this.threadBuf, this.throttlingPolicy, this.pageMemoryGroupResolver, this.curCpProgress, this.storeMgr, this::isShutdownNow);
                        write.run();
                    }
                    this.updateHeartbeat();
                    doneWriteFut.get();
                    if (this.shutdownNow) {
                        chp.progress.fail(new NodeStoppingException("Node is stopping."));
                        return;
                    }
                    tracker.onFsyncStart();
                    if (!this.skipSync) {
                        this.syncUpdatedStores(updStores);
                        if (this.shutdownNow) {
                            chp.progress.fail(new NodeStoppingException("Node is stopping."));
                            return;
                        }
                    }
                } else {
                    tracker.onPagesWriteStart();
                    tracker.onFsyncStart();
                }
                this.snapshotMgr.afterCheckpointPageWritten();
                destroyedPartitionsCnt = this.destroyEvictedPartitions();
                success = true;
            }
            finally {
                if (success) {
                    this.markCheckpointEnd(chp);
                }
            }
            tracker.onEnd();
            if ((chp.hasDelta() || destroyedPartitionsCnt > 0) && this.log.isInfoEnabled()) {
                String walSegsCoveredMsg = this.prepareWalSegsCoveredMsg(chp.walSegsCoveredRange);
                this.log.info(String.format("Checkpoint finished [cpId=%s, pages=%d, markPos=%s, walSegmentsCleared=%d, walSegmentsCovered=%s, markDuration=%dms, pagesWrite=%dms, fsync=%dms, total=%dms]", chp.cpEntry != null ? chp.cpEntry.checkpointId() : "", chp.pagesSize, chp.cpEntry != null ? chp.cpEntry.checkpointMark() : "", chp.walFilesDeleted, walSegsCoveredMsg, tracker.markDuration(), tracker.pagesWriteDuration(), tracker.fsyncDuration(), tracker.totalDuration()));
            }
            this.updateMetrics(chp, tracker);
        }
        catch (IgniteCheckedException e) {
            if (chp != null) {
                chp.progress.fail(e);
            }
            this.failureProcessor.process(new FailureContext(FailureType.CRITICAL_ERROR, e));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void syncUpdatedStores(ConcurrentLinkedHashMap<PageStore, LongAdder> updStores) throws IgniteCheckedException {
        if (this.asyncRunner == null) {
            for (Map.Entry<PageStore, LongAdder> updStoreEntry : updStores.entrySet()) {
                if (this.shutdownNow) {
                    return;
                }
                this.blockingSectionBegin();
                try {
                    updStoreEntry.getKey().sync();
                }
                finally {
                    this.blockingSectionEnd();
                }
                this.currentProgress().updateSyncedPages(updStoreEntry.getValue().intValue());
            }
        } else {
            int checkpointThreads = this.persistenceCfg.getCheckpointThreads();
            CountDownFuture doneFut = new CountDownFuture(checkpointThreads);
            LinkedBlockingQueue<Map.Entry<PageStore, LongAdder>> queue = new LinkedBlockingQueue<Map.Entry<PageStore, LongAdder>>(updStores.entrySet());
            for (int i = 0; i < checkpointThreads; ++i) {
                this.asyncRunner.execute(() -> {
                    Map.Entry updStoreEntry = (Map.Entry)queue.poll();
                    boolean err = false;
                    try {
                        while (updStoreEntry != null) {
                            if (this.shutdownNow) {
                                return;
                            }
                            this.blockingSectionBegin();
                            try {
                                ((PageStore)updStoreEntry.getKey()).sync();
                            }
                            finally {
                                this.blockingSectionEnd();
                            }
                            this.currentProgress().updateSyncedPages(((LongAdder)updStoreEntry.getValue()).intValue());
                            updStoreEntry = (Map.Entry)queue.poll();
                        }
                    }
                    catch (Throwable t) {
                        err = true;
                        doneFut.onDone(t);
                    }
                    finally {
                        if (!err) {
                            doneFut.onDone();
                        }
                    }
                });
            }
            doneFut.get();
        }
    }

    private GridConcurrentMultiPairQueue<PageMemoryEx, FullPageId> splitAndSortCpPagesIfNeeded(CheckpointPagesInfoHolder cpPages) throws IgniteCheckedException {
        HashSet cpPagesPerRegion = new HashSet();
        int realPagesArrSize = 0;
        int totalPagesCnt = cpPages.pagesNum();
        for (Map.Entry<PageMemoryEx, GridMultiCollectionWrapper<FullPageId>> regPages : cpPages.cpPages()) {
            FullPageId[] pages = new FullPageId[regPages.getValue().size()];
            int n = 0;
            for (int i = 0; i < regPages.getValue().collectionsSize(); ++i) {
                for (FullPageId page : regPages.getValue().innerCollection(i)) {
                    if (realPagesArrSize++ == totalPagesCnt) {
                        throw new AssertionError((Object)("Incorrect estimated dirty pages number: " + totalPagesCnt));
                    }
                    pages[n++] = page;
                }
            }
            if (n != pages.length) {
                cpPagesPerRegion.add(new T2<PageMemoryEx, FullPageId[]>(regPages.getKey(), Arrays.copyOf(pages, n)));
                continue;
            }
            cpPagesPerRegion.add(new T2<PageMemoryEx, FullPageId[]>(regPages.getKey(), pages));
        }
        if (this.persistenceCfg.getCheckpointWriteOrder() == CheckpointWriteOrder.SEQUENTIAL) {
            Comparator<FullPageId> cmp = Comparator.comparingInt(FullPageId::groupId).thenComparingLong(FullPageId::effectivePageId);
            ForkJoinPool pool = null;
            for (T2 t2 : cpPagesPerRegion) {
                if (((FullPageId[])t2.getValue()).length >= this.parallelSortThreshold) {
                    pool = Checkpointer.parallelSortInIsolatedPool((FullPageId[])t2.get2(), cmp, pool);
                    continue;
                }
                Arrays.sort((Object[])t2.get2(), cmp);
            }
            if (pool != null) {
                pool.shutdown();
            }
        }
        return new GridConcurrentMultiPairQueue<PageMemoryEx, FullPageId>(cpPagesPerRegion);
    }

    private static ForkJoinPool parallelSortInIsolatedPool(FullPageId[] pagesArr, Comparator<FullPageId> cmp, ForkJoinPool pool) throws IgniteCheckedException {
        ForkJoinPool.ForkJoinWorkerThreadFactory factory = new ForkJoinPool.ForkJoinWorkerThreadFactory(){

            @Override
            public ForkJoinWorkerThread newThread(ForkJoinPool pool) {
                ForkJoinWorkerThread worker = ForkJoinPool.defaultForkJoinWorkerThreadFactory.newThread(pool);
                worker.setName("checkpoint-pages-sorter-" + worker.getPoolIndex());
                return worker;
            }
        };
        ForkJoinPool execPool = pool == null ? new ForkJoinPool(PARALLEL_SORT_THREADS + 1, factory, null, false) : pool;
        Future sortTask = execPool.submit(() -> Arrays.parallelSort(pagesArr, cmp));
        try {
            sortTask.get();
        }
        catch (InterruptedException e) {
            throw new IgniteInterruptedCheckedException(e);
        }
        catch (ExecutionException e) {
            throw new IgniteCheckedException("Failed to perform pages array parallel sort", e.getCause());
        }
        return execPool;
    }

    public void writeCheckpointEntry(ByteBuffer entryBuf, CheckpointEntry cp, CheckpointEntryType type) throws StorageException {
        String fileName = Checkpointer.checkpointFileName(cp, type);
        String tmpFileName = fileName + ".tmp";
        try {
            try (FileIO io = this.ioFactory.create(Paths.get(this.cpDir.getAbsolutePath(), this.skipSync ? fileName : tmpFileName).toFile(), StandardOpenOption.CREATE_NEW, StandardOpenOption.WRITE);){
                io.writeFully(entryBuf);
                entryBuf.clear();
                if (!this.skipSync) {
                    io.force(true);
                }
            }
            if (!this.skipSync) {
                Files.move(Paths.get(this.cpDir.getAbsolutePath(), tmpFileName), Paths.get(this.cpDir.getAbsolutePath(), fileName), new CopyOption[0]);
            }
        }
        catch (IOException e) {
            throw new StorageException("Failed to write checkpoint entry [ptr=" + cp.checkpointMark() + ", cpTs=" + cp.timestamp() + ", cpId=" + cp.checkpointId() + ", type=" + (Object)((Object)type) + "]", e);
        }
    }

    private CheckpointEntry prepareCheckpointEntry(ByteBuffer entryBuf, long cpTs, UUID cpId, WALPointer ptr, @Nullable CheckpointRecord rec, CheckpointEntryType type) {
        assert (ptr instanceof FileWALPointer);
        FileWALPointer filePtr = (FileWALPointer)ptr;
        entryBuf.rewind();
        entryBuf.putLong(filePtr.index());
        entryBuf.putInt(filePtr.fileOffset());
        entryBuf.putInt(filePtr.length());
        entryBuf.flip();
        return this.createCheckPointEntry(cpTs, ptr, cpId, rec, type);
    }

    public CheckpointEntry createCheckPointEntry(long cpTs, WALPointer ptr, UUID cpId, @Nullable CheckpointRecord rec, CheckpointEntryType type) {
        assert (cpTs > 0L);
        assert (ptr != null);
        assert (cpId != null);
        assert (type != null);
        Map<Integer, CacheState> cacheGrpStates = null;
        if (rec != null) {
            cacheGrpStates = rec.cacheGroupStates();
        }
        return new CheckpointEntry(cpTs, ptr, cpId, cacheGrpStates);
    }

    private CheckpointPagesInfoHolder beginAllCheckpoints(IgniteInternalFuture<?> allowToReplace) {
        Collection<DataRegion> regions = this.dataRegions.get();
        ArrayList<Map.Entry<PageMemoryEx, GridMultiCollectionWrapper<FullPageId>>> res = new ArrayList<Map.Entry<PageMemoryEx, GridMultiCollectionWrapper<FullPageId>>>(regions.size());
        int pagesNum = 0;
        for (DataRegion reg : regions) {
            if (!reg.config().isPersistenceEnabled()) continue;
            GridMultiCollectionWrapper<FullPageId> nextCpPages = ((PageMemoryEx)reg.pageMemory()).beginCheckpoint(allowToReplace);
            pagesNum += nextCpPages.size();
            res.add(new T2<PageMemoryEx, GridMultiCollectionWrapper<FullPageId>>((PageMemoryEx)reg.pageMemory(), nextCpPages));
        }
        CheckpointProgressImpl progress = this.curCpProgress;
        if (progress != null) {
            progress.currentCheckpointPagesCount(pagesNum);
        }
        return new CheckpointPagesInfoHolder(res, pagesNum);
    }

    private void updateMetrics(Checkpoint chp, CheckpointMetricsTracker tracker) {
        if (this.persStoreMetrics.metricsEnabled()) {
            this.persStoreMetrics.onCheckpoint(tracker.lockWaitDuration(), tracker.markDuration(), tracker.pagesWriteDuration(), tracker.fsyncDuration(), tracker.totalDuration(), chp.pagesSize, tracker.dataPagesWritten(), tracker.cowPagesWritten(), this.forAllPageStores(PageStore::size), this.forAllPageStores(PageStore::getSparseSize));
        }
    }

    public long forAllPageStores(ToLongFunction<PageStore> f) {
        long res = 0L;
        for (CacheGroupContext gctx : this.cacheProcessor.cacheGroups()) {
            res += this.forGroupPageStores(gctx, f);
        }
        return res;
    }

    public long forGroupPageStores(CacheGroupContext gctx, ToLongFunction<PageStore> f) {
        int groupId = gctx.groupId();
        long res = 0L;
        try {
            Collection<PageStore> stores = this.storeMgr.getStores(groupId);
            if (stores != null) {
                for (PageStore store : stores) {
                    res += f.applyAsLong(store);
                }
            }
        }
        catch (IgniteCheckedException e) {
            throw new IgniteException(e);
        }
        return res;
    }

    private String prepareWalSegsCoveredMsg(IgniteBiTuple<Long, Long> walRange) {
        long startIdx = walRange.get1();
        long endIdx = walRange.get2();
        String res = endIdx < 0L || endIdx < startIdx ? "[]" : (endIdx == startIdx ? "[" + endIdx + "]" : "[" + startIdx + " - " + endIdx + "]");
        return res;
    }

    private int destroyEvictedPartitions() throws IgniteCheckedException {
        PartitionDestroyQueue destroyQueue = this.curCpProgress.getDestroyQueue();
        if (destroyQueue.pendingReqs().isEmpty()) {
            return 0;
        }
        ArrayList<PartitionDestroyRequest> reqs = null;
        for (PartitionDestroyRequest req : destroyQueue.pendingReqs().values()) {
            if (!req.beginDestroy()) continue;
            int grpId = req.groupId();
            int partId = req.partitionId();
            CacheGroupContext grp = this.cacheProcessor.cacheGroup(grpId);
            assert (grp != null) : "Cache group is not initialized [grpId=" + grpId + "]";
            assert (grp.offheap() instanceof GridCacheOffheapManager) : "Destroying partition files when persistence is off " + grp.offheap();
            GridCacheOffheapManager offheap = (GridCacheOffheapManager)grp.offheap();
            Runnable destroyPartTask = () -> {
                try {
                    offheap.destroyPartitionStore(grpId, partId);
                    req.onDone(null);
                    grp.metrics().decrementInitializedLocalPartitions();
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("Partition file has destroyed [grpId=" + grpId + ", partId=" + partId + "]");
                    }
                }
                catch (Exception e) {
                    req.onDone(new IgniteCheckedException("Partition file destroy has failed [grpId=" + grpId + ", partId=" + partId + "]", e));
                }
            };
            if (this.asyncRunner != null) {
                try {
                    this.asyncRunner.execute(destroyPartTask);
                }
                catch (RejectedExecutionException e) {
                    this.handleRejectiedExecutionException(e);
                }
            } else {
                destroyPartTask.run();
            }
            if (reqs == null) {
                reqs = new ArrayList<PartitionDestroyRequest>();
            }
            reqs.add(req);
        }
        if (reqs != null) {
            for (PartitionDestroyRequest req : reqs) {
                req.waitCompleted();
            }
        }
        destroyQueue.pendingReqs().clear();
        return reqs != null ? reqs.size() : 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void schedulePartitionDestroy(@Nullable CacheGroupContext grpCtx, int grpId, int partId) {
        Checkpointer checkpointer = this;
        synchronized (checkpointer) {
            this.scheduledCp.getDestroyQueue().addDestroyRequest(grpCtx, grpId, partId);
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("Partition file has been scheduled to destroy [grpId=" + grpId + ", partId=" + partId + "]");
        }
        if (grpCtx != null) {
            this.wakeupForCheckpoint(30000L, "partition destroy");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelOrWaitPartitionDestroy(int grpId, int partId) throws IgniteCheckedException {
        PartitionDestroyRequest req;
        Checkpointer checkpointer = this;
        synchronized (checkpointer) {
            req = this.scheduledCp.getDestroyQueue().cancelDestroy(grpId, partId);
        }
        if (req != null) {
            req.waitCompleted();
        }
        Checkpointer checkpointer2 = this;
        synchronized (checkpointer2) {
            CheckpointProgressImpl cur = this.curCpProgress;
            if (cur != null) {
                req = cur.getDestroyQueue().cancelDestroy(grpId, partId);
            }
        }
        if (req != null) {
            req.waitCompleted();
        }
        if (req != null && this.log.isDebugEnabled()) {
            this.log.debug("Partition file destroy has cancelled [grpId=" + grpId + ", partId=" + partId + "]");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitCheckpointEvent() {
        boolean cancel = false;
        try {
            Checkpointer checkpointer = this;
            synchronized (checkpointer) {
                long remaining = U.nanosToMillis(this.scheduledCp.nextCpNanos() - System.nanoTime());
                while (remaining > 0L && !this.isCancelled()) {
                    this.blockingSectionBegin();
                    try {
                        this.wait(remaining);
                        remaining = U.nanosToMillis(this.scheduledCp.nextCpNanos() - System.nanoTime());
                    }
                    finally {
                        this.blockingSectionEnd();
                    }
                }
            }
        }
        catch (InterruptedException ignored) {
            Thread.currentThread().interrupt();
            cancel = true;
        }
        if (cancel) {
            this.isCancelled = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Checkpoint markCheckpointBegin(CheckpointMetricsTracker tracker) throws IgniteCheckedException {
        boolean hasPartitionsToDestroy;
        int dirtyPagesCount;
        CheckpointPagesInfoHolder cpPagesHolder;
        long cpTs = this.updateLastCheckpointTime();
        CheckpointProgressImpl curr = this.scheduledCp;
        ArrayList<DbCheckpointListener> dbLsnrs = new ArrayList<DbCheckpointListener>(this.lsnrs);
        CheckpointRecord cpRec = new CheckpointRecord(this.memoryRecoveryRecordPtr);
        this.memoryRecoveryRecordPtr = null;
        CheckpointEntry cp = null;
        IgniteFuture<?> snapFut = null;
        DbCheckpointContextImpl ctx0 = new DbCheckpointContextImpl(curr, new PartitionAllocationMap(), this.asyncRunner, this::updateHeartbeat);
        this.internalReadLock();
        try {
            for (DbCheckpointListener lsnr : dbLsnrs) {
                lsnr.beforeCheckpointBegin(ctx0);
            }
            ctx0.awaitPendingTasksFinished();
        }
        finally {
            this.internalReadUnlock();
        }
        tracker.onLockWaitStart();
        this.checkpointLock.writeLock().lock();
        try {
            this.updateCurrentCheckpointProgress();
            assert (this.curCpProgress == curr) : "Concurrent checkpoint begin should not be happened";
            tracker.onMarkStart();
            for (DbCheckpointListener lsnr : dbLsnrs) {
                lsnr.onMarkCheckpointBegin(ctx0);
            }
            ctx0.awaitPendingTasksFinished();
            tracker.onListenersExecuteEnd();
            this.fillCacheGroupState(cpRec);
            if (curr.nextSnapshot()) {
                snapFut = this.snapshotMgr.onMarkCheckPointBegin(curr.snapshotOperation(), cpRec, ctx0.partitionStatMap());
            }
            cpPagesHolder = this.beginAllCheckpoints(curr.futureFor(CheckpointState.MARKER_STORED_TO_DISK));
            dirtyPagesCount = cpPagesHolder.pagesNum();
            hasPartitionsToDestroy = !curr.getDestroyQueue().pendingReqs().isEmpty();
            Object cpPtr = null;
            if ((dirtyPagesCount > 0 || curr.nextSnapshot() || hasPartitionsToDestroy) && (cpPtr = this.wal.log(cpRec)) == null) {
                cpPtr = GridCacheDatabaseSharedManager.CheckpointStatus.NULL_PTR;
            }
            if (dirtyPagesCount > 0 || hasPartitionsToDestroy) {
                cp = this.prepareCheckpointEntry(this.tmpWriteBuf, cpTs, cpRec.checkpointId(), (WALPointer)cpPtr, cpRec, CheckpointEntryType.START);
                this.cpHistory.addCheckpoint(cp, cpRec.cacheGroupStates());
            }
            curr.transitTo(CheckpointState.PAGE_SNAPSHOT_TAKEN);
        }
        finally {
            this.checkpointLock.writeLock().unlock();
            tracker.onLockRelease();
        }
        curr.transitTo(CheckpointState.LOCK_RELEASED);
        for (DbCheckpointListener lsnr : dbLsnrs) {
            lsnr.onCheckpointBegin(ctx0);
        }
        if (snapFut != null) {
            try {
                snapFut.get();
            }
            catch (IgniteException e) {
                U.error(this.log, "Failed to wait for snapshot operation initialization: " + curr.snapshotOperation(), e);
            }
        }
        if (dirtyPagesCount > 0 || hasPartitionsToDestroy) {
            assert (cp != null);
            assert (cp.checkpointMark() != null);
            tracker.onWalCpRecordFsyncStart();
            this.wal.flush(cp.checkpointMark(), true);
            tracker.onWalCpRecordFsyncEnd();
            this.writeCheckpointEntry(this.tmpWriteBuf, cp, CheckpointEntryType.START);
            curr.transitTo(CheckpointState.MARKER_STORED_TO_DISK);
            tracker.onSplitAndSortCpPagesStart();
            GridConcurrentMultiPairQueue<PageMemoryEx, FullPageId> cpPages = this.splitAndSortCpPagesIfNeeded(cpPagesHolder);
            tracker.onSplitAndSortCpPagesEnd();
            if (this.log.isInfoEnabled()) {
                long possibleJvmPauseDur = this.possibleLongJvmPauseDuration(tracker);
                if (this.log.isInfoEnabled()) {
                    this.log.info(String.format(CHECKPOINT_STARTED_LOG_FORMAT, cpRec.checkpointId(), cp.checkpointMark(), tracker.beforeLockDuration(), tracker.lockWaitDuration(), tracker.listenersExecuteDuration(), tracker.lockHoldDuration(), tracker.walCpRecordFsyncDuration(), tracker.writeCheckpointEntryDuration(), tracker.splitAndSortCpPagesDuration(), possibleJvmPauseDur > 0L ? "possibleJvmPauseDuration=" + possibleJvmPauseDur + "ms," : "", dirtyPagesCount, curr.reason()));
                }
            }
            return new Checkpoint(cp, cpPages, curr);
        }
        if (curr.nextSnapshot()) {
            this.wal.flush(null, true);
        }
        if (this.log.isInfoEnabled()) {
            LT.info(this.log, String.format("Skipping checkpoint (no pages were modified) [checkpointBeforeLockTime=%dms, checkpointLockWait=%dms, checkpointListenersExecuteTime=%dms, checkpointLockHoldTime=%dms, reason='%s']", tracker.beforeLockDuration(), tracker.lockWaitDuration(), tracker.listenersExecuteDuration(), tracker.lockHoldDuration(), curr.reason()));
        }
        return new Checkpoint(null, GridConcurrentMultiPairQueue.EMPTY, curr);
    }

    private long possibleLongJvmPauseDuration(CheckpointMetricsTracker tracker) {
        if (LongJVMPauseDetector.enabled() && tracker.lockWaitDuration() + tracker.lockHoldDuration() > (long)this.longJvmPauseThreshold) {
            long now = System.currentTimeMillis();
            long wakeUpTime = this.pauseDetector.getLastWakeUpTime();
            IgniteBiTuple<Long, Long> lastLongPause = this.pauseDetector.getLastLongPause();
            if (lastLongPause != null && tracker.checkpointStartTime() < lastLongPause.get1()) {
                return lastLongPause.get2();
            }
            if (now - wakeUpTime > (long)this.longJvmPauseThreshold) {
                return now - wakeUpTime;
            }
        }
        return -1L;
    }

    private void internalReadUnlock() {
        this.checkpointLock.readLock().unlock();
        if (ASSERTION_ENABLED) {
            CHECKPOINT_LOCK_HOLD_COUNT.set(CHECKPOINT_LOCK_HOLD_COUNT.get() - 1);
        }
    }

    private void internalReadLock() {
        this.checkpointLock.readLock().lock();
        if (ASSERTION_ENABLED) {
            CHECKPOINT_LOCK_HOLD_COUNT.set(CHECKPOINT_LOCK_HOLD_COUNT.get() + 1);
        }
    }

    private void fillCacheGroupState(CheckpointRecord cpRec) throws IgniteCheckedException {
        GridCompoundFuture grpHandleFut = this.asyncRunner == null ? null : new GridCompoundFuture();
        for (CacheGroupContext grp : this.cacheProcessor.cacheGroups()) {
            if (grp.isLocal() || !grp.walEnabled()) continue;
            Runnable r = () -> {
                ArrayList<GridDhtLocalPartition> parts = new ArrayList<GridDhtLocalPartition>(grp.topology().localPartitions().size());
                for (GridDhtLocalPartition part : grp.topology().currentLocalPartitions()) {
                    parts.add(part);
                }
                CacheState state = new CacheState(parts.size());
                for (GridDhtLocalPartition part : parts) {
                    GridDhtPartitionState partState = part.state();
                    if (partState == GridDhtPartitionState.LOST) {
                        partState = GridDhtPartitionState.OWNING;
                    }
                    state.addPartitionState(part.id(), part.dataStore().fullSize(), part.updateCounter(), (byte)partState.ordinal());
                }
                CheckpointRecord checkpointRecord = cpRec;
                synchronized (checkpointRecord) {
                    cpRec.addCacheGroupState(grp.groupId(), state);
                }
            };
            if (this.asyncRunner == null) {
                r.run();
                continue;
            }
            try {
                GridFutureAdapter res = new GridFutureAdapter();
                this.asyncRunner.execute(U.wrapIgniteFuture(r, res));
                grpHandleFut.add(res);
            }
            catch (RejectedExecutionException e) {
                this.handleRejectiedExecutionException(e);
            }
        }
        if (grpHandleFut != null) {
            grpHandleFut.markInitialized();
            grpHandleFut.get();
        }
    }

    private long updateLastCheckpointTime() {
        long cpTs = System.currentTimeMillis();
        if (cpTs == this.lastCpTs) {
            ++cpTs;
        }
        this.lastCpTs = cpTs;
        return cpTs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private CheckpointProgress updateCurrentCheckpointProgress() {
        CheckpointProgressImpl curr;
        Checkpointer checkpointer = this;
        synchronized (checkpointer) {
            curr = this.scheduledCp;
            curr.transitTo(CheckpointState.LOCK_TAKEN);
            if (curr.reason() == null) {
                curr.reason("timeout");
            }
            this.scheduledCp = new CheckpointProgressImpl(this.checkpointFreq);
            this.curCpProgress = curr;
        }
        return curr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void markCheckpointEnd(Checkpoint chp) throws IgniteCheckedException {
        Checkpointer checkpointer = this;
        synchronized (checkpointer) {
            chp.progress.clearCounters();
            for (DataRegion memPlc : this.dataRegions.get()) {
                if (!memPlc.config().isPersistenceEnabled()) continue;
                ((PageMemoryEx)memPlc.pageMemory()).finishCheckpoint();
            }
        }
        if (chp.hasDelta()) {
            CheckpointEntry cp = this.prepareCheckpointEntry(this.tmpWriteBuf, chp.cpEntry.timestamp(), chp.cpEntry.checkpointId(), chp.cpEntry.checkpointMark(), null, CheckpointEntryType.END);
            this.writeCheckpointEntry(this.tmpWriteBuf, cp, CheckpointEntryType.END);
            this.wal.notchLastCheckpointPtr(chp.cpEntry.checkpointMark());
        }
        List<CheckpointEntry> removedFromHistory = this.cpHistory.onCheckpointFinished(chp);
        for (CheckpointEntry cp : removedFromHistory) {
            this.removeCheckpointFiles(cp);
        }
        if (chp.progress != null) {
            chp.progress.transitTo(CheckpointState.FINISHED);
        }
    }

    private void removeCheckpointFiles(CheckpointEntry cpEntry) throws IgniteCheckedException {
        Path startFile = new File(this.cpDir.getAbsolutePath(), Checkpointer.checkpointFileName(cpEntry, CheckpointEntryType.START)).toPath();
        Path endFile = new File(this.cpDir.getAbsolutePath(), Checkpointer.checkpointFileName(cpEntry, CheckpointEntryType.END)).toPath();
        try {
            if (Files.exists(startFile, new LinkOption[0])) {
                Files.delete(startFile);
            }
            if (Files.exists(endFile, new LinkOption[0])) {
                Files.delete(endFile);
            }
        }
        catch (IOException e) {
            throw new StorageException("Failed to delete stale checkpoint files: " + cpEntry, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancel() {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Cancelling grid runnable: " + this);
        }
        this.isCancelled = true;
        Checkpointer checkpointer = this;
        synchronized (checkpointer) {
            this.notifyAll();
        }
    }

    public IgniteInternalFuture<Void> enableCheckpoints(boolean enable) {
        GridFutureAdapter<Void> fut = new GridFutureAdapter<Void>();
        this.enableChangeApplied = fut;
        this.checkpointsEnabled = enable;
        return fut;
    }

    public void shutdownNow() {
        this.shutdownNow = true;
        if (!this.isCancelled) {
            this.cancel();
        }
    }

    private void handleRejectiedExecutionException(RejectedExecutionException e) {
        assert (false) : "Task should never be rejected by async runner";
        throw new IgniteException(e);
    }

    public void memoryRecoveryRecordPtr(WALPointer memoryRecoveryRecordPtr) {
        this.memoryRecoveryRecordPtr = memoryRecoveryRecordPtr;
    }

    public void shutdownCheckpointer(boolean cancel) {
        if (cancel) {
            this.shutdownNow();
        } else {
            this.cancel();
        }
        try {
            U.join(this);
        }
        catch (IgniteInterruptedCheckedException ignore) {
            U.warn(this.log, "Was interrupted while waiting for checkpointer shutdown, will not wait for checkpoint to finish.");
            this.shutdownNow();
            while (true) {
                try {
                    U.join(this);
                    this.scheduledCp.fail(new NodeStoppingException("Checkpointer is stopped during node stop."));
                }
                catch (IgniteInterruptedCheckedException igniteInterruptedCheckedException) {
                    continue;
                }
                break;
            }
            Thread.currentThread().interrupt();
        }
        if (this.asyncRunner != null) {
            this.asyncRunner.shutdownNow();
            try {
                this.asyncRunner.awaitTermination(2L, TimeUnit.MINUTES);
            }
            catch (InterruptedException ignore) {
                Thread.currentThread().interrupt();
            }
        }
        this.lsnrs.clear();
    }

    public void addCheckpointListener(DbCheckpointListener lsnr) {
        this.lsnrs.add(lsnr);
    }

    public void removeCheckpointListener(DbCheckpointListener lsnr) {
        this.lsnrs.remove(lsnr);
    }

    public void finalizeCheckpointOnRecovery(long cpTs, UUID cpId, WALPointer walPtr, StripedExecutor exec) throws IgniteCheckedException {
        assert (cpTs != 0L);
        long start = System.currentTimeMillis();
        Collection<DataRegion> regions = this.dataRegions.get();
        CheckpointPagesInfoHolder cpPagesHolder = this.beginAllCheckpoints(new GridFinishedFuture());
        GridConcurrentMultiPairQueue<PageMemoryEx, FullPageId> pages = this.splitAndSortCpPagesIfNeeded(cpPagesHolder);
        GridConcurrentHashSet updStores = new GridConcurrentHashSet();
        AtomicInteger cpPagesCnt = new AtomicInteger();
        AtomicReference<Throwable> writePagesError = new AtomicReference<Throwable>();
        for (int stripeIdx = 0; stripeIdx < exec.stripes(); ++stripeIdx) {
            exec.execute(stripeIdx, () -> {
                int pagesWritten;
                block3: {
                    PageStoreWriter pageStoreWriter = (fullPageId, buf, tag) -> {
                        assert (tag != -1) : "Lock is held by other thread for page " + fullPageId;
                        int groupId = fullPageId.groupId();
                        long pageId = fullPageId.pageId();
                        PageStore store = this.storeMgr.writeInternal(groupId, pageId, buf, tag, true);
                        updStores.add(store);
                    };
                    ByteBuffer writePageBuf = ByteBuffer.allocateDirect(this.pageSize);
                    writePageBuf.order(ByteOrder.nativeOrder());
                    GridConcurrentMultiPairQueue.Result res = new GridConcurrentMultiPairQueue.Result();
                    pagesWritten = 0;
                    try {
                        while (pages.next(res) && writePagesError.get() == null) {
                            PageMemoryEx pageMem = (PageMemoryEx)res.getKey();
                            pageMem.checkpointWritePage((FullPageId)res.getValue(), writePageBuf, pageStoreWriter, null);
                            ++pagesWritten;
                        }
                    }
                    catch (Throwable e) {
                        U.error(this.log, "Failed to write page to pageStore: " + res);
                        writePagesError.compareAndSet(null, e);
                        if (!(e instanceof Error)) break block3;
                        throw (Error)e;
                    }
                }
                cpPagesCnt.addAndGet(pagesWritten);
            });
        }
        this.awaitApplyComplete(exec, writePagesError);
        long written = U.currentTimeMillis();
        for (PageStore updStore : updStores) {
            updStore.sync();
        }
        long fsync = U.currentTimeMillis();
        for (DataRegion memPlc : regions) {
            if (!memPlc.config().isPersistenceEnabled()) continue;
            ((PageMemoryEx)memPlc.pageMemory()).finishCheckpoint();
        }
        ByteBuffer tmpWriteBuf = ByteBuffer.allocateDirect(this.pageSize);
        tmpWriteBuf.order(ByteOrder.nativeOrder());
        CheckpointEntry cp = this.prepareCheckpointEntry(tmpWriteBuf, cpTs, cpId, walPtr, null, CheckpointEntryType.END);
        this.writeCheckpointEntry(tmpWriteBuf, cp, CheckpointEntryType.END);
        if (this.log.isInfoEnabled()) {
            this.log.info(String.format("Checkpoint finished [cpId=%s, pages=%d, markPos=%s, pagesWrite=%dms, fsync=%dms, total=%dms]", cpId, cpPagesCnt.get(), walPtr, written - start, fsync - written, fsync - start));
        }
    }

    private void awaitApplyComplete(StripedExecutor exec, AtomicReference<Throwable> applyError) throws IgniteCheckedException {
        try {
            exec.awaitComplete(new int[0]);
        }
        catch (InterruptedException e) {
            throw new IgniteInterruptedException(e);
        }
        Throwable error = applyError.get();
        if (error != null) {
            throw error instanceof IgniteCheckedException ? (IgniteCheckedException)error : new IgniteCheckedException(error);
        }
    }

    private static String checkpointFileName(long cpTs, UUID cpId, CheckpointEntryType type) {
        return cpTs + "-" + cpId + "-" + (Object)((Object)type) + ".bin";
    }

    public static String checkpointFileName(CheckpointEntry cp, CheckpointEntryType type) {
        return Checkpointer.checkpointFileName(cp.timestamp(), cp.checkpointId(), type);
    }

    public void threadBuf(ThreadLocal<ByteBuffer> threadBuf) {
        this.threadBuf = threadBuf;
    }

    public CheckpointProgress currentProgress() {
        return this.curCpProgress;
    }

    private boolean isShutdownNow() {
        return this.shutdownNow;
    }
}

