/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.persistence.checkpoint;

import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.processors.cache.persistence.DbCheckpointListener;
import org.apache.ignite.internal.processors.cache.persistence.checkpoint.CheckpointProgress;
import org.apache.ignite.internal.processors.cache.persistence.checkpoint.CheckpointProgressImpl;
import org.apache.ignite.internal.processors.cache.persistence.partstate.PartitionAllocationMap;
import org.apache.ignite.internal.util.future.GridCompoundFuture;
import org.apache.ignite.internal.util.future.GridFutureAdapter;
import org.apache.ignite.internal.util.typedef.internal.CU;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.thread.IgniteThreadPoolExecutor;
import org.jetbrains.annotations.Nullable;

public class DbCheckpointContextImpl
implements DbCheckpointListener.Context {
    private final CheckpointProgressImpl curr;
    private final PartitionAllocationMap map;
    @Nullable
    private final IgniteThreadPoolExecutor asyncRunner;
    private final Runnable heartbeatUpdater;
    private GridCompoundFuture pendingTaskFuture;

    DbCheckpointContextImpl(CheckpointProgressImpl curr, PartitionAllocationMap map, @Nullable IgniteThreadPoolExecutor asyncRunner, Runnable heartbeat) {
        this.curr = curr;
        this.map = map;
        this.asyncRunner = asyncRunner;
        this.heartbeatUpdater = heartbeat;
        this.pendingTaskFuture = this.asyncRunner == null ? null : new GridCompoundFuture();
    }

    @Override
    public CheckpointProgress progress() {
        return this.curr;
    }

    @Override
    public boolean nextSnapshot() {
        return this.curr.nextSnapshot();
    }

    @Override
    public PartitionAllocationMap partitionStatMap() {
        return this.map;
    }

    @Override
    public boolean needToSnapshot(String cacheOrGrpName) {
        return this.curr.snapshotOperation().cacheGroupIds().contains(CU.cacheId(cacheOrGrpName));
    }

    @Override
    public Executor executor() {
        return this.asyncRunner == null ? null : cmd -> {
            block2: {
                try {
                    GridFutureAdapter res = new GridFutureAdapter();
                    res.listen(fut -> this.heartbeatUpdater.run());
                    this.asyncRunner.execute(U.wrapIgniteFuture(cmd, res));
                    this.pendingTaskFuture.add(res);
                }
                catch (RejectedExecutionException e) {
                    if ($assertionsDisabled) break block2;
                    throw new AssertionError((Object)"A task should never be rejected by async runner");
                }
            }
        };
    }

    public void awaitPendingTasksFinished() throws IgniteCheckedException {
        GridCompoundFuture pendingFut = this.pendingTaskFuture;
        this.pendingTaskFuture = new GridCompoundFuture();
        if (pendingFut != null) {
            pendingFut.markInitialized();
            pendingFut.get();
        }
    }
}

