/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.persistence.diagnostic.pagelocktracker;

import org.apache.ignite.IgniteSystemProperties;
import org.apache.ignite.internal.processors.cache.persistence.diagnostic.pagelocktracker.MemoryCalculator;
import org.apache.ignite.internal.processors.cache.persistence.diagnostic.pagelocktracker.PageLockDump;
import org.apache.ignite.internal.processors.cache.persistence.diagnostic.pagelocktracker.PageLockTracker;
import org.apache.ignite.internal.processors.cache.persistence.diagnostic.pagelocktracker.log.LockLog;
import org.apache.ignite.internal.processors.cache.persistence.diagnostic.pagelocktracker.stack.LockStack;
import org.apache.ignite.internal.processors.cache.persistence.diagnostic.pagelocktracker.store.HeapPageMetaInfoStore;
import org.apache.ignite.internal.processors.cache.persistence.diagnostic.pagelocktracker.store.OffHeapPageMetaInfoStore;

public final class PageLockTrackerFactory {
    public static final int HEAP_STACK = 1;
    public static final int HEAP_LOG = 2;
    public static final int OFF_HEAP_STACK = 3;
    public static final int OFF_HEAP_LOG = 4;
    public static volatile int DEFAULT_CAPACITY = IgniteSystemProperties.getInteger("IGNITE_PAGE_LOCK_TRACKER_CAPACITY", 512);
    public static volatile int DEFAULT_TYPE = IgniteSystemProperties.getInteger("IGNITE_PAGE_LOCK_TRACKER_TYPE", 2);

    public static PageLockTracker<? extends PageLockDump> create(String name) {
        return PageLockTrackerFactory.create(DEFAULT_TYPE, name);
    }

    public static PageLockTracker<? extends PageLockDump> create(int type, String name) {
        return PageLockTrackerFactory.create(type, name, DEFAULT_CAPACITY);
    }

    public static PageLockTracker<? extends PageLockDump> create(int type, String name, int size) {
        return PageLockTrackerFactory.create(type, size, name, new MemoryCalculator());
    }

    public static PageLockTracker<? extends PageLockDump> create(int type, int size, String name, MemoryCalculator memCalc) {
        switch (type) {
            case 1: {
                return new LockStack(name, new HeapPageMetaInfoStore(size, memCalc), memCalc);
            }
            case 2: {
                return new LockLog(name, new HeapPageMetaInfoStore(size, memCalc), memCalc);
            }
            case 3: {
                return new LockStack(name, new OffHeapPageMetaInfoStore(size, memCalc), memCalc);
            }
            case 4: {
                return new LockLog(name, new OffHeapPageMetaInfoStore(size, memCalc), memCalc);
            }
        }
        throw new IllegalArgumentException(String.valueOf(type));
    }
}

