/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.persistence.diagnostic.pagelocktracker.dumpprocessors;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.IntFunction;
import org.apache.ignite.internal.pagemem.PageIdUtils;
import org.apache.ignite.internal.processors.cache.persistence.diagnostic.pagelocktracker.PageLockDump;
import org.apache.ignite.internal.processors.cache.persistence.diagnostic.pagelocktracker.PageLockTracker;
import org.apache.ignite.internal.processors.cache.persistence.diagnostic.pagelocktracker.PageMetaInfoStore;
import org.apache.ignite.internal.processors.cache.persistence.diagnostic.pagelocktracker.SharedPageLockTrackerDump;
import org.apache.ignite.internal.processors.cache.persistence.diagnostic.pagelocktracker.ThreadPageLockState;
import org.apache.ignite.internal.processors.cache.persistence.diagnostic.pagelocktracker.dumpprocessors.ToStringDumpHelper;
import org.apache.ignite.internal.processors.cache.persistence.diagnostic.pagelocktracker.log.LogEntry;
import org.apache.ignite.internal.processors.cache.persistence.diagnostic.pagelocktracker.log.PageLockLogSnapshot;
import org.apache.ignite.internal.processors.cache.persistence.diagnostic.pagelocktracker.stack.PageLockStackSnapshot;
import org.apache.ignite.internal.util.IgniteUtils;
import org.apache.ignite.internal.util.typedef.internal.SB;
import org.apache.ignite.internal.util.typedef.internal.U;

class ToStringDumpProcessor {
    private final IntFunction<String> strucutreIdMapFunc;
    private final StringBuilder sb;

    ToStringDumpProcessor(StringBuilder sb, IntFunction<String> strucutreIdMapFunc) {
        this.sb = sb;
        this.strucutreIdMapFunc = strucutreIdMapFunc;
    }

    private String operationToString(int op) {
        switch (op) {
            case 5: {
                return "Try Read lock";
            }
            case 6: {
                return "Try Write lock";
            }
            case 1: {
                return "Read lock";
            }
            case 2: {
                return "Read unlock";
            }
            case 3: {
                return "Write lock";
            }
            case 4: {
                return "Write unlock";
            }
        }
        return "N/A";
    }

    private String buildPageInfo(LogEntry entry) {
        int op = entry.operation;
        long pageId = entry.pageId;
        int structureId = entry.structureId;
        return this.operationToString(op) + " pageId=" + pageId + ", structureId=" + this.strucutreIdMapFunc.apply(structureId) + " [pageIdHex=" + IgniteUtils.hexLong(pageId) + ", partId=" + PageIdUtils.partId(pageId) + ", pageIdx=" + PageIdUtils.pageIndex(pageId) + ", flags=" + IgniteUtils.hexInt(PageIdUtils.flag(pageId)) + "]";
    }

    private String lockedPagesInfo(Map<Long, LockState> holdedLocks) {
        SB sb = new SB();
        sb.a("Locked pages = [");
        boolean first = true;
        for (Map.Entry<Long, LockState> entry : holdedLocks.entrySet()) {
            Long pageId = entry.getKey();
            LockState lockState = entry.getValue();
            if (!first) {
                sb.a(",");
            } else {
                first = false;
            }
            sb.a(pageId).a("[" + IgniteUtils.hexLong(pageId) + "]").a("(r=" + lockState.readlock + "|w=" + lockState.writelock + ")");
        }
        sb.a("]");
        return sb.toString();
    }

    void processDump(PageLockDump pageLockDump, ThreadPageLockState threadState) {
        if (pageLockDump instanceof PageLockStackSnapshot) {
            this.processDump((PageLockStackSnapshot)pageLockDump, threadState);
        } else if (pageLockDump instanceof PageLockLogSnapshot) {
            this.processDump((PageLockLogSnapshot)pageLockDump, threadState);
        }
    }

    void processDump(PageLockDump pageLockDump) {
        this.processDump(pageLockDump, null);
    }

    private void processDump(PageLockLogSnapshot snapshot, ThreadPageLockState threadState) {
        LinkedHashMap<Long, LockState> holdetLocks = new LinkedHashMap<Long, LockState>();
        SB logLocksStr = new SB();
        List<LogEntry> locklog = snapshot.locklog;
        int nextOp = snapshot.nextOp;
        long nextOpPageId = snapshot.nextOpPageId;
        int nextOpStructureId = snapshot.nextOpStructureId;
        for (LogEntry entry : locklog) {
            LockState state;
            int op = entry.operation;
            long pageId = entry.pageId;
            int locksHolded = entry.holdedLocks;
            if (op == 1 || op == 3 || op == 5 || op == 6) {
                state = (LockState)holdetLocks.get(pageId);
                if (state == null) {
                    state = new LockState();
                    holdetLocks.put(pageId, state);
                }
                if (op == 1) {
                    ++state.readlock;
                }
                if (op == 3) {
                    ++state.writelock;
                }
                logLocksStr.a("L=" + locksHolded + " -> " + this.buildPageInfo(entry) + U.nl());
            }
            if (op != 2 && op != 4) continue;
            state = (LockState)holdetLocks.get(pageId);
            if (op == 2) {
                --state.readlock;
            }
            if (op == 4) {
                --state.writelock;
            }
            if (state.readlock == 0 && state.writelock == 0) {
                holdetLocks.remove(pageId);
            }
            logLocksStr.a("L=" + locksHolded + " <- " + this.buildPageInfo(entry) + U.nl());
        }
        if (nextOpPageId != 0L) {
            logLocksStr.a("-> " + this.operationToString(nextOp) + " nextOpPageId=" + nextOpPageId + ", nextOpStructureId=" + this.strucutreIdMapFunc.apply(nextOpStructureId) + " [pageIdHex=" + IgniteUtils.hexLong(nextOpPageId) + ", partId=" + PageIdUtils.partId(nextOpPageId) + ", pageIdx=" + PageIdUtils.pageIndex(nextOpPageId) + ", flags=" + IgniteUtils.hexInt(PageIdUtils.flag(nextOpPageId)) + "]" + U.nl());
        }
        if (threadState != null) {
            if (holdetLocks.isEmpty() && logLocksStr.length() == 0) {
                return;
            }
            ToStringDumpProcessor.appendThreadInfo(this.sb, threadState);
        }
        this.sb.append(this.lockedPagesInfo(holdetLocks)).append(U.nl());
        this.sb.append("Locked pages log: ").append(snapshot.name).append(" time=(").append(snapshot.time).append(", ").append(ToStringDumpHelper.DATE_FMT.format(new Date(snapshot.time))).append(")").append(U.nl());
        this.sb.append(logLocksStr).append(U.nl());
    }

    private void processDump(PageLockStackSnapshot snapshot, ThreadPageLockState threadState) {
        long pageId;
        int headIdx = snapshot.headIdx;
        PageMetaInfoStore pageIdLocksStack = snapshot.pageIdLocksStack;
        long nextOpPageId = snapshot.nextOpPageId;
        LinkedHashMap<Long, LockState> holdedLocks = new LinkedHashMap<Long, LockState>();
        SB stackStr = new SB();
        if (nextOpPageId != 0L) {
            stackStr.a("\t-> " + this.operationToString(snapshot.nextOp) + " structureId=" + this.strucutreIdMapFunc.apply(snapshot.nextOpStructureId) + " " + PageLockTracker.pageIdToString(nextOpPageId) + U.nl());
        }
        for (int itemIdx = headIdx - 1; itemIdx >= 0 && ((pageId = pageIdLocksStack.getPageId(itemIdx)) != 0L || itemIdx != 0); --itemIdx) {
            if (pageId == 0L) {
                stackStr.a("\t -\n");
                continue;
            }
            int op = pageIdLocksStack.getOperation(itemIdx) & 0xFF;
            int structureId = pageIdLocksStack.getStructureId(itemIdx);
            stackStr.a("\t" + this.operationToString(op) + " structureId=" + this.strucutreIdMapFunc.apply(structureId) + " " + PageLockTracker.pageIdToString(pageId) + U.nl());
            if (op != 1 && op != 3 && op != 5) continue;
            LockState state = (LockState)holdedLocks.get(pageId);
            if (state == null) {
                state = new LockState();
                holdedLocks.put(pageId, state);
            }
            if (op == 1) {
                ++state.readlock;
            }
            if (op != 3) continue;
            ++state.writelock;
        }
        if (threadState != null) {
            if (holdedLocks.isEmpty()) {
                return;
            }
            ToStringDumpProcessor.appendThreadInfo(this.sb, threadState);
        }
        this.sb.append(this.lockedPagesInfo(holdedLocks)).append(U.nl());
        this.sb.append("Locked pages stack: ").append(snapshot.name).append(" time=(").append(snapshot.time).append(", ").append(ToStringDumpHelper.DATE_FMT.format(new Date(snapshot.time))).append(")").append(U.nl());
        this.sb.append(stackStr).append(U.nl());
    }

    void processDump(SharedPageLockTrackerDump snapshot) {
        this.sb.append("Page locks dump:").append(U.nl()).append(U.nl());
        ArrayList<ThreadPageLockState> threadPageLockStates = new ArrayList<ThreadPageLockState>(snapshot.threadPageLockStates);
        threadPageLockStates.sort(Comparator.comparing(state -> state.threadName));
        for (ThreadPageLockState ths : threadPageLockStates) {
            PageLockDump pageLockDump0;
            if (ths.invalidContext == null) {
                pageLockDump0 = ths.pageLockDump;
            } else {
                this.sb.append(ths.invalidContext.msg).append(U.nl());
                pageLockDump0 = ths.invalidContext.dump;
            }
            this.processDump(pageLockDump0, ths);
            this.sb.append(U.nl());
        }
    }

    private static void appendThreadInfo(StringBuilder sb, ThreadPageLockState ths) {
        sb.append("Thread=[name=").append(ths.threadName).append(", id=").append(ths.threadId).append("], state=").append((Object)ths.state).append(U.nl());
    }

    private static class LockState {
        int readlock;
        int writelock;

        private LockState() {
        }
    }
}

