/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.persistence.tree.io;

import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.internal.IgniteVersionUtils;
import org.apache.ignite.internal.pagemem.PageUtils;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.IOVersions;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.PageIO;
import org.apache.ignite.internal.util.GridStringBuilder;
import org.apache.ignite.lang.IgniteProductVersion;

public class BPlusMetaIO
extends PageIO {
    public static final IOVersions<BPlusMetaIO> VERSIONS = new IOVersions((PageIO[])new BPlusMetaIO[]{new BPlusMetaIO(1), new BPlusMetaIO(2), new BPlusMetaIO(3), new BPlusMetaIO(4)});
    private static final int LVLS_OFFSET = 40;
    private static final int INLINE_SIZE_OFFSET = 41;
    private static final int FLAGS_OFFSET = 43;
    private static final int CREATED_VER_OFFSET = 51;
    private static final int REFS_OFFSET = 82;
    private static final long FLAG_UNWRAPPED_PK = 1L;
    private static final long FLAG_INLINE_OBJECT_SUPPORTED = 2L;
    private static final long FLAG_INLINE_OBJECT_HASH = 4L;
    private static final long FLAG_DECIMAL_SUPPORTED = 8L;
    public static final long DEFAULT_FLAGS = 15L;
    private final int refsOff;

    private BPlusMetaIO(int ver) {
        super(2, ver);
        switch (ver) {
            case 1: {
                this.refsOff = 41;
                break;
            }
            case 2: {
                this.refsOff = 43;
                break;
            }
            case 3: {
                this.refsOff = 43;
                break;
            }
            case 4: {
                this.refsOff = 82;
                break;
            }
            default: {
                throw new IgniteException("invalid IO version: " + ver);
            }
        }
    }

    public void initRoot(long pageAdrr, long rootId, int pageSize) {
        this.setLevelsCount(pageAdrr, 1, pageSize);
        this.setFirstPageId(pageAdrr, 0, rootId);
    }

    public int getLevelsCount(long pageAddr) {
        return Byte.toUnsignedInt(PageUtils.getByte(pageAddr, 40));
    }

    private int getMaxLevels(long pageAddr, int pageSize) {
        return (pageSize - this.refsOff) / 8;
    }

    private void setLevelsCount(long pageAddr, int lvls, int pageSize) {
        assert (lvls >= 0 && lvls <= this.getMaxLevels(pageAddr, pageSize)) : lvls;
        PageUtils.putByte(pageAddr, 40, (byte)lvls);
        assert (this.getLevelsCount(pageAddr) == lvls);
    }

    private int offset(int lvl) {
        return lvl * 8 + this.refsOff;
    }

    public long getFirstPageId(long pageAddr, int lvl) {
        return PageUtils.getLong(pageAddr, this.offset(lvl));
    }

    private void setFirstPageId(long pageAddr, int lvl, long pageId) {
        assert (lvl >= 0 && lvl < this.getLevelsCount(pageAddr)) : lvl;
        PageUtils.putLong(pageAddr, this.offset(lvl), pageId);
        assert (this.getFirstPageId(pageAddr, lvl) == pageId);
    }

    public int getRootLevel(long pageAddr) {
        int lvls = this.getLevelsCount(pageAddr);
        assert (lvls > 0) : lvls;
        return lvls - 1;
    }

    public void addRoot(long pageAddr, long rootPageId, int pageSize) {
        int lvl = this.getLevelsCount(pageAddr);
        this.setLevelsCount(pageAddr, lvl + 1, pageSize);
        this.setFirstPageId(pageAddr, lvl, rootPageId);
    }

    public void cutRoot(long pageAddr, int pageSize) {
        int lvl = this.getRootLevel(pageAddr);
        this.setLevelsCount(pageAddr, lvl, pageSize);
    }

    public void setInlineSize(long pageAddr, int size) {
        if (this.getVersion() > 1) {
            PageUtils.putShort(pageAddr, 41, (short)size);
        }
    }

    public int getInlineSize(long pageAddr) {
        return this.getVersion() > 1 ? (int)PageUtils.getShort(pageAddr, 41) : 0;
    }

    public boolean unwrappedPk(long pageAddr) {
        return this.supportFlags() && (this.flags(pageAddr) & 1L) != 0L || this.getVersion() == 3;
    }

    public boolean inlineObjectSupported(long pageAddr) {
        assert (this.supportFlags());
        return (this.flags(pageAddr) & 2L) != 0L;
    }

    public boolean inlineObjectHash(long pageAddr) {
        assert (this.supportFlags());
        return (this.flags(pageAddr) & 4L) != 0L;
    }

    public boolean inlineDecimalSupported(long pageAddr) {
        assert (this.supportFlags());
        return (this.flags(pageAddr) & 8L) != 0L;
    }

    public boolean supportFlags() {
        return this.getVersion() > 3;
    }

    public void initFlagsAndVersion(long pageAddr, long flags, IgniteProductVersion createdVer) {
        PageUtils.putLong(pageAddr, 43, flags);
        this.setCreatedVersion(pageAddr, createdVer);
    }

    public void setCreatedVersion(long pageAddr, IgniteProductVersion curVer) {
        assert (curVer != null);
        PageUtils.putByte(pageAddr, 51, curVer.major());
        PageUtils.putByte(pageAddr, 52, curVer.minor());
        PageUtils.putByte(pageAddr, 53, curVer.maintenance());
        PageUtils.putLong(pageAddr, 54, curVer.revisionTimestamp());
        PageUtils.putBytes(pageAddr, 62, curVer.revisionHash());
    }

    public IgniteProductVersion createdVersion(long pageAddr) {
        if (this.getVersion() < 4) {
            return null;
        }
        return new IgniteProductVersion(PageUtils.getByte(pageAddr, 51), PageUtils.getByte(pageAddr, 52), PageUtils.getByte(pageAddr, 53), PageUtils.getLong(pageAddr, 54), PageUtils.getBytes(pageAddr, 62, 20));
    }

    private long flags(long pageAddr) {
        assert (this.supportFlags());
        return PageUtils.getLong(pageAddr, 43);
    }

    public void setFlags(long pageAddr, boolean unwrappedPk, boolean inlineObjSupported) {
        assert (this.supportFlags());
        long flags = unwrappedPk ? 1L : 0L;
        PageUtils.putLong(pageAddr, 43, flags |= inlineObjSupported ? 2L : 0L);
    }

    @Override
    protected void printPage(long addr, int pageSize, GridStringBuilder sb) throws IgniteCheckedException {
        sb.a("BPlusMeta [\n\tlevelsCnt=").a(this.getLevelsCount(addr)).a(",\n\trootLvl=").a(this.getRootLevel(addr)).a(",\n\tinlineSize=").a(this.getInlineSize(addr)).a("\n]");
    }

    public static void upgradePageVersion(long pageAddr, boolean inlineObjSupported, boolean unwrappedPk, int pageSize) {
        BPlusMetaIO ioPrev = VERSIONS.forPage(pageAddr);
        long[] lvls = new long[ioPrev.getLevelsCount(pageAddr)];
        for (int i = 0; i < lvls.length; ++i) {
            lvls[i] = ioPrev.getFirstPageId(pageAddr, i);
        }
        int inlineSize = ioPrev.getInlineSize(pageAddr);
        BPlusMetaIO ioNew = VERSIONS.latest();
        BPlusMetaIO.setVersion(pageAddr, VERSIONS.latest().getVersion());
        ioNew.setLevelsCount(pageAddr, lvls.length, pageSize);
        for (int i = 0; i < lvls.length; ++i) {
            ioNew.setFirstPageId(pageAddr, i, lvls[i]);
        }
        ioNew.setInlineSize(pageAddr, inlineSize);
        ioNew.setCreatedVersion(pageAddr, IgniteVersionUtils.VER);
        ioNew.setFlags(pageAddr, unwrappedPk, inlineObjSupported);
    }
}

