/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.persistence.wal;

import java.io.EOFException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.ByteOrder;
import java.util.Optional;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.internal.pagemem.wal.WALIterator;
import org.apache.ignite.internal.pagemem.wal.WALPointer;
import org.apache.ignite.internal.pagemem.wal.record.WALRecord;
import org.apache.ignite.internal.processors.cache.GridCacheSharedContext;
import org.apache.ignite.internal.processors.cache.persistence.file.FileIOFactory;
import org.apache.ignite.internal.processors.cache.persistence.wal.ByteBufferExpander;
import org.apache.ignite.internal.processors.cache.persistence.wal.FileWALPointer;
import org.apache.ignite.internal.processors.cache.persistence.wal.SegmentEofException;
import org.apache.ignite.internal.processors.cache.persistence.wal.WalSegmentTailReachedException;
import org.apache.ignite.internal.processors.cache.persistence.wal.io.FileInput;
import org.apache.ignite.internal.processors.cache.persistence.wal.io.SegmentFileInputFactory;
import org.apache.ignite.internal.processors.cache.persistence.wal.io.SegmentIO;
import org.apache.ignite.internal.processors.cache.persistence.wal.serializer.RecordSerializer;
import org.apache.ignite.internal.processors.cache.persistence.wal.serializer.RecordSerializerFactory;
import org.apache.ignite.internal.processors.cache.persistence.wal.serializer.RecordV1Serializer;
import org.apache.ignite.internal.processors.cache.persistence.wal.serializer.SegmentHeader;
import org.apache.ignite.internal.util.GridCloseableIteratorAdapter;
import org.apache.ignite.internal.util.typedef.P2;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteBiTuple;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractWalRecordsIterator
extends GridCloseableIteratorAdapter<IgniteBiTuple<WALPointer, WALRecord>>
implements WALIterator {
    private static final long serialVersionUID = 0L;
    protected IgniteBiTuple<WALPointer, WALRecord> curRec;
    private IgniteCheckedException curException;
    protected long curWalSegmIdx = -1L;
    private AbstractReadFileHandle currWalSegment;
    @NotNull
    protected final IgniteLogger log;
    @NotNull
    protected final GridCacheSharedContext sharedCtx;
    @NotNull
    private final RecordSerializerFactory serializerFactory;
    @NotNull
    protected final FileIOFactory ioFactory;
    private final ByteBufferExpander buf;
    private final SegmentFileInputFactory segmentFileInputFactory;
    private WALPointer lastRead;

    protected AbstractWalRecordsIterator(@NotNull IgniteLogger log, @NotNull GridCacheSharedContext sharedCtx, @NotNull RecordSerializerFactory serializerFactory, @NotNull FileIOFactory ioFactory, int initialReadBufferSize, SegmentFileInputFactory segmentFileInputFactory) {
        this.log = log;
        this.sharedCtx = sharedCtx;
        this.serializerFactory = serializerFactory;
        this.ioFactory = ioFactory;
        this.segmentFileInputFactory = segmentFileInputFactory;
        this.buf = new ByteBufferExpander(initialReadBufferSize, ByteOrder.nativeOrder());
    }

    @Override
    protected IgniteBiTuple<WALPointer, WALRecord> onNext() throws IgniteCheckedException {
        if (this.curException != null) {
            throw this.curException;
        }
        IgniteBiTuple<WALPointer, WALRecord> ret = this.curRec;
        try {
            this.advance();
        }
        catch (IgniteCheckedException e) {
            this.curException = e;
        }
        return ret;
    }

    @Override
    protected boolean onHasNext() throws IgniteCheckedException {
        return this.curRec != null;
    }

    @Override
    protected void onClose() throws IgniteCheckedException {
        try {
            this.buf.close();
        }
        catch (Exception ex) {
            throw new IgniteCheckedException(ex);
        }
    }

    protected void advance() throws IgniteCheckedException {
        try {
            while (true) {
                this.curRec = this.advanceRecord(this.currWalSegment);
                if (this.curRec != null) {
                    this.lastRead = this.curRec.get1();
                    if (this.curRec.get2().type() == null) continue;
                    return;
                }
                this.currWalSegment = this.advanceSegment(this.currWalSegment);
                if (this.currWalSegment == null) break;
            }
            return;
        }
        catch (WalSegmentTailReachedException e) {
            AbstractReadFileHandle currWalSegment = this.currWalSegment;
            IgniteCheckedException e0 = this.validateTailReachedException(e, currWalSegment);
            if (e0 != null) {
                throw e0;
            }
            this.log.warning(e.getMessage());
            this.curRec = null;
            return;
        }
    }

    @Override
    public Optional<WALPointer> lastRead() {
        return Optional.ofNullable(this.lastRead);
    }

    protected IgniteCheckedException validateTailReachedException(WalSegmentTailReachedException tailReachedException, AbstractReadFileHandle currWalSegment) {
        return !currWalSegment.workDir() ? new IgniteCheckedException("WAL tail reached in archive directory, WAL segment file is corrupted.", tailReachedException) : null;
    }

    @Nullable
    protected AbstractReadFileHandle closeCurrentWalSegment() throws IgniteCheckedException {
        AbstractReadFileHandle walSegmentClosed = this.currWalSegment;
        if (walSegmentClosed != null) {
            walSegmentClosed.close();
            this.currWalSegment = null;
        }
        return walSegmentClosed;
    }

    protected abstract AbstractReadFileHandle advanceSegment(@Nullable AbstractReadFileHandle var1) throws IgniteCheckedException;

    protected IgniteBiTuple<WALPointer, WALRecord> advanceRecord(@Nullable AbstractReadFileHandle hnd) throws IgniteCheckedException {
        if (hnd == null) {
            return null;
        }
        FileWALPointer actualFilePtr = new FileWALPointer(hnd.idx(), (int)hnd.in().position(), 0);
        try {
            WALRecord rec = hnd.ser().readRecord(hnd.in(), actualFilePtr);
            actualFilePtr.length(rec.size());
            return new IgniteBiTuple<WALPointer, WALRecord>(actualFilePtr, this.postProcessRecord(rec));
        }
        catch (IOException | IgniteCheckedException e) {
            IgniteCheckedException e0;
            if (e instanceof WalSegmentTailReachedException) {
                throw new WalSegmentTailReachedException("WAL segment tail reached. [idx=" + hnd.idx() + ", isWorkDir=" + hnd.workDir() + ", serVer=" + hnd.ser() + ", actualFilePtr=" + actualFilePtr + ']', e);
            }
            if (!(e instanceof SegmentEofException) && !(e instanceof EOFException) && (e0 = this.handleRecordException(e, actualFilePtr)) != null) {
                throw e0;
            }
            return null;
        }
    }

    @NotNull
    protected WALRecord postProcessRecord(@NotNull WALRecord rec) {
        return rec;
    }

    protected IgniteCheckedException handleRecordException(@NotNull Exception e, @Nullable FileWALPointer ptr) {
        if (this.log.isInfoEnabled()) {
            this.log.info("Stopping WAL iteration due to an exception: " + e.getMessage() + ", ptr=" + ptr);
        }
        return new IgniteCheckedException(e);
    }

    protected AbstractReadFileHandle initReadHandle(@NotNull AbstractFileDescriptor desc, @Nullable FileWALPointer start, @NotNull SegmentIO fileIO, @NotNull SegmentHeader segmentHdr) throws IgniteCheckedException {
        try {
            boolean isCompacted = segmentHdr.isCompacted();
            if (isCompacted) {
                this.serializerFactory.skipPositionCheck(true);
            }
            FileInput in = this.segmentFileInputFactory.createFileInput(fileIO, this.buf);
            if (start != null && desc.idx() == start.index()) {
                if (isCompacted) {
                    if (start.fileOffset() != 0) {
                        this.serializerFactory.recordDeserializeFilter(new StartSeekingFilter(start));
                    }
                } else {
                    long startOff = Math.max((long)start.fileOffset(), fileIO.position());
                    in.seek(startOff);
                }
            }
            int serVer = segmentHdr.getSerializerVersion();
            AbstractReadFileHandle abstractReadFileHandle = this.createReadFileHandle(fileIO, this.serializerFactory.createSerializer(serVer), in);
            return abstractReadFileHandle;
        }
        catch (EOFException | SegmentEofException ignore) {
            try {
                fileIO.close();
            }
            catch (IOException ce) {
                throw new IgniteCheckedException(ce);
            }
            AbstractReadFileHandle abstractReadFileHandle = null;
            return abstractReadFileHandle;
        }
        catch (IgniteCheckedException e) {
            U.closeWithSuppressingException(fileIO, e);
            throw e;
        }
        catch (IOException e) {
            U.closeWithSuppressingException(fileIO, e);
            throw new IgniteCheckedException("Failed to initialize WAL segment after reading segment header: " + desc.file().getAbsolutePath(), e);
        }
        finally {
            this.serializerFactory.clearSegmentLocalState();
        }
    }

    protected AbstractReadFileHandle initReadHandle(@NotNull AbstractFileDescriptor desc, @Nullable FileWALPointer start) throws IgniteCheckedException, FileNotFoundException {
        SegmentIO fileIO = null;
        try {
            SegmentHeader segmentHeader;
            fileIO = desc.toReadOnlyIO(this.ioFactory);
            try {
                segmentHeader = RecordV1Serializer.readSegmentHeader(fileIO, this.segmentFileInputFactory);
            }
            catch (EOFException | SegmentEofException ignore) {
                try {
                    fileIO.close();
                }
                catch (IOException ce) {
                    throw new IgniteCheckedException(ce);
                }
                return null;
            }
            catch (IOException | IgniteCheckedException e) {
                U.closeWithSuppressingException(fileIO, e);
                throw e;
            }
            return this.initReadHandle(desc, start, fileIO, segmentHeader);
        }
        catch (FileNotFoundException e) {
            U.closeQuiet(fileIO);
            throw e;
        }
        catch (IOException e) {
            U.closeQuiet(fileIO);
            throw new IgniteCheckedException("Failed to initialize WAL segment: " + desc.file().getAbsolutePath(), e);
        }
    }

    protected abstract AbstractReadFileHandle createReadFileHandle(SegmentIO var1, RecordSerializer var2, FileInput var3);

    protected static interface AbstractFileDescriptor {
        public boolean isCompressed();

        public File file();

        public long idx();

        public SegmentIO toReadOnlyIO(FileIOFactory var1) throws IOException;
    }

    protected static interface AbstractReadFileHandle {
        public void close() throws IgniteCheckedException;

        public long idx();

        public FileInput in();

        public RecordSerializer ser();

        public boolean workDir();
    }

    private static class StartSeekingFilter
    implements P2<WALRecord.RecordType, WALPointer> {
        private static final long serialVersionUID = 0L;
        private final FileWALPointer start;
        private boolean startReached;

        StartSeekingFilter(FileWALPointer start) {
            this.start = start;
        }

        @Override
        public boolean apply(WALRecord.RecordType type, WALPointer pointer) {
            FileWALPointer filePointer = (FileWALPointer)pointer;
            if (filePointer.index() == this.start.index()) {
                if (this.start.fileOffset() == filePointer.fileOffset()) {
                    this.startReached = true;
                }
                return this.startReached;
            }
            return filePointer.index() > this.start.index();
        }
    }
}

