/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.persistence.wal.aware;

import org.apache.ignite.IgniteLogger;
import org.apache.ignite.internal.IgniteInterruptedCheckedException;
import org.apache.ignite.internal.processors.cache.persistence.wal.aware.SegmentArchivedStorage;
import org.apache.ignite.internal.processors.cache.persistence.wal.aware.SegmentCompressStorage;
import org.apache.ignite.internal.processors.cache.persistence.wal.aware.SegmentCurrentStateStorage;
import org.apache.ignite.internal.processors.cache.persistence.wal.aware.SegmentLockStorage;
import org.apache.ignite.internal.processors.cache.persistence.wal.aware.SegmentReservationStorage;

public class SegmentAware {
    private final SegmentReservationStorage reservationStorage = new SegmentReservationStorage();
    private final SegmentLockStorage segmentLockStorage = new SegmentLockStorage();
    private final SegmentArchivedStorage segmentArchivedStorage = SegmentArchivedStorage.buildArchivedStorage(this.segmentLockStorage);
    private final SegmentCompressStorage segmentCompressStorage;
    private final SegmentCurrentStateStorage segmentCurrStateStorage;

    public SegmentAware(int walSegmentsCnt, boolean compactionEnabled, IgniteLogger log) {
        this.segmentCurrStateStorage = SegmentCurrentStateStorage.buildCurrentStateStorage(walSegmentsCnt, this.segmentArchivedStorage);
        this.segmentCompressStorage = SegmentCompressStorage.buildCompressStorage(this.segmentArchivedStorage, compactionEnabled, log);
    }

    public void awaitSegment(long absSegIdx) throws IgniteInterruptedCheckedException {
        this.segmentCurrStateStorage.awaitSegment(absSegIdx);
    }

    public long nextAbsoluteSegmentIndex() throws IgniteInterruptedCheckedException {
        return this.segmentCurrStateStorage.nextAbsoluteSegmentIndex();
    }

    public long curAbsWalIdx() {
        return this.segmentCurrStateStorage.curAbsWalIdx();
    }

    public long waitNextSegmentForArchivation() throws IgniteInterruptedCheckedException {
        return this.segmentCurrStateStorage.waitNextSegmentForArchivation();
    }

    public void markAsMovedToArchive(long toArchive) throws IgniteInterruptedCheckedException {
        this.segmentArchivedStorage.markAsMovedToArchive(toArchive);
    }

    public void awaitSegmentArchived(long awaitIdx) throws IgniteInterruptedCheckedException {
        this.segmentArchivedStorage.awaitSegmentArchived(awaitIdx);
    }

    public long waitNextSegmentToCompress() throws IgniteInterruptedCheckedException {
        long idx;
        while ((idx = this.segmentCompressStorage.nextSegmentToCompressOrWait()) <= this.lastTruncatedArchiveIdx()) {
            this.onSegmentCompressed(idx);
        }
        return idx;
    }

    public void onSegmentCompressed(long compressedIdx) {
        this.segmentCompressStorage.onSegmentCompressed(compressedIdx);
    }

    public long lastCompressedIdx() {
        return this.segmentCompressStorage.lastCompressedIdx();
    }

    public void keepUncompressedIdxFrom(long idx) {
        this.segmentCompressStorage.keepUncompressedIdxFrom(idx);
    }

    public long keepUncompressedIdxFrom() {
        return this.segmentCompressStorage.keepUncompressedIdxFrom();
    }

    public void curAbsWalIdx(long curAbsWalIdx) {
        this.segmentCurrStateStorage.curAbsWalIdx(curAbsWalIdx);
    }

    public void lastTruncatedArchiveIdx(long lastTruncatedArchiveIdx) {
        this.segmentArchivedStorage.lastTruncatedArchiveIdx(lastTruncatedArchiveIdx);
    }

    public long lastTruncatedArchiveIdx() {
        return this.segmentArchivedStorage.lastTruncatedArchiveIdx();
    }

    public void setLastArchivedAbsoluteIndex(long lastAbsArchivedIdx) {
        this.segmentArchivedStorage.setLastArchivedAbsoluteIndex(lastAbsArchivedIdx);
    }

    public long lastArchivedAbsoluteIndex() {
        return this.segmentArchivedStorage.lastArchivedAbsoluteIndex();
    }

    public void reserve(long absIdx) {
        this.reservationStorage.reserve(absIdx);
    }

    public boolean reserved(long absIdx) {
        return this.reservationStorage.reserved(absIdx);
    }

    public void release(long absIdx) {
        this.reservationStorage.release(absIdx);
    }

    public boolean locked(long absIdx) {
        return this.segmentLockStorage.locked(absIdx);
    }

    public boolean checkCanReadArchiveOrReserveWorkSegment(long absIdx) {
        return this.lastArchivedAbsoluteIndex() >= absIdx || this.segmentLockStorage.lockWorkSegment(absIdx);
    }

    void lockWorkSegment(long absIdx) {
        this.segmentLockStorage.lockWorkSegment(absIdx);
    }

    public void releaseWorkSegment(long absIdx) {
        this.segmentLockStorage.releaseWorkSegment(absIdx);
    }

    public void reset() {
        this.segmentArchivedStorage.reset();
        this.segmentCompressStorage.reset();
        this.segmentCurrStateStorage.reset();
    }

    public void interrupt() {
        this.segmentArchivedStorage.interrupt();
        this.segmentCompressStorage.interrupt();
        this.segmentCurrStateStorage.interrupt();
    }

    public void forceInterrupt() {
        this.segmentArchivedStorage.interrupt();
        this.segmentCompressStorage.interrupt();
        this.segmentCurrStateStorage.forceInterrupt();
    }
}

