/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.verify;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.pagemem.PageIdUtils;
import org.apache.ignite.internal.processors.cache.CacheGroupContext;
import org.apache.ignite.internal.processors.cache.DynamicCacheDescriptor;
import org.apache.ignite.internal.processors.cache.distributed.dht.topology.GridDhtLocalPartition;
import org.apache.ignite.internal.processors.cache.distributed.dht.topology.GridDhtPartitionState;
import org.apache.ignite.internal.processors.cache.distributed.dht.topology.GridDhtPartitionTopology;
import org.apache.ignite.internal.processors.cache.persistence.file.FilePageStore;
import org.apache.ignite.internal.processors.cache.persistence.file.FilePageStoreManager;
import org.apache.ignite.internal.processors.cache.verify.GridNotIdleException;
import org.apache.ignite.internal.util.typedef.internal.SB;
import org.apache.ignite.lang.IgniteInClosure;
import org.jetbrains.annotations.Nullable;

public class IdleVerifyUtility {
    public static final String GRID_NOT_IDLE_MSG = "Cluster not idle. Modifications found in caches or groups: ";

    public static void checkPartitionsPageCrcSum(@Nullable FilePageStoreManager pageStoreMgr, CacheGroupContext grpCtx, int partId, byte pageType) throws IgniteCheckedException, GridNotIdleException {
        if (!grpCtx.persistenceEnabled() || pageStoreMgr == null) {
            return;
        }
        FilePageStore pageStore = (FilePageStore)pageStoreMgr.getStore(grpCtx.groupId(), partId);
        IdleVerifyUtility.checkPartitionsPageCrcSum(pageStore, grpCtx, partId, pageType);
    }

    public static void checkPartitionsPageCrcSum(FilePageStore pageStore, CacheGroupContext grpCtx, int partId, byte pageType) throws IgniteCheckedException, GridNotIdleException {
        assert (pageType == 1 || pageType == 2) : pageType;
        long pageId = PageIdUtils.pageId(partId, pageType, 0);
        ByteBuffer buf = ByteBuffer.allocateDirect(grpCtx.dataRegion().pageMemory().pageSize());
        buf.order(ByteOrder.nativeOrder());
        for (int pageNo = 0; pageNo < pageStore.pages(); ++pageNo) {
            buf.clear();
            pageStore.read(pageId, buf, true);
            ++pageId;
        }
    }

    public static Map<Integer, Map<Integer, Long>> getUpdateCountersSnapshot(IgniteEx ign, Set<Integer> grpIds) {
        HashMap<Integer, Map<Integer, Long>> partsWithCountersPerGrp = new HashMap<Integer, Map<Integer, Long>>();
        for (Integer grpId : grpIds) {
            CacheGroupContext grpCtx = ign.context().cache().cacheGroup(grpId);
            if (grpCtx == null) {
                throw new GridNotIdleException("Group not found: " + grpId + ". Possible reasons: rebalance in progress or concurrent cache destroy.");
            }
            GridDhtPartitionTopology top = grpCtx.topology();
            Map partsWithCounters = partsWithCountersPerGrp.computeIfAbsent(grpId, k -> new HashMap());
            for (GridDhtLocalPartition part : top.currentLocalPartitions()) {
                if (part.state() != GridDhtPartitionState.OWNING) continue;
                partsWithCounters.put(part.id(), part.updateCounter());
            }
        }
        return partsWithCountersPerGrp;
    }

    public static List<Integer> compareUpdateCounters(IgniteEx ign, Map<Integer, Map<Integer, Long>> cntrsIn, Integer grpId) {
        Map<Integer, Map<Integer, Long>> curCntrs = IdleVerifyUtility.getUpdateCountersSnapshot(ign, Collections.singleton(grpId));
        if (curCntrs.isEmpty()) {
            throw new GridNotIdleException("No OWNING partitions for group: " + grpId);
        }
        ArrayList<Integer> diff = new ArrayList<Integer>();
        Map<Integer, Long> partsWithCntrsCur = curCntrs.get(grpId);
        if (partsWithCntrsCur == null) {
            throw new GridNotIdleException("Group not found: " + grpId + ". Possible reasons: rebalance in progress or concurrent cache destroy.");
        }
        Map<Integer, Long> partsWithCntrsIn = cntrsIn.get(grpId);
        if (!partsWithCntrsIn.equals(partsWithCntrsCur)) {
            diff.add(grpId);
        }
        return diff;
    }

    private IdleVerifyUtility() {
    }

    public static class IdleChecker
    implements IgniteInClosure<Integer> {
        private static final long serialVersionUID = 0L;
        private final IgniteEx ig;
        private final Map<Integer, Map<Integer, Long>> partsWithCntrsPerGrp;

        public IdleChecker(IgniteEx ig, Map<Integer, Map<Integer, Long>> partsWithCntrsPerGrp) {
            this.ig = ig;
            this.partsWithCntrsPerGrp = partsWithCntrsPerGrp;
        }

        @Override
        public void apply(Integer grpId) {
            List<Integer> diff = IdleVerifyUtility.compareUpdateCounters(this.ig, this.partsWithCntrsPerGrp, grpId);
            SB sb = new SB();
            if (!diff.isEmpty()) {
                for (int grpId0 : diff) {
                    if (sb.length() != 0) {
                        sb.a(", ");
                    } else {
                        sb.a("\"");
                    }
                    DynamicCacheDescriptor desc = this.ig.context().cache().cacheDescriptor(grpId0);
                    CacheGroupContext grpCtx = this.ig.context().cache().cacheGroup(desc == null ? grpId0 : desc.groupId());
                    sb.a(grpCtx.cacheOrGroupName());
                }
                sb.a("\"");
                throw new GridNotIdleException("Cluster not idle. Modifications found in caches or groups: [" + sb.toString() + "]");
            }
        }
    }
}

