/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cluster.baseline.autoadjust;

import org.apache.ignite.IgniteLogger;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.IgniteFeatures;
import org.apache.ignite.internal.cluster.DistributedBaselineConfiguration;
import org.apache.ignite.internal.cluster.IgniteClusterImpl;
import org.apache.ignite.internal.managers.discovery.GridDiscoveryManager;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.cache.GridCachePartitionExchangeManager;
import org.apache.ignite.internal.processors.cluster.GridClusterStateProcessor;
import org.apache.ignite.internal.processors.cluster.baseline.autoadjust.BaselineAutoAdjustData;
import org.apache.ignite.internal.processors.cluster.baseline.autoadjust.BaselineAutoAdjustExecutor;
import org.apache.ignite.internal.processors.cluster.baseline.autoadjust.BaselineAutoAdjustScheduler;
import org.apache.ignite.internal.processors.cluster.baseline.autoadjust.BaselineAutoAdjustStatus;
import org.apache.ignite.internal.util.IgniteUtils;
import org.apache.ignite.internal.util.typedef.internal.CU;

public class BaselineTopologyUpdater {
    private final IgniteLogger log;
    private final IgniteClusterImpl cluster;
    private final GridCachePartitionExchangeManager<?, ?> exchangeManager;
    private final DistributedBaselineConfiguration baselineConfiguration;
    private final GridDiscoveryManager discoveryMgr;
    private final GridClusterStateProcessor stateProcessor;
    private final BaselineAutoAdjustScheduler baselineAutoAdjustScheduler;
    private final GridKernalContext ctx;
    private BaselineAutoAdjustData lastBaselineData = BaselineAutoAdjustData.NULL_BASELINE_DATA;

    public BaselineTopologyUpdater(GridKernalContext ctx) {
        this.log = ctx.log(BaselineTopologyUpdater.class);
        this.cluster = ctx.cluster().get();
        this.baselineConfiguration = ctx.state().baselineConfiguration();
        this.exchangeManager = ctx.cache().context().exchange();
        this.stateProcessor = ctx.state();
        this.baselineAutoAdjustScheduler = new BaselineAutoAdjustScheduler(ctx.timeout(), new BaselineAutoAdjustExecutor(ctx.log(BaselineAutoAdjustExecutor.class), this.cluster, ctx.getSystemExecutorService(), this::isTopologyWatcherEnabled), ctx.log(BaselineAutoAdjustScheduler.class));
        this.discoveryMgr = ctx.discovery();
        this.ctx = ctx;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void triggerBaselineUpdate(long topologyVersion) {
        if (!this.isTopologyWatcherEnabled()) {
            BaselineTopologyUpdater baselineTopologyUpdater = this;
            synchronized (baselineTopologyUpdater) {
                this.lastBaselineData = BaselineAutoAdjustData.NULL_BASELINE_DATA;
            }
            return;
        }
        BaselineTopologyUpdater baselineTopologyUpdater = this;
        synchronized (baselineTopologyUpdater) {
            BaselineAutoAdjustData baselineData = this.lastBaselineData = this.lastBaselineData.next(topologyVersion);
            if (IgniteUtils.isLocalNodeCoordinator(this.discoveryMgr)) {
                this.exchangeManager.affinityReadyFuture(new AffinityTopologyVersion(topologyVersion)).listen(future -> {
                    if (future.error() != null) {
                        return;
                    }
                    if (this.exchangeManager.lastFinishedFuture().hasLostPartitions()) {
                        this.log.warning("Baseline won't be changed cause lost partitions were detected");
                        return;
                    }
                    long timeout = this.baselineConfiguration.getBaselineAutoAdjustTimeout();
                    this.log.warning("Baseline auto-adjust will be executed in '" + timeout + "' ms");
                    this.baselineAutoAdjustScheduler.schedule(baselineData, timeout);
                });
            }
        }
    }

    private boolean isTopologyWatcherEnabled() {
        return BaselineTopologyUpdater.isSupported(this.ctx) && !this.ctx.clientNode() && this.stateProcessor.clusterState().active() && this.baselineConfiguration.isBaselineAutoAdjustEnabled() && (CU.isPersistenceEnabled(this.cluster.ignite().configuration()) || this.cluster.baselineAutoAdjustTimeout() != 0L);
    }

    public static boolean isSupported(GridKernalContext ctx) {
        return IgniteFeatures.allNodesSupport(ctx, IgniteFeatures.BASELINE_AUTO_ADJUSTMENT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BaselineAutoAdjustStatus getStatus() {
        BaselineTopologyUpdater baselineTopologyUpdater = this;
        synchronized (baselineTopologyUpdater) {
            if (this.lastBaselineData.isAdjusted() || this.baselineAutoAdjustScheduler.isExecutionExpired(this.lastBaselineData)) {
                return BaselineAutoAdjustStatus.notScheduled();
            }
            long timeToLastTask = this.baselineAutoAdjustScheduler.lastScheduledTaskTime();
            if (timeToLastTask <= 0L) {
                return BaselineAutoAdjustStatus.inProgress();
            }
            return BaselineAutoAdjustStatus.scheduled(timeToLastTask);
        }
    }
}

