/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.diagnostic;

import java.io.File;
import java.nio.file.Path;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteSystemProperties;
import org.apache.ignite.failure.FailureContext;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.processors.GridProcessorAdapter;
import org.apache.ignite.internal.processors.cache.persistence.tree.CorruptedTreeException;
import org.apache.ignite.internal.processors.diagnostic.PageHistoryDiagnoster;
import org.apache.ignite.internal.processors.diagnostic.ReconciliationExecutionContext;
import org.apache.ignite.internal.util.IgniteStopwatch;
import org.apache.ignite.internal.util.typedef.T2;
import org.apache.ignite.internal.util.typedef.X;
import org.apache.ignite.internal.util.typedef.internal.SB;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.jetbrains.annotations.NotNull;

public class DiagnosticProcessor
extends GridProcessorAdapter {
    private static final boolean IGNITE_DUMP_PAGE_LOCK_ON_FAILURE = IgniteSystemProperties.getBoolean("IGNITE_DUMP_PAGE_LOCK_ON_FAILURE", true);
    private static final DateTimeFormatter TIME_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH-mm-ss_SSS");
    public static final String DEFAULT_TARGET_FOLDER = "diagnostic";
    static final String FILE_FORMAT = ".txt";
    static final String RAW_FILE_FORMAT = ".raw";
    private final Path diagnosticPath;
    private final PageHistoryDiagnoster pageHistoryDiagnoster;
    private final ReconciliationExecutionContext reconciliationExecutionContext;

    public DiagnosticProcessor(GridKernalContext ctx) throws IgniteCheckedException {
        super(ctx);
        this.diagnosticPath = U.resolveWorkDirectory(ctx.config().getWorkDirectory(), DEFAULT_TARGET_FOLDER, false).toPath();
        this.pageHistoryDiagnoster = new PageHistoryDiagnoster(ctx, this::diagnosticFile);
        this.reconciliationExecutionContext = new ReconciliationExecutionContext(ctx);
    }

    @Override
    public void onKernalStart(boolean active) throws IgniteCheckedException {
        super.onKernalStart(active);
        this.pageHistoryDiagnoster.onStart();
    }

    public void dumpPageHistory(@NotNull PageHistoryDiagnoster.DiagnosticPageBuilder builder) throws IgniteCheckedException {
        IgniteStopwatch.logTime(this.log, "DiagnosticPageHistory", () -> this.pageHistoryDiagnoster.dumpPageHistory(builder));
    }

    public void onFailure(Ignite ignite, FailureContext failureCtx) {
        if (IGNITE_DUMP_PAGE_LOCK_ON_FAILURE) {
            this.ctx.cache().context().diagnostic().pageLockTracker().dumpLocksToLog();
        }
        if (X.hasCause(failureCtx.error(), CorruptedTreeException.class)) {
            CorruptedTreeException corruptedTreeException = X.cause(failureCtx.error(), CorruptedTreeException.class);
            T2<Integer, Long>[] pageIds = corruptedTreeException.pages();
            try {
                this.dumpPageHistory(new PageHistoryDiagnoster.DiagnosticPageBuilder().pageIds(pageIds).addAction(DiagnosticAction.PRINT_TO_LOG).addAction(DiagnosticAction.PRINT_TO_FILE).addAction(DiagnosticAction.PRINT_TO_RAW_FILE));
            }
            catch (IgniteCheckedException e) {
                SB sb = new SB();
                sb.a("[");
                for (int i = 0; i < pageIds.length; ++i) {
                    sb.a("(").a(pageIds[i].get1()).a(",").a(pageIds[i].get2()).a(")");
                }
                sb.a("]");
                ignite.log().error("Failed to dump diagnostic info on tree corruption. PageIds=" + sb, e);
            }
        }
    }

    public ReconciliationExecutionContext reconciliationExecutionContext() {
        return this.reconciliationExecutionContext;
    }

    private File diagnosticFile(File customFile, DiagnosticFileWriteMode writeMode) {
        if (customFile == null) {
            return DiagnosticProcessor.finalizeFile(this.diagnosticPath, writeMode);
        }
        if (customFile.isAbsolute()) {
            return DiagnosticProcessor.finalizeFile(customFile.toPath(), writeMode);
        }
        return DiagnosticProcessor.finalizeFile(this.diagnosticPath.resolve(customFile.toPath()), writeMode);
    }

    private static File finalizeFile(Path diagnosticPath, DiagnosticFileWriteMode writeMode) {
        diagnosticPath.toFile().mkdirs();
        return diagnosticPath.resolve(LocalDateTime.now().format(TIME_FORMATTER) + DiagnosticProcessor.getFileExtension(writeMode)).toFile();
    }

    private static String getFileExtension(DiagnosticFileWriteMode writeMode) {
        switch (writeMode) {
            case HUMAN_READABLE: {
                return FILE_FORMAT;
            }
            case RAW: {
                return RAW_FILE_FORMAT;
            }
        }
        throw new IllegalArgumentException("writeMode=" + (Object)((Object)writeMode));
    }

    public static enum DiagnosticFileWriteMode {
        HUMAN_READABLE,
        RAW;

    }

    public static enum DiagnosticAction {
        PRINT_TO_LOG,
        PRINT_TO_FILE,
        PRINT_TO_RAW_FILE;

    }
}

