/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.metric;

import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryUsage;
import java.lang.management.OperatingSystemMXBean;
import java.lang.management.RuntimeMXBean;
import java.lang.management.ThreadMXBean;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.managers.GridManagerAdapter;
import org.apache.ignite.internal.processors.metric.MetricRegistry;
import org.apache.ignite.internal.processors.metric.impl.AtomicLongMetric;
import org.apache.ignite.internal.processors.metric.impl.DoubleMetricImpl;
import org.apache.ignite.internal.processors.metric.impl.MetricUtils;
import org.apache.ignite.internal.processors.timeout.GridTimeoutProcessor;
import org.apache.ignite.internal.util.StripedExecutor;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.spi.IgniteSpi;
import org.apache.ignite.spi.metric.MetricExporterSpi;
import org.apache.ignite.spi.metric.ReadOnlyMetricRegistry;
import org.apache.ignite.thread.IgniteStripedThreadPoolExecutor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GridMetricManager
extends GridManagerAdapter<MetricExporterSpi>
implements ReadOnlyMetricRegistry {
    public static final String ACTIVE_COUNT_DESC = "Approximate number of threads that are actively executing tasks.";
    public static final String COMPLETED_TASK_DESC = "Approximate total number of tasks that have completed execution.";
    public static final String CORE_SIZE_DESC = "The core number of threads.";
    public static final String LARGEST_SIZE_DESC = "Largest number of threads that have ever simultaneously been in the pool.";
    public static final String MAX_SIZE_DESC = "The maximum allowed number of threads.";
    public static final String POOL_SIZE_DESC = "Current number of threads in the pool.";
    public static final String TASK_COUNT_DESC = "Approximate total number of tasks that have been scheduled for execution.";
    public static final String QUEUE_SIZE_DESC = "Current size of the execution queue.";
    public static final String KEEP_ALIVE_TIME_DESC = "Thread keep-alive time, which is the amount of time which threads in excess of the core pool size may remain idle before being terminated.";
    public static final String IS_SHUTDOWN_DESC = "True if this executor has been shut down.";
    public static final String IS_TERMINATED_DESC = "True if all tasks have completed following shut down.";
    public static final String IS_TERMINATING_DESC = "True if terminating but not yet terminated.";
    public static final String REJ_HND_DESC = "Class name of current rejection handler.";
    public static final String THRD_FACTORY_DESC = "Class name of thread factory used to create new threads.";
    public static final String THREAD_POOLS = "threadPools";
    private static final long METRICS_UPDATE_FREQ = 3000L;
    public static final String SYS_METRICS = "sys";
    public static final String PME_METRICS = "pme";
    public static final String TX_METRICS = "tx";
    public static final String DIAGNOSTIC_METRICS = "diagnostic";
    public static final String GC_CPU_LOAD = "GcCpuLoad";
    public static final String GC_CPU_LOAD_DESCRIPTION = "GC CPU load.";
    public static final String CPU_LOAD = "CpuLoad";
    public static final String CPU_LOAD_DESCRIPTION = "CPU load.";
    public static final String UP_TIME = "UpTime";
    public static final String THREAD_CNT = "ThreadCount";
    public static final String PEAK_THREAD_CNT = "PeakThreadCount";
    public static final String TOTAL_STARTED_THREAD_CNT = "TotalStartedThreadCount";
    public static final String DAEMON_THREAD_CNT = "DaemonThreadCount";
    public static final String PME_DURATION = "Duration";
    public static final String PME_OPS_BLOCKED_DURATION = "CacheOperationsBlockedDuration";
    public static final String PME_DURATION_HISTOGRAM = "DurationHistogram";
    public static final String PME_OPS_BLOCKED_DURATION_HISTOGRAM = "CacheOperationsBlockedDurationHistogram";
    private static final MemoryMXBean mem = ManagementFactory.getMemoryMXBean();
    private static final OperatingSystemMXBean os = ManagementFactory.getOperatingSystemMXBean();
    private static final RuntimeMXBean rt = ManagementFactory.getRuntimeMXBean();
    private static final ThreadMXBean threads = ManagementFactory.getThreadMXBean();
    private static final Collection<GarbageCollectorMXBean> gc = ManagementFactory.getGarbageCollectorMXBeans();
    private final ConcurrentHashMap<String, MetricRegistry> registries = new ConcurrentHashMap();
    private final List<Consumer<MetricRegistry>> metricRegCreationLsnrs = new CopyOnWriteArrayList<Consumer<MetricRegistry>>();
    private final List<Consumer<MetricRegistry>> metricRegRemoveLsnrs = new CopyOnWriteArrayList<Consumer<MetricRegistry>>();
    private GridTimeoutProcessor.CancelableTask metricsUpdateTask;
    private final DoubleMetricImpl gcCpuLoad;
    private final DoubleMetricImpl cpuLoad;
    private final MemoryUsageMetrics heap;
    private final MemoryUsageMetrics nonHeap;

    public GridMetricManager(GridKernalContext ctx) {
        super(ctx, (IgniteSpi[])ctx.config().getMetricExporterSpi());
        ctx.addNodeAttribute("org.apache.ignite.phy.ram", this.totalSysMemory());
        this.heap = new MemoryUsageMetrics(SYS_METRICS, MetricUtils.metricName("memory", "heap"));
        this.nonHeap = new MemoryUsageMetrics(SYS_METRICS, MetricUtils.metricName("memory", "nonheap"));
        this.heap.update(mem.getHeapMemoryUsage());
        this.nonHeap.update(mem.getNonHeapMemoryUsage());
        MetricRegistry sysreg = this.registry(SYS_METRICS);
        this.gcCpuLoad = sysreg.doubleMetric(GC_CPU_LOAD, GC_CPU_LOAD_DESCRIPTION);
        this.cpuLoad = sysreg.doubleMetric(CPU_LOAD, CPU_LOAD_DESCRIPTION);
        sysreg.register("SystemLoadAverage", os::getSystemLoadAverage, Double.class, null);
        sysreg.register(UP_TIME, rt::getUptime, null);
        sysreg.register(THREAD_CNT, threads::getThreadCount, null);
        sysreg.register(PEAK_THREAD_CNT, threads::getPeakThreadCount, null);
        sysreg.register(TOTAL_STARTED_THREAD_CNT, threads::getTotalStartedThreadCount, null);
        sysreg.register(DAEMON_THREAD_CNT, threads::getDaemonThreadCount, null);
        sysreg.register("CurrentThreadCpuTime", threads::getCurrentThreadCpuTime, null);
        sysreg.register("CurrentThreadUserTime", threads::getCurrentThreadUserTime, null);
        MetricRegistry pmeReg = this.registry(PME_METRICS);
        long[] pmeBounds = new long[]{500L, 1000L, 5000L, 30000L};
        pmeReg.histogram(PME_DURATION_HISTOGRAM, pmeBounds, "Histogram of PME durations in milliseconds.");
        pmeReg.histogram(PME_OPS_BLOCKED_DURATION_HISTOGRAM, pmeBounds, "Histogram of cache operations blocked PME durations in milliseconds.");
    }

    @Override
    protected void onKernalStart0() throws IgniteCheckedException {
        this.metricsUpdateTask = this.ctx.timeout().schedule(new MetricsUpdater(), 3000L, 3000L);
    }

    @Override
    public void start() throws IgniteCheckedException {
        for (MetricExporterSpi spi : (MetricExporterSpi[])this.getSpis()) {
            spi.setMetricRegistry(this);
        }
        this.startSpi();
    }

    @Override
    public void stop(boolean cancel) throws IgniteCheckedException {
        this.stopSpi();
        U.closeQuiet(this.metricsUpdateTask);
    }

    public MetricRegistry registry(String name) {
        return this.registries.computeIfAbsent(name, n -> {
            MetricRegistry mreg = new MetricRegistry(name, name, this.log);
            this.notifyListeners(mreg, this.metricRegCreationLsnrs);
            return mreg;
        });
    }

    public Map<String, MetricRegistry> registries() {
        return this.registries;
    }

    @Override
    @NotNull
    public Iterator<MetricRegistry> iterator() {
        return this.registries.values().iterator();
    }

    @Override
    public void addMetricRegistryCreationListener(Consumer<MetricRegistry> lsnr) {
        this.metricRegCreationLsnrs.add(lsnr);
    }

    @Override
    public void addMetricRegistryRemoveListener(Consumer<MetricRegistry> lsnr) {
        this.metricRegRemoveLsnrs.add(lsnr);
    }

    public void remove(String regName) {
        MetricRegistry mreg = this.registries.remove(regName);
        if (mreg != null) {
            this.notifyListeners(mreg, this.metricRegRemoveLsnrs);
        }
    }

    private <T> void notifyListeners(T t, List<Consumer<T>> lsnrs) {
        for (Consumer<T> lsnr : lsnrs) {
            try {
                lsnr.accept(t);
            }
            catch (Exception e) {
                U.warn(this.log, "Metric listener error", e);
            }
        }
    }

    public void registerThreadPools(ExecutorService utilityCachePool, ExecutorService execSvc, ExecutorService svcExecSvc, ExecutorService sysExecSvc, StripedExecutor stripedExecSvc, ExecutorService p2pExecSvc, ExecutorService mgmtExecSvc, StripedExecutor dataStreamExecSvc, ExecutorService restExecSvc, ExecutorService affExecSvc, @Nullable ExecutorService idxExecSvc, IgniteStripedThreadPoolExecutor callbackExecSvc, ExecutorService qryExecSvc, ExecutorService schemaExecSvc, ExecutorService rebalanceExecSvc, @Nullable Map<String, ? extends ExecutorService> customExecSvcs) {
        this.monitorExecutor("GridUtilityCacheExecutor", utilityCachePool);
        this.monitorExecutor("GridExecutionExecutor", execSvc);
        this.monitorExecutor("GridServicesExecutor", svcExecSvc);
        this.monitorExecutor("GridSystemExecutor", sysExecSvc);
        this.monitorExecutor("GridClassLoadingExecutor", p2pExecSvc);
        this.monitorExecutor("GridManagementExecutor", mgmtExecSvc);
        this.monitorExecutor("GridDataStreamExecutor", dataStreamExecSvc);
        this.monitorExecutor("GridAffinityExecutor", affExecSvc);
        this.monitorExecutor("GridCallbackExecutor", callbackExecSvc);
        this.monitorExecutor("GridQueryExecutor", qryExecSvc);
        this.monitorExecutor("GridSchemaExecutor", schemaExecSvc);
        this.monitorExecutor("GridRebalanceExecutor", rebalanceExecSvc);
        if (idxExecSvc != null) {
            this.monitorExecutor("GridIndexingExecutor", idxExecSvc);
        }
        if (this.ctx.config().getConnectorConfiguration() != null) {
            this.monitorExecutor("GridRestExecutor", restExecSvc);
        }
        if (stripedExecSvc != null) {
            this.monitorStripedPool(stripedExecSvc);
        }
        if (customExecSvcs != null) {
            for (Map.Entry<String, ? extends ExecutorService> entry : customExecSvcs.entrySet()) {
                this.monitorExecutor(entry.getKey(), entry.getValue());
            }
        }
    }

    private void monitorExecutor(String name, ExecutorService execSvc) {
        MetricRegistry mreg = this.registry(MetricUtils.metricName(THREAD_POOLS, name));
        if (execSvc instanceof ThreadPoolExecutor) {
            ThreadPoolExecutor exec = (ThreadPoolExecutor)execSvc;
            mreg.register("ActiveCount", exec::getActiveCount, ACTIVE_COUNT_DESC);
            mreg.register("CompletedTaskCount", exec::getCompletedTaskCount, COMPLETED_TASK_DESC);
            mreg.register("CorePoolSize", exec::getCorePoolSize, CORE_SIZE_DESC);
            mreg.register("LargestPoolSize", exec::getLargestPoolSize, LARGEST_SIZE_DESC);
            mreg.register("MaximumPoolSize", exec::getMaximumPoolSize, MAX_SIZE_DESC);
            mreg.register("PoolSize", exec::getPoolSize, POOL_SIZE_DESC);
            mreg.register("TaskCount", exec::getTaskCount, TASK_COUNT_DESC);
            mreg.register("QueueSize", () -> exec.getQueue().size(), QUEUE_SIZE_DESC);
            mreg.register("KeepAliveTime", () -> exec.getKeepAliveTime(TimeUnit.MILLISECONDS), KEEP_ALIVE_TIME_DESC);
            mreg.register("Shutdown", exec::isShutdown, IS_SHUTDOWN_DESC);
            mreg.register("Terminated", exec::isTerminated, IS_TERMINATED_DESC);
            mreg.register("Terminating", exec::isTerminating, IS_TERMINATING_DESC);
            mreg.register("RejectedExecutionHandlerClass", () -> {
                RejectedExecutionHandler hnd = exec.getRejectedExecutionHandler();
                return hnd == null ? "" : hnd.getClass().getName();
            }, String.class, REJ_HND_DESC);
            mreg.register("ThreadFactoryClass", () -> {
                ThreadFactory factory = exec.getThreadFactory();
                return factory == null ? "" : factory.getClass().getName();
            }, String.class, THRD_FACTORY_DESC);
        } else {
            mreg.longMetric("ActiveCount", ACTIVE_COUNT_DESC).value(0L);
            mreg.longMetric("CompletedTaskCount", COMPLETED_TASK_DESC).value(0L);
            mreg.longMetric("CorePoolSize", CORE_SIZE_DESC).value(0L);
            mreg.longMetric("LargestPoolSize", LARGEST_SIZE_DESC).value(0L);
            mreg.longMetric("MaximumPoolSize", MAX_SIZE_DESC).value(0L);
            mreg.longMetric("PoolSize", POOL_SIZE_DESC).value(0L);
            mreg.longMetric("TaskCount", TASK_COUNT_DESC);
            mreg.longMetric("QueueSize", QUEUE_SIZE_DESC).value(0L);
            mreg.longMetric("KeepAliveTime", KEEP_ALIVE_TIME_DESC).value(0L);
            mreg.register("Shutdown", execSvc::isShutdown, IS_SHUTDOWN_DESC);
            mreg.register("Terminated", execSvc::isTerminated, IS_TERMINATED_DESC);
            mreg.longMetric("Terminating", IS_TERMINATING_DESC);
            mreg.objectMetric("RejectedExecutionHandlerClass", String.class, REJ_HND_DESC).value("");
            mreg.objectMetric("ThreadFactoryClass", String.class, THRD_FACTORY_DESC).value("");
        }
    }

    private void monitorStripedPool(StripedExecutor svc) {
        MetricRegistry mreg = this.registry(MetricUtils.metricName(THREAD_POOLS, "StripedExecutor"));
        mreg.register("DetectStarvation", svc::detectStarvation, "True if possible starvation in striped pool is detected.");
        mreg.register("StripesCount", svc::stripes, "Stripes count.");
        mreg.register("Shutdown", svc::isShutdown, IS_SHUTDOWN_DESC);
        mreg.register("Terminated", svc::isTerminated, IS_TERMINATED_DESC);
        mreg.register("TotalQueueSize", svc::queueSize, "Total queue size of all stripes.");
        mreg.register("TotalCompletedTasksCount", svc::completedTasks, "Completed tasks count of all stripes.");
        mreg.register("StripesCompletedTasksCounts", svc::stripesCompletedTasks, long[].class, "Number of completed tasks per stripe.");
        mreg.register("ActiveCount", svc::activeStripesCount, "Number of active tasks of all stripes.");
        mreg.register("StripesActiveStatuses", svc::stripesActiveStatuses, boolean[].class, "Number of active tasks per stripe.");
        mreg.register("StripesQueueSizes", svc::stripesQueueSizes, int[].class, "Size of queue per stripe.");
    }

    public MemoryUsage nonHeapMemoryUsage() {
        try {
            return mem.getNonHeapMemoryUsage();
        }
        catch (IllegalArgumentException ignored) {
            return new MemoryUsage(0L, 0L, 0L, 0L);
        }
    }

    public MemoryUsage heapMemoryUsage() {
        try {
            return mem.getHeapMemoryUsage();
        }
        catch (IllegalArgumentException ignored) {
            return new MemoryUsage(0L, 0L, 0L, 0L);
        }
    }

    private long totalSysMemory() {
        try {
            return (Long)U.property(os, "totalPhysicalMemorySize");
        }
        catch (RuntimeException ignored) {
            return -1L;
        }
    }

    public class MemoryUsageMetrics {
        private final AtomicLongMetric init;
        private final AtomicLongMetric used;
        private final AtomicLongMetric committed;
        private final AtomicLongMetric max;

        public MemoryUsageMetrics(String group, String metricNamePrefix) {
            MetricRegistry mreg = GridMetricManager.this.registry(group);
            this.init = mreg.longMetric(MetricUtils.metricName(metricNamePrefix, "init"), null);
            this.used = mreg.longMetric(MetricUtils.metricName(metricNamePrefix, "used"), null);
            this.committed = mreg.longMetric(MetricUtils.metricName(metricNamePrefix, "committed"), null);
            this.max = mreg.longMetric(MetricUtils.metricName(metricNamePrefix, "max"), null);
        }

        public void update(MemoryUsage usage) {
            this.init.value(usage.getInit());
            this.used.value(usage.getUsed());
            this.committed.value(usage.getCommitted());
            this.max.value(usage.getMax());
        }
    }

    private class MetricsUpdater
    implements Runnable {
        private long prevGcTime = -1L;
        private long prevCpuTime = -1L;

        private MetricsUpdater() {
        }

        @Override
        public void run() {
            GridMetricManager.this.heap.update(GridMetricManager.this.heapMemoryUsage());
            GridMetricManager.this.nonHeap.update(GridMetricManager.this.nonHeapMemoryUsage());
            GridMetricManager.this.gcCpuLoad.value(this.getGcCpuLoad());
            GridMetricManager.this.cpuLoad.value(this.getCpuLoad());
        }

        private double getGcCpuLoad() {
            long gcTime = 0L;
            for (GarbageCollectorMXBean bean : gc) {
                long colTime = bean.getCollectionTime();
                if (colTime <= 0L) continue;
                gcTime += colTime;
            }
            gcTime /= (long)os.getAvailableProcessors();
            double gc = 0.0;
            if (this.prevGcTime > 0L) {
                long gcTimeDiff = gcTime - this.prevGcTime;
                gc = (double)gcTimeDiff / 3000.0;
            }
            this.prevGcTime = gcTime;
            return gc;
        }

        private double getCpuLoad() {
            long cpuTime;
            try {
                cpuTime = (Long)U.property(os, "processCpuTime");
            }
            catch (IgniteException ignored) {
                return -1.0;
            }
            cpuTime /= (long)(1000000 * os.getAvailableProcessors());
            double cpu = 0.0;
            if (this.prevCpuTime > 0L) {
                long cpuTimeDiff = cpuTime - this.prevCpuTime;
                cpu = Math.min(1.0, (double)cpuTimeDiff / 3000.0);
            }
            this.prevCpuTime = cpuTime;
            return cpu;
        }

        public String toString() {
            return S.toString(MetricsUpdater.class, this, super.toString());
        }
    }
}

