/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.metric;

import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BooleanSupplier;
import java.util.function.DoubleSupplier;
import java.util.function.IntSupplier;
import java.util.function.LongConsumer;
import java.util.function.LongSupplier;
import java.util.function.Supplier;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.internal.processors.metric.impl.AtomicLongMetric;
import org.apache.ignite.internal.processors.metric.impl.BooleanGauge;
import org.apache.ignite.internal.processors.metric.impl.BooleanMetricImpl;
import org.apache.ignite.internal.processors.metric.impl.DoubleGauge;
import org.apache.ignite.internal.processors.metric.impl.DoubleMetricImpl;
import org.apache.ignite.internal.processors.metric.impl.HistogramMetric;
import org.apache.ignite.internal.processors.metric.impl.HitRateMetric;
import org.apache.ignite.internal.processors.metric.impl.IntGauge;
import org.apache.ignite.internal.processors.metric.impl.IntMetricImpl;
import org.apache.ignite.internal.processors.metric.impl.LongAdderMetric;
import org.apache.ignite.internal.processors.metric.impl.LongAdderWithDelegateMetric;
import org.apache.ignite.internal.processors.metric.impl.LongGauge;
import org.apache.ignite.internal.processors.metric.impl.MetricUtils;
import org.apache.ignite.internal.processors.metric.impl.ObjectGauge;
import org.apache.ignite.internal.processors.metric.impl.ObjectMetricImpl;
import org.apache.ignite.internal.util.lang.GridFunc;
import org.apache.ignite.spi.metric.Metric;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MetricRegistry
implements Iterable<Metric> {
    private final String type;
    private final String grpName;
    private final IgniteLogger log;
    private final Map<String, Metric> metrics;

    public MetricRegistry(String type, String grpName, IgniteLogger log) {
        this.type = type;
        this.grpName = grpName;
        this.log = log;
        this.metrics = new ConcurrentHashMap<String, Metric>();
    }

    public MetricRegistry(String type, String grpName, IgniteLogger log, Map<String, Metric> metrics) {
        this.type = type;
        this.grpName = grpName;
        this.log = log;
        this.metrics = Collections.unmodifiableMap(metrics);
    }

    public String type() {
        return this.type;
    }

    @Nullable
    public <M extends Metric> M findMetric(String name) {
        return (M)this.metrics.get(name);
    }

    public void reset() {
        for (Metric m : this.metrics.values()) {
            m.reset();
        }
    }

    public <T> ObjectMetricImpl<T> objectMetric(String name, Class<T> type, @Nullable String desc) {
        return this.addMetric(name, new ObjectMetricImpl<T>(MetricUtils.metricName(this.grpName, name), desc, type));
    }

    @Override
    @NotNull
    public Iterator<Metric> iterator() {
        return this.metrics.values().iterator();
    }

    public Map<String, Metric> metrics() {
        return Collections.unmodifiableMap(this.metrics);
    }

    public void register(Metric metric) {
        this.addMetric(metric.name(), metric);
    }

    public void remove(String name) {
        this.metrics.remove(name);
    }

    public void register(String name, BooleanSupplier supplier, @Nullable String desc) {
        this.addMetric(name, new BooleanGauge(MetricUtils.metricName(this.grpName, name), desc, GridFunc.nonThrowableSupplier(supplier, this.log)));
    }

    public void register(String name, DoubleSupplier supplier, @Nullable String desc) {
        this.addMetric(name, new DoubleGauge(MetricUtils.metricName(this.grpName, name), desc, GridFunc.nonThrowableSupplier(supplier, this.log)));
    }

    public void register(String name, IntSupplier supplier, @Nullable String desc) {
        this.addMetric(name, new IntGauge(MetricUtils.metricName(this.grpName, name), desc, GridFunc.nonThrowableSupplier(supplier, this.log)));
    }

    public LongGauge register(String name, LongSupplier supplier, @Nullable String desc) {
        return this.addMetric(name, new LongGauge(MetricUtils.metricName(this.grpName, name), desc, GridFunc.nonThrowableSupplier(supplier, this.log)));
    }

    public <T> void register(String name, Supplier<T> supplier, Class<T> type, @Nullable String desc) {
        this.addMetric(name, new ObjectGauge<T>(MetricUtils.metricName(this.grpName, name), desc, GridFunc.nonThrowableSupplier(supplier, this.log), type));
    }

    public DoubleMetricImpl doubleMetric(String name, @Nullable String desc) {
        return this.addMetric(name, new DoubleMetricImpl(MetricUtils.metricName(this.grpName, name), desc));
    }

    public IntMetricImpl intMetric(String name, @Nullable String desc) {
        return this.addMetric(name, new IntMetricImpl(MetricUtils.metricName(this.grpName, name), desc));
    }

    public AtomicLongMetric longMetric(String name, @Nullable String desc) {
        return this.addMetric(name, new AtomicLongMetric(MetricUtils.metricName(this.grpName, name), desc));
    }

    public LongAdderMetric longAdderMetric(String name, @Nullable String desc) {
        return this.addMetric(name, new LongAdderMetric(MetricUtils.metricName(this.grpName, name), desc));
    }

    public LongAdderMetric longAdderMetric(String name, LongConsumer delegate, @Nullable String desc) {
        return this.addMetric(name, new LongAdderWithDelegateMetric(MetricUtils.metricName(this.grpName, name), delegate, desc));
    }

    public HitRateMetric hitRateMetric(String name, @Nullable String desc, long rateTimeInterval, int size) {
        return this.addMetric(name, new HitRateMetric(MetricUtils.metricName(this.grpName, name), desc, rateTimeInterval, size));
    }

    public BooleanMetricImpl booleanMetric(String name, @Nullable String desc) {
        return this.addMetric(name, new BooleanMetricImpl(MetricUtils.metricName(this.grpName, name), desc));
    }

    public HistogramMetric histogram(String name, long[] bounds, @Nullable String desc) {
        return this.addMetric(name, new HistogramMetric(MetricUtils.metricName(this.grpName, name), desc, bounds));
    }

    private <T extends Metric> T addMetric(String name, T metric) {
        Metric old = this.metrics.putIfAbsent(name, metric);
        if (old != null) {
            return (T)old;
        }
        return metric;
    }

    public String name() {
        return this.grpName;
    }
}

