/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.metric;

import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import org.apache.ignite.internal.processors.metric.MetricRegistry;
import org.apache.ignite.spi.IgniteSpiAdapter;
import org.apache.ignite.spi.IgniteSpiException;
import org.apache.ignite.spi.metric.MetricExporterSpi;
import org.apache.ignite.spi.metric.ReadOnlyMetricRegistry;
import org.apache.ignite.thread.IgniteThreadFactory;
import org.jetbrains.annotations.Nullable;

public abstract class PushMetricsExporterAdapter
extends IgniteSpiAdapter
implements MetricExporterSpi {
    protected ReadOnlyMetricRegistry mreg;
    @Nullable
    protected Predicate<MetricRegistry> filter;
    private long period;
    private ScheduledExecutorService execSvc;
    private ScheduledFuture<?> fut;

    @Override
    public void spiStart(@Nullable String igniteInstanceName) throws IgniteSpiException {
        this.execSvc = Executors.newSingleThreadScheduledExecutor(new IgniteThreadFactory(igniteInstanceName, "push-metrics-exporter"));
        this.fut = this.execSvc.scheduleWithFixedDelay(() -> {
            try {
                this.export();
            }
            catch (Exception e) {
                this.log.error("Metrics export error. This exporter will be stopped [spiClass=" + this.getClass() + ",name=" + this.getName() + ']', e);
                throw e;
            }
        }, this.period, this.period, TimeUnit.MILLISECONDS);
    }

    @Override
    public void spiStop() throws IgniteSpiException {
        this.fut.cancel(false);
        this.execSvc.shutdown();
    }

    public abstract void export();

    public void setPeriod(long period) {
        this.period = period;
    }

    public long getPeriod() {
        return this.period;
    }

    @Override
    public void setMetricRegistry(ReadOnlyMetricRegistry mreg) {
        this.mreg = mreg;
    }

    @Override
    public void setExportFilter(Predicate<MetricRegistry> filter) {
        this.filter = filter;
    }
}

