/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.metric.impl;

import java.util.concurrent.atomic.AtomicLongArray;
import org.apache.ignite.internal.processors.metric.AbstractMetric;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.spi.metric.ObjectMetric;
import org.jetbrains.annotations.Nullable;

public class HistogramMetric
extends AbstractMetric
implements ObjectMetric<long[]> {
    private volatile HistogramHolder holder;

    public HistogramMetric(String name, @Nullable String desc, long[] bounds) {
        super(name, desc);
        this.holder = new HistogramHolder(bounds);
    }

    public void value(long x) {
        assert (x >= 0L);
        HistogramHolder h = this.holder;
        for (int i = 0; i < h.bounds.length; ++i) {
            if (x > h.bounds[i]) continue;
            h.measurements.incrementAndGet(i);
            return;
        }
        h.measurements.incrementAndGet(h.bounds.length);
    }

    public void reset(long[] bounds) {
        this.holder = new HistogramHolder(bounds);
    }

    @Override
    public void reset() {
        this.reset(this.holder.bounds);
    }

    @Override
    public long[] value() {
        HistogramHolder h = this.holder;
        long[] res = new long[h.measurements.length()];
        for (int i = 0; i < h.measurements.length(); ++i) {
            res[i] = h.measurements.get(i);
        }
        return res;
    }

    public long[] bounds() {
        return this.holder.bounds;
    }

    @Override
    public Class<long[]> type() {
        return long[].class;
    }

    private static class HistogramHolder {
        public final AtomicLongArray measurements;
        public final long[] bounds;

        public HistogramHolder(long[] bounds) {
            assert (!F.isEmpty(bounds) && F.isSorted(bounds));
            this.bounds = bounds;
            this.measurements = new AtomicLongArray(bounds.length + 1);
        }
    }
}

