/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.metric.impl;

import java.util.concurrent.atomic.AtomicLongArray;
import org.apache.ignite.internal.processors.metric.AbstractMetric;
import org.apache.ignite.internal.util.typedef.internal.A;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.spi.metric.LongMetric;
import org.jetbrains.annotations.Nullable;

public class HitRateMetric
extends AbstractMetric
implements LongMetric {
    private volatile HitRateMetricImpl cntr;

    public HitRateMetric(String name, @Nullable String desc, long rateTimeInterval, int size) {
        super(name, desc);
        this.cntr = new HitRateMetricImpl(rateTimeInterval, size);
    }

    @Override
    public void reset() {
        this.cntr = new HitRateMetricImpl(this.cntr.rateTimeInterval, this.cntr.size);
    }

    public void reset(long rateTimeInterval, int size) {
        this.cntr = new HitRateMetricImpl(rateTimeInterval, size);
    }

    public void add(long x) {
        this.cntr.add(x);
    }

    public void increment() {
        this.add(1L);
    }

    @Override
    public long value() {
        return this.cntr.value();
    }

    public long rateTimeInterval() {
        return this.cntr.rateTimeInterval;
    }

    private static class HitRateMetricImpl {
        private static final int TAG_OFFSET = 56;
        private static final long NO_TAG_MASK = 0xFFFFFFFFFFFFFFL;
        private final long rateTimeInterval;
        private final int size;
        private final AtomicLongArray taggedCounters;
        private final AtomicLongArray lastHitTimes;

        public HitRateMetricImpl(long rateTimeInterval, int size) {
            A.ensure(rateTimeInterval > 0L, "rateTimeInterval should be positive");
            A.ensure(size > 1, "Minimum value for size is 2");
            this.rateTimeInterval = rateTimeInterval;
            this.size = size;
            this.taggedCounters = new AtomicLongArray(size);
            this.lastHitTimes = new AtomicLongArray(size);
        }

        public void add(long hits) {
            long curTs = U.currentTimeMillis();
            int curPos = this.position(curTs);
            this.clearIfObsolete(curTs, curPos);
            this.lastHitTimes.set(curPos, curTs);
            this.taggedCounters.addAndGet(curPos, hits);
        }

        public long value() {
            long curTs = U.currentTimeMillis();
            long sum = 0L;
            for (int i = 0; i < this.size; ++i) {
                this.clearIfObsolete(curTs, i);
                sum += HitRateMetricImpl.untag(this.taggedCounters.get(i));
            }
            return sum;
        }

        private void clearIfObsolete(long curTs, int i) {
            long cur = this.taggedCounters.get(i);
            byte curTag = HitRateMetricImpl.getTag(cur);
            long lastTs = this.lastHitTimes.get(i);
            if (this.isObsolete(curTs, lastTs) && this.taggedCounters.compareAndSet(i, cur, HitRateMetricImpl.taggedLongZero(curTag = (byte)(curTag + 1)))) {
                this.lastHitTimes.set(i, curTs);
            }
        }

        private boolean isObsolete(long curTs, long lastHitTime) {
            return curTs - lastHitTime > this.rateTimeInterval * (long)(this.size - 1) / (long)this.size;
        }

        private int position(long time) {
            return (int)(time % this.rateTimeInterval * (long)this.size / this.rateTimeInterval);
        }

        private static long taggedLongZero(byte tag) {
            return (long)tag << 56;
        }

        private static long untag(long l) {
            return l & 0xFFFFFFFFFFFFFFL;
        }

        private static byte getTag(long taggedLong) {
            return (byte)(taggedLong >> 56);
        }
    }
}

