/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.platform.client.compute;

import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.internal.ComputeTaskInternalFuture;
import org.apache.ignite.internal.processors.platform.client.ClientCloseableResource;
import org.apache.ignite.internal.processors.platform.client.ClientConnectionContext;
import org.apache.ignite.internal.processors.platform.client.ClientNotification;
import org.apache.ignite.internal.processors.platform.client.ClientObjectNotification;
import org.apache.ignite.internal.processors.platform.client.IgniteClientException;
import org.apache.ignite.internal.processors.task.GridTaskProcessor;
import org.apache.ignite.internal.processors.task.GridTaskThreadContextKey;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.lang.IgnitePredicate;

class ClientComputeTask
implements ClientCloseableResource {
    private static final byte NO_FAILOVER_FLAG_MASK = 1;
    private static final byte NO_RESULT_CACHE_FLAG_MASK = 2;
    public static final byte KEEP_BINARY_FLAG_MASK = 4;
    private final ClientConnectionContext ctx;
    private final IgniteLogger log;
    private volatile long taskId;
    private volatile ComputeTaskInternalFuture<Object> taskFut;
    private final AtomicBoolean closed = new AtomicBoolean();

    ClientComputeTask(ClientConnectionContext ctx) {
        assert (ctx != null);
        this.ctx = ctx;
        this.log = ctx.kernalContext().log(this.getClass());
    }

    void execute(long taskId, String taskName, Object arg, Set<UUID> nodeIds, byte flags, long timeout) {
        assert (taskName != null);
        this.taskId = taskId;
        GridTaskProcessor task = this.ctx.kernalContext().task();
        IgnitePredicate nodePredicate = F.isEmpty(nodeIds) ? F.alwaysTrue() : F.nodeForNodeIds(nodeIds);
        UUID subjId = this.ctx.securityContext() == null ? null : this.ctx.securityContext().subject().id();
        task.setThreadContext(GridTaskThreadContextKey.TC_SUBGRID_PREDICATE, nodePredicate);
        task.setThreadContextIfNotNull(GridTaskThreadContextKey.TC_SUBJ_ID, subjId);
        task.setThreadContext(GridTaskThreadContextKey.TC_TIMEOUT, timeout);
        task.setThreadContext(GridTaskThreadContextKey.TC_NO_FAILOVER, (flags & 1) != 0);
        task.setThreadContext(GridTaskThreadContextKey.TC_NO_RESULT_CACHE, (flags & 2) != 0);
        this.taskFut = task.execute(taskName, arg);
        if (this.taskFut.isDone() && this.taskFut.error() != null) {
            throw new IgniteClientException(1, this.taskFut.error().getMessage());
        }
    }

    void onResponseSent() {
        this.taskFut.listen(f -> {
            try {
                ClientNotification notification = f.error() != null ? new ClientNotification(6001, this.taskId, f.error().getMessage()) : (f.isCancelled() ? new ClientNotification(6001, this.taskId, "Task was cancelled") : new ClientObjectNotification(6001, this.taskId, f.result()));
                this.ctx.notifyClient(notification);
            }
            finally {
                if (this.closed.compareAndSet(false, true)) {
                    this.ctx.decrementActiveTasksCount();
                    this.ctx.resources().release(this.taskId);
                }
            }
        });
    }

    long taskId() {
        return this.taskId;
    }

    @Override
    public void close() {
        if (this.closed.compareAndSet(false, true)) {
            this.ctx.decrementActiveTasksCount();
            try {
                if (this.taskFut != null) {
                    this.taskFut.cancel();
                }
            }
            catch (IgniteCheckedException e) {
                this.log.warning("Failed to cancel task", e);
            }
        }
    }
}

