/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query;

import java.util.concurrent.atomic.AtomicReference;
import org.apache.ignite.internal.processors.query.GridRunningQueryInfo;
import org.apache.ignite.internal.processors.query.QueryHistoryMetricsKey;
import org.apache.ignite.internal.processors.query.QueryHistoryMetricsValue;
import org.apache.ignite.internal.util.tostring.GridToStringExclude;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.jetbrains.annotations.Nullable;
import org.jsr166.ConcurrentLinkedDeque8;

public class QueryHistoryMetrics {
    @GridToStringExclude
    private final AtomicReference<ConcurrentLinkedDeque8.Node<QueryHistoryMetrics>> linkRef;
    private volatile QueryHistoryMetricsValue val;
    private final QueryHistoryMetricsKey key;

    public QueryHistoryMetrics(GridRunningQueryInfo info, boolean failed) {
        this.key = new QueryHistoryMetricsKey(info.query(), info.schemaName(), info.local());
        long failures = failed ? 1L : 0L;
        long duration = System.currentTimeMillis() - info.startTime();
        long reserved = info.memoryMetricProvider().maxReserved();
        long allocatedOnDisk = info.memoryMetricProvider().maxWrittenOnDisk();
        long totalWrittenOnDisk = info.memoryMetricProvider().totalWrittenOnDisk();
        this.val = new QueryHistoryMetricsValue(1L, failures, duration, duration, info.startTime(), reserved, reserved, allocatedOnDisk, allocatedOnDisk, totalWrittenOnDisk, totalWrittenOnDisk);
        this.linkRef = new AtomicReference();
    }

    public QueryHistoryMetricsKey key() {
        return this.key;
    }

    public QueryHistoryMetrics aggregateWithNew(QueryHistoryMetrics m) {
        this.val = new QueryHistoryMetricsValue(this.val.execs() + m.executions(), this.val.failures() + m.failures(), Math.min(this.val.minTime(), m.minimumTime()), Math.max(this.val.maxTime(), m.maximumTime()), Math.max(this.val.lastStartTime(), m.lastStartTime()), Math.min(this.val.minMemory(), m.minMemory()), Math.max(this.val.maxMemory(), m.maxMemory()), Math.min(this.val.minBytesAllocatedOnDisk(), m.minBytesAllocatedOnDisk()), Math.max(this.val.maxBytesAllocatedOnDisk(), m.maxBytesAllocatedOnDisk()), Math.min(this.val.minTotalBytesWrittenOnDisk(), m.minTotalBytesWrittenOnDisk()), Math.max(this.val.maxTotalBytesWrittenOnDisk(), m.maxTotalBytesWrittenOnDisk()));
        return this;
    }

    public String query() {
        return this.key.query();
    }

    public String schema() {
        return this.key.schema();
    }

    public boolean local() {
        return this.key.local();
    }

    public long executions() {
        return this.val.execs();
    }

    public long failures() {
        return this.val.failures();
    }

    public long minimumTime() {
        return this.val.minTime();
    }

    public long maximumTime() {
        return this.val.maxTime();
    }

    public long minMemory() {
        return this.val.minMemory();
    }

    public long maxMemory() {
        return this.val.maxMemory();
    }

    public long minBytesAllocatedOnDisk() {
        return this.val.minBytesAllocatedOnDisk();
    }

    public long maxBytesAllocatedOnDisk() {
        return this.val.maxBytesAllocatedOnDisk();
    }

    public long minTotalBytesWrittenOnDisk() {
        return this.val.minTotalBytesWrittenOnDisk();
    }

    public long maxTotalBytesWrittenOnDisk() {
        return this.val.maxTotalBytesWrittenOnDisk();
    }

    public long lastStartTime() {
        return this.val.lastStartTime();
    }

    @Nullable
    public ConcurrentLinkedDeque8.Node<QueryHistoryMetrics> link() {
        return this.linkRef.get();
    }

    public boolean replaceLink(ConcurrentLinkedDeque8.Node<QueryHistoryMetrics> expLink, ConcurrentLinkedDeque8.Node<QueryHistoryMetrics> updatedLink) {
        return this.linkRef.compareAndSet(expLink, updatedLink);
    }

    public String toString() {
        return S.toString(QueryHistoryMetrics.class, this);
    }
}

