/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.ignite.internal.processors.query.GridRunningQueryInfo;
import org.apache.ignite.internal.processors.query.QueryHistoryMetrics;
import org.apache.ignite.internal.processors.query.QueryHistoryMetricsKey;
import org.jsr166.ConcurrentLinkedDeque8;

class QueryHistoryTracker {
    private final ConcurrentHashMap<QueryHistoryMetricsKey, QueryHistoryMetrics> qryMetrics;
    private final ConcurrentLinkedDeque8<QueryHistoryMetrics> evictionQueue = new ConcurrentLinkedDeque8();
    private final int histSz;

    QueryHistoryTracker(int histSz) {
        this.histSz = histSz;
        this.qryMetrics = histSz > 0 ? new ConcurrentHashMap(histSz) : null;
    }

    void collectMetrics(GridRunningQueryInfo runningQryInfo, boolean failed) {
        if (this.histSz <= 0) {
            return;
        }
        QueryHistoryMetrics m = new QueryHistoryMetrics(runningQryInfo, failed);
        QueryHistoryMetrics mergedMetrics = this.qryMetrics.merge(m.key(), m, QueryHistoryMetrics::aggregateWithNew);
        if (this.touch(mergedMetrics) && this.qryMetrics.size() > this.histSz) {
            this.shrink();
        }
    }

    private boolean touch(QueryHistoryMetrics entry) {
        ConcurrentLinkedDeque8.Node<QueryHistoryMetrics> newNode;
        ConcurrentLinkedDeque8.Node<QueryHistoryMetrics> node = entry.link();
        if (node == null) {
            node = this.evictionQueue.offerLastx(entry);
            if (!entry.replaceLink(null, node)) {
                this.removeLink(node);
                return false;
            }
            if (node.item() == null) {
                entry.replaceLink(node, null);
                return false;
            }
            return true;
        }
        if (this.removeLink(node) && !entry.replaceLink(node, newNode = this.evictionQueue.offerLastx(entry))) {
            this.removeLink(newNode);
        }
        return false;
    }

    private void shrink() {
        QueryHistoryMetrics entry;
        do {
            if ((entry = this.evictionQueue.poll()) != null) continue;
            return;
        } while (!this.qryMetrics.remove(entry.key(), entry));
    }

    private boolean removeLink(ConcurrentLinkedDeque8.Node<QueryHistoryMetrics> node) {
        return this.evictionQueue.unlinkx(node);
    }

    Map<QueryHistoryMetricsKey, QueryHistoryMetrics> queryHistoryMetrics() {
        if (this.histSz <= 0) {
            return Collections.emptyMap();
        }
        return new HashMap<QueryHistoryMetricsKey, QueryHistoryMetrics>(this.qryMetrics);
    }
}

