/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.processors.cache.query.GridCacheQueryType;
import org.apache.ignite.internal.processors.closure.GridClosureProcessor;
import org.apache.ignite.internal.processors.metric.MetricRegistry;
import org.apache.ignite.internal.processors.metric.impl.AtomicLongMetric;
import org.apache.ignite.internal.processors.metric.impl.LongAdderMetric;
import org.apache.ignite.internal.processors.query.GridQueryCancel;
import org.apache.ignite.internal.processors.query.GridQueryFinishedInfo;
import org.apache.ignite.internal.processors.query.GridQueryMemoryMetricProvider;
import org.apache.ignite.internal.processors.query.GridQueryStartedInfo;
import org.apache.ignite.internal.processors.query.GridRunningQueryInfo;
import org.apache.ignite.internal.processors.query.QueryHistoryMetrics;
import org.apache.ignite.internal.processors.query.QueryHistoryMetricsKey;
import org.apache.ignite.internal.processors.query.QueryHistoryTracker;
import org.apache.ignite.internal.processors.query.QueryUtils;
import org.apache.ignite.internal.util.typedef.internal.A;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.jetbrains.annotations.Nullable;

public class RunningQueryManager {
    public static final String SQL_USER_QUERIES_REG_NAME = "sql.queries.user";
    private static final GridQueryMemoryMetricProvider DUMMY_TRACKER = new GridQueryMemoryMetricProvider(){

        @Override
        public long reserved() {
            return -1L;
        }

        @Override
        public long maxReserved() {
            return -1L;
        }

        @Override
        public long writtenOnDisk() {
            return -1L;
        }

        @Override
        public long maxWrittenOnDisk() {
            return -1L;
        }

        @Override
        public long totalWrittenOnDisk() {
            return -1L;
        }
    };
    private final IgniteLogger log;
    private final GridClosureProcessor closure;
    private final ConcurrentMap<Long, GridRunningQueryInfo> runs = new ConcurrentHashMap<Long, GridRunningQueryInfo>();
    private final AtomicLong qryIdGen = new AtomicLong();
    private final UUID locNodeId;
    private final int histSz;
    private volatile QueryHistoryTracker qryHistTracker;
    private final LongAdderMetric successQrsCnt;
    private final AtomicLongMetric failedQrsCnt;
    private final AtomicLongMetric canceledQrsCnt;
    private final AtomicLongMetric oomQrsCnt;
    private final List<Consumer<GridQueryStartedInfo>> qryStartedListeners = new CopyOnWriteArrayList<Consumer<GridQueryStartedInfo>>();
    private final List<Consumer<GridQueryFinishedInfo>> qryFinishedListeners = new CopyOnWriteArrayList<Consumer<GridQueryFinishedInfo>>();

    public RunningQueryManager(GridKernalContext ctx) {
        this.log = ctx.log(RunningQueryManager.class);
        this.locNodeId = ctx.localNodeId();
        this.histSz = ctx.config().getSqlConfiguration().getSqlQueryHistorySize();
        this.closure = ctx.closure();
        this.qryHistTracker = new QueryHistoryTracker(this.histSz);
        MetricRegistry userMetrics = ctx.metric().registry(SQL_USER_QUERIES_REG_NAME);
        this.successQrsCnt = userMetrics.longAdderMetric("success", "Number of successfully executed user queries that have been started on this node.");
        this.failedQrsCnt = userMetrics.longMetric("failed", "Total number of failed by any reason (cancel, oom etc) queries that have been started on this node.");
        this.canceledQrsCnt = userMetrics.longMetric("canceled", "Number of canceled queries that have been started on this node. This metric number included in the general 'failed' metric.");
        this.oomQrsCnt = userMetrics.longMetric("failedByOOM", "Number of queries started on this node failed due to out of memory protection. This metric number included in the general 'failed' metric.");
    }

    public Long register(String qry, GridCacheQueryType qryType, String schemaName, boolean loc, @Nullable GridQueryMemoryMetricProvider memTracker, @Nullable GridQueryCancel cancel, String qryInitiatorId) {
        Long qryId = this.qryIdGen.incrementAndGet();
        if (qryInitiatorId == null) {
            qryInitiatorId = SqlFieldsQuery.threadedQueryInitiatorId();
        }
        GridRunningQueryInfo run = new GridRunningQueryInfo(qryId, this.locNodeId, qry, qryType, schemaName, System.currentTimeMillis(), cancel, loc, memTracker == null ? DUMMY_TRACKER : memTracker, qryInitiatorId);
        GridRunningQueryInfo preRun = this.runs.putIfAbsent(qryId, run);
        assert (preRun == null) : "Running query already registered [prev_qry=" + preRun + ", newQry=" + run + ']';
        if (this.log.isDebugEnabled()) {
            this.log.debug("User's query started [id=" + qryId + ", type=" + (Object)((Object)qryType) + ", local=" + loc + ", qry=" + qry + ']');
        }
        if (!this.qryStartedListeners.isEmpty()) {
            GridQueryStartedInfo info = new GridQueryStartedInfo(run.id(), this.locNodeId, run.query(), run.queryType(), run.schemaName(), run.startTime(), run.local(), run.queryInitiatorId());
            try {
                this.closure.runLocal(() -> this.qryStartedListeners.forEach(lsnr -> {
                    try {
                        lsnr.accept(info);
                    }
                    catch (Exception ex) {
                        this.log.error("Listener fails during handling query started event [qryId=" + qryId + "]", ex);
                    }
                }), (byte)0);
            }
            catch (IgniteCheckedException ex) {
                throw new IgniteException(ex.getMessage(), ex);
            }
        }
        return qryId;
    }

    public void unregister(Long qryId, @Nullable Throwable failReason) {
        if (qryId == null) {
            return;
        }
        boolean failed = failReason != null;
        GridRunningQueryInfo qry = (GridRunningQueryInfo)this.runs.remove(qryId);
        if (qry == null) {
            return;
        }
        if (qry.memoryMetricProvider() instanceof AutoCloseable) {
            U.close((AutoCloseable)((Object)qry.memoryMetricProvider()), this.log);
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("User's query " + (failReason == null ? "completed " : "failed ") + "[id=" + qryId + ", tracker=" + qry.memoryMetricProvider() + ", failReason=" + (failReason != null ? failReason.getMessage() : "null") + ']');
        }
        if (!this.qryFinishedListeners.isEmpty()) {
            GridQueryFinishedInfo info = new GridQueryFinishedInfo(qry.id(), this.locNodeId, qry.query(), qry.queryType(), qry.schemaName(), qry.startTime(), System.currentTimeMillis(), qry.local(), failed, qry.queryInitiatorId());
            try {
                this.closure.runLocal(() -> this.qryFinishedListeners.forEach(lsnr -> {
                    try {
                        lsnr.accept(info);
                    }
                    catch (Exception ex) {
                        this.log.error("Listener fails during handling query finished event [qryId=" + qryId + "]", ex);
                    }
                }), (byte)0);
            }
            catch (IgniteCheckedException ex) {
                throw new IgniteException(ex.getMessage(), ex);
            }
        }
        if (this.isSqlQuery(qry)) {
            qry.runningFuture().onDone();
            this.qryHistTracker.collectMetrics(qry, failed);
            if (!failed) {
                this.successQrsCnt.increment();
            } else {
                this.failedQrsCnt.increment();
                if (QueryUtils.wasCancelled(failReason)) {
                    this.canceledQrsCnt.increment();
                } else if (QueryUtils.isLocalOrReduceOom(failReason)) {
                    this.oomQrsCnt.increment();
                }
            }
        }
    }

    public List<GridRunningQueryInfo> runningSqlQueries() {
        ArrayList<GridRunningQueryInfo> res = new ArrayList<GridRunningQueryInfo>();
        for (GridRunningQueryInfo run : this.runs.values()) {
            if (!this.isSqlQuery(run)) continue;
            res.add(run);
        }
        return res;
    }

    public void registerQueryStartedListener(Consumer<GridQueryStartedInfo> lsnr) {
        A.notNull(lsnr, "lsnr");
        this.qryStartedListeners.add(lsnr);
    }

    public boolean unregisterQueryStartedListener(Object lsnr) {
        A.notNull(lsnr, "lsnr");
        return this.qryStartedListeners.remove(lsnr);
    }

    public void registerQueryFinishedListener(Consumer<GridQueryFinishedInfo> lsnr) {
        A.notNull(lsnr, "lsnr");
        this.qryFinishedListeners.add(lsnr);
    }

    public boolean unregisterQueryFinishedListener(Object lsnr) {
        A.notNull(lsnr, "lsnr");
        return this.qryFinishedListeners.remove(lsnr);
    }

    private boolean isSqlQuery(GridRunningQueryInfo runningQryInfo) {
        return runningQryInfo.queryType() == GridCacheQueryType.SQL_FIELDS || runningQryInfo.queryType() == GridCacheQueryType.SQL;
    }

    public Collection<GridRunningQueryInfo> longRunningQueries(long duration) {
        ArrayList<GridRunningQueryInfo> res = new ArrayList<GridRunningQueryInfo>();
        long curTime = System.currentTimeMillis();
        for (GridRunningQueryInfo runningQryInfo : this.runs.values()) {
            if (!runningQryInfo.longQuery(curTime, duration)) continue;
            res.add(runningQryInfo);
        }
        return res;
    }

    public void cancel(Long qryId) {
        GridRunningQueryInfo run = (GridRunningQueryInfo)this.runs.get(qryId);
        if (run != null) {
            run.cancel();
        }
    }

    public void stop() {
        Iterator iter = this.runs.values().iterator();
        while (iter.hasNext()) {
            try {
                GridRunningQueryInfo r = (GridRunningQueryInfo)iter.next();
                iter.remove();
                r.cancel();
            }
            catch (Exception exception) {}
        }
    }

    public Map<QueryHistoryMetricsKey, QueryHistoryMetrics> queryHistoryMetrics() {
        return this.qryHistTracker.queryHistoryMetrics();
    }

    @Nullable
    public GridRunningQueryInfo runningQueryInfo(Long qryId) {
        return (GridRunningQueryInfo)this.runs.get(qryId);
    }

    public void resetQueryHistoryMetrics() {
        this.qryHistTracker = new QueryHistoryTracker(this.histSz);
    }

    public String toString() {
        return S.toString(RunningQueryManager.class, this);
    }
}

