/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2.twostep.messages;

import java.nio.ByteBuffer;
import java.sql.SQLException;
import org.apache.ignite.cache.query.QueryCancelledException;
import org.apache.ignite.cache.query.QueryRetryException;
import org.apache.ignite.cache.query.exceptions.SqlCacheException;
import org.apache.ignite.internal.processors.query.IgniteSQLException;
import org.apache.ignite.internal.util.typedef.X;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.plugin.extensions.communication.Message;
import org.apache.ignite.plugin.extensions.communication.MessageReader;
import org.apache.ignite.plugin.extensions.communication.MessageWriter;

public class GridQueryFailResponse
implements Message {
    public static final byte GENERAL_ERROR = 0;
    public static final byte CANCELLED_BY_ORIGINATOR = 1;
    public static final byte RETRY_QUERY = 2;
    private static final long serialVersionUID = 0L;
    private long qryReqId;
    private String errMsg;
    private byte failCode;
    private int sqlErrCode;

    public GridQueryFailResponse() {
    }

    public GridQueryFailResponse(long qryReqId, Throwable err) {
        this.qryReqId = qryReqId;
        this.errMsg = err.getMessage();
        this.failCode = err instanceof QueryCancelledException ? (byte)1 : (err instanceof QueryRetryException ? (byte)2 : (byte)0);
        if (err instanceof SqlCacheException) {
            this.sqlErrCode = ((SqlCacheException)((Object)err)).statusCode();
        } else {
            SQLException sqlEx;
            IgniteSQLException igniteSqlEx = X.cause(err, IgniteSQLException.class);
            SQLException sQLException = sqlEx = igniteSqlEx != null ? igniteSqlEx.toJdbcException() : X.cause(err, SQLException.class);
            if (sqlEx != null) {
                this.sqlErrCode = sqlEx.getErrorCode();
            }
        }
    }

    public long queryRequestId() {
        return this.qryReqId;
    }

    public String error() {
        return this.errMsg;
    }

    public byte failCode() {
        return this.failCode;
    }

    public int sqlErrCode() {
        return this.sqlErrCode;
    }

    @Override
    public void onAckReceived() {
    }

    public String toString() {
        return S.toString(GridQueryFailResponse.class, this);
    }

    @Override
    public boolean writeTo(ByteBuffer buf, MessageWriter writer) {
        writer.setBuffer(buf);
        if (!writer.isHeaderWritten()) {
            if (!writer.writeHeader(this.directType(), this.fieldsCount())) {
                return false;
            }
            writer.onHeaderWritten();
        }
        switch (writer.state()) {
            case 0: {
                if (!writer.writeString("errMsg", this.errMsg)) {
                    return false;
                }
                writer.incrementState();
            }
            case 1: {
                if (!writer.writeByte("failCode", this.failCode)) {
                    return false;
                }
                writer.incrementState();
            }
            case 2: {
                if (!writer.writeLong("qryReqId", this.qryReqId)) {
                    return false;
                }
                writer.incrementState();
            }
            case 3: {
                if (!writer.writeInt("sqlErrCode", this.sqlErrCode)) {
                    return false;
                }
                writer.incrementState();
            }
        }
        return true;
    }

    @Override
    public boolean readFrom(ByteBuffer buf, MessageReader reader) {
        reader.setBuffer(buf);
        if (!reader.beforeMessageRead()) {
            return false;
        }
        switch (reader.state()) {
            case 0: {
                this.errMsg = reader.readString("errMsg");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 1: {
                this.failCode = reader.readByte("failCode");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 2: {
                this.qryReqId = reader.readLong("qryReqId");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 3: {
                this.sqlErrCode = reader.readInt("sqlErrCode");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(GridQueryFailResponse.class);
    }

    @Override
    public short directType() {
        return 107;
    }

    @Override
    public byte fieldsCount() {
        return 4;
    }
}

