/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.rest.handlers.cluster;

import java.util.Collection;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.processors.rest.GridRestCommand;
import org.apache.ignite.internal.processors.rest.GridRestResponse;
import org.apache.ignite.internal.processors.rest.handlers.GridRestCommandHandlerAdapter;
import org.apache.ignite.internal.processors.rest.request.GridRestClusterStateRequest;
import org.apache.ignite.internal.processors.rest.request.GridRestRequest;
import org.apache.ignite.internal.util.future.GridFutureAdapter;
import org.apache.ignite.internal.util.typedef.internal.U;

public class GridChangeClusterStateCommandHandler
extends GridRestCommandHandlerAdapter {
    private static final Collection<GridRestCommand> COMMANDS = U.sealList(GridRestCommand.CLUSTER_SET_STATE, GridRestCommand.CLUSTER_STATE);

    public GridChangeClusterStateCommandHandler(GridKernalContext ctx) {
        super(ctx);
    }

    @Override
    public Collection<GridRestCommand> supportedCommands() {
        return COMMANDS;
    }

    @Override
    public IgniteInternalFuture<GridRestResponse> handleAsync(GridRestRequest restReq) {
        GridRestClusterStateRequest req = (GridRestClusterStateRequest)restReq;
        GridFutureAdapter<GridRestResponse> fut = new GridFutureAdapter<GridRestResponse>();
        GridRestResponse res = new GridRestResponse();
        try {
            switch (req.command()) {
                case CLUSTER_STATE: {
                    assert (req.isReqCurrentMode()) : req;
                    res.setResponse((Object)this.ctx.grid().cluster().state());
                    break;
                }
                default: {
                    assert (req.state() != null) : req;
                    U.log(this.log, "Received cluster state change request to " + (Object)((Object)req.state()) + " state from client node with ID: " + req.clientId());
                    this.ctx.grid().cluster().state(req.state());
                    res.setResponse(req.command().key() + " done");
                }
            }
            fut.onDone(res);
        }
        catch (Exception e) {
            res.setError(GridChangeClusterStateCommandHandler.errorMessage(e));
            fut.onDone(res);
        }
        return fut;
    }
}

