/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.ru;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Set;
import org.apache.ignite.internal.IgniteFeatures;
import org.apache.ignite.internal.dto.IgniteDataTransferObject;
import org.apache.ignite.internal.processors.ru.RollingUpgradeStatus;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.lang.IgniteProductVersion;

public class IgniteRollingUpgradeStatus
extends IgniteDataTransferObject
implements RollingUpgradeStatus {
    private static final long serialVersionUID = 0L;
    private boolean enabled;
    private boolean forcedModeEnabled;
    private IgniteProductVersion initVer;
    private IgniteProductVersion updateVer;
    private Set<IgniteFeatures> supportedFeatures;

    public IgniteRollingUpgradeStatus() {
    }

    public IgniteRollingUpgradeStatus(boolean enabled, boolean forcedModeEnabled, IgniteProductVersion initVer, IgniteProductVersion updateVer, Set<IgniteFeatures> supportedFeatures) {
        assert (enabled || !forcedModeEnabled) : "Forced mode cannot be enabled if Rolling Upgrade is disabled.";
        this.enabled = enabled;
        this.forcedModeEnabled = forcedModeEnabled;
        this.initVer = initVer;
        this.updateVer = updateVer;
        this.supportedFeatures = supportedFeatures;
    }

    @Override
    public boolean enabled() {
        return this.enabled;
    }

    @Override
    public boolean forcedModeEnabled() {
        return this.forcedModeEnabled;
    }

    @Override
    public IgniteProductVersion initialVersion() {
        return this.initVer;
    }

    @Override
    public IgniteProductVersion targetVersion() {
        return this.updateVer;
    }

    @Override
    public Set<IgniteFeatures> supportedFeatures() {
        return this.supportedFeatures;
    }

    @Override
    protected void writeExternalData(ObjectOutput out) throws IOException {
        out.writeBoolean(this.enabled);
        out.writeBoolean(this.forcedModeEnabled);
        out.writeObject(this.initVer);
        out.writeObject(this.updateVer);
        out.writeObject(this.supportedFeatures);
    }

    @Override
    protected void readExternalData(byte protoVer, ObjectInput in) throws IOException, ClassNotFoundException {
        this.enabled = in.readBoolean();
        this.forcedModeEnabled = in.readBoolean();
        this.initVer = (IgniteProductVersion)in.readObject();
        this.updateVer = (IgniteProductVersion)in.readObject();
        this.supportedFeatures = (Set)in.readObject();
    }

    public String toString() {
        return S.toString(IgniteRollingUpgradeStatus.class, this);
    }
}

