/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.tracing;

import org.apache.ignite.internal.processors.tracing.NoopSpan;
import org.apache.ignite.internal.processors.tracing.Span;
import org.jetbrains.annotations.NotNull;

public class MTC {
    private static final Span NOOP_SPAN = NoopSpan.INSTANCE;
    private static ThreadLocal<Span> span = ThreadLocal.withInitial(() -> NOOP_SPAN);

    @NotNull
    public static Span span() {
        return span.get();
    }

    public static TraceSurroundings support(Span startSpan) {
        Span oldSpan = MTC.span();
        if (startSpan != null && startSpan != NOOP_SPAN) {
            span.set(startSpan);
            return new TraceSurroundings(oldSpan, true);
        }
        return oldSpan == NOOP_SPAN ? TraceSurroundings.NOOP_UNCLOSED_SURROUNDINGS : new TraceSurroundings(oldSpan, false);
    }

    public static void supportInitial(Span startSpan) {
        span.set(startSpan);
    }

    public static TraceSurroundings supportContinual(Span startSpan) {
        Span oldSpan = MTC.span();
        if (startSpan != null && startSpan != NOOP_SPAN) {
            span.set(startSpan);
        }
        return new TraceSurroundings(oldSpan, false);
    }

    static /* synthetic */ Span access$100() {
        return NOOP_SPAN;
    }

    public static class TraceSurroundings
    implements AutoCloseable {
        private final Span oldSpan;
        private final boolean endRequired;
        static final TraceSurroundings NOOP_UNCLOSED_SURROUNDINGS = new TraceSurroundings(MTC.access$100(), false);

        private TraceSurroundings(Span oldSpan, boolean endRequired) {
            this.oldSpan = oldSpan;
            this.endRequired = endRequired;
        }

        @Override
        public void close() {
            if (this.endRequired) {
                ((Span)span.get()).end();
            }
            span.set(this.oldSpan);
        }
    }
}

