/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.tracing.configuration;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.processors.tracing.configuration.DistributedTracingConfiguration;
import org.apache.ignite.internal.util.tostring.GridToStringExclude;
import org.apache.ignite.spi.tracing.Scope;
import org.apache.ignite.spi.tracing.TracingConfigurationCoordinates;
import org.apache.ignite.spi.tracing.TracingConfigurationManager;
import org.apache.ignite.spi.tracing.TracingConfigurationParameters;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GridTracingConfigurationManager
implements TracingConfigurationManager {
    private static final Map<TracingConfigurationCoordinates, TracingConfigurationParameters> DEFAULT_CONFIGURATION_MAP;
    public static final String WARNING_MSG_TRACING_CONFIG_UPDATE_FAILED_COORDINATES = "Failed to update tracing configuration for coordinates=[%s].";
    public static final String WARNING_MSG_TRACING_CONFIG_UPDATE_FAILED_SCOPE = "Failed to update tracing configuration for scope=[%s].";
    private final DistributedTracingConfiguration distributedTracingConfiguration = DistributedTracingConfiguration.detachedProperty();
    private volatile Map<TracingConfigurationCoordinates, TracingConfigurationParameters> tracingConfiguration = DEFAULT_CONFIGURATION_MAP;
    @GridToStringExclude
    private final Object mux = new Object();
    @GridToStringExclude
    protected final GridKernalContext ctx;
    @GridToStringExclude
    protected final IgniteLogger log;

    public GridTracingConfigurationManager(@NotNull GridKernalContext ctx) {
        this.ctx = ctx;
        this.log = ctx.log(this.getClass());
        ctx.internalSubscriptionProcessor().registerDistributedConfigurationListener(dispatcher -> {
            this.distributedTracingConfiguration.addListener((name, oldVal, newVal) -> {
                Object object = this.mux;
                synchronized (object) {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("Tracing configuration was updated [oldVal= " + oldVal + ", newVal=" + newVal + "]");
                    }
                    if (newVal != null && !newVal.isEmpty()) {
                        this.tracingConfiguration = newVal;
                    }
                }
            });
            dispatcher.registerProperty(this.distributedTracingConfiguration);
        });
    }

    @Override
    public void set(@NotNull TracingConfigurationCoordinates coordinates, @NotNull TracingConfigurationParameters parameters) {
        HashMap<TracingConfigurationCoordinates, TracingConfigurationParameters> newTracingConfiguration = new HashMap<TracingConfigurationCoordinates, TracingConfigurationParameters>(this.tracingConfiguration);
        newTracingConfiguration.put(coordinates, parameters);
        try {
            this.distributedTracingConfiguration.propagate(newTracingConfiguration);
        }
        catch (IgniteCheckedException e) {
            String warningMsg = String.format(WARNING_MSG_TRACING_CONFIG_UPDATE_FAILED_COORDINATES, coordinates);
            this.log.warning(warningMsg, e);
            throw new IgniteException(warningMsg, e);
        }
    }

    @Override
    @NotNull
    public TracingConfigurationParameters get(@NotNull TracingConfigurationCoordinates coordinates) {
        TracingConfigurationParameters coordinateSpecificParameters = this.tracingConfiguration.get(coordinates);
        return coordinateSpecificParameters == null ? this.tracingConfiguration.get(new TracingConfigurationCoordinates.Builder(coordinates.scope()).build()) : coordinateSpecificParameters;
    }

    @Override
    @NotNull
    public Map<TracingConfigurationCoordinates, TracingConfigurationParameters> getAll(@Nullable Scope scope) {
        return scope != null ? this.tracingConfiguration.entrySet().stream().filter(e -> ((TracingConfigurationCoordinates)e.getKey()).scope() == scope).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)) : this.tracingConfiguration;
    }

    @Override
    public void reset(@NotNull TracingConfigurationCoordinates coordinates) {
        HashMap<TracingConfigurationCoordinates, TracingConfigurationParameters> newTracingConfiguration = new HashMap<TracingConfigurationCoordinates, TracingConfigurationParameters>(this.tracingConfiguration);
        if (coordinates.label() != null) {
            newTracingConfiguration.remove(coordinates);
        } else {
            newTracingConfiguration.put(coordinates, DEFAULT_CONFIGURATION_MAP.get(new TracingConfigurationCoordinates.Builder(coordinates.scope()).build()));
        }
        try {
            this.distributedTracingConfiguration.propagate(newTracingConfiguration);
        }
        catch (IgniteCheckedException e) {
            String warningMsg = String.format(WARNING_MSG_TRACING_CONFIG_UPDATE_FAILED_COORDINATES, coordinates);
            this.log.warning(warningMsg, e);
            throw new IgniteException(warningMsg, e);
        }
    }

    @Override
    public void resetAll(@Nullable Scope scope) throws IgniteException {
        HashMap<TracingConfigurationCoordinates, TracingConfigurationParameters> newTracingConfiguration;
        if (scope != null) {
            newTracingConfiguration = new HashMap<TracingConfigurationCoordinates, TracingConfigurationParameters>(this.tracingConfiguration.entrySet().stream().filter(e -> ((TracingConfigurationCoordinates)e.getKey()).scope() != scope).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)));
            TracingConfigurationCoordinates scopeSpecificCoordinates = new TracingConfigurationCoordinates.Builder(scope).build();
            newTracingConfiguration.put(scopeSpecificCoordinates, DEFAULT_CONFIGURATION_MAP.get(scopeSpecificCoordinates));
        } else {
            newTracingConfiguration = new HashMap<TracingConfigurationCoordinates, TracingConfigurationParameters>(DEFAULT_CONFIGURATION_MAP);
        }
        try {
            this.distributedTracingConfiguration.propagate(newTracingConfiguration);
        }
        catch (IgniteCheckedException e2) {
            String warningMsg = String.format(WARNING_MSG_TRACING_CONFIG_UPDATE_FAILED_SCOPE, new Object[]{scope});
            this.log.warning(warningMsg, e2);
            throw new IgniteException(warningMsg, e2);
        }
    }

    static {
        HashMap<TracingConfigurationCoordinates, TracingConfigurationParameters> tmpDfltConfigurationMap = new HashMap<TracingConfigurationCoordinates, TracingConfigurationParameters>();
        tmpDfltConfigurationMap.put(new TracingConfigurationCoordinates.Builder(Scope.TX).build(), TracingConfigurationManager.DEFAULT_TX_CONFIGURATION);
        tmpDfltConfigurationMap.put(new TracingConfigurationCoordinates.Builder(Scope.COMMUNICATION).build(), TracingConfigurationManager.DEFAULT_COMMUNICATION_CONFIGURATION);
        tmpDfltConfigurationMap.put(new TracingConfigurationCoordinates.Builder(Scope.EXCHANGE).build(), TracingConfigurationManager.DEFAULT_EXCHANGE_CONFIGURATION);
        tmpDfltConfigurationMap.put(new TracingConfigurationCoordinates.Builder(Scope.DISCOVERY).build(), TracingConfigurationManager.DEFAULT_DISCOVERY_CONFIGURATION);
        tmpDfltConfigurationMap.put(new TracingConfigurationCoordinates.Builder(Scope.CACHE_API_WRITE).build(), TracingConfigurationManager.DEFAULT_CACHE_API_WRITE_CONFIGURATION);
        tmpDfltConfigurationMap.put(new TracingConfigurationCoordinates.Builder(Scope.CACHE_API_READ).build(), TracingConfigurationManager.DEFAULT_CACHE_API_READ_CONFIGURATION);
        DEFAULT_CONFIGURATION_MAP = Collections.unmodifiableMap(tmpDfltConfigurationMap);
    }
}

