/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.visor.cache;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.apache.ignite.DataRegionMetrics;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.internal.visor.VisorDataTransferObject;

public class VisorMemoryMetrics
extends VisorDataTransferObject {
    private static final long serialVersionUID = 0L;
    private String name;
    private long totalAllocatedPages;
    private float allocationRate;
    private float evictionRate;
    private float largeEntriesPagesPercentage;
    private float pagesFillFactor;
    private long dirtyPages;
    private float pagesReplaceRate;
    private long physicalMemoryPages;
    private long totalAllocatedSz;
    private long physicalMemSz;
    private int pageSize;
    private long cpBufSz;
    private long cpUsedBufPages;
    private long cpUsedBufSz;
    private long pagesRead;
    private long pagesWritten;
    private long pagesReplaced;
    private long offHeapSz;
    private long offHeapUsedSz;
    private long totalUsedPages;

    public VisorMemoryMetrics() {
    }

    public VisorMemoryMetrics(DataRegionMetrics m) {
        this.name = m.getName();
        this.totalUsedPages = m.getTotalUsedPages();
        this.totalAllocatedPages = m.getTotalAllocatedPages();
        this.allocationRate = m.getAllocationRate();
        this.evictionRate = m.getEvictionRate();
        this.largeEntriesPagesPercentage = m.getLargeEntriesPagesPercentage();
        this.pagesFillFactor = m.getPagesFillFactor();
        this.dirtyPages = m.getDirtyPages();
        this.pagesReplaceRate = m.getPagesReplaceRate();
        this.physicalMemoryPages = m.getPhysicalMemoryPages();
        this.totalAllocatedSz = m.getTotalAllocatedSize();
        this.physicalMemSz = m.getPhysicalMemorySize();
        this.pageSize = m.getPageSize();
        this.cpBufSz = m.getCheckpointBufferSize();
        this.cpUsedBufPages = m.getUsedCheckpointBufferPages();
        this.cpUsedBufSz = m.getUsedCheckpointBufferSize();
        this.pagesRead = m.getPagesRead();
        this.pagesWritten = m.getPagesWritten();
        this.pagesReplaced = m.getPagesReplaced();
        this.offHeapSz = m.getOffHeapSize();
        this.offHeapUsedSz = m.getOffheapUsedSize();
    }

    public String getName() {
        return this.name;
    }

    public long getTotalAllocatedPages() {
        return this.totalAllocatedPages;
    }

    public float getAllocationRate() {
        return this.allocationRate;
    }

    public float getEvictionRate() {
        return this.evictionRate;
    }

    public float getLargeEntriesPagesPercentage() {
        return this.largeEntriesPagesPercentage;
    }

    public float getPagesFillFactor() {
        return this.pagesFillFactor;
    }

    public long getDirtyPages() {
        return this.dirtyPages;
    }

    public float getPagesReplaceRate() {
        return this.pagesReplaceRate;
    }

    public long getPhysicalMemoryPages() {
        return this.physicalMemoryPages;
    }

    public long getTotalAllocatedSize() {
        return this.totalAllocatedSz;
    }

    public long getPhysicalMemorySize() {
        return this.physicalMemSz;
    }

    public long getCheckpointBufferPages() {
        return this.cpUsedBufPages;
    }

    public long getCheckpointBufferSize() {
        return this.cpBufSz;
    }

    public long getUsedCheckpointBufferPages() {
        return this.cpUsedBufPages;
    }

    public long getUsedCheckpointBufferSize() {
        return this.cpUsedBufSz;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public long getPagesRead() {
        return this.pagesRead;
    }

    public long getPagesWritten() {
        return this.pagesWritten;
    }

    public long getPagesReplaced() {
        return this.pagesReplaced;
    }

    public long getOffHeapSize() {
        return this.offHeapSz;
    }

    public long getOffheapUsedSize() {
        return this.offHeapUsedSz;
    }

    public long getTotalUsedPages() {
        return this.totalUsedPages;
    }

    @Override
    public byte getProtocolVersion() {
        return 4;
    }

    @Override
    protected void writeExternalData(ObjectOutput out) throws IOException {
        U.writeString(out, this.name);
        out.writeLong(this.totalAllocatedPages);
        out.writeFloat(this.allocationRate);
        out.writeFloat(this.evictionRate);
        out.writeFloat(this.largeEntriesPagesPercentage);
        out.writeFloat(this.pagesFillFactor);
        out.writeLong(this.dirtyPages);
        out.writeFloat(this.pagesReplaceRate);
        out.writeLong(this.physicalMemoryPages);
        out.writeLong(this.totalAllocatedSz);
        out.writeLong(this.physicalMemSz);
        out.writeLong(this.cpUsedBufPages);
        out.writeLong(this.cpBufSz);
        out.writeInt(this.pageSize);
        out.writeLong(this.cpUsedBufSz);
        out.writeLong(this.pagesRead);
        out.writeLong(this.pagesWritten);
        out.writeLong(this.pagesReplaced);
        out.writeLong(this.offHeapSz);
        out.writeLong(this.offHeapUsedSz);
        out.writeLong(this.totalUsedPages);
    }

    @Override
    protected void readExternalData(byte protoVer, ObjectInput in) throws IOException, ClassNotFoundException {
        this.name = U.readString(in);
        this.totalAllocatedPages = in.readLong();
        this.allocationRate = in.readFloat();
        this.evictionRate = in.readFloat();
        this.largeEntriesPagesPercentage = in.readFloat();
        this.pagesFillFactor = in.readFloat();
        this.dirtyPages = in.readLong();
        this.pagesReplaceRate = in.readFloat();
        this.physicalMemoryPages = in.readLong();
        if (protoVer > 1) {
            this.totalAllocatedSz = in.readLong();
            this.physicalMemSz = in.readLong();
            this.cpUsedBufPages = in.readLong();
            this.cpBufSz = in.readLong();
            this.pageSize = in.readInt();
        }
        if (protoVer > 2) {
            this.cpUsedBufSz = in.readLong();
            this.pagesRead = in.readLong();
            this.pagesWritten = in.readLong();
            this.pagesReplaced = in.readLong();
            this.offHeapSz = in.readLong();
            this.offHeapUsedSz = in.readLong();
        }
        if (protoVer > 3) {
            this.totalUsedPages = in.readLong();
        }
    }

    public String toString() {
        return S.toString(VisorMemoryMetrics.class, this);
    }
}

