/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.visor.igfs;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.visor.VisorDataTransferObject;

@Deprecated
public class VisorIgfsMetrics
extends VisorDataTransferObject {
    private static final long serialVersionUID = 0L;
    private long totalSpaceSz;
    private long usedSpaceSz;
    private int foldersCnt;
    private int filesCnt;
    private int filesOpenedForRd;
    private int filesOpenedForWrt;
    private long blocksRd;
    private long blocksRdRmt;
    private long blocksWrt;
    private long blocksWrtRmt;
    private long bytesRd;
    private long bytesRdTm;
    private long bytesWrt;
    private long bytesWrtTm;

    public VisorIgfsMetrics add(VisorIgfsMetrics m) {
        assert (m != null);
        this.totalSpaceSz += m.totalSpaceSz;
        this.usedSpaceSz += m.usedSpaceSz;
        this.foldersCnt += m.foldersCnt;
        this.filesCnt += m.filesCnt;
        this.filesOpenedForRd += m.filesOpenedForRd;
        this.filesOpenedForWrt += m.filesOpenedForWrt;
        this.blocksRd += m.blocksRd;
        this.blocksRdRmt += m.blocksRdRmt;
        this.blocksWrt += m.blocksWrt;
        this.blocksWrtRmt += m.blocksWrtRmt;
        this.bytesRd += m.bytesRd;
        this.bytesRdTm += m.bytesRdTm;
        this.bytesWrt += m.bytesWrt;
        this.bytesWrtTm += m.bytesWrtTm;
        return this;
    }

    public VisorIgfsMetrics aggregate(int n) {
        if (n > 0) {
            this.foldersCnt /= n;
            this.filesCnt /= n;
        }
        return this;
    }

    public long getTotalSpaceSize() {
        return this.totalSpaceSz;
    }

    public long getUsedSpaceSize() {
        return this.usedSpaceSz;
    }

    public long getFreeSpaceSize() {
        return this.totalSpaceSz - this.usedSpaceSz;
    }

    public int getFoldersCount() {
        return this.foldersCnt;
    }

    public int getFilesCount() {
        return this.filesCnt;
    }

    public int getFilesOpenedForRead() {
        return this.filesOpenedForRd;
    }

    public int getFilesOpenedForWrite() {
        return this.filesOpenedForWrt;
    }

    public long getBlocksRead() {
        return this.blocksRd;
    }

    public long getBlocksReadRemote() {
        return this.blocksRdRmt;
    }

    public long getBlocksWritten() {
        return this.blocksWrt;
    }

    public long getBlocksWrittenRemote() {
        return this.blocksWrtRmt;
    }

    public long getBytesRead() {
        return this.bytesRd;
    }

    public long getBytesReadTime() {
        return this.bytesRdTm;
    }

    public long getBytesWritten() {
        return this.bytesWrt;
    }

    public long getBytesWriteTime() {
        return this.bytesWrtTm;
    }

    @Override
    protected void writeExternalData(ObjectOutput out) throws IOException {
        out.writeLong(this.totalSpaceSz);
        out.writeLong(this.usedSpaceSz);
        out.writeInt(this.foldersCnt);
        out.writeInt(this.filesCnt);
        out.writeInt(this.filesOpenedForRd);
        out.writeInt(this.filesOpenedForWrt);
        out.writeLong(this.blocksRd);
        out.writeLong(this.blocksRdRmt);
        out.writeLong(this.blocksWrt);
        out.writeLong(this.blocksWrtRmt);
        out.writeLong(this.bytesRd);
        out.writeLong(this.bytesRdTm);
        out.writeLong(this.bytesWrt);
        out.writeLong(this.bytesWrtTm);
    }

    @Override
    protected void readExternalData(byte protoVer, ObjectInput in) throws IOException, ClassNotFoundException {
        this.totalSpaceSz = in.readLong();
        this.usedSpaceSz = in.readLong();
        this.foldersCnt = in.readInt();
        this.filesCnt = in.readInt();
        this.filesOpenedForRd = in.readInt();
        this.filesOpenedForWrt = in.readInt();
        this.blocksRd = in.readLong();
        this.blocksRdRmt = in.readLong();
        this.blocksWrt = in.readLong();
        this.blocksWrtRmt = in.readLong();
        this.bytesRd = in.readLong();
        this.bytesRdTm = in.readLong();
        this.bytesWrt = in.readLong();
        this.bytesWrtTm = in.readLong();
    }

    public String toString() {
        return S.toString(VisorIgfsMetrics.class, this);
    }
}

