/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.visor.query;

import org.apache.ignite.internal.processors.task.GridInternal;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.internal.visor.VisorEither;
import org.apache.ignite.internal.visor.VisorJob;
import org.apache.ignite.internal.visor.VisorOneNodeTask;
import org.apache.ignite.internal.visor.query.VisorQueryHolder;
import org.apache.ignite.internal.visor.query.VisorQueryNextPageTaskArg;
import org.apache.ignite.internal.visor.query.VisorQueryPingTaskResult;
import org.apache.ignite.internal.visor.query.VisorQueryUtils;
import org.apache.ignite.internal.visor.util.VisorExceptionWrapper;
import org.apache.ignite.internal.visor.util.VisorTaskUtils;

@GridInternal
public class VisorQueryPingTask
extends VisorOneNodeTask<VisorQueryNextPageTaskArg, VisorEither<VisorQueryPingTaskResult>> {
    private static final long serialVersionUID = 0L;

    protected VisorQueryFetchFirstPageJob job(VisorQueryNextPageTaskArg arg) {
        return new VisorQueryFetchFirstPageJob(arg, this.debug);
    }

    private static class VisorQueryFetchFirstPageJob
    extends VisorJob<VisorQueryNextPageTaskArg, VisorEither<VisorQueryPingTaskResult>> {
        private static final long serialVersionUID = 0L;

        private VisorQueryFetchFirstPageJob(VisorQueryNextPageTaskArg arg, boolean debug) {
            super(arg, debug);
        }

        @Override
        protected VisorEither<VisorQueryPingTaskResult> run(VisorQueryNextPageTaskArg arg) {
            VisorQueryHolder holder;
            String qryId = arg.getQueryId();
            long start = U.currentTimeMillis();
            if (this.debug) {
                start = VisorTaskUtils.log(this.ignite.log(), "Ping of query started: " + qryId, this.getClass(), start);
            }
            if ((holder = VisorQueryUtils.getQueryHolder(this.ignite, qryId)).getErr() != null) {
                return new VisorEither<VisorQueryPingTaskResult>(new VisorExceptionWrapper(holder.getErr()));
            }
            holder.setAccessed(true);
            if (this.debug) {
                VisorTaskUtils.log(this.ignite.log(), "Ping of query finished: " + qryId, this.getClass(), start);
            }
            return new VisorEither<VisorQueryPingTaskResult>(new VisorQueryPingTaskResult());
        }

        public String toString() {
            return S.toString(VisorQueryFetchFirstPageJob.class, this);
        }
    }
}

