/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.visor.ru;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.ignite.internal.dto.IgniteDataTransferObject;
import org.apache.ignite.internal.processors.ru.RollingUpgradeStatus;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;

public class VisorRollingUpgradeStatus
extends IgniteDataTransferObject {
    private static final long serialVersionUID = 0L;
    private boolean enabled;
    private boolean forcedModeEnabled;
    private String initVer;
    private String targetVer;
    private Set<String> supportedFeatures;

    public VisorRollingUpgradeStatus() {
    }

    public VisorRollingUpgradeStatus(boolean enabled, boolean forcedModeEnabled, String initVer, String targetVer, Set<String> supportedFeatures) {
        this.enabled = enabled;
        this.forcedModeEnabled = forcedModeEnabled;
        this.initVer = initVer;
        this.targetVer = targetVer;
        this.supportedFeatures = supportedFeatures;
    }

    public VisorRollingUpgradeStatus(RollingUpgradeStatus status) {
        this(status.enabled(), status.forcedModeEnabled(), status.initialVersion().toString(), status.targetVersion() != null ? status.targetVersion().toString() : "", status.supportedFeatures().stream().map(Enum::name).collect(Collectors.toSet()));
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean isForcedModeEnabled() {
        return this.forcedModeEnabled;
    }

    public String getInitialVersion() {
        return this.initVer;
    }

    public String getTargetVersion() {
        return this.targetVer;
    }

    public Set<String> getSupportedFeatures() {
        return this.supportedFeatures;
    }

    @Override
    protected void writeExternalData(ObjectOutput out) throws IOException {
        out.writeBoolean(this.enabled);
        out.writeBoolean(this.forcedModeEnabled);
        U.writeString(out, this.initVer);
        U.writeString(out, this.targetVer);
        U.writeCollection(out, this.supportedFeatures);
    }

    @Override
    protected void readExternalData(byte protoVer, ObjectInput in) throws IOException, ClassNotFoundException {
        this.enabled = in.readBoolean();
        this.forcedModeEnabled = in.readBoolean();
        this.initVer = U.readString(in);
        this.targetVer = U.readString(in);
        this.supportedFeatures = U.readSet(in);
    }

    public String toString() {
        return S.toString(VisorRollingUpgradeStatus.class, this);
    }
}

