/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.spi.discovery.tcp.messages;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.UUID;
import org.apache.ignite.cache.CacheMetrics;
import org.apache.ignite.cluster.ClusterMetrics;
import org.apache.ignite.internal.ClusterMetricsSnapshot;
import org.apache.ignite.internal.util.tostring.GridToStringExclude;
import org.apache.ignite.internal.util.typedef.C1;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.T2;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgnitePredicate;
import org.apache.ignite.spi.discovery.tcp.messages.TcpDiscoveryAbstractMessage;
import org.apache.ignite.spi.discovery.tcp.messages.TcpDiscoveryRedirectToClient;

@TcpDiscoveryRedirectToClient
public class TcpDiscoveryMetricsUpdateMessage
extends TcpDiscoveryAbstractMessage {
    private static final long serialVersionUID = 0L;
    @GridToStringExclude
    private final Map<UUID, MetricsSet> metrics = new HashMap<UUID, MetricsSet>();
    private final Collection<UUID> clientNodeIds = new HashSet<UUID>();
    @GridToStringExclude
    private final Map<UUID, Map<Integer, CacheMetrics>> cacheMetrics = new HashMap<UUID, Map<Integer, CacheMetrics>>();

    public TcpDiscoveryMetricsUpdateMessage(UUID creatorNodeId) {
        super(creatorNodeId);
    }

    public void setMetrics(UUID nodeId, ClusterMetrics metrics) {
        assert (nodeId != null);
        assert (metrics != null);
        assert (!this.metrics.containsKey(nodeId));
        this.metrics.put(nodeId, new MetricsSet(metrics));
    }

    public void setCacheMetrics(UUID nodeId, Map<Integer, CacheMetrics> metrics) {
        assert (nodeId != null);
        assert (metrics != null);
        assert (!this.cacheMetrics.containsKey(nodeId));
        if (!F.isEmpty(metrics)) {
            this.cacheMetrics.put(nodeId, metrics);
        }
    }

    public void setClientMetrics(UUID nodeId, UUID clientNodeId, ClusterMetrics metrics) {
        assert (nodeId != null);
        assert (clientNodeId != null);
        assert (metrics != null);
        assert (this.metrics.containsKey(nodeId));
        this.metrics.get(nodeId).addClientMetrics(clientNodeId, metrics);
    }

    public void removeMetrics(UUID nodeId) {
        assert (nodeId != null);
        this.metrics.remove(nodeId);
    }

    public void removeCacheMetrics(UUID nodeId) {
        assert (nodeId != null);
        this.cacheMetrics.remove(nodeId);
    }

    public Map<UUID, MetricsSet> metrics() {
        return this.metrics;
    }

    public Map<UUID, Map<Integer, CacheMetrics>> cacheMetrics() {
        return this.cacheMetrics;
    }

    public boolean hasMetrics() {
        return !this.metrics.isEmpty();
    }

    public boolean hasCacheMetrics() {
        return !this.cacheMetrics.isEmpty();
    }

    public boolean hasMetrics(UUID nodeId) {
        assert (nodeId != null);
        return this.metrics.get(nodeId) != null;
    }

    public boolean hasCacheMetrics(UUID nodeId) {
        assert (nodeId != null);
        return this.cacheMetrics.get(nodeId) != null;
    }

    public Collection<UUID> clientNodeIds() {
        return this.clientNodeIds;
    }

    public void addClientNodeId(UUID clientNodeId) {
        this.clientNodeIds.add(clientNodeId);
    }

    public int passedLaps(UUID nodeId) {
        boolean hasLocMetrics;
        boolean bl = hasLocMetrics = this.hasMetrics(nodeId) || this.hasCacheMetrics(nodeId);
        if (nodeId.equals(this.creatorNodeId()) && !hasLocMetrics && this.senderNodeId() != null) {
            return 2;
        }
        if (this.senderNodeId() == null || !hasLocMetrics) {
            return 0;
        }
        return 1;
    }

    @Override
    public boolean traceLogLevel() {
        return true;
    }

    @Override
    public String toString() {
        return S.toString(TcpDiscoveryMetricsUpdateMessage.class, this, "super", super.toString());
    }

    private static byte[] serializeMetrics(UUID nodeId, ClusterMetrics metrics) {
        assert (nodeId != null);
        assert (metrics != null);
        byte[] buf = new byte[352];
        U.longToBytes(nodeId.getMostSignificantBits(), buf, 0);
        U.longToBytes(nodeId.getLeastSignificantBits(), buf, 8);
        ClusterMetricsSnapshot.serialize(buf, 16, metrics);
        return buf;
    }

    public static class MetricsSet
    implements Externalizable {
        private static final long serialVersionUID = 0L;
        private byte[] metrics;
        private Collection<byte[]> clientMetrics;

        public MetricsSet() {
        }

        public MetricsSet(ClusterMetrics metrics) {
            assert (metrics != null);
            this.metrics = ClusterMetricsSnapshot.serialize(metrics);
        }

        public ClusterMetrics metrics() {
            return ClusterMetricsSnapshot.deserialize(this.metrics, 0);
        }

        public Collection<T2<UUID, ClusterMetrics>> clientMetrics() {
            return F.viewReadOnly(this.clientMetrics, new C1<byte[], T2<UUID, ClusterMetrics>>(){

                @Override
                public T2<UUID, ClusterMetrics> apply(byte[] bytes) {
                    UUID nodeId = new UUID(U.bytesToLong(bytes, 0), U.bytesToLong(bytes, 8));
                    return new T2<UUID, ClusterMetrics>(nodeId, ClusterMetricsSnapshot.deserialize(bytes, 16));
                }
            }, new IgnitePredicate[0]);
        }

        private void addClientMetrics(UUID nodeId, ClusterMetrics metrics) {
            assert (nodeId != null);
            assert (metrics != null);
            if (this.clientMetrics == null) {
                this.clientMetrics = new ArrayList<byte[]>();
            }
            this.clientMetrics.add(TcpDiscoveryMetricsUpdateMessage.serializeMetrics(nodeId, metrics));
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            U.writeByteArray(out, this.metrics);
            out.writeInt(this.clientMetrics != null ? this.clientMetrics.size() : -1);
            if (this.clientMetrics != null) {
                for (byte[] arr : this.clientMetrics) {
                    U.writeByteArray(out, arr);
                }
            }
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.metrics = U.readByteArray(in);
            int clientMetricsSize = in.readInt();
            if (clientMetricsSize >= 0) {
                this.clientMetrics = new ArrayList<byte[]>(clientMetricsSize);
                for (int i = 0; i < clientMetricsSize; ++i) {
                    this.clientMetrics.add(U.readByteArray(in));
                }
            }
        }
    }
}

