/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.spi.metric.jmx;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.ignite.Ignite;
import org.apache.ignite.internal.processors.metric.MetricRegistry;
import org.apache.ignite.internal.processors.metric.impl.MetricUtils;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.spi.IgniteSpiAdapter;
import org.apache.ignite.spi.IgniteSpiException;
import org.apache.ignite.spi.metric.MetricExporterSpi;
import org.apache.ignite.spi.metric.ReadOnlyMetricRegistry;
import org.apache.ignite.spi.metric.jmx.MetricRegistryMBean;
import org.jetbrains.annotations.Nullable;

public class JmxMetricExporterSpi
extends IgniteSpiAdapter
implements MetricExporterSpi {
    private ReadOnlyMetricRegistry mreg;
    @Nullable
    private Predicate<MetricRegistry> filter;
    private final List<ObjectName> mBeans = new ArrayList<ObjectName>();

    @Override
    public void spiStart(@Nullable String igniteInstanceName) throws IgniteSpiException {
        this.mreg.forEach(this::register);
        this.mreg.addMetricRegistryCreationListener(this::register);
    }

    private void register(MetricRegistry grp) {
        if (this.filter != null && !this.filter.test(grp)) {
            return;
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("Found new metric registry [name=" + grp.name() + ']');
        }
        MetricUtils.MetricName n = MetricUtils.parse(grp.name());
        try {
            MetricRegistryMBean mregBean = new MetricRegistryMBean(grp);
            ObjectName mbean = U.registerMBean(this.ignite().configuration().getMBeanServer(), this.igniteInstanceName, n.root(), n.subName(), mregBean, MetricRegistryMBean.class);
            this.mBeans.add(mbean);
            if (this.log.isDebugEnabled()) {
                this.log.debug("MetricGroup JMX bean created. " + mbean);
            }
        }
        catch (JMException e) {
            this.log.error("MBean for " + grp.name() + " can't be created.", e);
        }
    }

    @Override
    public void spiStop() throws IgniteSpiException {
        Ignite ignite = this.ignite();
        if (ignite == null) {
            return;
        }
        MBeanServer jmx = ignite.configuration().getMBeanServer();
        for (ObjectName bean : this.mBeans) {
            try {
                jmx.unregisterMBean(bean);
                if (!this.log.isDebugEnabled()) continue;
                this.log.debug("Unregistered SPI MBean: " + bean);
            }
            catch (JMException e) {
                this.log.error("Failed to unregister SPI MBean: " + bean, e);
            }
        }
    }

    @Override
    public void setMetricRegistry(ReadOnlyMetricRegistry reg) {
        this.mreg = reg;
    }

    @Override
    public void setExportFilter(Predicate<MetricRegistry> filter) {
        this.filter = filter;
    }
}

