/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.spi.metric.jmx;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.DynamicMBean;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanInfo;
import org.apache.ignite.internal.processors.metric.MetricRegistry;
import org.apache.ignite.internal.processors.metric.impl.HistogramMetric;
import org.apache.ignite.internal.processors.metric.impl.MetricUtils;
import org.apache.ignite.spi.metric.BooleanMetric;
import org.apache.ignite.spi.metric.DoubleMetric;
import org.apache.ignite.spi.metric.IntMetric;
import org.apache.ignite.spi.metric.LongMetric;
import org.apache.ignite.spi.metric.Metric;
import org.apache.ignite.spi.metric.ObjectMetric;
import org.apache.ignite.spi.metric.ReadOnlyMetricRegistry;

public class MetricRegistryMBean
implements DynamicMBean {
    MetricRegistry mreg;

    public MetricRegistryMBean(MetricRegistry mreg) {
        this.mreg = mreg;
    }

    @Override
    public Object getAttribute(String attribute) {
        if (attribute.equals("MBeanInfo")) {
            return this.getMBeanInfo();
        }
        Object metric = this.mreg.findMetric(attribute);
        if (metric == null) {
            return MetricRegistryMBean.searchHistogram(attribute, this.mreg);
        }
        if (metric instanceof BooleanMetric) {
            return ((BooleanMetric)metric).value();
        }
        if (metric instanceof DoubleMetric) {
            return ((DoubleMetric)metric).value();
        }
        if (metric instanceof IntMetric) {
            return ((IntMetric)metric).value();
        }
        if (metric instanceof LongMetric) {
            return ((LongMetric)metric).value();
        }
        if (metric instanceof ObjectMetric) {
            return ((ObjectMetric)metric).value();
        }
        throw new IllegalArgumentException("Unknown metric class. " + metric.getClass());
    }

    @Override
    public MBeanInfo getMBeanInfo() {
        Iterator<Metric> iter = this.mreg.iterator();
        ArrayList attributes = new ArrayList();
        iter.forEachRemaining(metric -> {
            if (metric instanceof HistogramMetric) {
                String[] names = MetricUtils.histogramBucketNames((HistogramMetric)metric);
                assert (names.length == ((HistogramMetric)metric).value().length);
                for (String name : names) {
                    String n = name.substring(this.mreg.name().length() + 1);
                    attributes.add(new MBeanAttributeInfo(n, Long.class.getName(), metric.description() != null ? metric.description() : n, true, false, false));
                }
            } else {
                attributes.add(new MBeanAttributeInfo(metric.name().substring(this.mreg.name().length() + 1), this.metricClass((Metric)metric), metric.description() != null ? metric.description() : metric.name(), true, false, false));
            }
        });
        return new MBeanInfo(ReadOnlyMetricRegistry.class.getName(), this.mreg.name(), attributes.toArray(new MBeanAttributeInfo[attributes.size()]), null, null, null);
    }

    private String metricClass(Metric metric) {
        if (metric instanceof BooleanMetric) {
            return Boolean.class.getName();
        }
        if (metric instanceof DoubleMetric) {
            return Double.class.getName();
        }
        if (metric instanceof IntMetric) {
            return Integer.class.getName();
        }
        if (metric instanceof LongMetric) {
            return Long.class.getName();
        }
        if (metric instanceof ObjectMetric) {
            return ((ObjectMetric)metric).type().getName();
        }
        throw new IllegalArgumentException("Unknown metric class. " + metric.getClass());
    }

    @Override
    public AttributeList getAttributes(String[] attributes) {
        AttributeList list = new AttributeList();
        for (String attribute : attributes) {
            Object val = this.getAttribute(attribute);
            list.add(val);
        }
        return null;
    }

    @Override
    public void setAttribute(Attribute attribute) {
        throw new UnsupportedOperationException("setAttribute not supported.");
    }

    @Override
    public AttributeList setAttributes(AttributeList attributes) {
        throw new UnsupportedOperationException("setAttributes not supported.");
    }

    @Override
    public Object invoke(String actionName, Object[] params, String[] signature) {
        if (actionName.equals("getAttribute")) {
            return this.getAttribute((String)params[0]);
        }
        throw new UnsupportedOperationException("invoke not supported.");
    }

    public static Long searchHistogram(String name, MetricRegistry mreg) {
        long highBound;
        long lowBound;
        int highBoundIdx;
        boolean isInf = name.endsWith("_inf");
        if (isInf) {
            highBoundIdx = name.length() - 4;
        } else {
            highBoundIdx = name.lastIndexOf(95);
            if (highBoundIdx == -1) {
                return null;
            }
        }
        int lowBoundIdx = name.lastIndexOf(95, highBoundIdx - 1);
        if (lowBoundIdx == -1) {
            return null;
        }
        Object m = mreg.findMetric(name.substring(0, lowBoundIdx));
        if (!(m instanceof HistogramMetric)) {
            return null;
        }
        HistogramMetric h = (HistogramMetric)m;
        long[] bounds = h.bounds();
        long[] values = h.value();
        try {
            lowBound = Long.parseLong(name.substring(lowBoundIdx + 1, highBoundIdx));
        }
        catch (NumberFormatException e) {
            return null;
        }
        if (isInf) {
            if (bounds[bounds.length - 1] == lowBound) {
                return values[values.length - 1];
            }
            return null;
        }
        try {
            highBound = Long.parseLong(name.substring(highBoundIdx + 1));
        }
        catch (NumberFormatException e) {
            return null;
        }
        int idx = Arrays.binarySearch(bounds, highBound);
        if (idx < 0) {
            return null;
        }
        if (idx == 0 && lowBound != 0L || idx != 0 && bounds[idx - 1] != lowBound) {
            return null;
        }
        return values[idx];
    }
}

