/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.spi.tracing;

public enum Scope {
    DISCOVERY(1),
    EXCHANGE(2),
    COMMUNICATION(3),
    TX(4),
    CACHE_API_WRITE(5),
    CACHE_API_READ(6);

    private final short idx;
    private static final Scope[] VALS;

    private Scope(short idx) {
        this.idx = idx;
    }

    public short idx() {
        return this.idx;
    }

    public static Scope fromIndex(short idx) {
        return idx < 0 || idx >= VALS.length ? null : VALS[idx];
    }

    static {
        Scope[] scopes = Scope.values();
        int maxIdx = 0;
        for (Scope scope : scopes) {
            maxIdx = Math.max(maxIdx, scope.idx);
        }
        VALS = new Scope[maxIdx + 1];
        Scope[] scopeArray = scopes;
        int n = scopeArray.length;
        for (int i = 0; i < n; ++i) {
            Scope scope;
            Scope.VALS[scope.idx] = scope = scopeArray[i];
        }
    }
}

