/*
 * Copyright 2019 GridGain Systems, Inc. and Contributors.
 *
 * Licensed under the GridGain Community Edition License (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.gridgain.com/products/software/community-edition/gridgain-community-edition-license
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.ignite.internal;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

/**
 * Ignite properties holder.
 */
public class IgniteProperties {
    /** Properties file path. */
    private static final String FILE_PATH = "ignite.properties";

    /** Properties. */
    private static final Properties PROPS;

    /**
     *
     */
    static {
        PROPS = new Properties();

        readProperties(FILE_PATH, PROPS, true);
    }

    /**
     * @param path Path.
     * @param props Properties.
     * @param throwExc Flag indicating whether to throw an exception or not.
     */
    public static void readProperties(String path, Properties props, boolean throwExc) {
        try (InputStream is = IgniteVersionUtils.class.getClassLoader().getResourceAsStream(path)) {
            if (is == null) {
                if (throwExc)
                    throw new RuntimeException("Failed to find properties file: " + path);
                else
                    return;
            }

            props.load(is);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to read properties file: " + path, e);
        }
    }

    /**
     * Gets property value.
     *
     * @param key Property key.
     * @return Property value (possibly empty string, but never {@code null}).
     */
    public static String get(String key) {
        return PROPS.getProperty(key, "");
    }

    /**
     *
     */
    private IgniteProperties() {
        // No-op.
    }
}