/*
 * Copyright 2019 GridGain Systems, Inc. and Contributors.
 *
 * Licensed under the GridGain Community Edition License (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.gridgain.com/products/software/community-edition/gridgain-community-edition-license
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.ignite.internal;

import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.lang.IgnitePredicate;

/**
 * Predicate to filter out security credentials attribute by its name.
 */
public class SecurityCredentialsAttrFilterPredicate implements IgnitePredicate<String> {
    /** */
    private static final long serialVersionUID = 0L;

    /** {@inheritDoc} */
    @Override public boolean apply(String s) {
        return !IgniteNodeAttributes.ATTR_SECURITY_CREDENTIALS.equals(s);
    }

    /** {@inheritDoc} */
    @Override public String toString() {
        return S.toString(SecurityCredentialsAttrFilterPredicate.class, this);
    }
}
