/*
 * Copyright 2019 GridGain Systems, Inc. and Contributors.
 *
 * Licensed under the GridGain Community Edition License (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.gridgain.com/products/software/community-edition/gridgain-community-edition-license
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.ignite.internal;

import java.util.concurrent.ExecutorService;
import org.apache.ignite.internal.util.StripedExecutor;
import org.apache.ignite.mxbean.StripedExecutorMXBean;

/**
 * Adapter for {@link StripedExecutorMXBean} which delegates all method calls to the underlying
 * {@link ExecutorService} instance.
 */
public class StripedExecutorMXBeanAdapter implements StripedExecutorMXBean {
    /** */
    private final StripedExecutor exec;

    /**
     * @param exec Executor service
     */
    public StripedExecutorMXBeanAdapter(StripedExecutor exec) {
        assert exec != null;

        this.exec = exec;
    }

    /** {@inheritDoc} */
    @Deprecated
    @Override public void checkStarvation() {
        exec.detectStarvation();
    }

    /** {@inheritDoc} */
    @Override public boolean detectStarvation() {
        return exec.detectStarvation();
    }

    /** {@inheritDoc} */
    @Override public int getStripesCount() {
        return exec.stripesCount();
    }

    /** {@inheritDoc} */
    @Override public boolean isShutdown() {
        return exec.isShutdown();
    }

    /** {@inheritDoc} */
    @Override public boolean isTerminated() {
        return exec.isTerminated();
    }

    /** {@inheritDoc} */
    @Override public int getTotalQueueSize() {
        return exec.queueSize();
    }

    /** {@inheritDoc} */
    @Override public long getTotalCompletedTasksCount() {
        return exec.completedTasks();
    }

    /** {@inheritDoc} */
    @Override public long[] getStripesCompletedTasksCounts() {
        return exec.stripesCompletedTasks();
    }

    /** {@inheritDoc} */
    @Override public int getActiveCount() {
        return exec.activeStripesCount();
    }

    /** {@inheritDoc} */
    @Override public boolean[] getStripesActiveStatuses() {
        return exec.stripesActiveStatuses();
    }

    /** {@inheritDoc} */
    @Override public int[] getStripesQueueSizes() {
        return exec.stripesQueueSizes();
    }
}
