/*
 * Copyright 2020 GridGain Systems, Inc. and Contributors.
 *
 * Licensed under the GridGain Community Edition License (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.gridgain.com/products/software/community-edition/gridgain-community-edition-license
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.ignite.internal.client;

import java.util.UUID;

/**
 * Ignite Java client API for communicate with node before it start.
 * If node has already started, then there will be errors.
 * For get an instance, need to use {@link GridClientFactory#startBeforeNodeStart}.
 */
public interface GridClientBeforeNodeStart extends AutoCloseable {
    /**
     * Gets a unique client identifier. This identifier is generated by factory on client creation
     * and used in identification and authentication procedure on server node.
     *
     * @return Generated client id.
     */
    public UUID id();

    /**
     * Indicates whether client is connected to remote Grid.
     * In other words it allow to determine if client is able to communicate
     * with Grid right now. It can be used only fo diagnostic and monitoring purposes.
     *
     * @return Whether client is connected to remote Grid.
     */
    public boolean connected();

    /**
     * Closes client instance. This method is identical to
     * {@link GridClientFactory#stop(UUID) GridClientFactory.stop(clientId)}.
     */
    @Override public void close();

    /**
     * Checking for an error.
     *
     * @return {@code Exception} if client was not connected.
     */
    public GridClientException checkLastError();

    /**
     * Getting a client projection of node state before its start.
     *
     * @return Projection of node state before its start.
     *
     * @see GridClientNodeStateBeforeStart
     */
    public GridClientNodeStateBeforeStart beforeStartState();
}
