/*
 * Copyright 2019 GridGain Systems, Inc. and Contributors.
 *
 * Licensed under the GridGain Community Edition License (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.gridgain.com/products/software/community-edition/gridgain-community-edition-license
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.ignite.internal.managers.systemview.walker;

import java.util.UUID;
import org.apache.ignite.lang.IgniteUuid;
import org.apache.ignite.spi.systemview.view.ComputeTaskView;
import org.apache.ignite.spi.systemview.view.SystemViewRowAttributeWalker;

/**
 * Generated by {@code org.apache.ignite.codegen.SystemViewRowAttributeWalkerGenerator}.
 * {@link ComputeTaskView} attributes walker.
 * 
 * @see ComputeTaskView
 */
public class ComputeTaskViewWalker implements SystemViewRowAttributeWalker<ComputeTaskView> {
    /** {@inheritDoc} */
    @Override public void visitAll(AttributeVisitor v) {
        v.accept(0, "id", IgniteUuid.class);
        v.accept(1, "sessionId", IgniteUuid.class);
        v.accept(2, "taskNodeId", UUID.class);
        v.accept(3, "taskName", String.class);
        v.accept(4, "taskClassName", String.class);
        v.accept(5, "affinityPartitionId", int.class);
        v.accept(6, "affinityCacheName", String.class);
        v.accept(7, "startTime", long.class);
        v.accept(8, "endTime", long.class);
        v.accept(9, "execName", String.class);
        v.accept(10, "internal", boolean.class);
        v.accept(11, "jobId", IgniteUuid.class);
        v.accept(12, "userVersion", String.class);
    }

    /** {@inheritDoc} */
    @Override public void visitAll(ComputeTaskView row, AttributeWithValueVisitor v) {
        v.accept(0, "id", IgniteUuid.class, row.id());
        v.accept(1, "sessionId", IgniteUuid.class, row.sessionId());
        v.accept(2, "taskNodeId", UUID.class, row.taskNodeId());
        v.accept(3, "taskName", String.class, row.taskName());
        v.accept(4, "taskClassName", String.class, row.taskClassName());
        v.acceptInt(5, "affinityPartitionId", row.affinityPartitionId());
        v.accept(6, "affinityCacheName", String.class, row.affinityCacheName());
        v.acceptLong(7, "startTime", row.startTime());
        v.acceptLong(8, "endTime", row.endTime());
        v.accept(9, "execName", String.class, row.execName());
        v.acceptBoolean(10, "internal", row.internal());
        v.accept(11, "jobId", IgniteUuid.class, row.jobId());
        v.accept(12, "userVersion", String.class, row.userVersion());
    }

    /** {@inheritDoc} */
    @Override public int count() {
        return 13;
    }
}
