/*
 * Copyright 2019 GridGain Systems, Inc. and Contributors.
 *
 * Licensed under the GridGain Community Edition License (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.gridgain.com/products/software/community-edition/gridgain-community-edition-license
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.ignite.internal.managers.systemview.walker;

import org.apache.ignite.lang.IgniteUuid;
import org.apache.ignite.spi.systemview.view.SystemViewRowAttributeWalker;
import org.apache.ignite.spi.systemview.view.datastructures.QueueView;

/**
 * Generated by {@code org.apache.ignite.codegen.SystemViewRowAttributeWalkerGenerator}.
 * {@link QueueView} attributes walker.
 * 
 * @see QueueView
 */
public class QueueViewWalker implements SystemViewRowAttributeWalker<QueueView> {
    /** {@inheritDoc} */
    @Override public void visitAll(AttributeVisitor v) {
        v.accept(0, "id", IgniteUuid.class);
        v.accept(1, "name", String.class);
        v.accept(2, "capacity", int.class);
        v.accept(3, "size", int.class);
        v.accept(4, "groupName", String.class);
        v.accept(5, "groupId", int.class);
        v.accept(6, "bounded", boolean.class);
        v.accept(7, "collocated", boolean.class);
        v.accept(8, "removed", boolean.class);
    }

    /** {@inheritDoc} */
    @Override public void visitAll(QueueView row, AttributeWithValueVisitor v) {
        v.accept(0, "id", IgniteUuid.class, row.id());
        v.accept(1, "name", String.class, row.name());
        v.acceptInt(2, "capacity", row.capacity());
        v.acceptInt(3, "size", row.size());
        v.accept(4, "groupName", String.class, row.groupName());
        v.acceptInt(5, "groupId", row.groupId());
        v.acceptBoolean(6, "bounded", row.bounded());
        v.acceptBoolean(7, "collocated", row.collocated());
        v.acceptBoolean(8, "removed", row.removed());
    }

    /** {@inheritDoc} */
    @Override public int count() {
        return 9;
    }
}
