/*
 * Copyright 2019 GridGain Systems, Inc. and Contributors.
 *
 * Licensed under the GridGain Community Edition License (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.gridgain.com/products/software/community-edition/gridgain-community-edition-license
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.ignite.internal.managers.systemview.walker;

import java.util.UUID;
import org.apache.ignite.spi.systemview.view.ScanQueryView;
import org.apache.ignite.spi.systemview.view.SystemViewRowAttributeWalker;

/**
 * Generated by {@code org.apache.ignite.codegen.SystemViewRowAttributeWalkerGenerator}.
 * {@link ScanQueryView} attributes walker.
 * 
 * @see ScanQueryView
 */
public class ScanQueryViewWalker implements SystemViewRowAttributeWalker<ScanQueryView> {
    /** {@inheritDoc} */
    @Override public void visitAll(AttributeVisitor v) {
        v.accept(0, "originNodeId", UUID.class);
        v.accept(1, "queryId", long.class);
        v.accept(2, "cacheName", String.class);
        v.accept(3, "cacheId", int.class);
        v.accept(4, "cacheGroupId", int.class);
        v.accept(5, "cacheGroupName", String.class);
        v.accept(6, "startTime", long.class);
        v.accept(7, "duration", long.class);
        v.accept(8, "canceled", boolean.class);
        v.accept(9, "filter", String.class);
        v.accept(10, "keepBinary", boolean.class);
        v.accept(11, "local", boolean.class);
        v.accept(12, "pageSize", int.class);
        v.accept(13, "partition", int.class);
        v.accept(14, "subjectId", UUID.class);
        v.accept(15, "taskName", String.class);
        v.accept(16, "topology", String.class);
        v.accept(17, "transformer", String.class);
    }

    /** {@inheritDoc} */
    @Override public void visitAll(ScanQueryView row, AttributeWithValueVisitor v) {
        v.accept(0, "originNodeId", UUID.class, row.originNodeId());
        v.acceptLong(1, "queryId", row.queryId());
        v.accept(2, "cacheName", String.class, row.cacheName());
        v.acceptInt(3, "cacheId", row.cacheId());
        v.acceptInt(4, "cacheGroupId", row.cacheGroupId());
        v.accept(5, "cacheGroupName", String.class, row.cacheGroupName());
        v.acceptLong(6, "startTime", row.startTime());
        v.acceptLong(7, "duration", row.duration());
        v.acceptBoolean(8, "canceled", row.canceled());
        v.accept(9, "filter", String.class, row.filter());
        v.acceptBoolean(10, "keepBinary", row.keepBinary());
        v.acceptBoolean(11, "local", row.local());
        v.acceptInt(12, "pageSize", row.pageSize());
        v.acceptInt(13, "partition", row.partition());
        v.accept(14, "subjectId", UUID.class, row.subjectId());
        v.accept(15, "taskName", String.class, row.taskName());
        v.accept(16, "topology", String.class, row.topology());
        v.accept(17, "transformer", String.class, row.transformer());
    }

    /** {@inheritDoc} */
    @Override public int count() {
        return 18;
    }
}
