/*
 * Copyright 2019 GridGain Systems, Inc. and Contributors.
 *
 * Licensed under the GridGain Community Edition License (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.gridgain.com/products/software/community-edition/gridgain-community-edition-license
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.ignite.internal.metric;

import java.util.Map;

/**
 * Holder of IO statistics.
 */
public interface IoStatisticsHolder {
    /**
     * Track logical read of given page.
     *
     * @param pageAddr Address of page.
     */
    public void trackLogicalRead(long pageAddr);

    /**
     * Track physical and logical read of given page.
     *
     * @param pageAddr start address of page.
     */
    public void trackPhysicalAndLogicalRead(long pageAddr);

    /**
     * @return Number of logical reads.
     */
    public long logicalReads();

    /**
     * @return Number of physical reads.
     */
    public long physicalReads();

    /**
     * @return Logical reads statistics per page types.
     */
    public Map<String, Long> logicalReadsMap();

    /**
     * @return Physical reads statistics per page types.
     */
    public Map<String, Long> physicalReadsMap();

    /**
     * Reset statistics. All counters will be reset to 0.
     */
    public void resetStatistics();

    /**
     * @return Metric registry name.
     */
    public String metricRegistryName();
}
