/*
 * Copyright 2019 GridGain Systems, Inc. and Contributors.
 *
 * Licensed under the GridGain Community Edition License (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.gridgain.com/products/software/community-edition/gridgain-community-edition-license
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.ignite.internal.processors.odbc.odbc;

/**
 * Data type names that can occur within ODBC escape sequence
 */
public class OdbcTypes {
    /** Type name for BIGINT */
    static final String SQL_BIGINT = "SQL_BIGINT";

    /** Type name for BINARY */
    static final String SQL_BINARY = "SQL_BINARY";

    /** Type name for LONGVARBINARY */
    static final String SQL_LONGVARBINARY = "SQL_LONGVARBINARY";

    /** Type name for VARBINARY */
    static final String SQL_VARBINARY = "SQL_VARBINARY";

    /** Type name for BIT */
    static final String SQL_BIT = "SQL_BIT";

    /** Type name for CHAR */
    static final String SQL_CHAR = "SQL_CHAR";

    /** Type name for DECIMAL */
    static final String SQL_DECIMAL = "SQL_DECIMAL";

    /** Type name for NUMERIC */
    static final String SQL_NUMERIC = "SQL_NUMERIC";

    /** Type name for LONGVARCHAR */
    static final String SQL_LONGVARCHAR = "SQL_LONGVARCHAR";

    /** Type name for VARCHAR */
    static final String SQL_VARCHAR = "SQL_VARCHAR";

    /** Type name for WCHAR */
    static final String SQL_WCHAR = "SQL_WCHAR";

    /** Type name for WLONGVARCHAR */
    static final String SQL_WLONGVARCHAR = "SQL_WLONGVARCHAR";

    /** Type name for WVARCHAR */
    static final String SQL_WVARCHAR = "SQL_WVARCHAR";

    /** Type name for DOUBLE */
    static final String SQL_DOUBLE = "SQL_DOUBLE";

    /** Type name for FLOAT */
    static final String SQL_FLOAT = "SQL_FLOAT";

    /** Type name for REAL */
    static final String SQL_REAL = "SQL_REAL";

    /** Type name for GUID */
    static final String SQL_GUID = "SQL_GUID";

    /** Type name for SMALLINT */
    static final String SQL_SMALLINT = "SQL_SMALLINT";

    /** Type name for INTEGER */
    static final String SQL_INTEGER = "SQL_INTEGER";

    /** Type name for DATE */
    static final String SQL_DATE = "SQL_DATE";

    /** Type name for TIME */
    static final String SQL_TIME = "SQL_TIME";

    /** Type name for TIMESTAMP */
    static final String SQL_TIMESTAMP = "SQL_TIMESTAMP";

    /** Type name for TINYINT */
    static final String SQL_TINYINT = "SQL_TINYINT";

    /** Type name for INTERVAL_SECOND */
    static final String SQL_INTERVAL_SECOND = "SQL_INTERVAL_SECOND";

    /** Type name for INTERVAL_MINUTE */
    static final String SQL_INTERVAL_MINUTE = "SQL_INTERVAL_MINUTE";

    /** Type name for INTERVAL_HOUR */
    static final String SQL_INTERVAL_HOUR = "SQL_INTERVAL_HOUR";

    /** Type name for INTERVAL_DAY */
    static final String SQL_INTERVAL_DAY = "SQL_INTERVAL_DAY";

    /** Type name for INTERVAL_MONTH */
    static final String SQL_INTERVAL_MONTH = "SQL_INTERVAL_MONTH";

    /** Type name for INTERVAL_YEAR */
    static final String SQL_INTERVAL_YEAR = "SQL_INTERVAL_YEAR";

    /** Type name for INTERVAL_YEAR_TO_MONTH */
    static final String SQL_INTERVAL_YEAR_TO_MONTH = "SQL_INTERVAL_YEAR_TO_MONTH";

    /** Type name for INTERVAL_HOUR_TO_MINUTE */
    static final String SQL_INTERVAL_HOUR_TO_MINUTE = "SQL_INTERVAL_HOUR_TO_MINUTE";

    /** Type name for INTERVAL_HOUR_TO_SECOND */
    static final String SQL_INTERVAL_HOUR_TO_SECOND = "SQL_INTERVAL_HOUR_TO_SECOND";

    /** Type name for INTERVAL_MINUTE_TO_SECOND */
    static final String SQL_INTERVAL_MINUTE_TO_SECOND = "SQL_INTERVAL_MINUTE_TO_SECOND";

    /** Type name for INTERVAL_DAY_TO_HOUR */
    static final String SQL_INTERVAL_DAY_TO_HOUR = "SQL_INTERVAL_DAY_TO_HOUR";

    /** Type name for INTERVAL_DAY_TO_MINUTE */
    static final String SQL_INTERVAL_DAY_TO_MINUTE = "SQL_INTERVAL_DAY_TO_MINUTE";

    /** Type name for INTERVAL_DAY_TO_SECOND */
    static final String SQL_INTERVAL_DAY_TO_SECOND = "SQL_INTERVAL_DAY_TO_SECOND";
}
