/*
 * Copyright 2019 GridGain Systems, Inc. and Contributors.
 *
 * Licensed under the GridGain Community Edition License (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.gridgain.com/products/software/community-edition/gridgain-community-edition-license
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.ignite.internal.processors.platform.client.binary;

import org.apache.ignite.internal.binary.BinaryRawWriterEx;
import org.apache.ignite.internal.processors.platform.client.ClientConnectionContext;
import org.apache.ignite.internal.processors.platform.client.ClientResponse;

/**
 * Binary meta response.
 */
public class ClientBinaryConfigurationGetResponse extends ClientResponse {
    /** */
    private final boolean compactFooter;

    /** */
    private final byte nameMapperType;

    /**
     * Constructor.
     * @param requestId Request id.
     * @param compactFooter Compact footer flag.
     * @param nameMapperType Name mapper type.
     */
    ClientBinaryConfigurationGetResponse(long requestId, boolean compactFooter, byte nameMapperType) {
        super(requestId);

        this.compactFooter = compactFooter;
        this.nameMapperType = nameMapperType;
    }

    /** {@inheritDoc} */
    @Override public void encode(ClientConnectionContext ctx, BinaryRawWriterEx writer) {
        super.encode(ctx, writer);

        writer.writeBoolean(compactFooter);
        writer.writeByte(nameMapperType);
    }
}
