/*
 * Copyright 2019 GridGain Systems, Inc. and Contributors.
 *
 * Licensed under the GridGain Community Edition License (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.gridgain.com/products/software/community-edition/gridgain-community-edition-license
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.ignite.internal.processors.platform.client.streamer;

import org.apache.ignite.binary.BinaryRawReader;
import org.apache.ignite.internal.processors.platform.client.ClientRequest;
import org.apache.ignite.internal.processors.platform.client.ClientResponse;
import org.apache.ignite.internal.processors.platform.client.ClientStatus;

/**
 * Base class for streamer requests.
 */
abstract class ClientDataStreamerRequest extends ClientRequest {
    /**
     * Constructor.
     *
     * @param reader Data reader.
     */
    protected ClientDataStreamerRequest(BinaryRawReader reader) {
        super(reader);
    }

    /**
     * Returns invalid node state response.
     *
     * @return Invalid node state response.
     */
    protected ClientResponse getInvalidNodeStateResponse() {
        return new ClientResponse(requestId(), ClientStatus.INVALID_NODE_STATE,
                "Data streamer has been closed because node is stopping.");
    }
}
