/*
 * Copyright 2020 GridGain Systems, Inc. and Contributors.
 *
 * Licensed under the GridGain Community Edition License (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.gridgain.com/products/software/community-edition/gridgain-community-edition-license
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.ignite.internal.processors.rest.request;

import org.apache.ignite.internal.util.typedef.internal.S;

/**
 * Grid warm-up request.
 */
public class GridRestWarmUpRequest extends GridRestNodeStateBeforeStartRequest {
    /** Stop warm-up. */
    private boolean stopWarmUp;

    /**
     * Return {@code true} to stop warm-up.
     *
     * @return {@code true} to stop warm-up.
     */
    public boolean stopWarmUp() {
        return stopWarmUp;
    }

    /**
     * Set need to stop warm-up.
     *
     * @param stopWarmUp {@code true} to stop warm-up.
     * @return {@code this} instance.
     */
    public GridRestWarmUpRequest stopWarmUp(boolean stopWarmUp) {
        this.stopWarmUp = stopWarmUp;

        return this;
    }

    /** {@inheritDoc} */
    @Override public String toString() {
        return S.toString(GridRestWarmUpRequest.class, this, super.toString());
    }
}
